package queso.constraints;

import queso.core.*;

public class or_constraint_comparison extends or_c
{
    // this version works on an array of variables and an array of values.
    // A literal is true iff variables[var]==values[var] && !negated[var]  or  variables[var]!=values[var] && negated[var]
    
    public or_constraint_comparison(mid_domain [] variables, int [] values, int [] comparisons, int xi, qcsp problem)
    {
        super(variables, new boolean[variables.length], xi, problem);  // negated are all false.
        this.values=values;
        this.comparisons=comparisons;
        // can't really do any sanity checks on the values array.
    }
    public final int [] values;
    public final int [] comparisons;
    
    boolean pruning(int variable, boolean value)
    {
        // prune the value from the literal
        // System.out.println("Constraint "+this+" pruning value "+value+" variable "+variables[variable]+" values[var] "+values[variable]);
        // negated are all false
        int com=comparisons[variable];
        mid_domain var=variables[variable];
        if(com==-1)
        {
            //var<val
            if(value)
            {
                //now var>=values[variable]
                for(int i=values[variable]-1; i>=var.lowerbound(); i--)
                {
                    if(!var.exclude(i, this))
                    {
                        return false;
                    }
                }
                return true;
            }
            else
            {   //now var<values[variable]
                for(int i=values[variable]; i<=var.upperbound(); i++)
                {
                    if(!var.exclude(i, this))
                    {
                        return false;
                    }
                }
                return true;
            }
        }
        else if(com==1)
        {
            // similar to above but reversed
            if(!value)
            {
                //now var>values[variable]
                for(int i=values[variable]; i>=var.lowerbound(); i--)
                {
                    if(!var.exclude(i, this))
                    {
                        return false;
                    }
                }
                return true;
            }
            else
            {   //now var<=values[variable]
                for(int i=values[variable]+1; i<=var.upperbound(); i++)
                {
                    if(!var.exclude(i, this))
                    {
                        return false;
                    }
                }
                return true;
            }
        }
        else
        {
            // com==0 or com==2   equal or ne
            if((value && com==0) || (!value && com==2))
            {   // now var!=values[var]
                return var.exclude(values[variable], this);
            }
            else
            {   // now var==values[var]
                int intvalue=values[variable];
                //System.out.println("Pruning all values except "+intvalue+" from dom of "+var);
                for(int i=var.lowerbound(); i<=var.upperbound(); i++)
                {
                    if(i!=intvalue && var.is_present(i))
                    {
                        if(!var.exclude(i, this))
                        {
                            return false;
                        }
                    }
                }
                return true;
            }
        }
    }
    
    int litstate(int i)
    {
        // variable of index i, with negated[i], makes a literal
        // get the state of the literal
        // 0, 1, a=2 and e=3
        
        mid_domain var=variables[i];
        int value=values[i];
        int com=comparisons[i];
        // com is -1 for <,   0 for ==,   1 for >,  2 for !=
        if(com==-1)
        {
            if(var.upperbound()<value)
            {
                return 1;
            }
            else if(var.lowerbound()>=value)
            {
                return 0;
            }
            else if(var.quant())
            {
                return 2;
            }
            else
            {
                return 3;
            }
        }
        else if(com==1)
        {   //var > val
            if(var.lowerbound()>value)
            {
                return 1;
            }
            else if(var.upperbound()<=value)
            {
                return 0;
            }
            else if(var.quant())
            {
                return 2;
            }
            else
            {
                return 3;
            }
        }
        else if(com==0)
        {   // var == val
            if(!var.is_present(value))
            {
                return 0;
            }
            else if(var.unit())
            {
                return 1;
            }
            else if(var.quant())
            {
                return 2;
            }
            else
            {
                return 3;
            }
        }
        else
        {
            assert com==2;
            if(!var.is_present(value))
            {
                return 1;
            }
            else if(var.unit())
            {
                return 0;
            }
            else if(var.quant())
            {
                return 2;
            }
            else
            {
                return 3;
            }
        }
    }
    
    public String toString()
    {
        String st="";
        for(int i=0; i<variables.length; i++)
        {
            if(i!=xi)
            {
                st+=variables[i]+(negated[i]?"!=":"=")+values[i]+" or ";
            }
        }
        st+=" <=> "+variables[xi]+(negated[xi]?"!=":"=")+values[xi]+" " ;
        return st;
    }
}
