package queso.constraints;


public final class tuple
{
    // supports_current linked list pointers
    final tuple [] next;
    final tuple [] prev;
    
    final boolean [] in_list;
    
    public final int [] vals;   //  {val1, val2, val3...} where the tuple covers all constraint variables in order.
    
    public tuple(int [] vals)
    {
        this.vals=vals;
        
        // This tuple is contained in one linked list per variable in the constraint, in supports_current
        next = new tuple[vals.length];
        prev = new tuple[vals.length];
        in_list= new boolean[vals.length];
        for(int i=0; i<in_list.length; i++)
        {
            in_list[i]=false;
        }
    }
    
    public String toString()
    {
        String st="";
        for(int i=0; i<vals.length; i++)
            st+=vals[i]+" ";
        st+="in_list:";
        for(int i=0; i<vals.length; i++)
            st+=in_list[i]+" ";
        return st;
    }
    
    public int hashCode()
    {  // really could use some improvement.
        int total=0;
        for(int i=0; i<vals.length; i++)
        {
            total = (total+vals[i]) << 2;
        }
        return total;
    }
    
    public boolean equals(Object tup2)
    {
        if(tup2 instanceof tuple)
        {
            if(((tuple)tup2).vals.length!=this.vals.length)
            {
                return false;
            }
            else
            {
                for(int i=0; i<this.vals.length; i++)
                {
                    if(this.vals[i]!=((tuple)tup2).vals[i])
                    {
                        return false;
                    }
                }
                return true;
            }
        }
        
        return false;
    }
}
