// general class for backtracking data structures.
package queso.core; 

import gnu.trove.*;

public abstract class backtrack
{
    TIntArrayList backtrack_levels;   // maps tree depth -> first index of relevant data in removals_vars and removals_vals
    int level;                // Current tree depth 0.. #vars
    
    public backtrack()
    {
        backtrack_levels= new TIntArrayList();  // should really be n*d
        
        // init backtrack stack.
        level=0;
        backtrack_levels.add(-1);  //  this is invariant
    }
    
    public void add_backtrack_level()
    {
        backtrack_levels.add(backtrack_levels.get(level));
        level++;
    }
    
    public void backtrack_increment()
    {
        int curpointer=backtrack_levels.get(level)+1;
        
        backtrack_levels.set(level, curpointer);
    }
    
    public void backtrack()
    {
        // abstract backtrack function
        assert level>0;
        
        for(int i=backtrack_levels.get(level); i>backtrack_levels.get(level-1); i--)
        {
            backtrack_item();
        }
        
        backtrack_levels.remove(level);
        
        level--;
    }
    
    public abstract void backtrack_item();
}
