package queso.core;

import queso.constraints.*;

public class existential extends hash_var
{
    boolean empty=false;
    
    public existential(int lowerbound, int upperbound, qcsp problem, String name)
    {
        super(lowerbound, upperbound, problem, false, name);
    }
    
    public existential(int numvals, qcsp problem, String name)
    {
        super(0, numvals-1, problem, false, name);
    }
    
    public boolean exclude(int val, constraint callingcons)
    {
        // val is the value to remove, callingcons is the calling constraint (may be null).
        //System.out.println("In exclude.");
        
        if(problem.pruning) System.out.println("Pruning var "+this+" val "+val);
        
        assert is_present(val);
        
        if(!remove(val))
        {
            if(problem.treetrace)System.out.println("Empty domain "+this);
            return false;
        }
        
        // Check the wakeups array here
        for(constraint temp : wakeups_anychange)
        {
            if(temp!=callingcons)
            {
                //System.out.println("Adding constraint: "+temp);
                if(temp instanceof fd_propagate)
                    problem.queue.push_constraint((fd_propagate)temp, id, val);
                else
                    problem.queue.push_constraint((make_ac)temp);
            }
        }
        
        return true;
    }
    
    public boolean exclude_upper(int val, constraint cons)
    {
        assert val<upperbound;
        for(int i=upperbound; i>val; i--)
        {
            if(is_present(i))
            {
                if(!exclude(i, cons))
                    return false;
            }
        }
        assert invariant();
        return true;
    }
    
    public boolean exclude_lower(int val, constraint cons)
    {
        assert val>lowerbound;
        for(int i=lowerbound; i<val; i++)
        {
            if(is_present(i))
            {
                if(!exclude(i, cons))
                    return false;
            }
        }
        assert invariant();
        return true;
    }
    
    public boolean pure(int val, constraint cons)
    {
        assert is_present(val);//System.out.println("Pruning (pure) var "+this+" val "+val);
        // no need to consider other values.
        // does this work with optimization?
        // Yes, unless this is the optimization value.
        instantiate(val);
        return true;
    }
    
    /*public boolean trivial(int val, constraint cons)
    {
        assert false: "not implemented";
        // does trivial really mean anything for an existential, with optimization?
        // can we really set it?? I think probably not. :-/
        return true;
    }*/
    
    public boolean instantiate(int val)
    {
        // set var=val
        
        assert is_present(val);
        
        //exclude all other values
        for(int i=lowerbound; i<=upperbound; i++)
        {
            if(is_present(i) && i!=val)
            {
                boolean temp=exclude(i, null);
                assert temp;
            }
        }
        return true;
    }
    
    // All of the following prune from the bounds
    /*public boolean pure_upper(int val, constraint cons)
    {
        return trivial_upper(val, cons);
    }
    
    public boolean pure_lower(int val, constraint cons)
    {
        return trivial_lower(val, cons);
    }*/
    
    // in the existential case, we just set a pure value.
    
    // maybe set a trivial value as well.
    
    // THESE TWO ARE WRONG
    /*public boolean trivial_upper(int val, constraint cons)
    {assert false: "not implemented";
        // don't prune the last value
        int oldupperbound=upperbound;
        remove_upper_nofail(val);
        int newupperbound=upperbound;
        
        // Check the wakeups array here
        for(constraint temp : wakeups_anychange)
        {
            if(temp!=cons)
            {
                //System.out.println("Adding constraint: "+temp);
                if(temp instanceof make_ac)
                    problem.queue.push_constraint((make_ac)temp);
                else
                {
                    for(int i=oldupperbound; i>newupperbound; i++)
                        problem.queue.push_constraint((fd_propagate)temp, id, val);
                }
            }
        }
        return true;
    }
    
    public boolean trivial_lower(int val, constraint cons)
    {assert false: "not implemented";
        int oldlowerbound=lowerbound;
        remove_lower_nofail(val);
        int newlowerbound=lowerbound;
        
        // Check the wakeups array here
        for(constraint temp : wakeups_anychange)
        {
            if(temp!=cons)
            {
                //System.out.println("Adding constraint: "+temp);
                if(temp instanceof make_ac)
                    problem.queue.push_constraint((make_ac)temp);
                else
                {
                    for(int i=oldlowerbound; i<newlowerbound; i++)
                        problem.queue.push_constraint((fd_propagate)temp, id, val);
                }
            }
        }
        return true;
        // wakeups
    }*/
}
