package queso.core;

import gnu.math.*;
import queso.constraints.constraint;

public interface intnum_bounds extends variable_iface
{
    // should be everything necessary for propagators like product.
    IntNum upperbound_big();
    IntNum lowerbound_big();
    
    IntNum positive_smallest_big();    // for the sake of the new definition of 5-bound consistency.
    IntNum negative_smallest_big();
    
    boolean exclude_upper(IntNum val, constraint cons);
    boolean exclude_lower(IntNum val, constraint cons);
    
    // declares that from the old upper/lower bound to val is pure
    // boolean pure_upper(IntNum val, constraint cons);
    // boolean pure_lower(IntNum val, constraint cons);
    
    // declares that from the old upper/lower bound to val is trivial
    //boolean trivial_upper(IntNum val, constraint cons);
    //boolean trivial_lower(IntNum val, constraint cons);
    
    boolean is_present(IntNum val);
    boolean is_present(int val);
    
    boolean containsZero();  // if zero is in the domain
    
    // perhaps these two can be deleted.
    //int domsize();  // for making an array on the propagator side.
    //int offset();   // when addressing an array, use [offset+val]
    
    //boolean instantiate(IntNum val);  // it should always succeed
}
