package queso.core;

import queso.constraints.constraint;

public interface mid_domain extends variable_iface
{
    // everything required by a propagator which punches holes or revises upper or lower bounds.
    boolean exclude(int val, constraint cons);   // val is locally inconsistent
    boolean exclude_upper(int val, constraint cons);   // val is the new upperbound
    boolean exclude_lower(int val, constraint cons);   // val is the new lowerbound.
    
    boolean pure(int val, constraint cons);    // val is pure, should always succeed.
    //boolean trivial(int val, constraint cons); // val is trivial (i.e. causes the dual problem to falsify,
                                                        // that is the primal problem to be satisfied.
    boolean is_present(int val);
    
    // for iteration.
    int upperbound();
    int lowerbound();
    
    int domsize();  // for making an array on the propagator side.
    int offset();   // when addressing an array, use [offset+val]
    
    boolean quant();
    int id();
    
    boolean instantiate(int val);  // it should always succeed
}
