package queso.core;

import queso.constraints.*;

public class puremonitor extends hash_var
{
    // like an existential but does not monitor for domain wipeout.
    
    public puremonitor(int lowerbound, int upperbound, qcsp problem, String name)
    {
        super(lowerbound, upperbound, problem, false, name);
    }
    
    public puremonitor(int numvalues, qcsp problem, String name)
    {
        super(0, numvalues-1, problem, false, name);
    }
    
    public final boolean exclude(int val, constraint callingcons)
    {
        // val is the value to remove, callingcons is the calling constraint (may be null).
        //System.out.println("In exclude.");
        
        if(problem.pruning) System.out.println("Pruning var "+this+" val "+val);
        
        assert is_present(val);
        
        remove(val);
        
        // Check the wakeups array here
        for(constraint temp : wakeups_anychange)
        {
            if(temp!=callingcons)
            {
                //System.out.println("Adding constraint: "+temp);
                if(temp instanceof fd_propagate)   // if it is gac_schema
                    problem.queue.push_constraint((fd_propagate)temp, id, val);
                else
                    problem.queue.push_constraint((make_ac)temp);
            }
        }
        
        return true;
    }
    
    public boolean exclude_upper(int val, constraint cons)
    {
        assert val<upperbound;
        for(int i=upperbound; i>val; i--)
        {
            if(!exclude(i, cons))
                return false;
        }
        return true;
    }
    
    public boolean exclude_lower(int val, constraint cons)
    {
        assert val>lowerbound;
        for(int i=lowerbound; i<val; i++)
        {
            if(!exclude(i, cons))
                return false;
        }
        return true;
    }
    
    public boolean trivial_upper(int val, constraint cons)
    {
        // should never be called
        assert false; return false;
    }
    
    public boolean trivial_lower(int val, constraint cons)
    {
        assert false; return false;
    }
    
    public boolean pure_upper(int val, constraint cons)
    {
        assert false; return false;
    }
    
    public boolean pure_lower(int val, constraint cons)
    {
        assert false; return false;
    }
    
    public boolean pure(int val, constraint cons)
    {
        assert false : "Why was this called?"; return false;
    }
    
    public boolean instantiate(int val)
    {
        assert false : "Why was this called?";
        return false;
    }
}
