// lets go for three densities, tight (10% probability sat), loose (90%) and half.
// Say 5 constraints per problem
// ex1: 24 variables, cts arity 10, domain size 2->4
package queso.experiments;

import java.util.*;
import java.math.*;
import java.lang.*;
import java.io.*;
import queso.core.*;
import queso.constraints.*;
import queso.encoding.*;

// experiments for chapter 4 about general constraints. 
// for all constraint types:
// cf. domain size 2 against QBF solvers at various arities from 2 up to 10, across ph. transition
// with straightforward encoding into QBF.

// cf  against QCSPsolve/blocksolve for arity 2 and upwards using 

// for all constraint types:
// compare against each other for various d and r and looseness, adjusting e to span the p.t.
// Plot the whole thing on some scatter graphs for weight of evidence.

class chgen_experiment_vsqbf
{
    
    // derived from ijcai07quant
    
    // sq/wq algorithms against QBF using the straightforward QBF encoding.
    
    public static void main(String [] args)
    {
        chgen_experiment_vsqbf ex;
        Ctype c;
        for(looseness=0.2; looseness<=0.8; looseness=looseness+0.3)
        {//looseness=0.8;
        System.out.println("looseness:"+looseness);
        
        c=Ctype.sqgac;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("SQGAC");
        ex.runbunch(c);
        
        c=Ctype.gspredicate;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("WQGAC-predicate");
        ex.runbunch(c);
        
        c=Ctype.nightingale;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("nightingale");
        ex.runbunch(c);
        
        c=Ctype.nightingaleOneList;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("nightingaleOneList");
        ex.runbunch(c);
        
        c=Ctype.gspositive;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("WQGAC-positive");
        ex.runbunch(c);
        
        // run them all again after warming up the hotspot.
        
        c=Ctype.sqgac;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("SQGAC");
        ex.runbunch(c);
        
        c=Ctype.gspredicate;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("WQGAC-predicate");
        ex.runbunch(c);
        
        c=Ctype.nightingale;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("nightingale");
        ex.runbunch(c);
        
        c=Ctype.nightingaleOneList;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("nightingaleOneList");
        ex.runbunch(c);
        
        c=Ctype.gspositive;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("WQGAC-positive");
        ex.runbunch(c);
        
        c=Ctype.qbfcsbj;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("QBF csbj");
        ex.runbunch(c);
        
        c=Ctype.qbfquantor;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("QBF Quantor");
        ex.runbunch(c);
        
        c=Ctype.qbfskizzo;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("QBF Skizzo");
        ex.runbunch(c);
        
        c=Ctype.qbfquberel;
        ex=new chgen_experiment_vsqbf();
        ex.r=new Random(12345);
        System.out.println("QBF Qube Rel");
        ex.runbunch(c);
        
        }
    }
    
    void runbunch(Ctype c)
    {
        for(int arity=3; arity<=10; arity=arity+1)
        {//int arity=11;
        System.out.println("arity:"+arity);
        //for(int d=2; d<=5; d++)
        {int d=2;  // for easy encoding to QBF.
        
        int numvars;
        if(looseness==0.2) numvars=30;
        else numvars=25;
        
        //if(d==2) numvars=25;
        //else if(d==3) numvars=13;
        //else if(d==4) numvars=8;
        //else numvars=7; // d==5
        
        //if(arity==7 || arity==8) numvars--;
        //else if(arity==9 || arity==10) numvars=numvars-2;
        //else if(arity==11) numvars=numvars-3;
        
        //if(looseness==0.8) numvars=numvars-3;  // make it a bit easier
        
        //numvars=25;
        
        if(arity>numvars) break;
        
        if(arity==7 && d>=5) break;
        if(arity==9 && d>=4) break;
        if(arity==11 && d>=3) break;
        
        int numconslimit=(looseness<=0.3)?20:30;
        
        for(int numcons=1; numcons<=numconslimit; numcons=numcons+1)
        {
            long time=0;
            long snstimelocal=0;
            long snscountlocal=0;
            int numsat=0;
            int tries=10;
            int sumnodes=0;
            for(int i=0; i<tries; i++){
                time+=runtest(d, c, arity, numcons, numvars, "vsqcspsolve_d"+d+"_r"+arity+"_e"+numcons+"_i"+i);
                snstimelocal+=snstime;
                snscountlocal+=snscount;
                numsat+=(ifsat?1:0);
                sumnodes+=nodes;
            }
            System.out.println("d:"+d+" numcons:"+numcons+" numvars:"+numvars+" time for suite:"+time+" numsat:"+numsat+"/"+tries+" sumnodes:"+sumnodes);
            //if(numsat<=(tries/4)) break;  // below the quartile, stop.
        }
        }
        }
    }
    
    Random r; // random number generator.
    stopwatch2 sw;
    
    static double looseness;
    
    // returns from the runtest method.
    long snstime;
    long snscount;
    //long domainchecks;
    boolean ifsat=false;
    int nodes;
    
    long runtest(int d, Ctype c, int arity, int numcons, int numvars, String filename)
    {
        sw=new stopwatch2();
        // generate a model and run it for each propagator.
        qcsp prob=new qcsp(false, false, false, false, false);    // I don't see why it should be crippled like this.
        mid_domain [] vars=new mid_domain[numvars];
        
        for(int i=0; i<numvars; i++)
        {
            if(i==5 || i==5 || i==11 || i==11 || i==17 || i==17 || i==23 || i==23)
            {
                vars[i]=new universal(d, prob, "ux"+i);  // d for domain size.
            }
            else
            {
                vars[i]=new existential(d, prob, "ex"+i);  // d for domain size.
            }
        }
        
        numclauses=0;
        StringBuffer clauses=new StringBuffer();
        
        StringBuffer doms=new StringBuffer();
        StringBuffer hidvars=new StringBuffer();
        StringBuffer constemplates=new StringBuffer();
        StringBuffer conflicts=new StringBuffer();
        int hnumber=numvars;
        
        // gen  constraints.
        for(int i=0; i<numcons; i++)
        {
            // pick arity variables
            mid_domain [] gsvars=new mid_domain[arity];
            int counter=0;
            while(counter<arity)
            {
                int varIndex=(int) Math.floor(r.nextFloat()*numvars);
                if(!tuples.in(gsvars, vars[varIndex]))
                {
                    gsvars[counter]=vars[varIndex];
                    counter++;
                }
            }
            
            //sort
            varcompare vc=new varcompare();
            Arrays.sort(gsvars, vc);
            
            //int [][] tab=tuples.generateprobability(arity, gsvars, r, (float) looseness);
            int numtups=Math.round((float) (looseness* Math.pow((double)d, (double)arity )));
            if(numtups==0) {ifsat=false; return 0;}
            //System.out.println("generating tuples");
            int [][] tab=tuples.generatetuples(arity, gsvars, r, numtups);
            //System.out.println("Done tuples");
            // construct constraint
            predicate_wrapper p1=new table_predicate((int [][])tab.clone());
            
            if(c==Ctype.sqgac || c==Ctype.qcspsolve || c==Ctype.blocksolve)
            {
                new sqgac(gsvars, prob, p1);
            }
            else if(c==Ctype.gspredicate)
            {
                new gac_schema_predicate(gsvars, prob, p1); // warning: predicate maynot be efficient.
            }
            else if(c==Ctype.gspositive)
            {
                new gac_schema_positive(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.nightingale)
            {
                new nightingaletuples(gsvars, prob, p1, true, true);
            }
            else if(c==Ctype.nightingaleOneList)
            {
                new nightingaletuples(gsvars, prob, p1, false, true);
            }
            else if(c==Ctype.qbfquantor || c==Ctype.qbfquberel || c==Ctype.qbfqubebj || c==Ctype.qbfskizzo || c==Ctype.qbfcsbj)
            {
                genclauses(tab, clauses, gsvars);
            }
        }
        
        System.gc();  // attempt to stop it gc'ing during the run.
        
        if(c==Ctype.qbfquantor || c==Ctype.qbfquberel  || c==Ctype.qbfqubebj || c==Ctype.qbfskizzo || c==Ctype.qbfcsbj)
        {
            printqbfinstance(clauses, vars);
            sw.zero();
            sw.start();
            runqbfsolvers(c);
            sw.end();
            return sw.elapsedMicros();
        }
        else if(c==Ctype.qcspsolve || c==Ctype.blocksolve)
        {
            encoding.qcspencodeproblem(prob, filename);
            sw.zero();
            sw.start();
            ifsat=runbinarysolver(c);
            sw.end();
            return sw.elapsedMicros();
        }
        else
        {
        sw.zero();
        stopwatch swbackup=new stopwatch();
        swbackup.start();
        sw.start();
        ifsat=prob.establish();
        //sw.end();
        
        //System.out.println("Establish time: "+sw.elapsedMicros());
        //prob.printdomains();
        //sw.start();
        
        if(ifsat) ifsat=prob.search();
        
        //System.out.println("Sat:"+ifsat);
        sw.end();
        swbackup.end();
        
        this.nodes=prob.numnodes;
        
        snstime=0;
        snscount=0;
        for(constraint cons : prob.constraints)
        {
            if(!(cons instanceof gac_schema)) break;
            
            if(((gac_schema)cons).sw!=null){ 
            snstime+=((gac_schema)cons).sw.elapsedMicros();
            snscount+=((gac_schema)cons).snscount;
            }
        }
        
        //System.out.println("Search time: "+sw.elapsedMillis()+" nodes:"+prob.numnodes);
        return sw.elapsedMicros();
        }
        //return swbackup.elapsedMillis()*1000;
    }
    
    void printqbfinstance(StringBuffer sb, mid_domain [] vars)
    {
        String st="p cnf "+vars.length+" "+numclauses+"\n";
        
        for(int i=0; i<vars.length; i++)
        {
            if(vars[i].quant()) 
            {
                st+="a "+(vars[i].id()+1)+" 0\n";
            }
            else
            {
                st+="e "+(vars[i].id()+1)+" 0\n";
            }
        }
        
        sb.insert(0, st);
        
        try
        {
            File output = new File("myinstance.qdimacs");
            FileWriter out = new FileWriter(output);
            out.write(sb.toString());
            out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing myinstance.qdimacs");
        }
    }
    
    void runqbfsolvers(Ctype c)
    {
        Process p=null;
        try
        {
            if(c==Ctype.qbfcsbj)
                p = Runtime.getRuntime().exec("/home/pn/bin/csbj myinstance.qdimacs");
            else if(c==Ctype.qbfquantor)
                p = Runtime.getRuntime().exec("/home/pn/bin/quantor myinstance.qdimacs");
            else if(c==Ctype.qbfquberel)
                p = Runtime.getRuntime().exec("/home/pn/bin/quberel myinstance.qdimacs");
            else if(c==Ctype.qbfqubebj)
                p = Runtime.getRuntime().exec("/home/pn/bin/qubebj myinstance.qdimacs");
            else if(c==Ctype.qbfskizzo)
                p = Runtime.getRuntime().exec("/home/pn/bin/skizzo myinstance.qdimacs");
        } catch(java.lang.Exception e)
        {
            System.out.println("Problem running solver");
        }
        
        try
        {
            int retval=p.waitFor();
            //assert retval==0;
        } catch(java.lang.Exception e)
        {
            System.out.println("Problem waiting");
        }
    }
    
    static int numclauses;
    
    boolean runbinarysolver(Ctype c)
    {   
        Process p=null;
        boolean flag=false;
        if(c==Ctype.qcspsolve)
        {
            try
            {
                p = Runtime.getRuntime().exec("/home/pn/qcspsolve/qcspsolve-new myinstance.qcsp");
            }
            catch(java.lang.Exception e)
            {
                System.out.println("Problem running solver");
            }
            try
            {
                int retval=p.waitFor();
                BufferedInputStream in = new BufferedInputStream(p.getInputStream());
                
                int size = in.available();
	            byte[] content = new byte[size];
	            
	            in.read(content);
	            String st = new String(content);
                
                String [] st2=st.split(":");
                st=st2[st2.length-1];
                
                st=st.substring(1,2);
                
                flag= st.compareTo("t")==0;
                //System.out.println(st.compareTo("t")==0);
            } catch(java.lang.Exception e)
            {
                System.out.println("Problem waiting");
            }
            return flag;
        }
        else if(c==Ctype.blocksolve)
        {
            try
            {
                p = Runtime.getRuntime().exec
                ("java -Djava.library.path=/home/pn/BlockSolve/ -jar /home/pn/BlockSolve/blocksolve.jar myinstance.qcsp false");
            }
            catch(java.lang.Exception e)
            {
                System.out.println("Problem running solver");
            }
            try
            {
                int retval=p.waitFor();
                BufferedInputStream in = new BufferedInputStream(p.getInputStream());
                
                int size = in.available();
	            byte[] content = new byte[size];
	            
	            in.read(content);
	            String st = new String(content);
                
                String [] st2=st.split(":");
                
                flag= st2[0].compareTo("true")==0;
                
            } catch(java.lang.Exception e)
            {
                System.out.println("Problem waiting");
            }
            return flag;
        }
        assert false;
        return false;
    }
    
    /*void runbinarysolver(Ctype c)
    {   
        Process p=null;
        
        if(c==Ctype.qcspsolve)
        {
            try
            {
                p = Runtime.getRuntime().exec("/home/pn/bin/qcspsolve myinstance.qcsp");
            }
            catch(java.lang.Exception e)
            {
                System.out.println("Problem running solver");
            }
            try
            {
                int retval=p.waitFor();
                //assert retval==0;
            } catch(java.lang.Exception e)
            {
                System.out.println("Problem waiting");
            }
            return;
        }
        assert false;
    }*/
    
    void genclauses(int [][] table, StringBuffer sb, mid_domain [] consvars)
    {
        int [][] fliptable=tuples.fliptable(table, consvars);
        numclauses+=fliptable.length;
        for(int i=0; i<fliptable.length; i++)
        {
            for(int j=0; j<fliptable[i].length; j++)
            {
                sb.append((consvars[j].id()+1) * ((fliptable[i][j]==0)?1:-1));
                sb.append(" ");
            }
            sb.append("0\n");
        }
    }
}

class chgen_experiment_vsqcspsolve extends chgen_experiment_vsqbf
{
    // derived from ijcai07quant
    // sq/wq algorithms against qcspsolve using the hidden variable encoding.
    // run qcspsolve with the same parameters as the experiment above, 
    // then combine with the data above.
    public static void main(String [] args)
    {
        chgen_experiment_vsqcspsolve ex;
        Ctype c;
        //for(looseness=0.2; looseness<=0.8; looseness=looseness+0.3)
        {looseness=0.5;
        System.out.println("looseness:"+looseness);
        
        /*c=Ctype.sqgac;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("SQGAC");
        ex.runbunch(c);
        
        c=Ctype.gspredicate;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("WQGAC-predicate");
        ex.runbunch(c);
        
        c=Ctype.nightingale;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("nightingale");
        ex.runbunch(c);
        
        c=Ctype.nightingaleOneList;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("nightingaleOneList");
        ex.runbunch(c);
        
        c=Ctype.gspositive;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("WQGAC-positive");
        ex.runbunch(c);
        
        // run them all again after warming up the hotspot.
        
        c=Ctype.sqgac;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("SQGAC");
        ex.runbunch(c);
        
        c=Ctype.gspredicate;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("WQGAC-predicate");
        ex.runbunch(c);
        
        c=Ctype.nightingale;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("nightingale");
        ex.runbunch(c);
        
        c=Ctype.nightingaleOneList;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("nightingaleOneList");
        ex.runbunch(c);
        
        c=Ctype.gspositive;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("WQGAC-positive");
        ex.runbunch(c);
        */
        // now the other solvers
        
        c=Ctype.blocksolve;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("Blocksolve");
        ex.runbunch(c);
        
        
        /*c=Ctype.qcspsolve;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("QCSP-Solve");
        ex.runbunch(c);*/
        
        }
    }
    
}

class chgen_experiment_vsqcspsolve_todelete extends chgen_experiment_vsqbf
{
    // derived from ijcai07quant
    // sq/wq algorithms against qcspsolve using the hidden variable encoding.
    // run qcspsolve with the same parameters as the experiment above, 
    // then combine with the data above.
    public static void main(String [] args)
    {
        chgen_experiment_vsqcspsolve_todelete ex;
        Ctype c;
        //for(looseness=0.2; looseness<=0.8; looseness=looseness+0.3)
        {looseness=0.2;
        System.out.println("looseness:"+looseness);
        
        /*c=Ctype.sqgac;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("SQGAC");
        ex.runbunch(c);
        
        c=Ctype.gspredicate;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("WQGAC-predicate");
        ex.runbunch(c);
        
        c=Ctype.nightingale;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("nightingale");
        ex.runbunch(c);
        
        c=Ctype.nightingaleOneList;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("nightingaleOneList");
        ex.runbunch(c);
        
        c=Ctype.gspositive;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("WQGAC-positive");
        ex.runbunch(c);
        
        // run them all again after warming up the hotspot.
        
        c=Ctype.sqgac;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("SQGAC");
        ex.runbunch(c);
        
        c=Ctype.gspredicate;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("WQGAC-predicate");
        ex.runbunch(c);
        
        c=Ctype.nightingale;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("nightingale");
        ex.runbunch(c);
        
        c=Ctype.nightingaleOneList;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("nightingaleOneList");
        ex.runbunch(c);
        
        c=Ctype.gspositive;
        ex=new chgen_experiment_vsqcspsolve();
        ex.r=new Random(12345);
        System.out.println("WQGAC-positive");
        ex.runbunch(c);
        */
        // now the other solvers
        
        c=Ctype.blocksolve;
        ex=new chgen_experiment_vsqcspsolve_todelete();
        ex.r=new Random(12345);
        System.out.println("Blocksolve");
        ex.runbunch(c);
        
        
        c=Ctype.qcspsolve;
        ex=new chgen_experiment_vsqcspsolve_todelete();
        ex.r=new Random(12345);
        System.out.println("QCSP-Solve");
        ex.runbunch(c);
        
        c=Ctype.sqgac;
        ex=new chgen_experiment_vsqcspsolve_todelete();
        ex.r=new Random(12345);
        System.out.println("SQGAC");
        ex.runbunch(c);
        }
    }
    
    void runbunch(Ctype c)
    {
        for(int arity=3; arity<=3; arity=arity+1)
        {//int arity=3;
        System.out.println("arity:"+arity);
        //for(int d=2; d<=5; d++)
        {int d=2;  // for easy encoding to QBF.
        
        int numvars;
        if(looseness==0.2) numvars=30;
        else numvars=25;
        
        //if(d==2) numvars=25;
        //else if(d==3) numvars=13;
        //else if(d==4) numvars=8;
        //else numvars=7; // d==5
        
        //if(arity==7 || arity==8) numvars--;
        //else if(arity==9 || arity==10) numvars=numvars-2;
        //else if(arity==11) numvars=numvars-3;
        
        //if(looseness==0.8) numvars=numvars-3;  // make it a bit easier
        
        //numvars=25;
        
        if(arity>numvars) break;
        
        if(arity==7 && d>=5) break;
        if(arity==9 && d>=4) break;
        if(arity==11 && d>=3) break;
        
        int numconslimit=(looseness<=0.3)?20:30;
        
        //for(int numcons=1; numcons<=numconslimit; numcons=numcons+1)
        {int numcons=1;
            long time=0;
            long snstimelocal=0;
            long snscountlocal=0;
            int numsat=0;
            int tries=10;
            int sumnodes=0;
            for(int i=0; i<tries; i++){
                time+=runtest(d, c, arity, numcons, numvars, "vsqcspsolve_d"+d+"_r"+arity+"_e"+numcons+"_i"+i);
                snstimelocal+=snstime;
                snscountlocal+=snscount;
                numsat+=(ifsat?1:0);
                sumnodes+=nodes;
            }
            System.out.println("d:"+d+" numcons:"+numcons+" numvars:"+numvars+" time for suite:"+time+" numsat:"+numsat+"/"+tries+" sumnodes:"+sumnodes);
            //if(numsat<=(tries/4)) break;  // below the quartile, stop.
        }
        }
        }
    }
    
    long runtest(int d, Ctype c, int arity, int numcons, int numvars, String probname)
    {
        sw=new stopwatch2();
        // generate a model and run it for each propagator.
        qcsp prob=new qcsp(false, false, false, false, false);    // I don't see why it should be crippled like this.
        mid_domain [] vars=new mid_domain[numvars];
        
        for(int i=0; i<numvars; i++)
        {
            if(i==5 || i==5 || i==11 || i==11 || i==17 || i==17 || i==23 || i==23)
            {
                vars[i]=new universal(d, prob, "ux"+i);  // d for domain size.
            }
            else
            {
                vars[i]=new existential(d, prob, "ex"+i);  // d for domain size.
            }
        }
        
        numclauses=0;
        StringBuffer clauses=new StringBuffer();
        
        StringBuffer doms=new StringBuffer();
        StringBuffer hidvars=new StringBuffer();
        StringBuffer constemplates=new StringBuffer();
        StringBuffer conflicts=new StringBuffer();
        int hnumber=numvars;
        
        // gen  constraints.
        for(int i=0; i<numcons; i++)
        {
            // pick arity variables
            mid_domain [] gsvars=new mid_domain[arity];
            int counter=0;
            while(counter<arity)
            {
                int varIndex=(int) Math.floor(r.nextFloat()*numvars);
                if(!tuples.in(gsvars, vars[varIndex]))
                {
                    gsvars[counter]=vars[varIndex];
                    counter++;
                }
            }
            
            //sort
            varcompare vc=new varcompare();
            Arrays.sort(gsvars, vc);
            
            //int [][] tab=tuples.generateprobability(arity, gsvars, r, (float) looseness);
            int numtups=Math.round((float) (looseness* Math.pow((double)d, (double)arity )));
            if(numtups==0) {ifsat=false; return 0;}
            //System.out.println("generating tuples");
            int [][] tab=tuples.generatetuples(arity, gsvars, r, numtups);
            //System.out.println("Done tuples");
            // construct constraint
            predicate_wrapper p1=new table_predicate((int [][])tab.clone());
            
            if(c==Ctype.sqgac || c==Ctype.qcspsolve || c==Ctype.blocksolve)
            {
                new sqgac(gsvars, prob, p1);
            }
            else if(c==Ctype.gspredicate)
            {
                new gac_schema_predicate(gsvars, prob, p1); // warning: predicate maynot be efficient.
            }
            else if(c==Ctype.gspositive)
            {
                new gac_schema_positive(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.nightingale)
            {
                new nightingaletuples(gsvars, prob, p1, true, true);
            }
            else if(c==Ctype.nightingaleOneList)
            {
                new nightingaletuples(gsvars, prob, p1, false, true);
            }
            else if(c==Ctype.qbfquantor || c==Ctype.qbfquberel || c==Ctype.qbfqubebj || c==Ctype.qbfskizzo || c==Ctype.qbfcsbj)
            {
                genclauses(tab, clauses, gsvars);
            }
        }
        
        System.gc();  // attempt to stop it gc'ing during the run.
        
        if(c==Ctype.qbfquantor || c==Ctype.qbfquberel  || c==Ctype.qbfqubebj || c==Ctype.qbfskizzo || c==Ctype.qbfcsbj)
        {
            printqbfinstance(clauses, vars);
            sw.zero();
            sw.start();
            runqbfsolvers(c);
            sw.end();
            return sw.elapsedMicros();
        }
        else if(c==Ctype.qcspsolve || c==Ctype.blocksolve)
        {
            //encoding.outputqcspinstance(doms, hidvars, constemplates, conflicts, vars, numcons);
            encoding.qcspencodeproblem(prob, probname);
            sw.zero();
            sw.start();
            ifsat=runbinarysolver(c);
            sw.end();
            return sw.elapsedMicros();
        }
        else
        {
        sw.zero();
        stopwatch swbackup=new stopwatch();
        swbackup.start();
        sw.start();
        ifsat=prob.establish();
        //sw.end();
        
        //System.out.println("Establish time: "+sw.elapsedMicros());
        //prob.printdomains();
        //sw.start();
        
        if(ifsat) ifsat=prob.search();
        
        //System.out.println("Sat:"+ifsat);
        sw.end();
        swbackup.end();
        
        this.nodes=prob.numnodes;
        
        snstime=0;
        snscount=0;
        for(constraint cons : prob.constraints)
        {
            if(!(cons instanceof gac_schema)) break;
            
            if(((gac_schema)cons).sw!=null){ 
            snstime+=((gac_schema)cons).sw.elapsedMicros();
            snscount+=((gac_schema)cons).snscount;
            }
        }
        
        //System.out.println("Search time: "+sw.elapsedMillis()+" nodes:"+prob.numnodes);
        return sw.elapsedMicros();
        }
        //return swbackup.elapsedMillis()*1000;
    }
}

// a second experiment to 
class chgen_experiment_vsqcspsolve2 extends chgen_experiment_vsqbf
{
    // derived from ijcai07quant
    // sq/wq algorithms against qcspsolve using the hidden variable encoding.
    
    public static void main(String [] args)
    {
        chgen_experiment_vsqcspsolve2 ex;
        Ctype c;
        //for(looseness=0.2; looseness<=0.8; looseness=looseness+0.3)
        {looseness=0.8;
        System.out.println("looseness:"+looseness);
        
        /*c=Ctype.sqgac;
        ex=new chgen_experiment_vsqcspsolve2();
        ex.r=new Random(12345);
        System.out.println("SQGAC");
        ex.runbunch(c);
        
        c=Ctype.gspredicate;
        ex=new chgen_experiment_vsqcspsolve2();
        ex.r=new Random(12345);
        System.out.println("WQGAC-predicate");
        ex.runbunch(c);
        
        c=Ctype.nightingale;
        ex=new chgen_experiment_vsqcspsolve2();
        ex.r=new Random(12345);
        System.out.println("nightingale");
        ex.runbunch(c);
        
        c=Ctype.nightingaleOneList;
        ex=new chgen_experiment_vsqcspsolve2();
        ex.r=new Random(12345);
        System.out.println("nightingaleOneList");
        ex.runbunch(c);
        
        c=Ctype.gspositive;
        ex=new chgen_experiment_vsqcspsolve2();
        ex.r=new Random(12345);
        System.out.println("WQGAC-positive");
        ex.runbunch(c);
        
        // run them all again after warming up the hotspot.
        
        c=Ctype.sqgac;
        ex=new chgen_experiment_vsqcspsolve2();
        ex.r=new Random(12345);
        System.out.println("SQGAC");
        ex.runbunch(c);
        
        c=Ctype.gspredicate;
        ex=new chgen_experiment_vsqcspsolve2();
        ex.r=new Random(12345);
        System.out.println("WQGAC-predicate");
        ex.runbunch(c);
        
        c=Ctype.nightingale;
        ex=new chgen_experiment_vsqcspsolve2();
        ex.r=new Random(12345);
        System.out.println("nightingale");
        ex.runbunch(c);
        
        c=Ctype.nightingaleOneList;
        ex=new chgen_experiment_vsqcspsolve2();
        ex.r=new Random(12345);
        System.out.println("nightingaleOneList");
        ex.runbunch(c);
        
        c=Ctype.gspositive;
        ex=new chgen_experiment_vsqcspsolve2();
        ex.r=new Random(12345);
        System.out.println("WQGAC-positive");
        ex.runbunch(c);*/
        
        // now the other solvers
        
        c=Ctype.qcspsolve;
        ex=new chgen_experiment_vsqcspsolve2();
        ex.r=new Random(12345);
        System.out.println("QCSP-Solve");
        ex.runbunch(c);
        
        }
    }
    
    void runbunch(Ctype c)
    {
        //for(int arity=3; arity<=10; arity=arity+1)
        {int arity=5;
        System.out.println("arity:"+arity);
        //for(int d=2; d<=5; d++)
        {int d=6;  // for easy encoding to QBF.
        
        int numvars=10;
        
        int numconslimit=(looseness<=0.3)?15:((looseness<=0.5)?30:45);
        
        //for(int numcons=(looseness<=0.5)?1:25; numcons<=numconslimit; numcons=numcons+1)
        int numcons=45;
        {
            long time=0;
            long snstimelocal=0;
            long snscountlocal=0;
            int numsat=0;
            int tries=10;
            int sumnodes=0;
            for(int i=0; i<tries; i++){
                time+=runtest(d, c, arity, numcons, numvars, "myinstance.qcsp");
                snstimelocal+=snstime;
                snscountlocal+=snscount;
                numsat+=(ifsat?1:0);
                sumnodes+=nodes;
            }
            System.out.println("d:"+d+" numcons:"+numcons+" numvars:"+numvars+" time for suite:"+time+" numsat:"+numsat+"/"+tries+" sumnodes:"+sumnodes);
            //if(numsat<=(tries/4)) break;  // below the quartile, stop.
        }
        }
        }
    }
}


