package queso.experiments;

import java.io.*;
import java.util.*;
import gnu.math.IntNum;

import queso.core.*;
import queso.constraints.*;

// This is the better model based on periods, with a complete CSP model of JSSP for each period.

// Are the servicetime variables correctly copied forward from one period to the next? 
// yes-- or at least the gap between other tasks is accurately copied forward.

// What on earth is going on when it thrashes>

public class jobshop2
{
    public static void main(String[] args)
    {
        System.out.println("Warming up.");
        runit("prob/la01-5x5.prb", true, 600, 3, false, 5, false, 80, true);
        
        runit("prob/la01-5x5.prb", true, 600, 3, false, 1, false, 50, true);
        runit("prob/la01-5x5.prb", true, 600, 3, false, 1, false, 50, true);
        runit("prob/la01-5x5.prb", true, 600, 3, false, 1, false, 50, true);
        
        //System.out.println("Starting the real experiment without the additional lookahead");
        //experiment(false);
        
        System.out.println("Starting the experiment again with the additional lookahead");
        experiment(true);
        
    }
    
    private static void experiment(boolean lookahead)
    {
        runit("prob/la01-5x5.prb", true, 600, 3, false, 1, false, 50, lookahead);
        for(int i=10; i<=80; i=i+10)
            runit("prob/la01-5x5.prb", true, 600, 3, false, 5, false, i, lookahead);
        
        runit("prob/la02-5x5.prb", true, 600, 3, false, 1, false, 50, lookahead);
        for(int i=10; i<=80; i=i+10)
            runit("prob/la02-5x5.prb", true, 600, 3, false, 5, false, i, lookahead);
        
        runit("prob/la03-5x5.prb", true, 600, 3, false, 1, false, 50, lookahead);
        for(int i=10; i<=80; i=i+10)
            runit("prob/la03-5x5.prb", true, 600, 3, false, 5, false, i, lookahead);
        
        runit("prob/la04-5x5.prb", true, 600, 3, false, 1, false, 50, lookahead);
        for(int i=10; i<=80; i=i+10)
            runit("prob/la04-5x5.prb", true, 600, 3, false, 5, false, i, lookahead);
        
        runit("prob/la05-5x5.prb", true, 600, 3, false, 1, false, 50, lookahead);
        for(int i=10; i<=80; i=i+10)
            runit("prob/la05-5x5.prb", true, 600, 3, false, 5, false, i, lookahead);
        
        runit("prob/la06-5x5.prb", true, 600, 3, false, 1, false, 50, lookahead);
        for(int i=10; i<=80; i=i+10)
            runit("prob/la06-5x5.prb", true, 600, 3, false, 5, false, i, lookahead);
        
        runit("prob/la07-5x5.prb", true, 600, 3, false, 1, false, 50, lookahead);
        for(int i=10; i<=80; i=i+10)
            runit("prob/la07-5x5.prb", true, 600, 3, false, 5, false, i, lookahead);
        
        runit("prob/la08-5x5.prb", true, 600, 3, false, 1, false, 50, lookahead);
        for(int i=10; i<=80; i=i+10)
            runit("prob/la08-5x5.prb", true, 600, 3, false, 5, false, i, lookahead);
        
        runit("prob/la09-5x5.prb", true, 600, 3, false, 1, false, 50, lookahead);
        for(int i=10; i<=80; i=i+10)
            runit("prob/la09-5x5.prb", true, 600, 3, false, 5, false, i, lookahead);
        
        runit("prob/la10-5x5.prb", true, 600, 3, false, 1, false, 50, lookahead);
        for(int i=10; i<=80; i=i+10)
            runit("prob/la10-5x5.prb", true, 600, 3, false, 5, false, i, lookahead);
    }
    
    private static int getnumber(StreamTokenizer st)
    {
        try{ st.nextToken(); }
        catch(java.io.IOException e) {System.out.println("IOe");}
        
        if(st.ttype!=st.TT_NUMBER)
        {
            System.out.println("Error in getnumber");
        }
        return (int)st.nval;
    }
    
    static void runit(String filename, boolean optimize, int maxmakespan, int periods, boolean gimmetree, int failurep_const, boolean printtrues, int servicelength, boolean sac_lookahead)
    {
        int [][]taskmachines={};
        int [][] duration={};
        int jobs=0;
        int machines=0;
        
        System.out.println("fn:"+filename+" opt:"+optimize+" maxms:"+maxmakespan+" pers:"+periods+" tree:"+
            gimmetree+" p:"+failurep_const+" trues:"+printtrues+" servicelen:"+servicelength);
        
        try{
        File inputFile = new File(filename);
        FileReader infile = new FileReader(inputFile);
        BufferedReader in = new BufferedReader(infile);
        
        // throw away the comment line
        while(in.read()!=(int)'\n');
        
        StreamTokenizer st = new StreamTokenizer(in);
        
        st.eolIsSignificant(false);
        
        jobs=getnumber(st);
        machines=getnumber(st);
        
        System.out.println(jobs+" "+machines+"\n");
        //read jobs, then machines,
        // then pairs (machine indexed from 0, duration)
        
        taskmachines = new int[jobs][machines];
        duration = new int[jobs][machines];
        
        for(int job=0; job<jobs; job++)
        {
            for(int task=0; task<machines; task++)
            {
                taskmachines[job][task]=getnumber(st);
                duration[job][task]=getnumber(st);
                System.out.print(taskmachines[job][task]+" "+duration[job][task]+"   ");
            }
            System.out.println();
        }
        } catch(java.lang.Exception e){System.out.println("Problem reading "+filename);}
        
        final int slotsperperiod=maxmakespan/periods;
        assert maxmakespan%periods ==0;
        // testing and repairs parameters
        // each equal period begins with a test. periods must divide maxmakespan.
        
        jsqcsp prob = new jsqcsp(true, false, sac_lookahead, printtrues, false, gimmetree, true);
        
        int [][] failurep=new int[periods][machines];
        
        for(int i=0; i<periods; i++)
            Arrays.fill(failurep[i], failurep_const); // expressed as a percentage in this instance.
        
        IntNum denom=IntNum.make(100);   // the failure probability is failurep/denom.
        
        IntNum quotient=IntNum.power(denom, periods*machines);
        
        IntNum thresholdp=IntNum.quotient(quotient, denom);   // less than 0.01 probability branches are not considered.
        
        mid_domain [][][] begin=new mid_domain[periods][jobs][machines];  // indexed [period][job][task]
        mid_domain [][][] end=new mid_domain[periods][jobs][machines];
        // note that end is the time the job ends, e.g. 6pm, so the next job can start at the same time 6pm.
        // begin 6 and end 6 mean the job actually takes no time.
        
        //mid_domain [][] timeslots=new mid_domain[machines][maxmakespan];  // indexed [machine][slot]
        
        // servicing jobs
        
        mid_domain [][] servicebegin=new mid_domain[periods][machines];
        mid_domain [][] serviceend=new mid_domain[periods][machines];
        
        prob.setvars(machines, jobs, periods, begin, end, taskmachines, maxmakespan, servicebegin, serviceend);
        
        // combined probability of all events that have already happened
        intnum_bounds [][] leftp=new intnum_bounds[periods][machines];
        
        // leftp * non-fail probability for all future events * fail probability for this one.
        intnum_bounds [][] priorp=new intnum_bounds[periods][machines];  
        
        mid_domain [][] available=new mid_domain[periods][machines];
        mid_domain [][] fault=new mid_domain[periods][machines];
        mid_domain [][] shadow=new mid_domain[periods][machines];
        intnum_bounds [][] phere=new intnum_bounds[periods][machines];
        
        mid_domain [] nofault=new mid_domain[periods];   // no fault at the period, so prop. all vars forwards.
        // set up all the variables
        int numconstants=(maxmakespan+1>101)?(maxmakespan+1):101;
        mid_domain [] constants= new mid_domain[numconstants];   // make some constants
        for(int i=0; i<numconstants; i++) constants[i]=new existential(i, i, prob, ""+i);
        
        intnum_bounds threshold_var=new bexistential(thresholdp, thresholdp, prob, thresholdp.toString());
        
        // set up the timeslots in chron. order
        
        for(int period=0; period<periods; period++)
        {
            // do the availability and fault variables here.
            // with connecting constraints
            for(int machine=0; machine<machines; machine++)
            {
                if(period==0 && machine==0)
                    leftp[period][machine]=(intnum_bounds)constants[1];
                else
                    leftp[period][machine]=new bexistential(IntNum.zero(), quotient, prob, "leftp["+period+"]["+machine+"]");
                
                priorp[period][machine]=new bexistential(IntNum.zero(), quotient, prob, "priorp["+period+"]["+machine+"]");
                
                available[period][machine]=new existential(0, 1, prob, "available["+period+"]["+machine+"]");
                fault[period][machine]=new universal(0, 1, prob, "fault["+period+"]["+machine+"]");
                int [] weights={100-failurep[period][machine], failurep[period][machine]};
                ((universal)fault[period][machine]).setweights(weights);
                shadow[period][machine]=new existential(0, 1, prob, "shadow["+period+"]["+machine+"]");
                
                phere[period][machine]=new bexistential(IntNum.zero(), IntNum.make(100), prob, "phere["+period+"]["+machine+"]");
                
                // connect available, fault and shadow s.t. fault can have pure values.
                mid_domain [] v3={available[period][machine], fault[period][machine], shadow[period][machine]};
                boolean [] neg3={true, true, true};
                constraint c3=new or_constraint(v3,neg3,2,prob);
                
                // construct the after maximum probability.
                IntNum afterMaxP=IntNum.one();
                for(int m2=machine+1; m2<machines; m2++)
                {
                    afterMaxP=IntNum.times(afterMaxP, (100-failurep[period][m2]));   // warning: assumes failurep <50%
                }
                
                for(int p2=period+1; p2<periods; p2++)
                {
                    for(int m2=0; m2<machines; m2++)
                    {
                        afterMaxP=IntNum.times(afterMaxP, (100-failurep[p2][m2]));
                    }
                }
                
                afterMaxP=IntNum.times(afterMaxP, failurep[period][machine]);  // no longer just the events after this one.
                intnum_bounds tempconst=new bexistential(afterMaxP, afterMaxP, prob, "afterMaxP:"+period+","+machine);
                
                {intnum_bounds [] v1={leftp[period][machine], priorp[period][machine], tempconst};
                constraint c1=new product_constraint(v1, 1, IntNum.one(), IntNum.one(), prob);}
                
                // compare priorp with the threshold and set available appropriately
                {intnum_bounds [] v1={priorp[period][machine], threshold_var};
                constraint c1=new comparison_constraint(v1, available[period][machine], 1, prob);}
                
                // set phere for the probability of this event.
                assert failurep[period][machine]!=50;
                intnum_bounds failurep_var=(intnum_bounds)constants[failurep[period][machine]];
                intnum_bounds failurep_inv=(intnum_bounds)constants[100-failurep[period][machine]];
                
                {intnum_bounds [] v1={phere[period][machine], failurep_var};
                constraint c1=new comparison_constraint(v1, shadow[period][machine], 0, prob);}
                
                {intnum_bounds [] v1={phere[period][machine], failurep_inv};
                constraint c1=new comparison_constraint(v1, shadow[period][machine], 3, prob);}
                
                // now link lastp and the previous shadow abnd the previous last
                if(period!=0 || machine!=0)
                {
                    int prevperiod=(machine==0)?(period-1):period;
                    int prevmachine=(machine==0)?(machines-1):(machine-1);
                    
                    //leftp[period][machine]=phere[prevperiod][prevmachine]*leftp[prevperiod][prevmachine]
                    intnum_bounds [] v1={leftp[prevperiod][prevmachine], phere[prevperiod][prevmachine], leftp[period][machine]};
                    constraint c1=new product_constraint(v1, 2, IntNum.one(), IntNum.one(), prob);
                }
            }
            
            nofault[period]=new existential(2, prob, "nofault["+period+"]");
            {mid_domain[] v1=new mid_domain[machines+1];
            v1[machines]=nofault[period];
            for(int m=0; m<machines; m++) v1[m]=shadow[period][m];
            boolean[] neg1=new boolean[machines+1]; Arrays.fill(neg1, false); neg1[machines]=true;
            constraint c1=new or_constraint(v1, neg1, machines, prob);
            }
            
            // now the 0/1 vars indicating order on resource
            mid_domain[][][] ltvars=new mid_domain[jobs][jobs][machines];
            for(int job1=0; job1<jobs; job1++)
            {
                for(int job2=job1+1; job2<jobs; job2++)
                {
                    for(int machine=0; machine<machines; machine++)
                    {
                        ltvars[job1][job2][machine]=new existential(2, prob, "lt"+job1+"<"+job2+",m:"+machine);
                    }
                }
            }
            
            // service ordering vars.
            mid_domain[][] slt1=new mid_domain[machines][jobs];
            mid_domain[][] slt2=new mid_domain[machines][jobs];
            for(int machine=0; machine<machines; machine++)
            {
                for(int job=0; job<jobs; job++)
                {
                    slt1[machine][job]=new existential(2, prob, "slt1,m:"+machine+",j:"+job);
                    slt2[machine][job]=new existential(2, prob, "slt2,m:"+machine+",j:"+job);
                }
            }
            
            // construct the model for this period
            for(int task=0; task<machines; task++)
            {
                for(int job=0; job<jobs; job++)
                {
                    begin[period][job][task]=new existential(0, maxmakespan, prob, period+"begin["+job+"]["+task+"]");
                    end[period][job][task]=new existential(0, maxmakespan, prob, period+"end["+job+"]["+task+"]");
                    begin[period][job][task].set_functional();   // hack hack hack
                    end[period][job][task].set_functional();
                    
                    {mid_domain [] v1={(mid_domain)end[period][job][task], 
                        (mid_domain)begin[period][job][task],
                        (mid_domain)constants[duration[job][task]]};
                    int [] w1={1, -1, -1};
                    // end-beginning = duration => end-beginning-duration=0
                    constraint c1=new sum_constraint(v1, w1, prob);}
                    
                    if(task>0)
                    {   //end(task-1)<=begin(task)  
                        mid_domain [] v1={end[period][job][task-1], begin[period][job][task]};
                        constraint c1=new e_comparison(v1, constants[1], -1, prob);
                    }
                }
            }
            
            for(int job1=0; job1<jobs; job1++)
            {
                for(int job2=job1+1; job2<jobs; job2++)
                {
                    for(int machine=0; machine<machines; machine++)
                    {
                        // now find the two tasks from job1 and job2 which contend for the machine.
                        int task1=0, task2=0;
                        
                        while(taskmachines[job1][task1]!=machine) task1++;
                        while(taskmachines[job2][task2]!=machine) task2++;
                        
                        // now task1 < task2  or  task2 < task1
                        //ltvars[job1][job2][machine]=new existential(2, prob, "lt"+job1+"<"+job2+",m:"+machine);
                        mid_domain[] tocomp1= {end[period][job1][task1], begin[period][job2][task2]};
                        constraint c1=new e_comparison(tocomp1, ltvars[job1][job2][machine], -1, prob);
                        
                        mid_domain[] tocomp2= {begin[period][job1][task1], end[period][job2][task2]};
                        constraint c2=new e_comparison(tocomp2, ltvars[job1][job2][machine], -2, prob);
                    }
                }
            }
            
            // now service variables
            for(int machine=0; machine<machines; machine++)
            {
                int periodstart=period*(maxmakespan/periods);
                servicebegin[period][machine]=new existential(periodstart, periodstart+(maxmakespan/periods), prob, "servicebegin["+period+"]["+machine+"]");
                serviceend[period][machine]=new existential(periodstart, periodstart+(maxmakespan/periods), prob, "serviceend["+period+"]["+machine+"]");
                
                servicebegin[period][machine].set_functional();
                serviceend[period][machine].set_functional();
                {mid_domain [] v1={(mid_domain)serviceend[period][machine], 
                    (mid_domain)servicebegin[period][machine],
                    (mid_domain)constants[servicelength]};
                int [] w1={1, -1, -1};
                // end-beginning = duration => end-beginning-duration=0
                constraint c1=new sum_constraint(v1, w1, prob);}
                
                // if shadow == 0 then servicebegin is fixed to periodstart to avoid lots of branching.
                {mid_domain [] vars1={(mid_domain)shadow[period][machine], 
                    (mid_domain)servicebegin[period][machine],
                    (mid_domain)constants[1]};
                int [] vals1={0, periodstart, 1};
                boolean [] neg1={true, false, false};
                // shadow==0  => servicebegin=periodstart
                constraint c1=new or_constraint_values(vars1, vals1, neg1, 2, prob);}
                
                // if shadow ==1 then we need to schedule a period for servicing
                // shadow => slt1 or slt2 where slt1 and slt2 indicate either servicing is before or after.
                
                for(int job=0; job<jobs; job++)
                {
                    // each job has a task that contends with servicing.
                    mid_domain [] vars1={shadow[period][machine], slt1[machine][job], slt2[machine][job], constants[1]};
                    boolean [] neg1={true, false, false, false};
                    or_constraint c1=new or_constraint(vars1, neg1, 3, prob);
                    
                    int task1=0;
                    while(taskmachines[job][task1]!=machine) task1++;
                    mid_domain[] tocomp1= {end[period][job][task1], servicebegin[period][machine]};
                    constraint c2=new e_comparison(tocomp1, slt1[machine][job], -1, prob);
                    
                    mid_domain[] tocomp2= {begin[period][job][task1], serviceend[period][machine]};
                    constraint c3=new e_comparison(tocomp2, slt2[machine][job], 1, prob);
                }
            }
            
            if(period>=1)
            {
                // connect this period with the previous one if necessary.
                for(int task=0; task<machines; task++)
                {
                    for(int job=0; job<jobs; job++)
                    {
                        mid_domain t1=new existential(2, prob, "t1");
                        mid_domain t2=new existential(2, prob, "t2");
                        
                        // begin[period-1][job][task] < period*slotsperperiod  iff  t1
                        mid_domain[] tocomp1= {begin[period-1][job][task], constants[period*slotsperperiod]};
                        constraint c1=new e_comparison(tocomp1, t1, -2, prob);
                        
                        // t1 => t2
                        mid_domain[] v1={t1, t2, constants[1]};
                        boolean[] neg1={true, false, false};
                        or_constraint c2=new or_constraint(v1, neg1, 2, prob);
                        
                        // nofault => t2
                        mid_domain[] v2={nofault[period], t2, constants[1]};
                        or_constraint c3=new or_constraint(v2, neg1, 2, prob);
                        
                        // begin[period-1][job][task] == begin[period][job][task]  iff t2
                        mid_domain[] tocomp2= {begin[period-1][job][task], begin[period][job][task]};
                        constraint c4=new e_comparison(tocomp2, t2, 0, prob);
                    }
                }
            }
        }
        
        // set up the optimization variable
        
        mid_domain [] makespans = new mid_domain[periods];
        
        for(int per=0; per<periods; per++)
        {
            mid_domain [] maxvars = new mid_domain[jobs+1];
            for(int job=0; job<jobs; job++)
            {
                maxvars[job]=end[per][job][machines-1]; // last end time for this job
            }
            
            makespans[per]=new existential(0, maxmakespan, prob, "makespans["+per+"]");
            maxvars[jobs]=makespans[per];
            constraint max_cons=new max_constraint(maxvars, jobs, prob);
        }
        
        prob.pure_setup_universals();  // enables the pure value rule, could take some time to execute
        
        //System.out.println(prob.constraints.toString());
        
        // root node processing here.
        //System.out.println("Establish GAC list:");
        //System.out.println(prob.queue.toestablish);
        
        prob.setHeuristic(new random_heuristic());
        
        stopwatch sw= new stopwatch("GMT");
        
        sw.start();
        boolean flag=prob.establish();
        sw.end();
        //prob.printdomains();
        System.out.println("Time to establish:"+sw.elapsedMillis());
        
        assert flag;
        sw.start();
        if(optimize)
        {
            //System.out.println(prob.bandb(makespans[periods-1], false, false, true));
            System.out.println(prob.bandb2(makespans[periods-1], true, makespans));
        }
        else System.out.println(prob.search());
        sw.end();
        System.out.println("Nodes: "+prob.numnodes);
        System.out.println("Time (ms): "+sw.elapsedMillis());
        
        prob.savetree("jobshop.dot");
        //System.out.println(cons);
    }
}

class jsqcsp extends qcsp
{
    int machines=0;
    int jobs=0;
    int periods=0;
    int makespan=0;
    
    mid_domain [][][] begin;
    mid_domain [][][] end;
        
    mid_domain [][] servicebegin;
    mid_domain [][] serviceend;
    
    int [][] taskmachines;
    
    jsqcsp(boolean entailed, boolean sac_pre, boolean lookahead, boolean trues, boolean falses, boolean tree, boolean prunefalses)
    {
        super(entailed, sac_pre, lookahead, trues, falses, tree, prunefalses);
    }
    
    void setvars(int machines, int jobs, int periods, mid_domain [][][] begin, mid_domain [][][] end, int [][] taskmachines, int makespan,
        mid_domain [][] servicebegin, mid_domain [][] serviceend)
    {
        this.machines=machines; this.jobs=jobs; this.periods=periods; this.begin=begin; this.end=end; this.taskmachines=taskmachines; this.makespan=makespan;
        this.servicebegin=servicebegin; this.serviceend=serviceend;
    }
    
    
    
    public void printsol()
    {
        for(int i=0; i<variables.size(); i++)
        {
            variable v=variables.get(i);
            System.out.println((v.quant()?"A ":"E ")+v.toString()+"="+v.domain());
            assert v.unit();
        }
        System.out.println();
        
        for(int m=0; m<machines; m++)
        {
            System.out.print(m+"       ");
        }
        System.out.println();
        
        for(int ts=0; ts<makespan; ts++)
        {
            for(int m=0; m<machines; m++)
            {
                // search for intervals with this timeslot in them for this machine, and print the job number.
                
                for(int job=0; job<jobs; job++)
                {
                    // find the appropriate task for this job
                    int task=0;
                    while(taskmachines[job][task]!=m) task++;
                    if(begin[periods-1][job][task].lowerbound()<=ts && end[periods-1][job][task].lowerbound()>ts)
                    {
                        System.out.print(job);
                    }
                }
                for(int per=0; per<periods; per++)
                {
                    if(servicebegin[per][m].lowerbound()<=ts && serviceend[per][m].lowerbound()>ts)
                    {
                        System.out.print("s");
                    }
                }
                System.out.print("       ");
            }
            System.out.println();
        }
    }
    
    int findval(String varname) // given a variable name, return the value.
    {
        for(variable t : variables)
        {
            if(t instanceof mid_domain && t.toString().equals(varname))
            {   
                mid_domain md1=(mid_domain)t;
                for(int j=md1.lowerbound(); j<=md1.upperbound(); j++)
                {
                    if(md1.is_present(j))
                    {
                        return j;
                    }
                }
                assert false: "No value found for variable "+varname;
            }
        }
        assert false: "No mid_domain variable found:"+varname;
        return -1;
    }
}

class random_heuristic implements heuristic
{
    final Random r; // random number generator.
    random_heuristic()
    {
        r=new Random(12345);
    }
    
    public int choosevalue(variable m)
    {
        mid_domain md1= (mid_domain)m;
        
        // added separate handling for fault variables 20-2-07
        // taken out; made no improvement.
        /*if(md1.toString().startsWith("fault"))
        {
            assert md1.upperbound()==1 && md1.lowerbound()==0;
            return 1;   // do the faulty case first.
        }*/
        
        //int ran=r.next(1);
        
        if(md1.upperbound()==1 && md1.lowerbound()==0 && false)  // deliberately broken here
        {
            int ran=r.nextInt(2);
            //System.out.println("branching with random value "+ran);
            return ran;
        }
        else
        {
            // this is the real heuristic
            if(md1.quant())
            {
                //return md1.upperbound();   
            }
            return md1.lowerbound();  // this is the real heuristic.
        }
    }
}

