package queso.experiments;

import gnu.trove.*;
import java.io.*;

import queso.core.*;
import queso.constraints.*;
import queso.encoding.*;

class noughts extends qcsp
{
    public void printsol()
    {
        for(int i=0; i<6; i++)
        {
            String st="board"+i+":";
            System.out.println("Board at move "+i);
            for(int j=0; j<9; j++)
            {
                System.out.print(findval(st+j)+" | ");
                if(j==2||j==5||j==8) System.out.println();
            }
        }
        
        System.out.println("Last two moves:"+findval("move6")+" "+findval("move7"));
        
        for(int i=0; i<variables.size(); i++)
        {
            mid_domain v=(mid_domain)variables.get(i);
            System.out.print(v.toString()+"="+v.domain());
            
            System.out.print(" ");
        }
        System.out.println();
        verifysol();
    }
    
    // should be factored out.
    int findval(String varname) // given a variable name, return the value.
    {
        for(variable t : variables)
        {
            if(t.toString().equals(varname))
            {
                mid_domain t2=(mid_domain)t;
                for(int j=t2.lowerbound(); j<=t2.upperbound(); j++)
                {
                    if(t2.is_present(j))
                    {
                        return j;
                    }
                }
                assert false: "No value found for variable "+varname;
            }
        }
        assert false: "No variable found:"+varname;
        return -1;
    }
    
    void verifysol()
    {
        int [] board=new int[9];
        
        for(int move=0; move<9; move++)
        {
            int themove=findval("move"+move);
            assert board[move]==0;
            if(move%2==0) board[move]=10; else board[move]=11;
            int temp=wins(board);
            if(temp==0)
            {
                assert false: "Claimed true is not a true.";
            }
            else if(temp==1)
            {
                return;
            }
            
        }
        
        assert false: "Claimed true is not a true.";
    }
    
    int wins(int []board)
    {
        // player 10 lost == 0, wins ==1 and undetermined==2
        if( (board[0]==10 && board[1]==10 && board[2]==10)
        || (board[3]==10 && board[4]==10 && board[5]==10)
        || (board[6]==10 && board[7]==10 && board[8]==10)
        
        // verticals
        || (board[0]==10 && board[3]==10 && board[6]==10)
        || (board[1]==10 && board[4]==10 && board[7]==10)
        || (board[2]==10 && board[5]==10 && board[8]==10)
        
        // diagonals
        || (board[0]==10 && board[4]==10 && board[8]==10)
        || (board[2]==10 && board[4]==10 && board[6]==10) )
        {
            return 1;
        }
        
        if( (board[0]==11 && board[1]==11 && board[2]==11)
        || (board[3]==11 && board[4]==11 && board[5]==11)
        || (board[6]==11 && board[7]==11 && board[8]==11)
        
        // verticals
        || (board[0]==11 && board[3]==11 && board[6]==11)
        || (board[1]==11 && board[4]==11 && board[7]==11)
        || (board[2]==11 && board[5]==11 && board[8]==11)
        
        // diagonals
        || (board[0]==11 && board[4]==11 && board[8]==11)
        || (board[2]==11 && board[4]==11 && board[6]==11) )
        {
            return 0;
        }
        // it's indeterminate
        
        return 2;
    }
}

class cons_used_here extends gac_schema_predicate
{
    cons_used_here(mid_domain [] v, qcsp p, predicate_wrapper p1)
    {
        super(v,p,p1);
    }
}

public class noughtspure2
{
    public static void main(String[] args)
    {
        runit();
        runit();
        runit();
    }
    
    static void runit()
    {
        qcsp prob = new noughts();
        
        mid_domain[] moves=new mid_domain[9];
        
        mid_domain[] shadowmoves=new mid_domain[9];
        
        mid_domain[][] board=new mid_domain[9][];
        
        //mid_domain[][] available=new mid_domain[9][];
        
        mid_domain[] winstate=new mid_domain[9];
        
        mid_domain[] xline=new mid_domain[9];
        mid_domain[] oline=new mid_domain[9];
        
        boolean big_end_cons=true; // do we have all 9 moves, or 6 moves and a big end constraint?
        
        for(int move=0; move< ((big_end_cons)?6:9 ) ; move++)
        {
            // board state mid_domains
            board[move]=new mid_domain[9];
            //available[move]=new mid_domain[9];
        }
        
        for(int move=0; move< ((big_end_cons)?6:9) ; move++) // what move are we on.
        {
            // make move variables
            if((move%2)==0)
            {
                moves[move]=new existential(9, prob, "move"+move);
            }
            else
            {
                moves[move]=new universal(9, prob, "move"+move);
                shadowmoves[move]=new existential(9, prob, "shadowmove"+move);
            }
            
            for(int i=0; i<9; i++)
            {
                board[move][i]=new existential(3, prob, "board"+move+":"+i);  // x, o or unoccupied= 0, 1 or 2
                if(move==0 || move==2 || move==4 || move==6)
                {
                    //available[move+1][i]=new existential(2, prob, "available["+(move+1)+"]["+i+"]");  // 1 is empty, 0 is occupied
                }
            }
            
            // winstate per move
            
            winstate[move]=new existential(3, prob, "winstate"+move);
            
            xline[move]=new existential(2, prob, "xline"+move);

            oline[move]=new existential(2, prob, "oline"+move);

            // connect move variables to board variables.
            if((move%2)==0)
            {
                if(move==0)
                {
                    for(int i=0; i<9; i++)
                    {
                        {firstxmove_predicate p1=new firstxmove_predicate(i);
                        mid_domain[] gsvars = new mid_domain[2];
                        gsvars[0]=board[0][i];
                        gsvars[1]=moves[0];
                        cons_used_here cons= new cons_used_here(gsvars, prob, p1);}
                    }
                }
                else
                {
                    for(int i=0; i<9; i++)
                    {
                        {xmove_predicate p1=new xmove_predicate(i);
                        mid_domain[] gsvars = new mid_domain[3];
                        gsvars[0]=board[move-1][i];
                        gsvars[1]=moves[move];
                        gsvars[2]=board[move][i];
                        cons_used_here cons= new cons_used_here(gsvars, prob, p1);}
                    }
                }
            }
            else
            {
                // o move now using combined constraint for the move variable 
                
                // o move using pure propagator and xmove predicate
                
                for(int i=0; i<9; i++)
                {
                    {omove_predicate p1=new omove_predicate(i);
                    mid_domain[] gsvars = new mid_domain[3];
                    gsvars[0]=board[move-1][i];
                    gsvars[1]=shadowmoves[move];
                    gsvars[2]=board[move][i];
                    
                    cons_used_here cons= new cons_used_here(gsvars, prob, p1);}
                    
                    /*boardtoavailable p1=new boardtoavailable();
                    mid_domain[] gsvars = new mid_domain[2];
                    gsvars[0]=board[move-1][i];
                    gsvars[1]=available[move][i];
                    
                    cons_used_here cons= new cons_used_here(gsvars, prob, p1);*/
                }
            }
            
            // detect lines and map onto appropriate xline or oline var.
            
            if(move==4 || move==6 || move==8)
            {
                // x can win by move 4, so start checking for lines here.
                System.out.println("Setting up xline_constraint for move"+move);
                xline_predicate p1=new xline_predicate();
                mid_domain[] gsvars= new mid_domain[10];
                
                for(int i=0; i<9; i++)
                {
                    gsvars[i]=board[move][i];
                }
                System.out.println("Setting up xline_constraint for var"+xline[move]);
                gsvars[9]=xline[move];
                
                cons_used_here cons= new cons_used_here(gsvars, prob, p1);
                
                //  not owins[move-1] and xline[move] <=> xwins[move] and not owins[move]
                // connect  xline[move]. xwins[move] and owins[move] to xwins[move-1] and owins[move-1]
            }
            
            if(move==5 || move==7)
            {
                // o can win by move 5, so start checking for lines here.
                
                oline_predicate p1=new oline_predicate();
                mid_domain[] gsvars= new mid_domain[10];
                
                for(int i=0; i<9; i++)
                {
                    gsvars[i]=board[move][i];
                }
                
                gsvars[9]=oline[move];
                
                cons_used_here cons= new cons_used_here(gsvars, prob, p1);
            }
            
            // This is a standardised pure construction based on the design pattern.
            if((move%2)==1)
            {
                // for each constraint move[1] is involved in, 
                // generate the puremonitor and the inverted constraint.
                // currently the only constraints move[1] is involved in are the design pattern ones.
                
                puremonitor[] board_monitor=new puremonitor[9];
                puremonitor[] moves_monitor=new puremonitor[9];
                puremonitor[] shadow_monitor=new puremonitor[9];
                
                for(int i=0; i<9; i++)
                {
                    // The regular constraint part
                    hacked_designpattern p1=new hacked_designpattern(i);
                    {
                    mid_domain[] gsvars = new mid_domain[3];
                    gsvars[0]=board[move-1][i]; System.out.println(board[move-1][i].toString());
                    gsvars[1]=moves[move]; System.out.println(moves[move].toString());
                    gsvars[2]=shadowmoves[move]; System.out.println(shadowmoves[move].toString());
                    
                    cons_used_here cons= new cons_used_here(gsvars, prob, p1);}
                    
                    // The pure part
                    
                    board_monitor[i]=new puremonitor(3, prob, "board_monitor"+move+":"+i);
                    moves_monitor[i]=new puremonitor(9, prob, "moves_monitor:"+move+":"+i);
                    shadow_monitor[i]=new puremonitor(9, prob, "shadow_monitor:"+move+":"+i);
                    
                    negated_predicate p2=new negated_predicate(p1);
                    
                    mid_domain[] gsvars = new mid_domain[3];
                    gsvars[0]=board_monitor[i];
                    gsvars[1]=moves_monitor[i];
                    gsvars[2]=shadow_monitor[i];
                    warning_wrapper cons= new warning_wrapper(gsvars, prob, p2);
                    
                    mid_domain [] temp={board[move-1][i], board_monitor[i]};
                    mid_domain [] temp2={shadowmoves[move], shadow_monitor[i]};
                    
                    dummy_linkup d1=new dummy_linkup(temp, prob);
                    dummy_linkup d2=new dummy_linkup(temp2, prob);
                }
                
                mid_domain [] allvars=new mid_domain[moves_monitor.length+1];
                allvars[0]=moves[move];
                for(int i=1; i<allvars.length; i++)
                    allvars[i]=moves_monitor[i-1];
                
                linkup_pures linkup=new linkup_pures(allvars, prob);
            }
            
            if(move>=1)  // from move 1 something can happen i.e. o can cheat.
            {
                mid_domain[] tempvars= new mid_domain[4];
                tempvars[0]=winstate[move-1];
                tempvars[1]=xline[move];
                tempvars[2]=oline[move];
                tempvars[3]=winstate[move];
                
                logic_predicate p2=new logic_predicate();
                cons_used_here cons2= new cons_used_here(tempvars, prob, p2);
            }
        }
        
        // make the last two move variables
        
        
        if(big_end_cons)
        {
        moves[6]=new existential(3, prob, "move6");
        
        moves[7]=new universal(2, prob, "move7");
        
        // make the big end constraint
        // last three moves -- last move is unit.
        
        
        {mid_domain [] tempvar=new mid_domain[12];
        System.arraycopy(board[5], 0, tempvar, 0, 9);
        tempvar[9]=winstate[5];
        
        tempvar[10]=moves[6];
        tempvar[11]=moves[7];
        
        for(int i=0; i<tempvar.length; i++)
            System.out.println(tempvar[i]+" ");
        
        System.out.println();
        
        lastmoves_predicate p1=new lastmoves_predicate();
        
        cons_used_here cons= new cons_used_here(tempvar, prob, p1);}
        }
        else
        {
            // set the final winstate variable to 0;
        }
        // root node processing here.
        
        //System.out.println("Establish GAC list:");
        //System.out.println(prob.queue.toestablish);
        
        stopwatch sw= new stopwatch("GMT");
        sw.start();
        prob.establish();
        
        // set some variables
        
        winstate[0].exclude(0, null);
        //winstate[0].exclude(1, null);
        
        xline[0].exclude(1, null);
        oline[0].exclude(1, null);
        
        xline[1].exclude(1, null);
        oline[1].exclude(1, null);
        
        xline[2].exclude(1, null);
        oline[2].exclude(1, null);
        
        xline[3].exclude(1, null);
        oline[3].exclude(1, null);
        
        // move 4 -- x line can happen now
        oline[4].exclude(1, null);
        
        xline[5].exclude(1, null);
        
        if(!big_end_cons)
        {
            oline[6].exclude(1, null);
            xline[7].exclude(1, null);
            oline[8].exclude(1, null);
            
            winstate[8].exclude(1, null);
            winstate[8].exclude(2, null);
        }
        
        // symmetry breaking
        /*board[0][2].instantiate(2);
        board[0][3].instantiate(2);
        board[0][5].instantiate(2);
        board[0][6].instantiate(2);
        board[0][7].instantiate(2);
        board[0][8].instantiate(2);*/
        
        prob.add_backtrack_level();
        
        prob.propagate();
        
        sw.end();
        System.out.println("Setup time: "+sw.elapsedMillis());
        
        prob.printdomains();
        
        //System.out.println(prob.blocks);
        
        //System.out.println(
        sw= new stopwatch("GMT");
        
        sw.start();
        System.out.println(prob.search());
        
        //moves[0].instantiate(0);
        
        //prob.propagate();
        
        //prob.printdomains();
        
        sw.end();
        System.out.println("Search time: "+sw.elapsedMillis()+" , Nodes:"+prob.numnodes);
        
        try
        {
        File output = new File("noughtspure2.dot");
        
        FileWriter out = new FileWriter(output);
        
        out.write(prob.printtree());
        
        out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing noughtspure2.dot");
        }
        //System.out.println(cons);
    }
}

class warning_wrapper extends gac_schema_predicate
{
    warning_wrapper(mid_domain [] gsvars, qcsp prob, predicate_wrapper pred)
    {
        super(gsvars, prob, pred);
    }
    
    public boolean propagate(int var, int val)
    {
        boolean result=super.propagate(var, val);
        assert result;
        
        return true;
    }
}

class omove_predicate implements predicate_wrapper
{
    final int pos;
    
    omove_predicate(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect oldboard position tau[0] to move (tau[1]) and newboard position [2]
        
        // board places are   0=x 1=o 2=empty
        
        // x place is denoted by board[i]==0
        int [] vals=tau.vals;
        
        assert vals.length==3;
        
        if(vals[0]==0)
        {
            return vals[2]==0;
        }
        else if(vals[0]==1)
        {
            return vals[2]==1;
        }
        else
        {
            //System.out.println("tuple "+vals[0]+","+vals[1]+","+vals[2]);
            assert vals[0]==2;
            
            if(vals[1]==pos)
                return vals[2]==1;
            else
                return vals[2]==2;
        }
    }
}

class firstxmove_predicate implements predicate_wrapper
{
    final int pos;
    
    firstxmove_predicate(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect move (tau[1]) to newboard position [0]
        
        // board places are   0=x 1=o 2=empty
        
        // x place is denoted by board[i]==0
        
        if(tau.vals[1]==pos)
        {
            return (tau.vals[0]==0);
        }
        else
        {
            return tau.vals[0]==2;
        }
    }
}

class xmove_predicate implements predicate_wrapper
{
    final int pos;
    
    xmove_predicate(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect move (tau[1]) to oldboard position [0] and newboard position [2]
        
        // board places are   0=x 1=o 2=empty
        
        // x place is denoted by board[i]==0
        
        if(tau.vals[1]==pos)
        {
            // this is the existential player so we want to prune the cheating moves.
            return (tau.vals[0]==2 && tau.vals[2]==0);
        }
        else
        {
            return tau.vals[0]==tau.vals[2];
        }
    }
}

class boardtoavailable implements predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // connect oldboard position tau[0] to move (tau[1]) and newboard position [2]
        
        // board places are   0=x 1=o 2=empty
        
        // x place is denoted by board[i]==0
        
        // board, 2=available tau[0]
        // available variable, 1=available tau[1].
        
        if(tau.vals[0]==2)
        {
            return tau.vals[1]==1;
        }
        else
        {
            return tau.vals[1]==0;
        }
    }
}

class hacked_designpattern implements predicate_wrapper
{
    final int pos;
    
    hacked_designpattern(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect board tau[0], move (tau[1]) to shadow (tau[2])
        
        if(tau.vals[0]==2)  // 2 instead of 1 means available.
        {
            if(tau.vals[1]==pos)
                return tau.vals[2]==pos;
        }
        
        return true;
    }
}

class xline_predicate implements predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // first 9 entries in tau are the board, and the tenth is a 0/1 variable indicating if player 0 has won.
        
        if( (tau.vals[0]==0 && tau.vals[1]==0 && tau.vals[2]==0)
        || (tau.vals[3]==0 && tau.vals[4]==0 && tau.vals[5]==0)
        || (tau.vals[6]==0 && tau.vals[7]==0 && tau.vals[8]==0)
        
        // verticals
        || (tau.vals[0]==0 && tau.vals[3]==0 && tau.vals[6]==0)
        || (tau.vals[1]==0 && tau.vals[4]==0 && tau.vals[7]==0)
        || (tau.vals[2]==0 && tau.vals[5]==0 && tau.vals[8]==0)
        
        // diagonals
        || (tau.vals[0]==0 && tau.vals[4]==0 && tau.vals[8]==0)
        || (tau.vals[2]==0 && tau.vals[4]==0 && tau.vals[6]==0) )
        {
            // so x has a line
            return tau.vals[9]==1;
        }
        else
        {
            // x does not have a line
            return tau.vals[9]==0;
        }
    }
}

class oline_predicate implements predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // first 9 entries in tau are the board, and the tenth is a 0/1 variable indicating if player 0 has won.

        if( (tau.vals[0]==1 && tau.vals[1]==1 && tau.vals[2]==1)
        || (tau.vals[3]==1 && tau.vals[4]==1 && tau.vals[5]==1)
        || (tau.vals[6]==1 && tau.vals[7]==1 && tau.vals[8]==1)

        // verticals
        || (tau.vals[0]==1 && tau.vals[3]==1 && tau.vals[6]==1)
        || (tau.vals[1]==1 && tau.vals[4]==1 && tau.vals[7]==1)
        || (tau.vals[2]==1 && tau.vals[5]==1 && tau.vals[8]==1)

        // diagonals
        || (tau.vals[0]==1 && tau.vals[4]==1 && tau.vals[8]==1)
        || (tau.vals[2]==1 && tau.vals[4]==1 && tau.vals[6]==1) )
        {
            // so o has a line
            return tau.vals[9]==1;
        }
        else
        {
            // o does not have a line
            return tau.vals[9]==0;
        }
    }
}

class logic_predicate implements predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // connect  xline[move]. xwins[move] and owins[move] to xwins[move-1] and owins[move-1]
        
        //tempvars[0]=winstate[move-1];
        //tempvars[1]=xline[move];
        //tempvars[2]=oline[move];
        //tempvars[3]=winstate[move];
        
        if(tau.vals[0]==0)  // if x won last move, ensure that x wins this move
        {
            return tau.vals[3]==0;
        }
        
        if(tau.vals[0]==1)  // if o won last move, ensure that o wins this move
        {
            return tau.vals[3]==1;
        }
        
        // neither player won last move.
        
        if(tau.vals[1]==1)
        {
            // x wins with a line
            return tau.vals[3]==0;
        }
        else
        {
            if(tau.vals[2]==1)
            {
                // o wins with a line
                return tau.vals[3]==1;
            }
            else
            {
                // neither wins
                return tau.vals[3]==2;
            }
        }
    }
}

class lastmoves_predicate implements predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // tau[0..8] is boardstate before
        // tau[9] is winstate before
        // tau[10] is move7 (existential)
        // tau[11] is move8 (universal)
        
        int [] vals=tau.vals;
        
        if(vals[9]!=2)    // if someone has already won, this cons is satisfied iff it is the first player.
            return vals[9]==0;
        
        int move1=vals[10];
        
        for(int i=0; i<9; i++)
        {
            if(vals[i]!=2)
            {
                move1++;
            }
            
            if(move1<=i)
            {
                break;
            }
        }
        
        int move2=vals[11];
        
        for(int i=0; i<9; i++)
        {
            if(vals[i]!=2)
            {
                move2++;
            }
            
            if(move2==move1)
            {
                move2++;
            }
            
            if(move2<=i)
            {
                break;
            }
        }
        
        // move1 and move2 should now be in 0..8
        
        // if either have gone over the limit, the boardstate is seriously flawed so
        // just reject it.
        if(move1>8 || move2>8)
            return false;
        
        // copy to be sure we don't alter the tuple
        int [] board=new int[9];
        for(int i=0; i<9; i++)
            board[i]=vals[i];
        
        assert board[move1]==2;
        
        board[move1]=0;
        
        // if x has won after move1, then return true.
        
        if( (board[0]==0 && board[1]==0 && board[2]==0)
        || (board[3]==0 && board[4]==0 && board[5]==0)
        || (board[6]==0 && board[7]==0 && board[8]==0)
        
        // verticals
        || (board[0]==0 && board[3]==0 && board[6]==0)
        || (board[1]==0 && board[4]==0 && board[7]==0)
        || (board[2]==0 && board[5]==0 && board[8]==0)
        
        // diagonals
        || (board[0]==0 && board[4]==0 && board[8]==0)
        || (board[2]==0 && board[4]==0 && board[6]==0) )
        {
            return true;
        }
        
        // if o has won after move2, then return false;
        
        assert board[move2]==2;
        board[move2]=1;
        
        if( (board[0]==1 && board[1]==1 && board[2]==1)
        || (board[3]==1 && board[4]==1 && board[5]==1)
        || (board[6]==1 && board[7]==1 && board[8]==1)
        
        // verticals
        || (board[0]==1 && board[3]==1 && board[6]==1)
        || (board[1]==1 && board[4]==1 && board[7]==1)
        || (board[2]==1 && board[5]==1 && board[8]==1)
        
        // diagonals
        || (board[0]==1 && board[4]==1 && board[8]==1)
        || (board[2]==1 && board[4]==1 && board[6]==1) )
        {
            return false;
        }
        
        // find and fill in the one remaining empty slot, then test again if 
        // x has won.
        
        for(int i=0; i<9; i++)
        {
            if(board[i]==2){ board[i]=0; break; }
        }
        
        if( (board[0]==0 && board[1]==0 && board[2]==0)
        || (board[3]==0 && board[4]==0 && board[5]==0)
        || (board[6]==0 && board[7]==0 && board[8]==0)
        
        // verticals
        || (board[0]==0 && board[3]==0 && board[6]==0)
        || (board[1]==0 && board[4]==0 && board[7]==0)
        || (board[2]==0 && board[5]==0 && board[8]==0)
        
        // diagonals
        || (board[0]==0 && board[4]==0 && board[8]==0)
        || (board[2]==0 && board[4]==0 && board[6]==0) )
        {
            return true;
        }
        
        // it's a draw.
        
        return false;
    }
}
