import java.util.*;
import java.io.*;

class loader 
{
    public static void main(String[] args) throws FileNotFoundException, IOException
    {
        // First argument is a filename
        if(args.length>1)
        {
            System.out.println("Too many args");
        }
        
        // solve each arg
        for(int i=0; i<args.length; i++)
        {
            loadedqcsp newinstance=new loadedqcsp(args[i]);
            System.out.println(args[i]+":"+newinstance.search(0));
        }
    }
}

class loadedqcsp extends qcsp
{
    loadedqcsp(String filename) throws FileNotFoundException, IOException
    {
        variable[] variables;
        has_make_ac[] constraints;
        // Can't handle comments in the file, unless they're C/C++ style.
        
        File inputFile = new File(filename);
        FileReader infile = new FileReader(inputFile);
        BufferedReader in = new BufferedReader(infile);
        StreamTokenizer st = new StreamTokenizer(in);
        
        st.eolIsSignificant(false);
        
        comptoken(st, "begincsp");
        
        String problemname=gettoken(st);
        
        //System.out.println("BeginCSP "+problemname);
        
        comptoken(st, "domains");
        
        int numdomains=getnumber(st);
        //System.out.println("domains "+numdomains);
        
        domain[] domains = new domain[numdomains];
        
        getopenbracket(st); //System.out.println("(");
        for(int i=0; i<numdomains; i++)
        {
            getopenbracket(st);
            domains[i]=new domain();
            domains[i].domname=gettoken(st);
            domains[i].elements = new String[getnumber(st)];
            
            //System.out.print("("+domains[i].domname+" "+domains[i].elements.length+" (");
            
            getopenbracket(st);
            
            for(int j=0; j<domains[i].elements.length; j++)
            {
                domains[i].elements[j] = gettoken(st);
                //System.out.print(domains[i].elements[j]+" ");
            }
            getclosebracket(st);
            //System.out.print(")");
            getclosebracket(st);
            //System.out.println(")");
        }
        
        getclosebracket(st);
        //System.out.println(")");
        
        comptoken(st, "variables");
        
        String[] varnames=new String[getnumber(st)];
        int[] vardoms=new int[varnames.length];
        
        //System.out.println("variables "+varnames.length);
        
        getopenbracket(st);
        //System.out.println("(");
        
        for(int i=0; i<varnames.length; i++)
        {
            getopenbracket(st);
            varnames[i]=gettoken(st);
            String domname=gettoken(st);
            int j;
            
            for(j=0; j<=varnames.length; j++)
            {
                if(j==varnames.length)
                {
                    System.out.println("Unknown domain in variables");
                    System.exit(-1);
                }
                if(domname.compareToIgnoreCase(domains[j].domname)==0)
                    break;
            }
            
            vardoms[i]=j;
            //System.out.println("("+varnames[i]+" "+domains[vardoms[i]].domname+")");
            getclosebracket(st);
        }
        getclosebracket(st);
        //System.out.println(")");
        comptoken(st, "quantifiers");
        int numquants=getnumber(st);
        getopenbracket(st);
        //System.out.println("quantifiers "+numquants+"\n(");
        
        if(numquants!=varnames.length)
        {
            System.out.println("Too many/few quantifiers");
            System.exit(-1);
        }
        
        variables=new variable[varnames.length];
                
        for(int i=0; i<variables.length; i++)
        {
            getopenbracket(st);
            String varname=gettoken(st);
            int j;
            for(j=0; j<=variables.length; j++)
            {
                if(j==variables.length)
                {
                    System.out.println("Unknown variable in quantifiers");
                    System.exit(-1);
                }
                if(varname.compareToIgnoreCase(varnames[j])==0)
                    break;
            }
            String quant=gettoken(st);
            if(quant.compareToIgnoreCase("e")==0)
            {
                int domsize=domains[vardoms[j]].elements.length;
                
                variables[i]=new existential(domsize, this, i, varnames[j]);
            }
            else
                variables[i]=new universal(domains[vardoms[j]].elements.length, this, i, varnames[j]);
            getclosebracket(st);
            //System.out.println("("+variables[i].name+" "+(variables[i].quant?"a":"e")+")");
        }
        getclosebracket(st);
        //System.out.println(")");
        
        // Ignoring the constraints bit
        
        comptoken(st, "constraints");
        int numcons=getnumber(st);
        getopenbracket(st);
        
        for(int i=0; i<numcons; i++)
        {
            getopenbracket(st);
            String varname1=gettoken(st);
            String varname2=gettoken(st);
            getclosebracket(st);
        }
        getclosebracket(st);
        
        // Get all constraint information from the conflicts bit
        
        comptoken(st, "conflicts");
        if(numcons!=getnumber(st))
        {
            System.out.println("Number of constraints does not match number of conflicts");
            System.exit(-1);
        }
        
        getopenbracket(st);
        //System.out.println("conflicts "+numcons+"\n(");
        constraints = new has_make_ac[numcons];
        
        // set up the qcsp instance.
        this.set_stuff(variables, constraints);
        
        for(int i=0; i<numcons; i++)
        {
            getopenbracket(st);
            getopenbracket(st);
            String varname1=gettoken(st);
            String varname2=gettoken(st);
            getclosebracket(st);
            int numconflicts = getnumber(st);
            int j;
            for(j=0; j<=variables.length; j++)
            {
                if(j==variables.length)
                    throw new IOException("variable not found");
                if(variables[j].name.compareToIgnoreCase(varname1)==0)
                    break;
            }
            
            int varindex1=j;
            for(j=0; j<=variables.length; j++)
            {
                if(j==variables.length)
                    throw new IOException("variable not found");
                if(variables[j].name.compareToIgnoreCase(varname2)==0)
                    break;
            }
            int varindex2=j;
            
            domain dom1=domains[vardoms[varindex1]];
            domain dom2=domains[vardoms[varindex2]];
            
            //System.out.print("(("+varname1+" "+varname2+") "+numconflicts+" ");
            
            int[][] conflicts = new int[numconflicts][];
            
            for(j=0; j<numconflicts; j++)
            {
                int k;
                getopenbracket(st);
                
                String valname1=gettoken(st);
                String valname2=gettoken(st);
                
                getclosebracket(st);
                //System.out.print("("+valname1+" "+valname2+") ");
                
                for(k=0; k<=dom1.elements.length; k++)
                {
                    if(k==dom1.elements.length)
                        throw new IOException("domain element not found");
                    if(dom1.elements[k].compareToIgnoreCase(valname1)==0)
                        break;
                }
                int val1=k;
                
                for(k=0; k<=dom2.elements.length; k++)
                {
                    if(k==dom2.elements.length)
                        throw new IOException("domain element not found");
                    if(dom2.elements[k].compareToIgnoreCase(valname2)==0)
                        break;
                }
                int val2=k;
                
                conflicts[j]=new int[2];
                conflicts[j][0]=val1;
                conflicts[j][1]=val2;
            }
            
            variable[] thisvars=new variable[2];
            thisvars[0]=variables[varindex1];
            thisvars[1]=variables[varindex2];
            
            int[][] thistables = new int[2][];
            
            thistables[0]= new int[dom1.elements.length*dom2.elements.length - numconflicts];
            thistables[1]= new int[dom1.elements.length*dom2.elements.length - numconflicts];
            
            // Assumes no repeat conflicts
            
            int counter=0;
            for(j=0; j<dom1.elements.length; j++)
            {
                for(int k=0; k<dom2.elements.length; k++)
                {
                    boolean found=false;  
                    for(int l=0; l<numconflicts; l++)
                    {
                        if(j==conflicts[l][0] && k==conflicts[l][1])
                        {
                            found=true;
                            break;
                        }
                    }
                    if(!found)
                    {
                        thistables[0][counter]=j;
                        thistables[1][counter]=k;
                        counter++;
                    }
                }
            }
            
            constraints[i]= new binary_constraint(thisvars, this, thistables);
            
            getclosebracket(st);
            //System.out.println(")");
        }
        
        getclosebracket(st);
        //System.out.println(")");
        
        for(int i=0; i<constraints.length; i++)
        {
            this.queue.push_constraint(constraints[i]);
        }
    }
    
    private void comptoken(StreamTokenizer st, String tok) throws IOException
    {
        if(gettoken(st).compareToIgnoreCase(tok)!=0)
        {
            System.out.println(tok+" not found.");
            throw new IOException("comptoken");
        }
    }
    
    private void getopenbracket(StreamTokenizer st) throws IOException
    {
        st.nextToken();
        if(st.ttype!=40)
        {
            System.out.println("Error in getopenbracket");
            throw new IOException("missing open bracket");
        }
    }
    
    private void getclosebracket(StreamTokenizer st) throws IOException
    {
        st.nextToken();
        if(st.ttype!=41)
        {
            System.out.println("Error in getclosebracket");
            throw new IOException("missing closing bracket");
        }
    }
    
    private String gettoken(StreamTokenizer st) throws IOException
    {
        st.nextToken();
        
        if(st.ttype == st.TT_NUMBER)
        {
            return Double.toString(st.nval);
        }
        else if(st.ttype == st.TT_WORD)
        {
            return st.sval;
        }
        else
        {
            System.out.println("Error in gettoken");
            System.out.println(st.sval);
            System.out.println(st.nval);
            System.out.println(st.ttype);
            System.out.println(st.TT_EOL);
            throw new IOException("gettoken");
        }
    }
    
    private int getnumber(StreamTokenizer st) throws IOException
    {
        st.nextToken();
        if(st.ttype!=st.TT_NUMBER)
        {
            System.out.println("Error in getnumber");
            throw new IOException("getnumber");
        }
        return (int)st.nval;
    }
}

class domain
{
    // just used for reading
    String domname;
    String[] elements;
}
