// test the rat_compare constraint

import gnu.trove.*;
import java.util.*;
import gnu.math.*;

class probability_test
{
    public static void main(String [] args)
    {
        variable[] vars=new variable[2];
        qcsp prob=new qcsp();
        
        IntNum zero=new IntNum(0);
        IntNum one=new IntNum(1);
        IntNum two=new IntNum(2);
        
        IntFraction zerofrac=new IntFraction(zero, one);
        IntFraction onefrac=new IntFraction(one, one);
        IntFraction half=new IntFraction(one, two);
        
        vars[0]=new rat_existential(zerofrac, onefrac, prob, "rat");
        vars[1]=new existential(2, prob, "bool");
        
        prob.addvar(vars[0]);
        prob.addvar(vars[1]);
        
        constraint cons=new rat_compare(vars, prob, half, 1); // 1  is  <=
        
        prob.printdomains();
        
        prob.backtrack.add_backtrack_level();
        
        ((existential)vars[1]).exclude(0, null);
        System.out.println(prob.propagate());
        prob.printdomains();
        
        
        
        prob.backtrack.backtrack();
        
        prob.backtrack.add_backtrack_level();
        
        ((existential)vars[1]).exclude(1, null);
        System.out.println(prob.propagate());
        prob.printdomains();
        ((rat_existential)vars[0]).exclude_upper(half, null);
        
        System.out.println(prob.propagate());
        prob.backtrack.backtrack();
        
        //prob.printdomains();
    }
}
