import java.math.*;

class rat
{
    // normalized rational number represented with two bigints.
    // perhaps the bigints should be a fallback.
    
    BigInteger num;
    BigInteger den;
    
    rat(BigInteger num, BigInteger den)
    {
        // If negative, only the numerator can be negative.
        int sign_num=num.signum();
        int sign_den=den.signum();
        
        assert sign_den!=0: "division by zero error"; 
        
        if(sign_num==-1)
        {
            if(sign_den==-1)
            {
                num=num.negate();
                den=den.negate();
            }
        }
        else
        {
            // numerator positive
            if(sign_den==-1)
            {
                num=num.negate();
                den=den.negate();
            }
        }
        
        // normalize
        
        if(sign_num==0)
        {
            // zero
            this.num=BigInteger.ZERO;
            this.den=BigInteger.ONE;
        }
        else
        {
            // non-zero
            BigInteger gcd=num.gcd(den);
            this.num=num.divide(gcd);
            this.den=den.divide(gcd);
        }
    }
    
    // optimized constructor
    rat(int num, int den, boolean normal)
    {
        this.num=new BigInteger(num);
        this.den=new BigInteger(den);
        
        if(!normal)
        {
            // not normalized
            BigInteger gcd=this.num.gcd(this.den);
            this.num=this.num.divide(gcd);
            this.den=this.den.divide(gcd);
        }
    }
    
    
}
