class simplesttableconstraint extends fd_constraint implements make_ac
{
    int[][][][] tables;  // tables[var][val][#supports][#vars]=value
    int[][] memotable;
    
    simplesttableconstraint(mid_domain[] variables, qcsp problem, int[][][][] tables)
    {
        super(variables, problem);
        memotable = new int[variables.length][];
        
        for(int i=0; i<variables.length; i++)
        {
            memotable[i]=variables[i].hash;
        }
        
        // didn't add to the wakeup lists!
    }
    
    // Three possible outcomes:
    // 1: AC established, keep constraint
    // 2: AC established, discard constraint
    // 3: Fail
    public int make_ac()
    {
        boolean removalmade=true;
        
        while(removalmade)
        {
            removalmade=false;
            for(int var=0; var<memotable.length; var++)
            {
                //System.out.println("Searching variable "+variables[var].name);
                //printmemotable(memotable);

                int[] temparray;	        // declare an array of integers
                temparray=memotable[var];
                memotable[var] = new int[memotable[var].length];	// create an array of integers

                for(int val=0; val<memotable[var].length; val++)
                {
                    memotable[var][val]=2;   // pruned
                }

                for(int val=0; val<memotable[var].length; val++)
                {
                    if (temparray[val]==0)  // not pruned
                    {
                        //printmemotable(memotable);
                        //System.out.println("Chosen var,val:"+variables[var].name+","+val);
                        memotable[var][val]=0;

                        boolean result=checkvalue(var, val, var+1);

                        memotable[var][val]=2;

                        if(!result)
                        {
                            //System.out.println("Pruning var,val:"+variables[var].name+","+val);
                            removalmade=true;
                            if(!variables[var].exclude(val, this))
                            {
                                // fail
                                memotable[var]=temparray;
                                return 3;
                            }
                        }
                    }
                }
                memotable[var]=temparray;
            }
        }
        return 1;  //succeed, keep constraint
    }

    private void printmemotable(int memotable[][])
    {
        int i,j;
        System.out.println("memotable:");

        for(i=0; i<memotable.length; i++)
        {
            System.out.println("Var:"+variables[i].name);
            for(j=0; j<memotable[i].length; j++)
                System.out.println(memotable[i][j]);
        }
        printeq();
    }
    
    private void printeq()
    {
        System.out.println("Printeq");
        for(int i=0; i<variables.length; i++)
        {
            System.out.print(memotable[i]==variables[i].hash);
        }
        System.out.println("");
    }
    
    private boolean checkvalue(int origvar, int origval, int currentvar)
    {
        // currentvar is 0,1,2... for indexing the arrays
        // memotable[var][val]= 0 for present, 2 for pruned
        // tables[var][index]= val
        
        // base case
        
        if(currentvar==memotable.length)
        {
            // search for support through the tables using memotable

            boolean supporting=false;  //is i a supporting tuple?
            int i, var;
            
            int[][] table=tables[origvar][origval];
            
            for(i=0; i<table.length; i++)
            {
                supporting=true;  
                
                for(var=0; var<memotable.length; var++)
                {
                    if(memotable[var][table[var][i]]==2)
                    {
                        // if the value from the tuple is pruned/the variable 
                        // has been tentatively assigned to something else.
                        supporting=false;
                        break;
                    }
                }

                if(supporting)
                    break;
            }
            
            return supporting;
        }

        // recursive case

        if(variables[currentvar].quant)
        {
            // currentvar is universal so we need to branch.
            // branch for value 0  // replace with loop.
            // Temporarily set memotable[currentvar][1]=2 (pruned)
            
            boolean result=false; // WHY?? What if a universal domain is empty? 
            // If a u. domain is empty then the problem is true (false in dual)
            // so we would already have backtracked
            int[] temparray;  // declare an array of integers
            
            // instead of copying, swap the pointers
            temparray = memotable[currentvar];
            memotable[currentvar] = new int[memotable[currentvar].length];	// create an array of integers
            
            for(int val=0; val<memotable[currentvar].length; val++)
            {
                memotable[currentvar][val]=2;
            }
            
            for(int val=0; val<memotable[currentvar].length;  val++)
            {
                // branch for val
                if(temparray[val]<2)
                {
                    memotable[currentvar][val]=0;

                    //System.out.println("In recursive case.");
                    //printmemotable(memotable);

                    result=checkvalue(origvar, origval, currentvar+1);
                    if(result)
                    {
                        temparray[val]=1;   // mark as checked
                    }
                    else
                    {
                        memotable[currentvar]=temparray;
                        return false;
                    }
                    memotable[currentvar][val]=2;   // undo the change
                }
            }
            
            // swap back
            memotable[currentvar]=temparray;
            return true;
        }
        else
        {
            // currentvar is existential
            return checkvalue(origvar, origval, currentvar+1);
        }
    }
    
    String print()
    {
        String st="Table constraint:\n";
        for(int i=0; i<tables.length; i++)
        {
            System.out.println(variables[i].name+":");
            for(int j=0; j<tables[i].length; j++)
            {
                st+=tables[i][j]+", ";
            }
            st+="\n";
        }
        return st;
    }
}


class table_constraint2 extends fd_constraint implements make_ac
{
    int[][] tables;
    int[][] memotable;
    
    final mid_domain [] variables;
    // What if we stored the supporting index for each var-val pair??
    // This only works for inner variables, up to and including the innermost universal.
    // This somewhat contradicts the other approach of having a check against checked values.
    // This version of table_constraint takes the supports approach.
    // For each var, either use the checking mechanism or the support index.
    
    final boolean debug=false;
    
    int[][] supports;  // -1 indicates that the variable has multiple supports, therefore none are recorded
    
    //int sat_level=0; // The backtrack level at which the constraint became satisfied. When we backtrack
                        // over this level, it becomes indeterminate again.
    //boolean satisfied=false;  // When all but one vars are completely instantiated, this can be set.
    
    table_constraint2(mid_domain[] variables, qcsp problem)
    {
        super(problem);
        this.variables=variables;
        
        memotable = new int[variables.length][];
        
        for(int i=0; i<variables.length; i++)
        {
            memotable[i]=variables[i].hash;
        }
        
        supports = new int[variables.length][];
        boolean makeminusone=false;
        for(int i=variables.length-1; i>=0; i--)
        {
            supports[i]=new int[variables[i].hash.length];
            for(int j=0; j<variables[i].hash.length; j++)
            {
                if(makeminusone)
                    suppxorts[i][j]=-1;
                else
                    supports[i][j]=0;
            }
            if(variables[i].quant)
                makeminusone=true;  // make inner variables -1.
        }
    }
    
    // Three possible outcomes:
    // 1: AC established, keep constraint
    // 2: AC established, discard constraint
    // 3: Fail
    public int make_ac()
    {
        boolean globaliteratorflag=true;
        
        while(globaliteratorflag)
        {
            globaliteratorflag=false;
            // Find a non-checked var-val pair
            
            int var, val;
            // boolean found=false;
            
            // first find a variable
            for(var=0; var<memotable.length; var++)
            {
                if(debug) System.out.println("Searching variable "+variables[var].name);
                //printmemotable(memotable);
                
                int[] temparray;	        // declare an array of integers
                
                temparray=memotable[var];
                
                memotable[var] = new int[memotable[var].length];	// create an array of integers
                
                for(val=0; val<memotable[var].length; val++)
                {
                    memotable[var][val]=2;
                }
                
                for(val=0; val<memotable[var].length; val++)
                {
                    if (temparray[val]==0)
                    {
                        //printmemotable(memotable);
                        if(debug) System.out.println("Chosen var,val:"+variables[var].name+","+val);
                        memotable[var][val]=0;
                        
                        boolean result=table_constraint2(var+1, var, val, var);
                        
                        memotable[var][val]=2;
                        
                        if(result)
                        {
                            if(supports[var][val]==-1)
                            {
                                temparray[val]=1;
                            }
                        }
                        else
                        {
                            if(debug) System.out.println("Pruning var,val:"+variables[var].name+","+val);
                            if(!variables[var].exclude(val, this))
                            {
                                // fail
                                memotable[var]=temparray;
                                return 3;
                            }
                            if(temparray[val]==1)
                            {
                                // if var=val has been checked, then it may be used to support other
                                // values. Therefore it needs to be cleared and the whole procedure
                                // repeated.
                                globaliteratorflag=true;
                            }
                        }
                    }
                }
                
                memotable[var]=temparray;
            }
            // Scrub all the 1's here.
            for(var=0; var<memotable.length; var++)
                for(val=0; val<memotable[var].length; val++)
                    if(memotable[var][val]==1)
                        memotable[var][val]=0;

            if(globaliteratorflag)
            {
                if(debug) System.out.println("Restarting...:");
                //printmemotable(memotable);
            }
        }
        if(debug) System.out.println("All remaining values supported.");
        //printmemotable(memotable);
        
        return 1;  //succeed, keep constraint
    }

    private void printmemotable(int memotable[][])
    {
        int i,j;
        System.out.println("memotable:");

        for(i=0; i<memotable.length; i++)
        {
            System.out.println("Var:"+variables[i].name);
            for(j=0; j<memotable[i].length; j++)
                System.out.println(memotable[i][j]);
        }
        printeq();
    }
    
    private void printeq()
    {
        System.out.println("Printeq");
        for(int i=0; i<variables.length; i++)
        {
            System.out.print(memotable[i]==variables[i].hash);
        }
        System.out.println("");
    }
    
    private boolean table_constraint2(int currentvar, int supportvar, int supportval, int origvar)
    {
        // currentvar is 0,1,2... for indexing the arrays
        // Supportvar and supportval are the innermost var/val pair that is instantiated.
        // origvar is the original variable instantiated (i.e. the one we are checking). 
        // memotable[var][val]= 0 for unchecked, 1 for checked, 2 for pruned
        // tables[var][index]= val
        // the returned integer is either index+1 for support, or 0 for no support.

        // base case

        if(currentvar==memotable.length)
        {
            // search for support through the tables using memotable
            boolean supporting=false;  //is i a supporting tuple?
            int i, var;
            
            // search from the previous supporting index
            // need original var-val pair here.
            
            int initial=supports[supportvar][supportval];
            
            if(initial==-1)
            {
                System.out.println("error in table_constraint2");
                System.exit(-1);
            }
            
            for(i=initial; i<tables[0].length; i++)
            {
                supporting=true;  
                for(var=0; var<memotable.length; var++)
                {
                    if(memotable[var][tables[var][i]]==2)
                    {
                        // if the value is pruned
                        supporting=false;
                        break;
                    }
                }
                
                if(supporting)
                    break;
            }
            
            if(!supporting)
            {
                for(i=0; i<initial; i++)
                {
                    supporting=true;  
                    for(var=0; var<memotable.length; var++)
                    {
                        if(memotable[var][tables[var][i]]==2)
                        {
                            // if the value is pruned
                            supporting=false;
                            break;
                        }
                    }
                    
                    if(supporting)
                        break;
                }
            }
            
            
            // if supporting is true, i contains the relevant index
            if(supporting)
            {
                if(supportvar==origvar)
                {
                    // update support for this var-val
                    supports[supportvar][supportval]=i;
                }
                return true;
            }
            else
            {
                return false;
            }
        }

        // recursive case

        if(variables[currentvar].quant)
        {
            // currentvar is universal so we need to branch.
            
            boolean result=false; // WHY?? What if a universal domain is empty?
            // because a universal domain could not be empty if it were contained in a constraint
            // Even with pure values, 
            int[] temparray;  // declare an array of integers
            
            // instead of copying, swap the pointers
            temparray = memotable[currentvar];
            memotable[currentvar] = new int[memotable[currentvar].length];	// create an array of integers
            
            for(int val=0; val<memotable[currentvar].length; val++)
            {
                memotable[currentvar][val]=2;
            }
            
            for(int val=0; val<memotable[currentvar].length;  val++)
            {
                // branch for val
                if(temparray[val]<2)
                {
                    memotable[currentvar][val]=0;
                    
                    if(debug){ System.out.println("In recursive case.");
                    printmemotable(memotable);}
                    
                    // pass on new supportvar and supportval
                    result=table_constraint2(currentvar+1, currentvar, val, origvar);
                    if(result)
                    {
                        if(supports[currentvar][val]==-1)
                        {
                            temparray[val]=1;   // if this is not the innermost universal, mark as checked
                        }
                    }
                    else
                    {
                        memotable[currentvar]=temparray;
                        return false;
                    }
                    memotable[currentvar][val]=2;   // undo the change
                }
            }
            
            // swap back
            memotable[currentvar]=temparray;
            return true;
        }
        else
        {
            // currentvar is existential, so just increment currentvar
            return table_constraint2(currentvar+1, supportvar, supportval, origvar);
        }
    }
    
    String print()
    {
        String st="Table constraint:\n";
        for(int i=0; i<tables.length; i++)
        {
            System.out.println(variables[i].name+":");
            for(int j=0; j<tables[i].length; j++)
            {
                st+=tables[i][j]+", ";
            }
            st+="\n";
        }
        return st;
    }
}

class and_constraint extends table_constraint2
{
    int[] order;   // this is just for print
    
    and_constraint(fd_var[] variables, int[] order, qcsp problem)
    {
        super(variables, problem);
        // variables are passed in in quantification order.
        // order specifies order of variables in constraint e.g. {0,1,2} for 0 \wedge 1 \eq 2 e.g. {1,2,0} for 1 and 2 = 0
        // variables has the variables in quant order.
        int[][] tables_and={{0,0,1,1}, {0,1,0,1}, {0,0,0,1}};
        
        tables = new int[3][];
        
        for(int i=0; i<3; i++)
        {
            tables[order[i]]=tables_and[i];
        }
        
        // Add it to the appropriate wakeup lists
        for(int i=0; i<3; i++)
        {
            variables[i].wakeups[0].add(this);
            variables[i].wakeups[1].add(this);
        }
        
        this.order=order;
        System.out.println(print());
    }
    
    public int make_ac()
    {
        System.out.println("Processing constraint:");
        System.out.println(print());
        return super.make_ac();
    }
    
    String print()
    {
        return "Constraint: "+variables[order[0]].name+" and "+variables[order[1]].name+" = "+variables[order[2]].name;
    }
}

class or_constraint extends table_constraint2
{
    int[] order;   // this is just for print
    
    or_constraint(fd_var[] variables, int[] order, qcsp problem)
    {
        super(variables, problem);
        // variables are passed in in quantification order.
        // order specifies order of variables in constraint e.g. {0,1,2} for 0 \wedge 1 \eq 2 e.g. {1,2,0} for 1 and 2 = 0
        // variables has the variables in quant order.
        int[][] tables_or={{0,0,1,1}, {0,1,0,1}, {0,1,1,1}};
        
        tables = new int[3][];
        
        for(int i=0; i<3; i++)
        {
            tables[order[i]]=tables_or[i];
        }
        
        // Add it to the appropriate wakeup lists
        for(int i=0; i<3; i++)
        {
            variables[i].wakeups[0].add(this);
            variables[i].wakeups[1].add(this);
        }
        
        this.order=order;
        System.out.println(print());
    }
    
    public int make_ac()
    {
        System.out.println("Processing constraint:");
        System.out.println(print());
        return super.make_ac();
    }
    
    String print()
    {
        return "Constraint: "+variables[order[0]].name+" or "+variables[order[1]].name+" = "+variables[order[2]].name;
    }
}

class not_constraint extends table_constraint2
{
    not_constraint(fd_var[] variables, qcsp problem)
    {
        super(variables, problem);
        // variables are passed in in quantification order.
        int[][] tables_not={{0,1}, {1,0}};
        
        tables=tables_not;
        // Add it to the appropriate wakeup lists
        for(int i=0; i<2; i++)
        {
            variables[i].wakeups[0].add(this);
            variables[i].wakeups[1].add(this);
        }
        
        System.out.println(print());
    }
    
    public int make_ac()
    {
        System.out.println("Processing constraint:");
        System.out.println(print());
        return super.make_ac();
    }
    
    String print()
    {
        return "Constraint: "+variables[0].name+" = not "+variables[1].name;
    }
}

class binary_constraint extends table_constraint2
{
    binary_constraint(fd_var[] variables, qcsp problem, int[][] tables) throws IOException
    {
        super(variables, problem);
        if(variables.length!=2 || tables.length!=2)
        {
            System.out.println("This isn't binary");
            throw new IOException("binary_constraint");
        }
        
        this.tables=tables;
        for(int i=0; i<2; i++)
        {
            for(int j=0; j<variables[i].hash.length; j++)
            {
                variables[i].wakeups[j].add(this);
            }
        }
    }
}
