//import java.util.*;
import gnu.trove.*;
import java.io.*;

class sqgac_test
{
    public static void main(String[] args)
    {
        hash_var[] variables = new hash_var[6];
        
        qcsp prob = new qcsp();
        
        variables[0]=new existential(3, prob, "a");
        prob.addvar(variables[0]);
        variables[1]=new universal(3, prob, "b");
        prob.addvar(variables[1]);
        variables[2]=new existential(3, prob, "c");
        prob.addvar(variables[2]);
        variables[3]=new universal(3, prob, "d");
        prob.addvar(variables[3]);
        variables[4]=new existential(3, prob, "e");
        prob.addvar(variables[4]);
        
        mid_domain [] gsvars= {variables[0], variables[1], variables[2], variables[3], variables[4]};
        
        // goods must be lex sorted.
        /*int [][] goods={{ 0, 0, 0, 0, 0 },
                        { 0, 0, 0, 1, 0 },
                        { 0, 0, 0, 2, 0 },
                        { 0, 1, 0, 0, 0 },
                        { 0, 1, 0, 0, 1 },
                        { 0, 1, 0, 1, 0 },
                        { 0, 1, 0, 2, 0 },
                        { 0, 2, 0, 0, 0 },
                        { 0, 2, 0, 0, 1 },
                        { 0, 2, 0, 1, 0 },
                        { 0, 2, 0, 2, 0 }}; */
        
        
        // this one is for pruning x5=1 to see that the correct
        // nodes are removed from the tree without determining falsity.
        int [][] goods={{ 0, 0, 0, 0, 0 },
                        { 0, 0, 0, 1, 0 },
                        { 0, 0, 0, 2, 0 },
                        { 0, 1, 0, 0, 0 },
                        { 0, 1, 0, 0, 1 },
                        { 0, 1, 0, 1, 0 },
                        { 0, 1, 0, 2, 0 },
                        { 0, 2, 0, 0, 1 },
                        { 0, 2, 0, 1, 0 },
                        { 0, 2, 0, 2, 0 },
                        { 0, 2, 1, 0, 2 },
                        { 0, 2, 1, 1, 2 },
                        { 0, 2, 1, 2, 2 }
                        };
        
        sqgac c1= new sqgac(gsvars, prob, goods);
        
        prob.printdomains();
        
        System.out.println("calling establish");
        prob.establish();
        
        prob.printdomains();
        
        //System.out.println(prob.bandb(variables[5]));
        
        try
        {
        File output = new File("sqgac_test.dot");
        
        FileWriter out = new FileWriter(output);
        
        out.write(c1.printtree_alt());
        
        out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing sqgac_test.dot");
        }
        
        prob.add_backtrack_level();
        
        variables[4].exclude(1, null);
        
        System.out.println("calling propagate:"+prob.propagate());
        
        prob.printdomains();
        
        try
        {
        File output = new File("sqgac_test2.dot");
        
        FileWriter out = new FileWriter(output);
        
        out.write(c1.printtree_alt());
        
        out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing sqgac_test2.dot");
        }
        
        prob.backtrack();
        
        System.out.println("After backtracking.");
        
        prob.printdomains();
        
        try
        {
        File output = new File("sqgac_test3.dot");
        
        FileWriter out = new FileWriter(output);
        
        out.write(c1.printtree_alt());
        
        out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing sqgac_test3.dot");
        }
    }
}
