//import java.util.*;

package queso.testing;

import gnu.trove.*;
import queso.core.*;
import queso.constraints.*;

public class schema_test
{
    public static void main(String[] args)
    {
        hash_var[] variables = new hash_var[5];
        constraint[] constraints = new constraint[1];
        
        qcsp prob = new qcsp();
        
        variables[0]=new existential(4, prob, "a");
        variables[1]=new universal(2, prob, "b");
        variables[2]=new existential(3, prob, "c");
        variables[3]=new existential(4, prob, "d");
        variables[4]=new existential(3, prob, "superfluous");
        
        //prob.printall();
        
        // make a quaternary gac_schema_positive constraint representing
        // alldiff(a,b,c,d)
        
        int count=0;
        
        for(int a=0; a<4; a++)
        {
            for(int b=0; b<2; b++)
            {
                for(int c=0; c<3; c++)
                {
                    for(int d=0; d<4; d++)
                    {
                        if(a!=b && a!=c && a!=d && b!=c && b!=d && c!=d)
                            count++;
                    }
                }
            }
        }
        
        int [][] alltuples= new int[count][];
        count=0;
        
        for(int a=0; a<4; a++)
        {
            for(int b=0; b<2; b++)
            {
                for(int c=0; c<3; c++)
                {
                    for(int d=0; d<4; d++)
                    {
                        if(a!=b && a!=c && a!=d && b!=c && b!=d && c!=d)
                        {
                            int [] temp=new int[4];
                            temp[0]=a;
                            temp[1]=b;
                            temp[2]=c;
                            temp[3]=d;
                            alltuples[count]=temp;
                            count++;
                        }
                    }
                }
            }
        }
        
        THashMap goods= new THashMap();  // <pa, goodlistwrapper>
        
        mid_domain[] gsvars= {variables[0], variables[1], variables[2], variables[3]};
        
        gac_schema_positive c1= new gac_schema_positive(gsvars, prob, alltuples);
        
        System.out.println(c1.establish());
        
        prob.printdomains();
        
        c1.add_backtrack_level();
        prob.backtrack.add_backtrack_level();
        
        System.out.println(c1);
        
        System.out.println(variables[3].exclude(3, null));
        
        System.out.println(prob.propagate());
        
        prob.printdomains();
        
        prob.backtrack.backtrack();
        
        prob.printdomains();
        
        System.out.println(c1);
        
        System.out.println("Now testing gac_schema_predicate --------------------");
        
        variables = new hash_var[4];
        constraints = new constraint[1];
        
        prob = new qcsp();
        
        variables[0]=new existential(4, prob, "a");
        variables[1]=new universal(2, prob, "b");
        variables[2]=new existential(3, prob, "c");
        variables[3]=new existential(4, prob, "d");
        
        alldiff_predicate temp= new alldiff_predicate();
        mid_domain [] gsvars2= {variables[0], variables[1], variables[2], variables[3]};
        
        gac_schema_predicate c2= new gac_schema_predicate(gsvars2, prob, temp);
        
        System.out.println(c2.establish());
        
        prob.printdomains();
        
        prob.backtrack.add_backtrack_level();
        
        System.out.println(c2);
        
        System.out.println(variables[3].exclude(3, null));
        
        System.out.println(prob.propagate());
        
        System.out.println("After setting d ne 4:"+c2);
        
        System.out.println(c2.literals_by_support_b);
        
        prob.backtrack.backtrack();
        
        System.out.println("After backtracking:"+c2);
        
        prob.printdomains();
        
        System.out.println(" Now testing search ------------------------------------------");
        
        boolean result=prob.search();
        System.out.println(result);
        
        //System.out.println(c1.toString());
        
        //System.out.println();
        
        /*// add an and constraint
        variable[] andvars = new variable[3];
        variable[] andvars2 = new variable[3];
        
        andvars[0]=variables[0];
        andvars[1]=variables[1];
        andvars[2]=variables[2];
        
        int[] order= {1,2,0};
        
        constraints[1] = new and_constraint(andvars, order, prob);
        
        andvars2[0]=variables[2];
        andvars2[1]=variables[3];
        andvars2[2]=variables[4];
        
        constraints[0] = new and_constraint(andvars2, order, prob);
        
        for(int i=0; i<constraints.length; i++)
        {
            prob.queue.push_constraint(constraints[i]);
        }
        
        prob.make_ac();
        
        prob.printall();
        
        prob.backtrack.backtrack();
        
        prob.printall();*/
    }
    
    
}

class alldiff_predicate extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // there is a quicker way than this -- think sorting in nlogn time.

        for(int i=0; i<4; i++)
        {
            for(int j=i+1; j<4; j++)
            {
                if(tau.vals[i]==tau.vals[j])
                {
                    return false;
                }
            }
        }
        return true;
    }
}

class schema_test2
{
    // using the alldiff predicate on existential vars, compare with
    // sqgac.
    
    public static void main(String[] args)
    {
        schema_test2 o1=new schema_test2();
        
        for(int i=0; i<100000; i++)
        {
            o1.test_random_prob();
            System.out.println("Done test "+i);
        }
    }
    
    void test_random_prob()
    {
        final int numvars=6;
        mid_domain [] vars_other= new mid_domain[numvars];
        mid_domain [] vars_sqgac= new mid_domain[numvars];
        
        qcsp prob_other = new qcsp();
        qcsp prob_sqgac = new qcsp();
        
        // 5 types of universal to choose from
        
        // random test.
        
        for(int i=0; i<numvars; i++)
        {
            if(Math.random()>2.0)
            {
                // universal  --never
                double temp=Math.random();
                int ub, lb;
                if(temp<0.2)
                {   // positive
                    ub=12; lb=3;
                }
                else if(temp<0.4)
                {   // includes 0.
                    ub=9; lb=0;
                }
                else if(temp<0.6)
                {   // spans 0
                    ub=6; lb=-3;
                }
                else if(temp<0.8)
                {   // includes 0 negative
                    ub=0; lb=-9;
                }
                else
                {
                    ub=-3; lb=-12;
                }
                vars_other[i]=new universal(lb, ub, prob_other, "x"+(i+1));
                vars_sqgac[i]=new universal(lb, ub, prob_sqgac, "x"+(i+1));
            }
            else
            {
                // existential
                double temp=Math.random();
                int ub, lb;
                if(temp<0.2)
                {   // positive
                    ub=12; lb=3;
                }
                else if(temp<0.4)
                {   // includes 0.
                    ub=9; lb=0;
                }
                else if(temp<0.6)
                {   // spans 0
                    ub=6; lb=-3;
                }
                else if(temp<0.8)
                {   // includes 0 negative
                    ub=0; lb=-9;
                }
                else
                {
                    ub=-3; lb=-12;
                }
                vars_other[i]=new existential(lb, ub, prob_other, "x"+(i+1));
                vars_sqgac[i]=new existential(lb, ub, prob_sqgac, "x"+(i+1));
            }
        }
        
        predicate_wrapper pred=new alldiff_predicate();
        sqgac c2= new sqgac(vars_sqgac, prob_sqgac, pred);
        gac_schema_predicate c1= new gac_schema_predicate(vars_other, prob_other, pred);
        
        // first check equivalence of the first pass
        
        assert same_domains(prob_other, prob_sqgac) : "something wrong in constructing the problems";
        
        boolean flag1=prob_other.establish();
        boolean flag2=prob_sqgac.establish();
        
        assert !flag2 || flag1 : "Found "+flag2+" for sqgac and "+flag1+" for other";
        if(!flag2)
        {
            return;
        }
        
        flag1=prob_other.propagate();
        flag2=prob_sqgac.propagate();
        
        assert !flag2 || flag1 : "Found "+flag2+" for sqgac and "+flag1+" for other";
        
        if(flag2 && !same_domains(prob_other, prob_sqgac))   // if not false, compare doms.
        {
            System.out.println("different domains");
            System.out.println("other:");
            prob_other.printdomains();
            System.out.println("SQGAC:");
            prob_sqgac.printdomains();
            assert false;
        }
        
        if(!flag2)
        {
            return;
        }
        
        prob_other.printdomains();
        for(int descents=0; descents<5; descents++)
        {
            System.out.println("New descent.");
            // now make some random assignments up to a leaf node.
            int numassigned=0;
            while(true)
            {
                // first check that an assignment is possible
                boolean assignmentposs=false;
                for(int i=0; i<numvars; i++)
                {
                    // making an assumption about the internals of c1:
                    if(!vars_other[i].unit() && !vars_other[i].quant())
                    {
                        assignmentposs=true;
                        break;
                    }
                }
                
                if(!assignmentposs)
                {
                    prob_other.printdomains();
                    break;
                }
                
                System.out.println("Assignment possible.");
                
                // pick an assignment to make
                int var=(int)(numvars*Math.random());
                //int val=(int)(2*Math.random());
                
                boolean outer=false;
                for(int i=var-1; i>=0; i--) 
                    if((vars_sqgac[var].quant() && !vars_other[i].quant() && !vars_other[i].unit()) ||
                       (!vars_sqgac[var].quant() && vars_other[i].quant() && !vars_other[i].unit())) outer=true;
                
                while(vars_other[var].unit() || outer)
                {
                    var=(int)(numvars*Math.random());
                    outer=false;
                    for(int i=var-1; i>=0; i--) 
                        if((vars_sqgac[var].quant() && !vars_other[i].quant() && !vars_other[i].unit()) ||
                            (!vars_sqgac[var].quant() && vars_other[i].quant() && !vars_other[i].unit())) outer=true;
                }
                
                int val=(int) (Math.random()*40-20);
                while(!vars_other[var].is_present(val) || !vars_sqgac[var].is_present(val)) 
                {
                    val=(int) (Math.random()*40-20);
                }
                
                System.out.println("Test harness: Assigning variable "+prob_sqgac.variables.get(var)+" value "+val);
                
                /*try
                {
                    File output = new File("or_constraint_test.dot");
                    FileWriter out = new FileWriter(output);
                    out.write(c2.printtree_alt());
                    out.close();
                }
                catch(java.io.IOException e)
                {
                    System.out.println("Problem writing sqgac_test.dot");
                }*/
                
                numassigned++;
                prob_other.add_backtrack_level();
                prob_sqgac.add_backtrack_level();
                
                /////////////////////////////////////////////////////////
                // WARNING this is not what the test procedures normally do!!!!
                // they normally instantiate val. This method allows us to reach
                // more of the subdomain space.
                
                ((mid_domain)prob_other.variables.get(var)).exclude(val, null);
                ((mid_domain)prob_sqgac.variables.get(var)).exclude(val, null);
                
                for(int i=0; i<numvars; i++)
                {
                    assert !vars_other[i].empty();
                    assert !vars_sqgac[i].empty();
                }
                
                flag1=prob_other.propagate();
                flag2=prob_sqgac.propagate();
                
                if(flag2 && !flag1)
                {
                    System.out.println("other:");
                    prob_other.printdomains();
                    System.out.println("sqgac:");
                    prob_sqgac.printdomains();
                    
                    /*try
                    {
                        File output = new File("other_constraint_test2.dot");
                        FileWriter out = new FileWriter(output);
                        out.write(c2.printtree_alt());
                        out.close();
                    }
                    catch(java.io.IOException e)
                    {
                        System.out.println("Problem writing sqgac_test.dot");
                    }*/
                    
                    assert false : "found "+flag1+" for other_constraint and "+flag2+" for sqgac";
                }
                
                if(flag2 && !same_domains(prob_other, prob_sqgac))   // if not false, compare doms.
                {
                    System.out.println("different domains");
                    System.out.println("other:");
                    prob_other.printdomains();
                    System.out.println("sqgac:");
                    prob_sqgac.printdomains();
                    
                    /*try
                    {
                        File output = new File("or_constraint_test2.dot");
                        FileWriter out = new FileWriter(output);
                        out.write(c2.printtree_alt());
                        out.close();
                    }
                    catch(java.io.IOException e)
                    {
                        System.out.println("Problem writing sqgac_test.dot");
                    }*/
                    assert false;
                }
                
                if(!flag1 || !flag2)
                    break;  // no point making more assignments.
                
                
            }
            
            // backtrack before starting the next descent.
            for(int i=0; i<numassigned; i++)
            {
                prob_other.backtrack();
                prob_sqgac.backtrack();
            }
        }
    }
    
    boolean same_domains(qcsp prob1, qcsp prob2)
    {
        if(prob1.variables.size()!=prob2.variables.size())
            return false;
        
        for(int i=0; i<prob1.variables.size(); i++)
        {
            mid_domain var1 = (mid_domain)prob1.variables.get(i);
            mid_domain var2 = (mid_domain)prob2.variables.get(i);
            
            if(var1.domsize()!=var2.domsize())
                return false;
            
            if(var1.lowerbound()!=var2.lowerbound())
                return false;
            
            if(var1.upperbound()!=var2.upperbound())
                return false;
            
            for(int j=var1.lowerbound(); j<=var1.upperbound(); j++)
            {
                if(var1.is_present(j)!=var2.is_present(j))
                    return false;
            }
        }
        return true;
    }
}
