package queso.testing;

import queso.constraints.*;
import queso.core.*;

public class testpurelinkup
{
    public static void main(String[] args)
    {
        qcsp prob = new qcsp();
        
        // one orig var and three puremonitor vars
        
        hash_var original = new existential(4, prob, "original");
        
        puremonitor [] pm=new puremonitor[2];
        pm[0]=new puremonitor(4, prob, "pm0");
        pm[1]=new puremonitor(4, prob, "pm1");
        
        mid_domain [] allvars={original, pm[0], pm[1]};
        
        linkup_pures p1=new linkup_pures(allvars, prob);
        p1.establish();
        
        prob.printdomains();
        
        prob.backtrack.add_backtrack_level();
        
        pm[0].exclude(0, null);
        
        prob.propagate();
        
        prob.printdomains();
        
        prob.backtrack.add_backtrack_level();
        
        pm[1].exclude(0, null);
        prob.propagate();
        
        prob.printdomains();
        
        assert original.hash[0]==0 && original.hash[1]==2 && original.hash[2]==2 && original.hash[3]==2;
        
        prob.backtrack.backtrack();
        
        pm[1].exclude(2, null);
        prob.propagate();
        
        assert original.hash[0]==0 && original.hash[1]==0 && original.hash[2]==0 && original.hash[3]==0;
        
        pm[0].exclude(2, null);
        prob.propagate();
        
        assert original.hash[0]==2 && original.hash[1]==2 && original.hash[2]==0 && original.hash[3]==2;
        
        prob.backtrack.backtrack();
        
        // back to initial state.
        // now test propagation from original to the others
        
        original.exclude(2, null);
        prob.propagate();
        prob.printdomains();
        assert pm[0].hash[0]==0 && pm[0].hash[1]==0  && pm[0].hash[2]==2 && pm[0].hash[3]==0;
        assert pm[1].hash[0]==0 && pm[1].hash[1]==0  && pm[1].hash[2]==2 && pm[1].hash[3]==0;
        
        System.out.println("now test with a universal. -------------------------------------------------------------------------");
        
        prob = new qcsp();
        
        // one orig var and three puremonitor vars
        
        original = new universal(4, prob, "original");
        
        pm=new puremonitor[2];
        pm[0]=new puremonitor(4, prob, "pm0");
        pm[1]=new puremonitor(4, prob, "pm1");
        
        mid_domain [] allvars2={original, pm[0], pm[1]};
        
        p1=new linkup_pures(allvars2, prob);
        p1.establish();
        
        prob.printdomains();
        
        prob.backtrack.add_backtrack_level();
        
        pm[0].exclude(0, null);
        
        prob.propagate();
        
        prob.printdomains();
        
        prob.backtrack.add_backtrack_level();
        
        pm[1].exclude(0, null);;
        prob.propagate();
        
        prob.printdomains();
        
        assert original.hash[0]==2 && original.hash[1]==0 && original.hash[2]==0 && original.hash[3]==0;
        
        prob.backtrack.backtrack();
        
        pm[1].exclude(2, null);
        prob.propagate();
        
        assert original.hash[0]==0 && original.hash[1]==0 && original.hash[2]==0 && original.hash[3]==0;
        
        pm[0].exclude(2, null);
        prob.propagate();
        
        assert original.hash[0]==0 && original.hash[1]==0 && original.hash[2]==2 && original.hash[3]==0;
        
        prob.backtrack.backtrack();
        
        // back to initial state.
        // now test propagation from original to the others
        
        ((universal)original).pure(2, null);
        prob.propagate();
        prob.printdomains();
        assert pm[0].hash[0]==0 && pm[0].hash[1]==0  && pm[0].hash[2]==2 && pm[0].hash[3]==0;
        assert pm[1].hash[0]==0 && pm[1].hash[1]==0  && pm[1].hash[2]==2 && pm[1].hash[3]==0;
        
        System.out.println("Now test dummy_linkup -----------------------------------------------");
        
        prob=new qcsp();
        // one orig var and one puremonitor linked up with dummy_linkup
        
        original=new existential(4, prob, "original");
        puremonitor purem=new puremonitor(4, prob, "purem");
        mid_domain[] dummyvars={original, purem};
        dummy_linkup dl=new dummy_linkup(dummyvars, prob);
        dl.establish();
        prob.backtrack.add_backtrack_level();
        
        original.exclude(2, null);
        System.out.println(purem.id+" "+original.id);
        prob.propagate();
        
        prob.printdomains();
        
        for(int i=0; i<purem.hash.length; i++)
        {
            System.out.println(purem.hash[i]);
        }
        
        assert purem.hash[0]==0 && purem.hash[1]==0  && purem.hash[2]==2 && purem.hash[3]==0;
    }
}
