package queso.constraints;

import queso.core.*;

public class dummy_linkup extends constraint implements fd_propagate
{
    // this links a puremonitor variable to a real problem variable.
    // The real problem variable is one which does not have the pure
    // value rule applied to it.
    // Just propagates removals from the real variable to the monitor, not vice versa.
    
    final puremonitor pm;
    final mid_domain other;
    
    final mid_domain [] variables;
    
    public dummy_linkup(mid_domain[] variables, qcsp problem)
    {   
        super(problem);
        
        this.variables=variables;
        
        check_variables(variables);
        
        assert variables[1] instanceof puremonitor;
        assert !(variables[0] instanceof puremonitor);
        assert variables[0].domsize() == variables[1].domsize();
        
        // add to the appropriate wakeup lists
        
        pm=(puremonitor)variables[1];
        other=variables[0];
        
        assert pm.upperbound()<=other.upperbound();  // dom(pm) \subseteq dom(other)
        assert pm.lowerbound()>=other.lowerbound();
        
        other.add_wakeup(this);
    }
    
    public variable_iface [] variables()
    {
        return (variable_iface []) variables;
    }
    
    public boolean establish()
    {
        for(int i=other.lowerbound(); i<=other.upperbound(); i++)
        {
            if(!other.is_present(i)) //pruned already
            {
                // inverted constraints may already have pruned the puremonitor
                if(pm.is_present(i)) pm.exclude(i, this);
            }
        }
        return true;
    }
    
    public boolean propagate(int problem_var, int val)
    {
        // problem_var is the id of the pruned variable.
        assert other.id()==problem_var;   // we should only be woken up by the real variable
        
        // var, val is the pair removed.
        //System.out.println("Propagate called for variable "+variables[var]+" value "+val);
        
        if(pm.is_present(val))
        {
            boolean flag=pm.exclude(val, this);
            assert flag : "Why has this returned false?";
        }
        
        return true;
    }
    
    public String toString()
    {
        return "dummy_linkup "+other+" => "+pm;
    }
    
    public boolean entailed()
    {   // none of this rubbish
        assert false;
        return false;
    }
}

