package queso.constraints;

import queso.core.*;
import java.util.*;
import gnu.trove.*;

class goodlistwrapper
{
    int[][] goodlist;
}

public class gac_schema_positive extends gac_schema implements stateful, negatable
{
    final int [] last_tuple_pointer;   // <pa.scindex, integer>
    
    final int [][][] goods; //  [pa.scindex][goodnumber][variable]
    
    final gac_schema_positive_backtrack gsposbt;
    
    // should not be public :revert when pure value rule is sorted out.
    public predicate_wrapper pred;  // for the inverter.
    
    int [][] tuplelist; // for debugging purposes, and used in make_negated_constraint.
    
    public gac_schema_positive(mid_domain [] vars, qcsp prob, int [][] table)
    {
        super(vars, prob);
        //goods=new THashMap();
        TupleComparator2 tc = new TupleComparator2() ;
        Arrays.sort( (Object []) table, tc);
        tuplelist=table;
        goods=new int [numpa][][];
        splittuples(goods, table);
        //last_tuple_pointer= new TObjectIntHashMap(); //<pa, Integer>
        last_tuple_pointer=new int[numpa];
        Arrays.fill(last_tuple_pointer, -1);
        gsposbt= new gac_schema_positive_backtrack(last_tuple_pointer);
    }
    
    public gac_schema_positive(mid_domain [] vars, qcsp prob, predicate_wrapper pred)
    {
        super(vars, prob);
        
        goods=new int [numpa][][];
        int [][] table=tuples.pred2table(pred, variables);
        TupleComparator2 tc = new TupleComparator2() ;
        Arrays.sort( (Object []) table, tc);
        tuplelist=table;
        //System.out.println("table length:"+table.length);
        splittuples(goods, table);
        //last_tuple_pointer= new TObjectIntHashMap(); //<pa, Integer>
        last_tuple_pointer=new int[numpa];
        Arrays.fill(last_tuple_pointer, -1);
        gsposbt= new gac_schema_positive_backtrack(last_tuple_pointer);
        this.pred=pred;
    }
    
    public void make_negated_constraint(puremonitor pm1, int v1ind)
    {
        if(pred==null)
        {
            pred=new table_predicate(tuplelist);
        }
        predicate_wrapper p2=new negated_predicate(pred);
        puremonitor [] vars=new puremonitor[variables.length];
        
        for(int j=0; j<variables.length; j++)
        {
            // doesn't matter that the original has holes in the domain, because ????
            if(j==v1ind) vars[j]=pm1;
            else
            {
                vars[j]=new puremonitor(variables[j].lowerbound(), variables[j].upperbound(), problem, "pm-c"+this.id+"-"+variables[j]);
                // make the dummy linkup.
                mid_domain[] dlvars={variables[j], vars[j]};
                constraint dl1=new dummy_linkup(dlvars, problem);
                problem.purecons(dl1);
            }
        }
        gac_schema_positive c2=new gac_schema_positive_nofail(vars, problem, p2);
        problem.purecons(c2);
    }
    
    tuple seekNextSupport(pa partial, tuple previous_support)
    {
        // don't actually need previous_support
        boolean testflag=false;
        assert testflag=true;
        int [] nxsupport=null;
        if(testflag)
        {
            int nxvalid=0;
            System.out.println("Testing");
            while(nxvalid<tuplelist.length && (!tuples.valid(tuplelist[nxvalid], variables) || !tuples.contains(tuplelist[nxvalid], partial)))
                nxvalid++;
            if(nxvalid<tuplelist.length)
                nxsupport=tuplelist[nxvalid];
        }
        
        int last_pointer;
        int [] assignment;
        
        last_pointer=last_tuple_pointer[partial.scindex];
        
        //System.out.println("seekNextSupport called with pa:" + partial);
        
        int [][]good_set=goods[partial.scindex];
        
        // Now seek the next support given the assignment and the current variable hashes
        
        int [] thisvalues;
        
        //should be last_pointer plus 1??
        for(int new_pointer=last_pointer+1; new_pointer<good_set.length; new_pointer++)
        {
            thisvalues=good_set[new_pointer];
            
            if(tuples.valid(thisvalues, variables))
            {
                // new_pointer points at a tuple that supports
                // assignment and matches the variable hashes
                
                tuple boxit=new tuple(thisvalues);
                
                //System.out.println("Matched " + boxit+ " with "+ partial);
                
                gsposbt.add_backtrack_pair(partial, last_pointer);
                
                last_tuple_pointer[partial.scindex]=new_pointer;
                assert tuples.comparetuples(thisvalues, nxsupport)==0;
                return boxit;
            }
        }
        
        // So we searched from last_pointer+1 to the end of good_set.
        // nothing found so we return nothing.
        assert nxsupport==null;
        return null;
    }
    
    tuple entail_watch=null;
    // this is bad because it assumes a predicate was used to set up this constraint.
    public boolean entailed()
    {
        // if all vars unit
        boolean flag=true;
        for(int i=0; i<variables.length; i++)
        {
            if(!variables[i].unit())
            {
                flag=false;
                break;
            }
        }
        if(flag) return true;
        
        // check the watch against current domains
        if(entail_watch!=null && tuples.valid(entail_watch.vals, variables))
        {
            return false;
        }
        
        // throttled at 50 tests.
        // generate the first 50 tuples (lex-order)
        // and test them. If we get to the end (i.e. the lex-last in-domain tuple)
        // without finding a false, then return true.
        // If we reach 50 without finding a false, assume there is one later. and return false.
        
        int [] tuplearray=new int[variables.length];
        int [] pavarsvals=new int[0];
        
        tuple tau=new tuple(tuplearray);
        
        // set the tuplearray to lowest val in all domains.
        for(int i=0; i<variables.length; i++)
        {
            tuplearray[i]=variables[i].lowerbound();
        }
        
        for(int i=0; i<50; i++)
        {
            if(!pred.predicate(tau))
            {
                entail_watch=tau;
                return false;
            }
            
            if(!tuples.increment(tuplearray, variables))
            {
                // if no next tuple, then constraint is entailed.
                return true;
            }
        }
        
        return false;  // default is assume not entailed.
    }
    
    public String toString()
    {
        String st="gac_schema_positive2:\n";
        
        for(int i=0; i<variables.length; i++)
            st+=variables[i].toString()+" ";
        st+="\n";
        
        st+= super.toString();
        
        return st;
    }
    
    public void add_backtrack_level()
    {
        gsposbt.add_backtrack_level();
        super.add_backtrack_level();
    }
    
    public void backtrack()
    {
        gsposbt.backtrack();
        super.backtrack();
    }
}

final class gac_schema_positive_backtrack extends backtrack
{
    gac_schema_positive_backtrack(int [] last_tuple_pointer)//TObjectIntHashMap last_tuple_pointer)
    {
        this.last_tuple_pointer=last_tuple_pointer;
        palist=new ArrayList<pa>();
        numlist=new TIntArrayList();
    }
    
    int [] last_tuple_pointer;
    final ArrayList<pa> palist;
    final TIntArrayList numlist;
    
    public void backtrack_item()
    {
        int index=palist.size()-1;
        pa partial=palist.remove(index);
        int old_value=numlist.remove(index);
        last_tuple_pointer[partial.scindex]=old_value;
    }
    
    void add_backtrack_pair(pa partial, int value)
    {
        palist.add(partial);
        numlist.add(value);
        backtrack_increment();
    }
}


