package queso.constraints;

import queso.core.*;

public class or_constraint_values_nofail extends or_constraint_values
{
    public or_constraint_values_nofail(mid_domain [] variables, int [] values, boolean [] negated, int xi, qcsp problem)
    {
        super(variables, values, negated, xi, problem);
    }
    
    public boolean establish()
    {
        boolean flag=true;
        for(int i=0; i<variables.length; i++) if(variables[i].empty()) flag=false;
        
        flag=flag && super.establish();
        if(!flag)
        {
            // prune all values
            for(mid_domain md : variables)
            {
                for(int i=md.lowerbound(); i<=md.upperbound(); i++)
                    if(md.is_present(i)) 
                        md.exclude(i, this);
            }
        }
        return true;
    }
    
    public boolean make_ac()
    {
        boolean flag=true;
        for(int i=0; i<variables.length; i++) if(variables[i].empty()) flag=false;
        
        flag=flag && super.make_ac();
        if(!flag)
        {
            // prune all values
            for(mid_domain md : variables)
            {
                for(int i=md.lowerbound(); i<=md.upperbound(); i++)
                    if(md.is_present(i)) 
                        md.exclude(i, this);
            }
        }
        return true;
    }
}

