package queso.constraints;

import java.util.*;
import queso.core.*;

public class trieconstraint extends gac_schema implements stateful
{
  private final class TupleTrie {
      final int arity ;
      final int significantIndex ;
      int delim ;
      final int[][] trie ;
      
      final int [] last_tuple_pointer;  // pointer to the last found leaf node, by value+offset
      
      final mid_domain [] variables;
      
      final int [][] tuplelist;
      /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         Constructor
	     Assumes tuples is non-empty and each tuple has same length.
	     WCase: each level of trie has |tuples| elements.
	     Tuples are first sorted lexicographically, then added to trie.
	     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      
      TupleTrie(int significantIndex, int[][] tuples, mid_domain [] variables) {
        int componentIndex, trieLevel, tupleIndex ;
	    int noTuples = tuples.length ;
        arity = tuples[0].length ;
	    this.significantIndex = significantIndex ;
        this.variables=variables;
        
	    // delimiter value is distinct from any value in any tuple
	    delim = -1 ;
	    for (tupleIndex = 0; tupleIndex < noTuples; tupleIndex++)
	      for (componentIndex = 0; componentIndex < arity; componentIndex++)
	        if (tuples[tupleIndex][componentIndex] <= delim)
		      delim = tuples[tupleIndex][componentIndex] - 1 ;
	    // Sort tuples for ease of addition to trie
        TupleComparator tc = new TupleComparator(significantIndex, arity);
        Arrays.sort(tuples, tc) ;
        this.tuplelist=(int [][])tuples.clone();
        
	    int[][] initTrie = new int[arity][noTuples*4] ;       //val+2ptr+del
	    for (trieLevel = 0; trieLevel < arity; trieLevel++)
	      Arrays.fill(initTrie[trieLevel], delim) ;
	    // currElement, currIndices. Indexed by trie level.
        int[] currElement = new int[arity] ;
	    int[] currIndices = new int[arity] ;
	    Arrays.fill(currElement, delim) ;
	    Arrays.fill(currIndices, 0) ;
	    // Iterate over tuples, adding each to the trie.
	    for (tupleIndex = 0; tupleIndex < noTuples; tupleIndex++) {
	      int[] tuple = tuples[tupleIndex] ;
	      // lev 0 = signif idx. No delimiters/back ptrs on level 0
          assert tuple[significantIndex]!=delim;
          if (tuple[significantIndex] != currElement[0]) {
	        currElement[0] = tuple[significantIndex] ;
		    initTrie[0][currIndices[0]++] = tuple[significantIndex] ;
		    if (arity > 1) {
		      // Start new block at next level
		      if (currIndices[1] > 0)
		        initTrie[1][currIndices[1]++] = delim ;
		      // point to new block at next level
		      initTrie[0][currIndices[0]++] = currIndices[1];
		      // reset currElement at next level
		      currElement[1] = delim;
		    }
	      }
	      // Now look at rest of tuple
	      for (trieLevel = 1; trieLevel < arity; trieLevel++) {
	        componentIndex = (trieLevel <= significantIndex) ? 
		  			         trieLevel - 1 : trieLevel ;
		    // Only modify this level if this is a new prefix
		    if (tuple[componentIndex] != currElement[trieLevel]) {
		      currElement[trieLevel] = tuple[componentIndex] ;
		      initTrie[trieLevel][currIndices[trieLevel]++] =
		        tuple[componentIndex] ;
		      if (trieLevel < (arity - 1)) {
		        // Start new block at next level
		        if (currIndices[trieLevel+1] > 0)
			      initTrie[trieLevel+1][currIndices[trieLevel+1]++] = delim ;
			    // point to new block at next level
		        initTrie[trieLevel][currIndices[trieLevel]++] =
		          currIndices[trieLevel+1] ;
			    // reset currElement at next level
			    currElement[trieLevel+1] = delim ;
		      }
		      // Point back to parent
		      initTrie[trieLevel][currIndices[trieLevel]++] =
		            currIndices[trieLevel-1] - ((trieLevel==1) ? 2 : 3) ;
		    }
            //if(trieLevel==arity-1) System.out.println("cI[tL]="+currIndices[trieLevel]+" tupleindex:"+tupleIndex+" "+tuples.atos(initTrie[trieLevel]));
            //assert !(trieLevel==arity-1) || currIndices[trieLevel]==(tupleIndex+1)*2;
	      } // end of trieLevel loop
	    } // end of tuple loop
	    // Create final, immutable trie.
	    trie = new int[arity][] ;
	    for (trieLevel = 0; trieLevel < arity; trieLevel++) {
	      trie[trieLevel] = new int[currIndices[trieLevel]] ;
	      System.arraycopy(initTrie[trieLevel], 0,
	                       trie[trieLevel], 0, trie[trieLevel].length);
        }
        
        last_tuple_pointer=new int[variables[significantIndex].domsize()];
        // intended to cause an error if the wrong element is used.
        Arrays.fill(last_tuple_pointer, -1);
        
        /*for(int i=0; i<noTuples; i++)
        {
            System.out.println(tuples.atos(tuples[i]));
        }
        System.out.println("Trie:");
        for(int i=0; i<arity; i++)
        {
            System.out.println(tuples.atos(trie[i]));
        }*/
      }
      
      /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         toString
	     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      public String toString() {
        StringBuffer result = new StringBuffer() ;
	    int i ;
        for (int trieLevel = 0; trieLevel < arity; trieLevel++) {
	      result.append("Trie Level: "+trieLevel+":\n") ;
	      i = 0 ;
	      while (i < trie[trieLevel].length) {
	        if (trie[trieLevel][i] == delim) {
		      result.append("End of blk.\n") ;
		      i++ ;
		    }
		    else {
	          result.append("val: "+trie[trieLevel][i++]+" ") ;
		      if (trieLevel < (arity - 1))
		        result.append("points to idx: "+trie[trieLevel][i++]+" ") ;
		      if (trieLevel > 0)
		        result.append("ptr back to idx: "+trie[trieLevel][i++]) ;
		      result.append("\n");
		    }
	      }
	    }
        return result.toString() ;
      }
      
      /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         nextSupportingTuple
	     Assumes tuple is supporting the ancestor at trieLevel 0.
	     index is into last level of trie.
	     Find highest lvl where domelem in tuple gone. Search from here.
 	     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      
      public int[] nextSupportingTuple (int valToSupport) {
      // valToSupport is the value to find a support for.
        // find the leaf node index from the last time this method was run.
        int valPtr=last_tuple_pointer[valToSupport+variables[significantIndex].offset()];
        int highestLevel = arity, highestIndex = -1;
        if(valPtr==-1)
        {
            highestLevel=1;
            // should be binary search           
            boolean found=false; 
            for(int i=0; i<trie[0].length; i=i+2)
            {
                if(trie[0][i]==valToSupport)
                {
                    highestIndex=trie[0][i+1];
                    //System.out.println("highestIndex:"+highestIndex);
                    found=true;
                    break;
                }
            }
            if(!found) return null;
        }
        else
        {
            int index=valPtr;
            for (int trieLevel = arity-1; trieLevel > 0; trieLevel--) {
              if (!inDomain(trie[trieLevel][index], trieLevel))
              {
	            highestLevel = trieLevel ;
		        highestIndex = index ;
	          }
	          index = trie[trieLevel][index+((trieLevel == arity-1)? 1:2)];
	        }
	        // still supported
	        if (highestLevel == arity) return reconstructTuple(valPtr);
	        // search for next supporting tuple
        }
        int [] st= searchTrie(highestLevel, highestIndex, valToSupport);
        return st;
      }
      
      /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         searchTrie
	     NB call from nextSupport: designed so 1st call to inDomain fails.
 	     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      private int[] searchTrie(int trieLevel, int index, int valToSupport) {
        // First search from startIndex to the
        // end, then from baseIndex to the old support.
        
        // search from index to the end
        boolean searchUpTo=false;  // while false, store min level for each level. if true, search up to the min level.
        int [] minlevel=new int[arity];
        Arrays.fill(minlevel, 2000000000);
        
	    while(true)
        {  // all ending conditions tested first.
            //System.out.println("trieLevel:"+trieLevel+" index:"+index);
          if(searchUpTo && (trieLevel==0 || index>minlevel[trieLevel] || index==trie[trieLevel].length)) return null;
          if(trieLevel==0 || index==trie[trieLevel].length)
          {     // and not searchUpTo.
              searchUpTo=true; boolean found=false;
                for(int i=0; i<trie[0].length; i=i+2) // should be a binary search.
                {
                    if(trie[0][i]==valToSupport)
                    {
                        index=trie[0][i+1];
                        found=true;
                        break;
                    }
                }
                assert found;
                //System.out.println("Resetting and returning to the start. index="+index);
                trieLevel=1; continue;
          }
          
          if(!searchUpTo && minlevel[trieLevel]>index){
            //System.out.println("Changing minlevel["+trieLevel+"] to "+index);
            minlevel[trieLevel]=index;
          }
          
          // Done testing end conditions, now change index and/or trieLevel.
          if (trie[trieLevel][index] == delim)
          {   // Block end, so backtrack.
		      // Point to value after parent of previous value.
              int parent=trie[trieLevel][index-1];
              trieLevel--;
		      index = parent+(trieLevel == (arity-1)? 2:3);
              continue;
		  }
          
          if (inDomain(trie[trieLevel][index], trieLevel)) {
	        // value is in domain. We might be done?
	        if (trieLevel == (arity - 1)){
              last_tuple_pointer[valToSupport+variables[significantIndex].offset()]=index;
	          return reconstructTuple(index);
            }
	        // Move down to next level.
		    index = trie[trieLevel][index+1];
	        trieLevel++;
            continue;
	      }
          else
          {  // Value not in domain, move on to next value.
	        index += ((trieLevel == (arity-1)? 2:3)) ;
            continue;
	      }
        } // end of trie search
      }
      
      /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         inDomain
	     Assumes domain is ordered.
 	     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      private boolean inDomain(int val, int trieLevel) {
        int componentIndex = (trieLevel <= significantIndex) ? 
					         trieLevel - 1 : trieLevel ;
        return variables[componentIndex].is_present(val);
      }
      
      /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         reconstructTuple
	     Follow back ptrs up the tree.
 	     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      int[] reconstructTuple(int valPtr) {
        int componentIndex ;
        int[] tuple = new int[arity] ;
	    for (int trieLevel = arity-1; trieLevel > 0; trieLevel--)
        {
	      componentIndex = (trieLevel <= significantIndex) ? 
					       trieLevel - 1 : trieLevel ;
	      tuple[componentIndex] = trie[trieLevel][valPtr];
	      // get back ptr
	      valPtr = trie[trieLevel][valPtr+((trieLevel == arity-1)? 1:2)] ;
	    }
	    tuple[significantIndex] = trie[0][valPtr] ;
	    return tuple ;
      }
    }  // end of class TupleTrie
  
  // data for class TrieConstraint
  
  final TupleTrie[] tupleTries ;
  final int arity;
  
  // Need support for every literal.
  
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     Constructor
	 Given an arity k constraint, construct k tries from the tuples.
	 Assumes tuples is non-empty.
	 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  public trieconstraint(mid_domain [] vars, qcsp prob, predicate_wrapper pred) 
  {
    super(vars, prob);
    arity = variables.length ;
    tupleTries = new TupleTrie[arity];
    int [][] tuples=queso.constraints.tuples.pred2table(pred, variables);
    for (int varIndex = 0; varIndex < arity; varIndex++) {
      tupleTries[varIndex] = new TupleTrie(varIndex, tuples, variables);
      //System.out.println(tupleTries[varIndex]);
	}
  }
  
  public trieconstraint(mid_domain [] vars, qcsp prob, int [][] tuples)
  {
    super(vars, prob);
    arity = variables.length ;
    tupleTries = new TupleTrie[arity];
    
    for (int varIndex = 0; varIndex < arity; varIndex++) {
      tupleTries[varIndex] = new TupleTrie(varIndex, tuples, variables);
      //System.out.println(tupleTries[varIndex]);
	}
  }
  
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     seekSupport
     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  public tuple seekNextSupport(pa partial, tuple previous_support)
  {
    assert partial.vars.length==1;
    int var=partial.vars[0];
    int val=partial.vals[0];
    //System.out.println("Finding support for var:"+var+" val:"+val);
    
    // can find max (over variables) of min (over values) for other variables, for the valPtr. 
    // Not really, Could do if we used the same trie for everything.
    
    int [] t=tupleTries[var].nextSupportingTuple(val);
    if(t!=null)
    {
        //System.out.println(tuples.atos(t));
        return new tuple(t);
    }
    else
        return null;
  }
  
  public boolean entailed()
  {
    return false;
  }
}
