package queso.core;
import gnu.trove.*;
import java.util.*;
import gnu.math.*;
import java.math.*;

import queso.constraints.*;

public class bexistential extends bounds_var implements intnum_bounds
{
    public bexistential(IntNum lowerbound, IntNum upperbound, qcsp problem, String name)
    {
        super(lowerbound, upperbound, problem, false, name);
    }
    
    public boolean exclude_upper(IntNum val, constraint c)
    {
        assert val.compare(upperbound)<0;
        if(!remove_upper(val)) return false;
        
        for(constraint c1 : upper_wakeups)
        {
            if(c1!=c)
            {
                if(c1 instanceof fd_propagate)   // if it is gac_schema
                    problem.queue.push_constraint((fd_propagate)c1, id, val.intValue());
                else
                    problem.queue.push_constraint((make_ac)c1);
            }
        }
        return true;
    }
    
    public boolean exclude_lower(IntNum val, constraint c)
    {
        assert val.compare(lowerbound)>0;
        if(!remove_lower(val)) return false;
        
        for(constraint c1 : lower_wakeups)
        {
            if(c1!=c)
            {
                if(c1 instanceof fd_propagate)   // if it is gac_schema
                    problem.queue.push_constraint((fd_propagate)c1, id, val.intValue());
                else
                    problem.queue.push_constraint((make_ac)c1);
            }
        }
        return true;
    }
}
