package queso.core;

import java.io.*;
import java.util.*;


// Warning: this one works differently to stopwatch: it returns a cumulative time between calls to start and end, since the last call to zero.
public class stopwatch2
{
    public stopwatch2()
    {}
    
    static
    {
        System.loadLibrary("nativetimer");
    }
    
    long starttime;
    long accumulator=0;
    
    public void start() {
        starttime = nativetimer.gettimeofday();
    }
    
    public void end() {
        accumulator+= nativetimer.gettimeofday()-starttime;
    }
    
    public void zero() {
        accumulator=0;
    }
    
    public long elapsedMicros() {
        return accumulator;
    }
}

class nativetimer
{
    public static native long gettimeofday(); // returns the time in microseconds. 
}

