package queso.encoding;

// stuff related to binary encoding and QBF goes here.
import java.util.*;
import java.io.*;

import queso.core.*;
import queso.constraints.*;
import queso.experiments.Ctype;

public class encoding
{
    public static void main(String [] args)
    {
        // test the encodings with simple examples
        qcsp prob = new qcsp();
        
        boolean [] neg={true, false, true, false};
        mid_domain[] vars=new mid_domain[4];
        vars[0]=new universal(2, prob, "0");
        for(int i=1; i<4; i++) vars[i]=new existential(2, prob, ""+i);
        predicate_wrapper p1=new or_predicate(neg, 2);
        predicate_wrapper p2=new or_predicate(neg, 3);
        sqgac c1=new sqgac(vars, prob, p1);
        sqgac c2=new sqgac(vars, prob, p2);
        
        encoding.qcspencodeproblem(prob);
    }
    
    public static void qcspencodeproblem(qcsp prob)
    {
        qcspencodeproblem(prob, "myinstance.qcsp");
    }
    
    public static void qcspencodeproblem(qcsp prob, String filename)
    {
        // assuming a problem consists entirely of SQGAC constraints from a predicate, extract the variables and predicates
        // and encode the problem.
        StringBuffer doms=new StringBuffer();
        StringBuffer hidvars=new StringBuffer();
        StringBuffer templates=new StringBuffer();
        StringBuffer conflicts=new StringBuffer();
        
        mid_domain [] allvars=new mid_domain[prob.variables.size()];
        for(int i=0; i<allvars.length; i++) allvars[i]=(mid_domain) prob.variables.get(i);
        
        int hnumber=allvars.length;
        
        for(constraint cons : prob.regularconstraints)
        {
            sqgac c1=(sqgac) cons;
            predicate_wrapper p1=c1.pred;
            variable_iface [] v2=c1.variables();
            mid_domain [] v1=new mid_domain[v2.length];
            for(int k=0; k<v2.length; k++)
            {
                v1[k]=(mid_domain)v2[k];
            }
            
            int [][] table=tuples.pred2table(p1, v1);
            if(v1.length==2)  // binary constraint, special case
            {
                genbinaryencoding_bin(table, doms, hidvars, templates, conflicts, v1, hnumber);
            }
            else
            {
                genbinaryencoding(table, doms, hidvars, templates, conflicts, v1, hnumber);
                hnumber++;
            }
        }
        outputqcspinstance(doms, hidvars, templates, conflicts, allvars, prob.regularconstraints.size(), hnumber, filename);
    }
    
    public static void genbinaryencoding(int [][] table, StringBuffer doms, StringBuffer hidvars, StringBuffer templates, StringBuffer conflicts, mid_domain [] consvars, int hnumber)
    {
        // generate the hidden variable binary encoding of one constraint.
        doms.append("(h"+hnumber+" "+table.length+" ("); for(int i=0; i<table.length; i++) doms.append(""+i+" ");
        doms.append("))\n");
        
        hidvars.append("("+hnumber+" h"+hnumber+")\n");
        
        /*System.out.println("table:");
        for(int i=0; i<table.length; i++)
        {
            System.out.println(tuples.atos(table[i]));
        }
        System.out.println("vars:");
        for(int i=0; i<consvars.length; i++)
        {
            System.out.println(consvars[i].domain());
        }*/
        
        //quant.append("("+hnumber+" e)\n");
        
        for(int i=0; i<consvars.length; i++)
        {
            // count number of conflicts
            int domsize=0;
            for(int val=consvars[i].lowerbound(); val<=consvars[i].upperbound(); val++)
            {
                if(consvars[i].is_present(val))
                {
                    domsize++;
                }
            }
            //System.out.println("Domsize="+domsize+" table length="+table.length);
            int numconf=(domsize-1)*table.length;
            templates.append("("+consvars[i].id()+" "+hnumber+")\n"); // the template for one binary constraint.
            
            conflicts.append("(("+consvars[i].id()+" "+hnumber+") "+numconf+" "); // the template for one binary constraint
            
            // now generate all the conflicts
            for(int val=consvars[i].lowerbound(); val<=consvars[i].upperbound(); val++)
            {
                if(consvars[i].is_present(val))
                {
                    for(int j=0; j<table.length; j++)
                    {
                        if(table[j][i]!=val)
                        {
                            conflicts.append("("+val+" "+j+") ");
                        }
                    }
                }
            }
            conflicts.append(")\n");
        }
    }
    
    public static void genbinaryencoding_bin(int [][] table, StringBuffer doms, StringBuffer hidvars, StringBuffer templates, StringBuffer conflicts, mid_domain [] consvars, int hnumber)
    {
        // Output a binary constraint
        //System.out.println("Passing through a binary constraint:"+consvars[0].id()+", "+consvars[1].id());
        //System.out.println(tuples.atos(table));
        //System.out.println(tuples.atos(tuples.fliptable(table, consvars)));
        templates.append("("+consvars[0].id()+" "+consvars[1].id()+")\n");
        
        int numconf=0;
        for(int val=consvars[0].lowerbound(); val<=consvars[0].upperbound(); val++)
        {
            if(consvars[0].is_present(val))
            {
                for(int val2=consvars[1].lowerbound(); val2<=consvars[1].upperbound(); val2++)
                {
                    if(consvars[1].is_present(val2))
                    {
                        boolean intable=false;
                        for(int i=0; i<table.length; i++)
                        {
                            if(table[i][0]==val && table[i][1]==val2)
                            {
                                intable=true;
                                break;
                            }
                        }
                        if(!intable)
                            numconf++;
                    }
                }
            }
        }
        //System.out.println(numconf);
        assert tuples.fliptable(table, consvars).length==numconf;
        
        conflicts.append("(("+consvars[0].id()+" "+consvars[1].id()+") "+numconf+" ");
        
        // now generate all the conflicts
        for(int val=consvars[0].lowerbound(); val<=consvars[0].upperbound(); val++)
        {
            if(consvars[0].is_present(val))
            {
                for(int val2=consvars[1].lowerbound(); val2<=consvars[1].upperbound(); val2++)
                {
                    if(consvars[1].is_present(val2))
                    {
                        boolean intable=false;
                        for(int i=0; i<table.length; i++)
                        {
                            if(table[i][0]==val && table[i][1]==val2)
                            {
                                intable=true;
                                break;
                            }
                        }
                        if(!intable)
                            conflicts.append("("+val+" "+val2+") ");
                    }
                }
            }
        }
        conflicts.append(")\n");
    }
    
    // change of tactic: use actual values from original variables. as values in the binary qcsp.
    
    public static void outputqcspinstance(StringBuffer doms, StringBuffer hidvars, StringBuffer templates, StringBuffer conflicts, mid_domain [] allvars, int e, int n, String filename)
    {
        // first print out the instance myinstance.qcsp
        
        StringBuffer st= new StringBuffer(); 
        st.append("BeginCSP Encoded\n");
        
        // domains
        
        st.append("domains "+(n)+" (\n");  // One for each variable.
        for(int i=0; i<allvars.length; i++)
        {
            int numvals=0;
            for(int val=allvars[i].lowerbound(); val<=allvars[i].upperbound(); val++)
            {
                if(allvars[i].is_present(val)) numvals++;
            }
            
            st.append("(v"+i+" "+numvals+" ("); 
            for(int val=allvars[i].lowerbound(); val<=allvars[i].upperbound(); val++)
            { 
                if(allvars[i].is_present(val)) st.append(""+val+" ");
            }
            st.append("))\n");
        }
        st.append(doms.toString());
        st.append("\n)\n");
        
        // variables
        
        st.append("variables "+(n)+" (\n");
        for(int i=0; i<allvars.length; i++) st.append("("+i+" v"+i+")\n");
        for(int i=0; i<(n-allvars.length); i++) st.append("("+(allvars.length+i)+" h"+(allvars.length+i)+")\n");
        st.append(")\n");
        
        // quantifiers
        
        st.append("quantifiers "+(n)+" (\n");
        for(int i=0; i<allvars.length; i++) st.append("("+i+" "+(allvars[i].quant()?"a":"e")+")\n");
        for(int i=0; i<(n-allvars.length); i++) st.append("("+(allvars.length+i)+" e)\n");
        st.append(")\n");
        
        int numcons=(new StringTokenizer(templates.toString(), "\n")).countTokens();
        
        // constraint templates
        st.append("constraints "+numcons+" (\n");
        st.append(templates.toString());
        st.append(")\n");
        
        // nogoods
        st.append("conflicts "+numcons+" (\n");
        st.append(conflicts.toString());
        st.append(")\n");
        
        st.append("EndCSP Encoded\n");
        
        try
        {
            File output = new File(filename);
            FileWriter out = new FileWriter(output);
            out.write(st.toString());
            out.close();
        }
        catch(java.io.IOException ex)
        {
            System.out.println("Problem writing "+filename);
        }
        
        try
        {
            File output = new File("myinstance.qcsp");
            FileWriter out = new FileWriter(output);
            out.write(st.toString());
            out.close();
        }
        catch(java.io.IOException ex)
        {
            System.out.println("Problem writing "+filename);
        }
    }
    
    public static void qbfencodeproblem(qcsp prob, String filename)
    {
        StringBuffer clauses=new StringBuffer();
        
        int clausecounter=0;
        
        int [] variableoffset=new int[prob.variables.size()];
        
        mid_domain [] allvars=new mid_domain[prob.variables.size()];
        for(int i=0; i<allvars.length; i++) allvars[i]=(mid_domain) prob.variables.get(i);
        
        int varoffset=0;
        
        for(int i=0; i<allvars.length; i++)
        {
            mid_domain thisvar=allvars[i];
            variableoffset[i]=varoffset;
            varoffset+=thisvar.domsize();
            
            assert thisvar.id()==i;
        }
        
        /*for(constraint cons : prob.regularconstraints)
        {
            or_c c1=(or_c) cons;
            
            mid_domain [] v1=c1.variables;
            
            int xi=c1.xi;
            
            // print implication from xi to all other vars.
            
            if(c1 instanceof or_constraint)
            {
                or_constraint c2=(or_constraint)c1;
                
                // print implication from xi to all other vars.
                clauses.append((variableoffset[v1[xi].id()]+(c1.negated[xi]?1:0))+" ");
                
                for(int i=0; i<v1.length; i++)
                {
                    if(i!=xi)
                    {
                        clauses.append((variableoffset[v1[i].id()]+(c1.negated[i]?0:1))+" ");
                    }
                }
                clauses.append("0\n"); clausecounter++;
                
                // now print implication from each of the other vars to xi
                for(int i=0; i<v1.length; i++)
                {
                    if(i!=xi)
                    {
                        clauses.append((variableoffset[v1[i].id()]+(c1.negated[i]?1:0))+" "+
                            (variableoffset[v1[xi].id()]+(c1.negated[xi]?1:0))+"0\n");
                        clausecounter++;
                    }
                }
                
            }
            else
            {
                assert c1 instanceof or_constraint_values;
                
                
            }
            
            
        }*/
        
        // print out the variables.
        
        StringBuffer all=new StringBuffer();
        
        int numnormalvars=variableoffset[variableoffset.length-1]+allvars[allvars.length-1].domsize();
        
        int numuniv=0; for(mid_domain v1 : allvars) if(v1.quant()) numuniv+=v1.domsize();
        
        all.append("p cnf "+(numnormalvars+numuniv)+" "+clausecounter+"\n");
        for(int i=0; i<allvars.length; i++)
        {
            all.append((allvars[i].quant()?"a ":"e "));
            
            if(!allvars[i].quant())
            {
                for(int j=0; j<allvars[i].domsize(); j++)
                {
                    all.append((variableoffset[i]+j)+" ");
                }
                all.append("0\n");
            }
            else
            {
                // adapt this for a log number of vars.
                for(int j=0; j<allvars[i].domsize(); j++)
                {
                    int offset=0; for(int k=0; k<i; k++) if(allvars[k].quant()) offset+=allvars[k].domsize();
                    all.append((variableoffset[i]+j)+" ");
                }
                all.append("0\ne ");
                
                
                for(int j=0; j<allvars[i].domsize(); j++)
                {
                    all.append((variableoffset[i]+j)+" ");
                }
                
                all.append("0\n");
            }
            
        }
        
        // channel the universals into the appropriate numbered existentials...
        
        for(int i=0; i<allvars.length; i++)
        {
            if(!allvars[i].quant())
            {
                for(int j=0; j<allvars[i].domsize(); j++)
                {
                    all.append((variableoffset[i]+j)+" ");  // ALO
                }
                all.append("0\n");
            }
            else
            {
                for(int j=0; j<allvars[i].domsize(); j++)
                {
                    // write contents of this loop.
                    
                    int offset=0; for(int k=0; k<i; k++) if(allvars[k].quant()) offset+=allvars[k].domsize();
                    
                    all.append((variableoffset[i]+j)+" ");
                }
            }
            
            // AMO for both var types.
            for(int j=0; j<allvars[i].domsize(); j++)
            {
                for(int k=j+1; k<allvars[i].domsize(); k++)
                {
                    all.append((variableoffset[i]+j)+" "+(variableoffset[i]+k)+" 0\n");
                }
            }
        }
    }
}

class testqcspsolve
{
    public static void main(String [] args)
    {
        testqcspsolve ex;
        Ctype c;
        for(density=0.2; density<=0.8; density=density+0.3)
        {
        System.out.println("Density:"+density);
        
        c=Ctype.qcspsolve;
        ex=new testqcspsolve();
        ex.r=new Random(12345);
        System.out.println("QCSP-Solve");
        ex.runbunch(c);
        
        }
    }
    
    void runbunch(Ctype c)
    {
        for(int arity=2; arity<=6; arity=arity+2)
        {//int arity=10;
        System.out.println("arity:"+arity);
        for(int d=2; d<=5; d++)
        {//int d=2;  // for easy encoding to QBF.
        int numvars;
        if(d==2) numvars=25;
        else if(d==3) numvars=13;
        else if(d==4) numvars=8;
        else numvars=7; // d==5
        
        if(arity==7) numvars--;
        else if(arity==9) numvars=numvars-2;
        else if(arity==11) numvars=numvars-3;
        
        if(density==0.8) numvars=numvars-3;  // make it a bit easier
        
        numvars=25;
        
        //if(arity>numvars) break;
        
        //if(arity==7 && d>=5) break;
        //if(arity==9 && d>=4) break;
        //if(arity==11 && d>=3) break;
        
        for(int numcons=1; numcons<=15; numcons=numcons+1)
        {
            long time=0;
            long snstimelocal=0;
            long snscountlocal=0;
            int numsat=0;
            int tries=10;
            for(int i=0; i<tries; i++){
                time+=runtest(d, c, arity, numcons, numvars);
                snstimelocal+=snstime;
                snscountlocal+=snscount;
                numsat+=(ifsat?1:0);
            }
            System.out.println("d:"+d+" numcons:"+numcons+" numvars:"+numvars+" time for suite:"+time+" numsat:"+numsat+"/"+tries);
            //if(numsat<=(tries/4)) break;  // below the quartile, stop.
        }
        }
        }
    }
    
    Random r; // random number generator.
    stopwatch2 sw;
    
    static double density;
    
    // returns from the runtest method.
    long snstime;
    long snscount;
    //long domainchecks;
    boolean ifsat=false;
    
    long runtest(int d, Ctype c, int arity, int numcons, int numvars)
    {
        sw=new stopwatch2();
        // generate a model and run it for each propagator.
        qcsp prob=new qcsp(false, false, false, false, false);
        mid_domain [] vars=new mid_domain[numvars];
        
        for(int i=0; i<numvars; i++)
        {
            if(i==5 || i==5 || i==11 || i==11 || i==17 || i==17 || i==23 || i==23)
            {
                vars[i]=new universal(d, prob, "ux"+i);  // d for domain size.
            }
            else
            {
                vars[i]=new existential(d, prob, "ex"+i);  // d for domain size.
            }
        }
        
        numclauses=0;
        StringBuffer clauses=new StringBuffer();
        
        StringBuffer doms=new StringBuffer();
        StringBuffer hidvars=new StringBuffer();
        StringBuffer constemplates=new StringBuffer();
        StringBuffer conflicts=new StringBuffer();
        int hnumber=numvars;
        
        // gen  constraints.
        for(int i=0; i<numcons; i++)
        {
            // pick arity variables
            mid_domain [] gsvars=new mid_domain[arity];
            int counter=0;
            while(counter<arity)
            {
                int varIndex=(int) Math.floor(r.nextFloat()*numvars);
                if(!tuples.in(gsvars, vars[varIndex]))
                {
                    gsvars[counter]=vars[varIndex];
                    counter++;
                }
            }
            
            //sort
            varcompare vc=new varcompare();
            Arrays.sort(gsvars, vc);
            
            //int [][] tab=tuples.generateprobability(arity, gsvars, r, (float) density);
            
            int [][] tab=tuples.generatetuples(arity, gsvars, r, Math.round((float) (density* Math.pow((double)d, (double)arity ))));
            
            // construct constraint
            predicate_wrapper p1=new table_predicate((int [][])tab.clone());
            
            if(c==Ctype.sqgac || c==Ctype.qcspsolve)
            {
                new sqgac(gsvars, prob, p1);
            }
            else if(c==Ctype.gspredicate)
            {
                new gac_schema_predicate(gsvars, prob, p1); // warning: predicate maynot be efficient.
            }
            else if(c==Ctype.gspositive)
            {
                new gac_schema_positive(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.qbfquantor || c==Ctype.qbfquberel || c==Ctype.qbfqubebj || c==Ctype.qbfskizzo || c==Ctype.qbfcsbj)
            {
                genclauses(tab, clauses, gsvars);
            }
        }
        System.gc();  // attempt to stop it gc'ing during the run.
        
        if(c==Ctype.qbfquantor || c==Ctype.qbfquberel  || c==Ctype.qbfqubebj || c==Ctype.qbfskizzo || c==Ctype.qbfcsbj)
        {
            sw.zero();
            sw.start();
            runqbfsolvers(c, clauses, vars);
            sw.end();
            return sw.elapsedMicros();
        }
        else if(c==Ctype.qcspsolve)
        {
            //encoding.outputqcspinstance(doms, hidvars, constemplates, conflicts, vars, numcons);
            encoding.qcspencodeproblem(prob);
            sw.zero();
            sw.start();
            boolean flag=runbinarysolver(c);
            sw.end();
            
            ifsat=prob.establish();
            
            if(!ifsat)
            {
                System.out.println("Verify: false");
            }
            else
            {
                ifsat=prob.search();
                System.out.println("Verify: "+ifsat);
            }
            assert ifsat==flag;
            return sw.elapsedMicros();
        }
        else
        {
        sw.zero();
        stopwatch swbackup=new stopwatch();
        swbackup.start();
        sw.start();
        ifsat=prob.establish();
        //sw.end();
        
        //System.out.println("Establish time: "+sw.elapsedMillis());
        //prob.printdomains();
        //sw.start();
        
        if(ifsat) ifsat=prob.search();
        
        //System.out.println("Sat:"+ifsat);
        sw.end();
        swbackup.end();
        snstime=0;
        snscount=0;
        for(constraint cons : prob.constraints)
        {
            if(!(cons instanceof gac_schema)) break;
            
            if(((gac_schema)cons).sw!=null){ 
            snstime+=((gac_schema)cons).sw.elapsedMicros();
            snscount+=((gac_schema)cons).snscount;
            }
        }
        
        //System.out.println("Search time: "+sw.elapsedMillis()+" nodes:"+prob.numnodes);
        return sw.elapsedMicros();
        }
        //return swbackup.elapsedMillis()*1000;
    }
    
    void runqbfsolvers(Ctype c, StringBuffer sb, mid_domain [] vars)
    {
        // first print out the instance.
        String st="p cnf "+vars.length+" "+numclauses+"\n";
        
        for(int i=0; i<vars.length; i++)
        {
            if(vars[i].quant()) 
            {
                st+="a "+(vars[i].id()+1)+" 0\n";
            }
            else
            {
                st+="e "+(vars[i].id()+1)+" 0\n";
            }
        }
        
        sb.insert(0, st);
        
        try
        {
            File output = new File("myinstance.qdimacs");
            FileWriter out = new FileWriter(output);
            out.write(sb.toString());
            out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing myinstance.qbf");
        }
        Process p=null;
        try
        {
            if(c==Ctype.qbfcsbj)
                p = Runtime.getRuntime().exec("/home/pn/bin/csbj myinstance.qdimacs");
            else if(c==Ctype.qbfquantor)
                p = Runtime.getRuntime().exec("/home/pn/bin/quantor myinstance.qdimacs");
            else if(c==Ctype.qbfquberel)
                p = Runtime.getRuntime().exec("/home/pn/bin/quberel myinstance.qdimacs");
            else if(c==Ctype.qbfqubebj)
                p = Runtime.getRuntime().exec("/home/pn/bin/qubebj myinstance.qdimacs");
            else if(c==Ctype.qbfskizzo)
                p = Runtime.getRuntime().exec("/home/pn/bin/skizzo myinstance.qdimacs");
        } catch(java.lang.Exception e)
        {
            System.out.println("Problem running solver");
        }
        
        try
        {
            int retval=p.waitFor();
            assert retval==0;
        } catch(java.lang.Exception e)
        {
            System.out.println("Problem waiting");
        }
    }
    
    static int numclauses;
    
    boolean runbinarysolver(Ctype c)
    {   
        Process p=null;
        boolean flag=false;
        if(c==Ctype.qcspsolve)
        {
            try
            {
                p = Runtime.getRuntime().exec("/home/pn/qcspsolve/qcspsolve-new myinstance.qcsp");
            }
            catch(java.lang.Exception e)
            {
                System.out.println("Problem running solver");
            }
            try
            {
                int retval=p.waitFor();
                BufferedInputStream in = new BufferedInputStream(p.getInputStream());
                
                int size = in.available();
	            byte[] content = new byte[size];
	            
	            in.read(content);
	            String st = new String(content);
                
                String [] st2=st.split(":");
                st=st2[st2.length-1];
                
                st=st.substring(1,2);
                
                flag= st.compareTo("t")==0;
                System.out.println(st.compareTo("t")==0);
            } catch(java.lang.Exception e)
            {
                System.out.println("Problem waiting");
            }
            return flag;
        }
        assert false;
        return false;
    }
    
    void genclauses(int [][] table, StringBuffer sb, mid_domain [] consvars)
    {
        int [][] fliptable=tuples.fliptable(table, consvars);
        numclauses+=fliptable.length;
        for(int i=0; i<fliptable.length; i++)
        {
            for(int j=0; j<fliptable[i].length; j++)
            {
                sb.append((consvars[j].id()+1) * ((fliptable[i][j]==0)?1:-1));
                sb.append(" ");
            }
            sb.append("0\n");
        }
    }
    
}
