package queso.experiments;

import java.io.*;
import java.util.*;
import gnu.math.IntNum;

import queso.core.*;
import queso.constraints.*;

//  This is the really awful model with a variable for each time slot and machine, to represent the job.
//  jobshop2.java contains the better model.

public class jobshop
{
    public static void main(String[] args)
    {
        /*runit("js-tiny.prb", true, 20, 2);
        runit("js-tiny.prb", true, 20, 2);
        runit("js-tiny.prb", true, 20, 2);
        runit("js-tiny.prb", true, 20, 2);
        runit("js-tiny.prb", true, 20, 2);
        
        runit("js-tiny.prb", true, 20, 2);
        runit("js-tiny.prb", true, 20, 2);
        runit("js-tiny.prb", true, 20, 2);
        runit("js-tiny.prb", true, 20, 2);
        runit("js-tiny.prb", true, 20, 2);
        
        
        runit("prob/la01.prb", false, 1000, 2);
        runit("prob/la01.prb", false, 1000, 2);
        runit("prob/la01.prb", false, 1000, 2);
        runit("prob/la01.prb", false, 1000, 2);
        runit("prob/la01.prb", false, 1000, 2);
        runit("prob/la01.prb", false, 1000, 2);
        runit("prob/la01.prb", false, 1000, 2);*/
        
        runit("prob/la01-5x5.prb", true, 500, 2);
        
        //runit("prob/la01.prb", true, 700, 2);
        //runit();
    }
    
    private static int getnumber(StreamTokenizer st)
    {
        try{ st.nextToken(); }
        catch(java.io.IOException e) {System.out.println("IOe");}
        
        if(st.ttype!=st.TT_NUMBER)
        {
            System.out.println("Error in getnumber");
        }
        return (int)st.nval;
    }
    
    static void runit(String filename, boolean optimize, int maxmakespan, int periods)
    {
        int [][]taskmachines={};
        int [][] duration={};
        int jobs=0;
        int machines=0;
        
        try{
        File inputFile = new File(filename);
        FileReader infile = new FileReader(inputFile);
        BufferedReader in = new BufferedReader(infile);
        
        // throw away the comment line
        while(in.read()!=(int)'\n');
        
        StreamTokenizer st = new StreamTokenizer(in);
        
        st.eolIsSignificant(false);
        
        jobs=getnumber(st);
        machines=getnumber(st);
        
        System.out.println(jobs+" "+machines+"\n");
        //read jobs, then machines,
        // then pairs (machine indexed from 0, duration)
        
        taskmachines = new int[jobs][machines];
        duration = new int[jobs][machines];
        
        for(int job=0; job<jobs; job++)
        {
            for(int task=0; task<machines; task++)
            {
                taskmachines[job][task]=getnumber(st);
                duration[job][task]=getnumber(st);
                System.out.print(taskmachines[job][task]+" "+duration[job][task]+"   ");
            }
            System.out.println();
        }
        
        } catch(java.lang.Exception e){System.out.println("Problem reading "+filename);}
        
        final int slotsperperiod=maxmakespan/periods;
        
        // testing and repairs parameters
        // each equal period begins with a test. periods must divide maxmakespan.
        
        final int servicelength=3;  // the length of time scheduled for servicing
        boolean slow_chan=true;
        qcsp prob = new qcsp(true, false, false, false, false, true, true);
        
        //int [][] taskmachines=new int[jobs][machines]; // indexed by [job][task] to get machine number.
        //int [][] duration=new int[jobs][machines]; // indexed by [job][task] to get duration -- 0 means does not need this machine.
        
        // fill in the arrays here!
        
        //int [][] taskmachines={{0,1,2},{2,1,0},{1,2,0}};
        //int [][] duration={{3,3,3},{4,4,4},{3,3,3}};
        int [][] failurep=new int[periods][machines];
        
        for(int i=0; i<periods; i++)
            Arrays.fill(failurep[i], 1); // expressed as a percentage in this instance.
        
        IntNum denom=IntNum.make(100);   // the failure probability is failurep/denom.
        
        IntNum quotient=IntNum.power(denom, periods*machines);
        //IntNum quotient=IntNum.make(1000000000000L);
        
        IntNum thresholdp=IntNum.quotient(quotient, denom);   // less than 0.01 probability branches are not considered.
        
        mid_domain [][] begin=new mid_domain[jobs][machines];  // indexed [job][task]
        mid_domain [][] end=new mid_domain[jobs][machines];
        // note that end is the time the job ends, e.g. 6pm, so the next job can start at the same time 6pm.
        // begin 6 and end 6 mean the job actually takes no time.
        
        mid_domain [][] timeslots=new mid_domain[machines][maxmakespan];  // indexed [machine][slot]
        
        // servicing jobs
        
        mid_domain [][] servicebegin=new mid_domain[periods][machines];
        mid_domain [][] serviceend=new mid_domain[periods][machines];
        
        // combined probability of all events that have already happened
        intnum_bounds [][] leftp=new intnum_bounds[periods][machines];
        
        // leftp * non-fail probability for all future events * fail probability for this one.
        intnum_bounds [][] priorp=new intnum_bounds[periods][machines];  
        
        mid_domain [][] available=new mid_domain[periods][machines];
        mid_domain [][] fault=new mid_domain[periods][machines];
        mid_domain [][] shadow=new mid_domain[periods][machines];
        intnum_bounds [][] phere=new intnum_bounds[periods][machines];
        
        // set up all the variables
        int numconstants=(maxmakespan+1>101)?(maxmakespan+1):101;
        mid_domain [] constants= new mid_domain[numconstants];   // make some constants
        for(int i=0; i<numconstants; i++) constants[i]=new existential(i, i, prob, ""+i);
        
        intnum_bounds threshold_var=new bexistential(thresholdp, thresholdp, prob, thresholdp.toString());
        
        // set up the timeslots in chron. order
        
        for(int period=0; period<periods; period++)
        {
            // do the availability and fault variables here.
            // with connecting constraints
            for(int machine=0; machine<machines; machine++)
            {
                if(period==0 && machine==0)
                    leftp[period][machine]=(intnum_bounds)constants[1];
                else
                    leftp[period][machine]=new bexistential(IntNum.zero(), quotient, prob, "leftp["+period+"]["+machine+"]");
                
                priorp[period][machine]=new bexistential(IntNum.zero(), quotient, prob, "priorp["+period+"]["+machine+"]");
                
                available[period][machine]=new existential(0, 1, prob, "available["+period+"]["+machine+"]");
                fault[period][machine]=new universal(0, 1, prob, "fault["+period+"]["+machine+"]");
                int [] weights={100-failurep[period][machine], failurep[period][machine]};
                ((universal)fault[period][machine]).setweights(weights);
                shadow[period][machine]=new existential(0, 1, prob, "shadow["+period+"]["+machine+"]");
                
                phere[period][machine]=new bexistential(IntNum.zero(), IntNum.make(100), prob, "phere["+period+"]["+machine+"]");
                
                // connect available, fault and shadow s.t. fault can have pure values.
                mid_domain [] v3={available[period][machine], fault[period][machine], shadow[period][machine]};
                boolean [] neg3={true, true, true};
                constraint c3=new or_constraint(v3,neg3,2,prob);
                
                // construct the after maximum probability.
                IntNum afterMaxP=IntNum.one();
                for(int m2=machine+1; m2<machines; m2++)
                {
                    afterMaxP=IntNum.times(afterMaxP, (100-failurep[period][m2]));   // warning: assumes failurep <50%
                }
                
                for(int p2=period+1; p2<periods; p2++)
                {
                    for(int m2=0; m2<machines; m2++)
                    {
                        afterMaxP=IntNum.times(afterMaxP, (100-failurep[p2][m2]));
                    }
                }
                
                afterMaxP=IntNum.times(afterMaxP, failurep[period][machine]);  // no longer just the events after this one.
                intnum_bounds tempconst=new bexistential(afterMaxP, afterMaxP, prob, "afterMaxP:"+period+","+machine);
                
                {intnum_bounds [] v1={leftp[period][machine], priorp[period][machine], tempconst};
                constraint c1=new product_constraint(v1, 1, IntNum.one(), IntNum.one(), prob);}
                
                // compare priorp with the threshold and set available appropriately
                {intnum_bounds [] v1={priorp[period][machine], threshold_var};
                constraint c1=new comparison_constraint(v1, available[period][machine], 1, prob);}
                
                // set phere for the probability of this event.
                assert failurep[period][machine]!=50;
                intnum_bounds failurep_var=(intnum_bounds)constants[failurep[period][machine]];
                intnum_bounds failurep_inv=(intnum_bounds)constants[100-failurep[period][machine]];
                
                {intnum_bounds [] v1={phere[period][machine], failurep_var};
                constraint c1=new comparison_constraint(v1, shadow[period][machine], 0, prob);}
                
                {intnum_bounds [] v1={phere[period][machine], failurep_inv};
                constraint c1=new comparison_constraint(v1, shadow[period][machine], 3, prob);}
                
                // now link lastp and the previous shadow abnd the previous last
                if(period!=0 || machine!=0)
                {
                    int prevperiod=(machine==0)?(period-1):period;
                    int prevmachine=(machine==0)?(machines-1):(machine-1);
                    
                    //leftp[period][machine]=phere[prevperiod][prevmachine]*leftp[prevperiod][prevmachine]
                    intnum_bounds [] v1={leftp[prevperiod][prevmachine], phere[prevperiod][prevmachine], leftp[period][machine]};
                    constraint c1=new product_constraint(v1, 2, IntNum.one(), IntNum.one(), prob);
                }
            }
            
            // make the time slot variables.
            
            for(int slot=period*slotsperperiod; slot<(period+1)*slotsperperiod; slot++)
            {
                for(int machine=0; machine<machines; machine++)
                {
                    timeslots[machine][slot]=new existential(-2, jobs-1, prob, "timeslot["+machine+"]["+slot+"]");
                    // -1 indicates idleness
                    // -2 indicates servicing.
                }
            }
        }
        
        // set up the begin and end variables and constraints among them
        
        for(int job=0; job<jobs; job++)
        {
            for(int task=0; task<machines; task++)
            {
                begin[job][task]=new existential(0, maxmakespan, prob, "begin["+job+"]["+task+"]");
                end[job][task]=new existential(0, maxmakespan, prob, "end["+job+"]["+task+"]");
                
                {mid_domain [] v1={(mid_domain)end[job][task], 
                    (mid_domain)begin[job][task],
                    (mid_domain)constants[duration[job][task]]};
                int [] w1={1, -1, -1};
                // end-beginning = duration => end-beginning-duration=0
                constraint c1=new sum_constraint(v1, w1, prob);}
                
                if(task>0)
                {   //end(task-1)<=begin(task)  
                    intnum_bounds [] v1={(intnum_bounds)end[job][task-1], (intnum_bounds)begin[job][task]};
                    constraint c1=new comparison_constraint(v1, constants[1], -1, prob);
                }
            }
        }
        
        // set up the service variables and constraints among them
        for(int period=0; period<periods; period++)
        {
            for(int machine=0; machine<machines; machine++)
            {
                int periodstart=period*(maxmakespan/periods);
                servicebegin[period][machine]=new existential(periodstart, periodstart+(maxmakespan/periods), prob, "servicebegin["+period+"]["+machine+"]");
                
                serviceend[period][machine]=new existential(periodstart, periodstart+(maxmakespan/periods), prob, "serviceend["+period+"]["+machine+"]");
                
                {mid_domain [] v1={(mid_domain)serviceend[period][machine], 
                    (mid_domain)servicebegin[period][machine],
                    (mid_domain)constants[servicelength]};
                int [] w1={1, -1, -1};
                // end-beginning = duration => end-beginning-duration=0
                constraint c1=new sum_constraint(v1, w1, prob);}
                
                // if shadow == 0 then servicebegin is fixed to periodstart to avoid lots of branching.
                {mid_domain [] vars1={(mid_domain)shadow[period][machine], 
                    (mid_domain)servicebegin[period][machine],
                    (mid_domain)constants[1]};
                int [] vals1={0, periodstart, 1};
                boolean [] neg1={true, false, false};
                // shadow==0  => servicebegin=periodstart
                constraint c1=new or_constraint_values(vars1, vals1, neg1, 2, prob);}
            }
        }
        
        // now set up the channelling constraints
        // for each slot on each machine, channel to the begin/end vars.
        for(int machine=0; machine<machines; machine++)
        {
            for(int slot=0; slot<maxmakespan; slot++)
            {
                mid_domain slotvar=timeslots[machine][slot];
                
                // channel to each job.
                for(int job=0; job<jobs; job++)
                {
                    int task=0;
                    while(taskmachines[job][task]!=machine) task++;
                    
                    // iff begin[job][task] <= slot and end[job][task]>slot then slotvar==job
                    
                    if(slow_chan)
                    {
                    intnum_bounds [] v1={(intnum_bounds) begin[job][task], (intnum_bounds) constants[slot]};
                    mid_domain temp1=new existential(0, 1, prob, "temp1");
                    constraint c1=new comparison_constraint(v1, temp1, -1, prob);
                    
                    intnum_bounds [] v2={(intnum_bounds) end[job][task], (intnum_bounds) constants[slot]};
                    mid_domain temp2=new existential(0, 1, prob, "temp2");
                    constraint c2=new comparison_constraint(v2, temp2, 2, prob);
                    
                    mid_domain [] v3={temp1, temp2, slotvar};
                    int [] vals3={1, 1, job};
                    boolean [] neg3={true, true, true};
                    constraint c3=new or_constraint_values(v3,vals3,neg3,2,prob);
                    }
                    else
                    {
                        mid_domain [] v1={begin[job][task], end[job][task], slotvar};
                        int [] values={slot, slot+1, job};
                        int [] comp={1, -1, 2};  // 2 for !=
                        constraint c1=new or_constraint_comparison(v1, values, comp, 2, prob);
                    }
                }
            }
        }
        
        // for each period and each machine, channel from the servicing variables to 
        // the timeslots. Code -2
        // and do other servicing related things.
        for(int machine=0; machine<machines; machine++)
        {
            for(int slot=0; slot<maxmakespan; slot++)
            {
                mid_domain slotvar=timeslots[machine][slot];
                
                // iff begin[job][task] <= slot and end[job][task]>slot then slotvar==job
                if(slow_chan)
                {
                intnum_bounds [] v1={(intnum_bounds) servicebegin[slot/slotsperperiod][machine], (intnum_bounds) constants[slot]};
                mid_domain temp1=new existential(0, 1, prob, "temp1");
                constraint c1=new comparison_constraint(v1, temp1, -1, prob);
                
                intnum_bounds [] v2={(intnum_bounds) serviceend[slot/slotsperperiod][machine], (intnum_bounds) constants[slot]};
                mid_domain temp2=new existential(0, 1, prob, "temp2");
                constraint c2=new comparison_constraint(v2, temp2, 2, prob);
                
                mid_domain [] v3={available[slot/slotsperperiod][machine], fault[slot/slotsperperiod][machine], temp1, temp2, slotvar};
                int [] vals3={1, 1, 1, 1, -2};
                boolean [] neg3={true, true, true, true, true};
                constraint c3=new or_constraint_values(v3,vals3,neg3,4,prob);
                }
                else
                {
                    mid_domain [] v1={available[slot/slotsperperiod][machine], fault[slot/slotsperperiod][machine], 
                        servicebegin[slot/slotsperperiod][machine], serviceend[slot/slotsperperiod][machine], slotvar};
                    int [] values={1, 1, slot, slot+1, -2};
                    int [] comp={2, 2, 1, -1, 2};  // 2 for !=
                    constraint c1=new or_constraint_comparison(v1, values, comp, 4, prob);
                }
            }
        }
        
        // set up the optimization variable
        
        mid_domain [] maxvars = new mid_domain[jobs+1];
        for(int job=0; job<jobs; job++)
        {
            maxvars[job]=end[job][machines-1]; // last end time for this job
        }
        mid_domain makespan=new existential(0, maxmakespan, prob, "makespan");
        maxvars[jobs]=makespan;
        constraint max_cons=new max_constraint(maxvars, jobs, prob);
        
        prob.pure_setup_universals();  // enables the pure value rule, could take some time to execute
        
        //System.out.println(prob.constraints.toString());
        
        // root node processing here.
        //System.out.println("Establish GAC list:");
        //System.out.println(prob.queue.toestablish);
        
        prob.setHeuristic(new jsheuristic());
        
        stopwatch sw= new stopwatch("GMT");
        
        sw.start();
        boolean flag=prob.establish();
        sw.end();
        //prob.printdomains();
        System.out.println("Time to establish:"+sw.elapsedMillis());
        
        assert flag;
        sw.start();
        if(optimize) System.out.println(prob.bandb(makespan, false, false, true));
        else System.out.println(prob.search());
        sw.end();
        System.out.println("Nodes: "+prob.numnodes);
        System.out.println("Time (ms): "+sw.elapsedMillis());
        
        prob.savetree("jobshop.dot");
        //System.out.println(cons);
    }
}

class jsheuristic implements heuristic
{
    public int choosevalue(variable m)
    {
        // has access to all variable domains through prob.
        mid_domain md1= (mid_domain)m;
        
        int i= md1.upperbound();
        if(i==-1)
        {
            return md1.lowerbound();  // might be able to do -2 (servicing) first.
        }
        return i;
    }
}
