//import java.util.*;
import gnu.trove.*;



class crosses_chan extends qcsp
{
    void printsol()
    {
        for(int i=0; i<9; i++)
        {
            System.out.print(findval("board"+i)+" | ");
            if(i==2||i==5||i==8) System.out.println();
        }
        
        System.out.println();
        
        for(int i=0; i<9; i++)
        {
            System.out.print(findval("time"+i)+" | ");
            if(i==2||i==5||i==8) System.out.println();
        }
        
        for(variable var : variables)
        {
            System.out.println("Variable "+var+" : "+findval(var.name));
        }
        printdomains();
    }
    
    String findval(String varname) // given a variable name, return the value(s).
    {
        String temp="";
        for(variable t : variables)
        {
            if(t.name.equals(varname))
            {   
                for(int j=((hash_var)t).lowerbound(); j<((hash_var)t).domsize(); j++)
                {
                    if(((hash_var)t).is_present(j))
                    {
                        temp+=" "+j;
                    }
                }
                return temp;
            }
        }
        assert false;
        return temp;
    }
}

class noughts_chan
{
    public static void main(String[] args)
    {
        runit();
        //runit();
        //runit();
    }
    
    static void runit()
    {
        qcsp prob = new crosses_chan();
        
        hash_var[] moves=new hash_var[9];
        
        hash_var[] shadowmoves=new hash_var[9];  // the shadow hash_vars for universal move hash_vars
        
        hash_var[] board=new hash_var[9];   // binary vars
        
        hash_var[][] available=new hash_var[9][];  // boolean, is a hash_var available at the move
        
        hash_var[] times=new hash_var[9];   // times that tokens were placed on the board
        
        hash_var xline;
        
        hash_var oline;
        
        hash_var[] lines=new hash_var[8];   // one hash_var per possible line
        
        hash_var[] linetimes=new hash_var[8];   // max time for the respective line
        
        for(int move=0; move<9; move++)
        {
            // make move availability vars
            available[move]=new hash_var[9];
            for(int i=0; i<9; i++)
            {
                available[move][i]=new existential(2, prob, "available["+move+"]["+i+"]");
            }
            
            // make move variables
            if((move%2)==0)
            {
                moves[move]=new existential(9, prob, "move"+move);
            }
            else
            {
                moves[move]=new universal(9, prob, "move"+move);
                shadowmoves[move]=new existential(9, prob, "shadow"+move);
            }
        }
        
        // make board variables
        for(int pos=0; pos<9; pos++)
        {
            board[pos]=new existential(2, prob, "board"+pos);
            times[pos]=new existential(9, prob, "time"+pos);
        }
        
        xline=new existential(6, prob, "xline");
        oline=new existential(5, prob, "oline");        
        
        for(int line=0; line<8; line++)
        {
            lines[line]=new existential(3, prob, "lines"+line);
            linetimes[line]=new existential(9, prob, "linetimes"+line);
        }
        
        // add constraints
        
        for(int move=0; move<9; move++)
        {
            // channel move variable to board and times
            for(int pos=0; pos<9; pos++)
            {
                
                if((move%2)==0)
                {
                    // x goes first.
                    predicate_wrapper xc = new xchannelling_pred(pos, move);
                    hash_var[] gsvars = new hash_var[4];
                    gsvars[0]=available[move][pos];
                    gsvars[1]=moves[move];
                    gsvars[2]=board[pos];
                    gsvars[3]=times[pos];
                    cons_used_here cons= new cons_used_here(gsvars, prob, xc);
                }
                else
                {
                    // o goes second.
                    
                    // relate the move variable to the shadow move variable.
                    {predicate_wrapper dp = new designpattern_pred(pos);
                    hash_var[] gsvars = new hash_var[3];
                    gsvars[0]=available[move][pos];
                    gsvars[1]=moves[move];
                    gsvars[2]=shadowmoves[move];
                    
                    cons_used_here cons= new cons_used_here(gsvars, prob, dp);}
                    
                    // now relate the shadow to the board and time
                    predicate_wrapper oc = new ochannelling_pred(pos, move);
                    hash_var[] gsvars = new hash_var[3];
                    gsvars[0]=shadowmoves[move];
                    gsvars[1]=board[pos];
                    gsvars[2]=times[pos];
                    cons_used_here cons= new cons_used_here(gsvars, prob, oc);
                }
                
                if(move<8)
                {
                    // propagate the available variables forward.
                    predicate_wrapper av= new available_forward(pos);
                    hash_var[] gsvars = new hash_var[3];
                    gsvars[0]=available[move][pos];
                    if((move%2)==0)
                    { 
                        gsvars[1]=moves[move]; 
                    }
                    else 
                    {
                        gsvars[1]=shadowmoves[move];
                    }
                    
                    gsvars[2]=available[move+1][pos];
                    cons_used_here cons= new cons_used_here(gsvars, prob, av);
                }
            }
            
            if((move%2)==1)
            {
                // for each constraint move[1] is involved in, 
                // generate the puremonitor and the inverted constraint.
                // currently the only constraints move[1] is involved in are the design pattern ones.
                
                puremonitor[] available_monitor=new puremonitor[9];
                puremonitor[] moves_monitor=new puremonitor[9];
                puremonitor[] shadow_monitor=new puremonitor[9];
                
                for(int i=0; i<9; i++)
                {
                    available_monitor[i]=new puremonitor(2, prob, "av_monitor"+move+":"+i);
                    moves_monitor[i]=new puremonitor(9, prob, "moves_monitor:"+move+":"+i);
                    shadow_monitor[i]=new puremonitor(9, prob, "shadow_monitor:"+move+":"+i);
                    
                    designpattern_pred p1=new designpattern_pred(i);
                    negated_predicate p2=new negated_predicate(p1);
                    
                    hash_var[] gsvars = new hash_var[3];
                    gsvars[0]=available_monitor[i];
                    gsvars[1]=moves_monitor[i];
                    gsvars[2]=shadow_monitor[i];
                    warning_wrapper cons= new warning_wrapper(gsvars, prob, p2);
                    
                    hash_var [] temp={available[move][i], available_monitor[i]};
                    hash_var [] temp2={shadowmoves[move], shadow_monitor[i]};
                    
                    dummy_linkup d1=new dummy_linkup(temp, prob);
                    dummy_linkup d2=new dummy_linkup(temp2, prob);
                }
                
                hash_var [] allvars=new hash_var[moves_monitor.length+1];
                allvars[0]=moves[move];
                for(int i=1; i<allvars.length; i++)
                    allvars[i]=moves_monitor[i-1];
                
                linkup_pures linkup=new linkup_pures(allvars, prob);
            }
        }
        
        // horizontal lines
        
        for(int line=0; line<3; line++)
        {
            // line-detection constraints
            // lines and linetimes
            {predicate_wrapper ld = new linedetect_pred();
            
            hash_var[] gsvars = new hash_var[4];
            gsvars[0]=board[line*3];
            gsvars[1]=board[line*3+1];
            gsvars[2]=board[line*3+2];
            gsvars[3]=lines[line];
            
            cons_used_here cons= new cons_used_here(gsvars, prob, ld);}
            
            {predicate_wrapper lt = new threemax_pred();
            
            hash_var[] gsvars = new hash_var[4];
            gsvars[0]=times[line*3];
            gsvars[1]=times[line*3+1];
            gsvars[2]=times[line*3+2];
            gsvars[3]=linetimes[line];
            
            cons_used_here cons= new cons_used_here(gsvars, prob, lt);}
        }
        
        // vertical lines
        
        for(int line=3; line<6; line++)
        {
            // line-detection constraints
            // lines and linetimes
            {predicate_wrapper ld = new linedetect_pred();
            
            hash_var[] gsvars = new hash_var[4];
            gsvars[0]=board[line-3];
            gsvars[1]=board[line];
            gsvars[2]=board[line+3];
            gsvars[3]=lines[line];
            
            cons_used_here cons= new cons_used_here(gsvars, prob, ld);}
            
            {predicate_wrapper lt = new threemax_pred();
            
            hash_var[] gsvars = new hash_var[4];
            gsvars[0]=times[line-3];
            gsvars[1]=times[line];
            gsvars[2]=times[line+3];
            gsvars[3]=linetimes[line];
            
            cons_used_here cons= new cons_used_here(gsvars, prob, lt);}
        }
        
        // leading diagonal
        
        {predicate_wrapper ld = new linedetect_pred();
            
        hash_var[] gsvars = new hash_var[4];
        gsvars[0]=board[0];
        gsvars[1]=board[4];
        gsvars[2]=board[8];
        gsvars[3]=lines[6];

        cons_used_here cons= new cons_used_here(gsvars, prob, ld);}

        {predicate_wrapper lt = new threemax_pred();

        hash_var[] gsvars = new hash_var[4];
        gsvars[0]=times[0];
        gsvars[1]=times[4];
        gsvars[2]=times[8];
        gsvars[3]=linetimes[6];

        cons_used_here cons= new cons_used_here(gsvars, prob, lt);}
        
        // secondary diagonal
        
        {predicate_wrapper ld = new linedetect_pred();
            
        hash_var[] gsvars = new hash_var[4];
        gsvars[0]=board[2];
        gsvars[1]=board[4];
        gsvars[2]=board[6];
        gsvars[3]=lines[7];

        cons_used_here cons= new cons_used_here(gsvars, prob, ld);}

        {predicate_wrapper lt = new threemax_pred();

        hash_var[] gsvars = new hash_var[4];
        gsvars[0]=times[2];
        gsvars[1]=times[4];
        gsvars[2]=times[6];
        gsvars[3]=linetimes[7];

        cons_used_here cons= new cons_used_here(gsvars, prob, lt);}
        
        // aggregate the line pairs
        
        hash_var[] layer1lines = new hash_var[4];
        hash_var[] layer1linetimes = new hash_var[4];
        
        for(int i=0; i<4; i++)
        {
            layer1lines[i]=new existential(3, prob, "layer1lines["+i+"]");
            layer1linetimes[i]=new existential(9, prob, "layer1linetimes["+i+"]");
            
            {predicate_wrapper ag = new lines_aggregator();
            
            hash_var[] gsvars = new hash_var[6];
            gsvars[0]=lines[2*i];
            gsvars[1]=linetimes[2*i];
            gsvars[2]=lines[2*i+1];
            gsvars[3]=linetimes[2*i+1];
            gsvars[4]=layer1lines[i];
            gsvars[5]=layer1linetimes[i];
            
            cons_used_here cons= new cons_used_here(gsvars, prob, ag);}
        }
        
        // next layer
        
        hash_var[] layer2lines = new hash_var[2];
        hash_var[] layer2linetimes = new hash_var[2];
        
        for(int i=0; i<2; i++)
        {
            layer2lines[i]=new existential(3, prob, "layer2lines["+i+"]");
            layer2linetimes[i]=new existential(9, prob, "layer2linetimes["+i+"]");
            
            {predicate_wrapper ag = new lines_aggregator();
            
            hash_var[] gsvars = new hash_var[6];
            gsvars[0]=layer1lines[2*i];
            gsvars[1]=layer1linetimes[2*i];
            gsvars[2]=layer1lines[2*i+1];
            gsvars[3]=layer1linetimes[2*i+1];
            gsvars[4]=layer2lines[i];
            gsvars[5]=layer2linetimes[i];
            
            cons_used_here cons= new cons_used_here(gsvars, prob, ag);}
        }
        
        // final one
        
        hash_var finallines=new existential(3, prob, "finallines");
        hash_var finallinetimes=new existential(9, prob, "finallinetimes");
        
        {predicate_wrapper ag = new lines_aggregator();
        
        hash_var[] gsvars = new hash_var[6];
        gsvars[0]=layer2lines[0];
        gsvars[1]=layer2linetimes[0];
        gsvars[2]=layer2lines[1];
        gsvars[3]=layer2linetimes[1];
        gsvars[4]=finallines;
        gsvars[5]=finallinetimes;
        
        cons_used_here cons= new cons_used_here(gsvars, prob, ag);}
        
        
        
        // root node processing here.
        
        StopWatch sw= new StopWatch("GMT");
        sw.start();
        prob.establish();
        
        for(int i=0; i<9; i++) available[0][i].instantiate(1);
        
        finallines.instantiate(0);
        
        /*
        // symmetry breaking
        board[0][2].instantiate(2, null);
        board[0][3].instantiate(2, null);
        board[0][5].instantiate(2, null);
        board[0][6].instantiate(2, null);
        board[0][7].instantiate(2, null);
        board[0][8].instantiate(2, null);
        */
        
        prob.backtrack.add_backtrack_level();
        
        prob.propagate();
        
        sw.end();
        
        System.out.println("Setup time: "+sw.elapsedMillis());
        
        prob.printdomains();
        
        System.out.println(prob.blocks);
        
        //System.out.println(
        sw= new StopWatch("GMT");
        
        sw.start();
        System.out.println(prob.search());
        sw.end();
        System.out.println("Search time: "+sw.elapsedMillis()+" , Nodes:"+prob.numnodes);
        
        
        //System.out.println(cons);
    }
}

class xchannelling_pred extends predicate_wrapper
{
    final int pos;
    final int time;
    
    xchannelling_pred(int pos, int time)
    {
        this.pos=pos;
        this.time=time;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect available tau[0] move (tau[1]) to board [2] and time[3]
        
        // board places are   0=x 1=o 2=empty
        
        // x place is denoted by board[i]==0
        
        if(tau.vals[0]==0)
        {
            return tau.vals[1]!=pos; // if not available, prune the appropriate move value.
        }
        
        if(tau.vals[1]==pos)
        {
            // ==> tau.vals[2]==0 and tau.vals[3]==this time.
            return tau.vals[2]==0 && tau.vals[3]==time;
        }
        
        return true;
    }
}

class designpattern_pred extends predicate_wrapper
{
    final int pos;
    
    designpattern_pred(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect available tau[0], move (tau[1]) to shadow (tau[2])
        
        if(tau.vals[0]==1)
        {
            if(tau.vals[1]==pos)
                return tau.vals[2]==pos;
        }
        
        return true;
    }
}

class ochannelling_pred extends predicate_wrapper
{
    final int pos;
    final int time;
    
    ochannelling_pred(int pos, int time)
    {
        this.pos=pos;
        this.time=time;
    }
    
    public boolean predicate(tuple tau)
    {   // connect move (tau[0]) to board [1] and time[2]
        
        // board places are   0=x 1=o 2=empty
        
        // o place is denoted by board[i]==1
        
        if(tau.vals[0]==pos)
        {
            // tau.vals[1]==1 and tau.vals[2]==this time.
            return tau.vals[1]==1 && tau.vals[2]==time;
        }
        
        return true;
    }
}

class available_forward extends predicate_wrapper
{
    final int pos;
    
    available_forward(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {   // connect av (tau[0]) to (shadow)move [1] and new av[2]
        
        // board places are   0=x 1=o 2=empty
        // available=1 iff the place is available.
        
        // o place is denoted by board[i]==1
        
        if(tau.vals[0]==0)
        {
            return tau.vals[2]==0;
        }
        
        if(tau.vals[1]==pos)
        {
            return tau.vals[2]==0;
        }
        else
        {
            return tau.vals[2]==1;
        }
    }
}

class linedetect_pred extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // board1 tau[0], board2 tau[1], board3 tau[2]
        // line \in X, O, none  tau[3]
        
        if(tau.vals[0]==0 && tau.vals[1]==0 && tau.vals[2]==0)
        {
            return tau.vals[3]==0;
        }
        else if(tau.vals[0]==1 && tau.vals[1]==1 && tau.vals[2]==1)
        {
            return tau.vals[3]==1;
        }
        else
        {
            // neither
            return tau.vals[3]==2;
        }
    }
}

class threemax_pred extends predicate_wrapper
{
    // max(a,b,c)=d
    public boolean predicate(tuple tau)
    {
        // a tau[0], b tau[1], c tau[2]
        // max(a,b,c)=d= tau[4]
        
        int max=tau.vals[0];
        
        if(tau.vals[1]>max) max=tau.vals[1];
        
        if(tau.vals[2]>max) max=tau.vals[2];
        
        return tau.vals[3]==max;
    }
}

class lines_aggregator extends predicate_wrapper
{
    // takes two lines \in 0,1,2  and linetimes variables
    // and aggregates them into one lines and linetimes pair.
    
    // pair one: tau.vals[0] and tau.vals[1]
    // pair two: tau.vals[2] and tau.vals[3]
    
    // aggregated pair: tau.vals[4] and tau.vals[5]
    
    public boolean predicate(tuple tau)
    {
        // 
        // a tau[0], b tau[1], c tau[2]
        // max(a,b,c)=d= tau[4]
        
        if(tau.vals[0]!=2)
        {
            if(tau.vals[2]!=2)
            {
                // both contain valid lines
                if(tau.vals[1]<tau.vals[3])
                {
                    // first pair is earlier
                    return tau.vals[4]==tau.vals[0] && tau.vals[5]==tau.vals[1];
                }
                else
                {
                    // second pair is earlier
                    return tau.vals[4]==tau.vals[2] && tau.vals[5]==tau.vals[3];
                }
            }
            else
            {
                // first pair has a line, second pair doesn't
                return tau.vals[4]==tau.vals[0] && tau.vals[5]==tau.vals[1];
            }
        }
        else
        {
            // first pair does not contain a line, second pair might.
            return tau.vals[4]==tau.vals[2] && tau.vals[5]==tau.vals[3];
        }
    }
}
