// A constraint which implements the design pattern with probabilities for binary variables
import gnu.trove.*;
import java.util.*;
import gnu.math.*;

class conditional_implication_pred extends predicate_wrapper
{
    boolean predicate(tuple tau)
    {
        // connect active [0] to fault [1] and shadow [2]
        if(tau.vals[0]==0)
        {
            return tau.vals[2]==0;
        }
        
        assert tau.vals[0]==1;
        
        return tau.vals[1]==tau.vals[2];
    }
}



class rat_compare extends constraint implements make_ac
{
    // compares a rat_var with a constant and sets a boolean accordingly.
    
    rat_existential number;       // is the fault possible
    IntFraction threshold;      // If p_other x p < threshold then the fault cannot happen.
    
    int comparison_type;   // 1 for <=, 2 for ==, 3 for >=   the threshold.
    
    existential boolvar;        // true iff ratvar comp threshold is satisfied.
    rat_existential ratvar;     // 
    
    rat_compare(variable[] variables, qcsp problem, IntFraction threshold, int comparison)
    {
        super(variables, problem);
        
        this.threshold=threshold;
        this.comparison_type=comparison;
        
        // add to the appropriate wakeup lists
        assert variables.length==2;
        
        ((rat_existential) variables[0]).wakeups_upper.add(this);
        ((rat_existential) variables[0]).wakeups_lower.add(this);
        
        ((existential) variables[1]).wakeups[0].add(this);
        ((existential) variables[1]).wakeups[1].add(this);
        
        boolvar=((existential)variables[1]);
        ratvar=((rat_existential)variables[0]);
    }
    
    public int make_ac()
    {
        // since it is stateless, there is not much point in having the propagate methods.
        if(boolvar.is_present(0))
        {
            if(boolvar.is_present(1))
            {
                // look at the comparison 
                int comp=do_comparison();
                if(comp==1) // satisfied
                {
                    boolean flag=boolvar.exclude(0, this);
                    assert flag;
                    return 1; // true 
                }
                else if(comp==2)
                {
                    boolean flag=boolvar.exclude(1, this);
                    assert flag;
                    return 1;
                }
                else
                {
                    return 1; // nothing to be done
                }
            }
            else // boolvar is set false
            {
                int comp=do_comparison();
                // check the comparison is false, or make it false.
                
                if(comp==1)
                {
                    return 3; // false
                }
                else if(comp==2)
                {
                    return 1; // true
                }
                else
                {
                    // make the comparison false.
                    if(comparison_type==1)  // <=
                    {
                        // inverse is > but this is impossible to impose exactly, so the constraint must stay around.
                        boolean res=ratvar.exclude_lower(threshold, this);
                        assert res;
                        return 1;
                    }
                    else if(comparison_type==2) // ==
                    {
                        // inverse is =/= but this is impossible to impose so the constraint must stay around
                        return 1;
                    }
                    else
                    {
                        // >=
                        // inverse is < so impose <= and remain

                        boolean res=ratvar.exclude_upper(threshold, this);
                        assert res;
                        return 1;
                    }
                }
            }
        }
        else // boolvar is set true
        {
            if(!boolvar.is_present(1))
            {
                // boolvar is empty
                // why haven't we already failed at this point?
                return 3;
            }
            
            // make sure comparison is satisfied or fail.
            
            int comp=do_comparison();
            if(comp==1)
            {
                return 1; // true
            }
            else if(comp==2)
            {
                return 3; // false
            }
            else
            {
                // make the comparison true.
                if(comparison_type==1)  // <=
                {
                    // inverse is > but this is impossible to impose exactly, so the constraint must stay around.
                    boolean res=ratvar.exclude_upper(threshold, this);
                    assert res;
                    return 1;
                }
                else if(comparison_type==2) // ==
                {
                    // set the value
                    if(ratvar.upperbound.compare(threshold)==1)
                    {
                        boolean res=ratvar.exclude_upper(threshold, this);
                        assert res;
                    }
                    if(ratvar.lowerbound.compare(threshold)==-1)
                    {
                        boolean res=ratvar.exclude_lower(threshold, this);
                        assert res;
                    }
                    
                    return 1;
                }
                else
                {
                    // >=
                    
                    boolean res=ratvar.exclude_lower(threshold, this);
                    assert res;
                    return 1;
                }
            }
        }
    }
    
    private int do_comparison()
    {
        // performs the comparison, returning whether the
        // comparison is satisfied (1), unsatisfied(2), or not determined(3)
        int comp1=ratvar.upperbound.compare(threshold);
        int comp2=ratvar.lowerbound.compare(threshold);
        
        if(comparison_type==1)  // <=
        {
            if(comp1!=1) // upperbound <= threshold
            {
                // the comparison is definitely true
                return 1;
            }
            else if(comp2==1)  // lowerbound >= threshold
            {
                // the comparison is definitely false
                return 2;
            }
            else
            {
                // comparison indeterminate
                return 3;
            }
        }
        else if(comparison_type==2)  // ==
        {
            if(comp1==0 && comp2==0) // upperbound==threshold && lowerbound==threshold
            {
                // comparison satisfied
                return 1;
            }
            else if(comp1==-1 || comp2==1)  // upperbound<threshold or lowerbound>threshold
            {
                // the threshold is not included in the range
                return 2;
            }
            else
            {
                // threshold is within the range
                // nothing happens
                return 3;
            }
        }
        else  // >=
        { 
            assert comparison_type==3;
            if(comp2!=-1)  // lowerbound >=threshold
            {
                return 1;
            }
            else if(comp1==-1)  // upperbound<threshold
            {
                return 2;
            }
            else
            {
                // bounds include the threshold
                return 3;
            }
        }
    }
}

interface function_wrapper
{
    // arr is the whole list of bounds for this constraint, i.e. there is a null hidden in there.
    abstract IntFraction fcn(IntFraction [] arr);
}

class bc extends constraint
{
    // takes functions over class NumberType (probably IntFraction) and
    // uses them to perform bound consistency on a constraint of
    // arbitrary arity.
    
    // the functions below map 1-1 with the variables i.e. a function represents a variable in terms of the other variables.
    
    function_wrapper [] fcns;
    
    variable [] variables; 
    
    // obviously not thread-safe.
    
    IntFraction unionupper;
    IntFraction unionlower;
    boolean unionempty;
    
    void union(IntFraction upper1, IntFraction lower1, boolean empty1, IntFraction upper2, IntFraction lower2, boolean empty2)
    {
        if(empty1)
        {
            unionupper=upper2;
            unionlower=lower2;
            unionempty=empty2;
            return;
        }
        
        if(empty2)
        {
            unionupper=upper1;
            unionlower=lower1;
            unionempty=empty1;
            return;
        }
        
        if(upper1.compare(upper2)==1)
        {
            unionupper=upper1;
        }
        else
        {
            unionupper=upper2;
        }
        
        if(lower1.compare(lower2)==-1)
        {
            unionlower=lower1;
        }
        else
        {
            unionlower=lower2;
        }
        
        unionempty=false;
    }
    
    
    IntFraction interupper;
    IntFraction interlower;
    boolean interempty;
    
    void intersection(IntFraction upper1, IntFraction lower1, boolean empty1, IntFraction upper2, IntFraction lower2, boolean empty2)
    {
        // take the lowest upper bound and the highest lower bound
        if(empty1 || empty2)
        {
            interempty=true;
            return;
        }
        
        // both intervals are non-empty
        
        if(upper1.compare(upper2)==1)
        {
            // upper1>upper2
            interupper=upper2;
        }
        else
        {
            interupper=upper1;
        }
        
        if(lower1.compare(lower2)==-1)
        {
            // lower1<lower2
            interlower=lower2;
        }
        else
        {
            interlower=lower1;
        }
        
        // 
        interempty=(interupper.compare(interlower)==-1);
    }
    
    void updatebounds(int updatevar)
    {
        // updatevar is index into the variables array for this constraint.
        
    }
    
    IntFraction newupper;
    IntFraction newlower;
    IntFraction newempty;
    
    IntFraction [] function_input;
    
    void newbounds(int currentvar, int updatevar)
    {
        // recurse over the variables in quantifier order
        if(currentvar<variables.length)
        {
            if(currentvar==updatevar)
            {
                function_input[currentvar]=null;
                newbounds(currentvar+1, updatevar);
                return;
            }
            else if(currentvar<updatevar || !variables[currentvar].quant)
            {
                // take union of two recursive calls
                
                
                return;
            }
            else
            {
                // take intersection of two recursive calls
                
                
                return;
            }
        }
        else
        {
            // run the function and return the result.
            
        }
    }
}
