////////////////////////////////////////////////////////////////////////////////////
// Simple non-binary constraints for small domains
//

class table_constraint extends constraint implements make_ac
{
    int[][] tables;
    int[][] memotable;
    
    final mid_domain [] variables;
    
    table_constraint(mid_domain[] variables, qcsp problem)
    {
        super(problem);
        this.variables=variables;
        memotable = new int[variables.length][];
        
        for(int i=0; i<variables.length; i++)
        {
            memotable[i]=variables[i].hash;
        }
    }
    
    public boolean establish()
    {
        for(int i=0; i<variables.length; i++)
        {
            variables[i].add_wakeup(this);
        }
        return make_ac();
    }
    
    public boolean entailed()
    {
        for(int i=0; i<variables.length; i++)
        {
            if(!variables[i].unit())
                return false;
        }
        return true;
    }
    
    public boolean make_ac()
    {
        boolean globaliteratorflag=true;
        
        while(globaliteratorflag)
        {
            globaliteratorflag=false;
            // Find a non-checked var-val pair
            
            int var, val;
            // boolean found=false;
            
            // first find a variable
            for(var=0; var<memotable.length; var++)
            {
                //System.out.println("Searching variable "+variables[var].name);
                //printmemotable(memotable);
                
                int[] temparray;	        // declare an array of integers
                
                temparray=memotable[var];
                
                memotable[var] = new int[memotable[var].length];	// create an array of integers
                
                for(val=0; val<memotable[var].length; val++)
                {
                    memotable[var][val]=2;
                }
                
                for(val=0; val<memotable[var].length; val++)
                {
                    if (temparray[val]==0)
                    {
                        //printmemotable(memotable);
                        //System.out.println("Chosen var,val:"+variables[var].name+","+val);
                        memotable[var][val]=0;
                        
                        boolean result=table_constraint2(var+1);
                        
                        memotable[var][val]=2;
                        
                        if(result)
                        {
                            temparray[val]=1;
                        }
                        else
                        {
                            //System.out.println("Pruning var,val:"+variables[var].name+","+val);
                            if(!variables[var].exclude(val, this))
                            {
                                // fail
                                memotable[var]=temparray;
                                return 3;
                            }
                            if(temparray[val]==1)
                            {
                                // if var=val has been checked, then it may be used to support other
                                // values. Therefore it needs to be cleared and the whole procedure
                                // repeated.
                                globaliteratorflag=true;
                            }
                        }
                    }
                }
                
                memotable[var]=temparray;
            }
            // Scrub all the 1's here.
            for(var=0; var<memotable.length; var++)
                for(val=0; val<memotable[var].length; val++)
                    if(memotable[var][val]==1)
                        memotable[var][val]=0;

            if(globaliteratorflag)
            {
                //System.out.println("Restarting...:");
                //printmemotable(memotable);
            }
        }
        //System.out.println("All remaining values supported.");
        //printmemotable(memotable);
        
        return 1;  //succeed, keep constraint
    }

    private void printmemotable(int memotable[][])
    {
        int i,j;
        System.out.println("memotable:");

        for(i=0; i<memotable.length; i++)
        {
            System.out.println("Var:"+variables[i].name);
            for(j=0; j<memotable[i].length; j++)
                System.out.println(memotable[i][j]);
        }
        printeq();
    }
    
    private void printeq()
    {
        System.out.println("Printeq");
        for(int i=0; i<variables.length; i++)
        {
            System.out.print(memotable[i]==variables[i].hash);
        }
        System.out.println("");
    }
    
    private boolean table_constraint2(int currentvar)
    {
        // currentvar is 0,1,2... for indexing the arrays
        // memotable[var][val]= 0 for unchecked, 1 for checked, 2 for pruned
        // tables[var][index]= val
        // the returned integer is either index+1 for support, or 0 for no support.

        // base case

        if(currentvar==memotable.length)
        {
            // search for support through the tables using memotable

            boolean supporting=true;  //is i a supporting tuple?
            int i, var;
            for(i=0; i<tables[0].length; i++)
            {
                supporting=true;  
                
                for(var=0; var<memotable.length; var++)
                {
                    if(memotable[var][tables[var][i]]==2)
                    {
                        // if the value is pruned
                        supporting=false;
                        break;
                    }
                }

                if(supporting)
                    break;
            }
            // if supporting is true, i contains the relevant index
            if(supporting)
            {
                // mark all the appropriate memotable entries
                for(var=memotable.length-1; var>=0; var--)
                {   
                    if(variables[var].quant())  // only mark as far as the innermost universal. 
                        break;
                        // Should we not actually include the innermost universal??
                    memotable[var][tables[var][i]]=1;
                }

                return true;
            }
            else
            {
                return false;
            }
        }

        // recursive case

        if(variables[currentvar].quant())
        {
            // currentvar is universal so we need to branch.
            // branch for value 0  // replace with loop.
            // Temporarily set memotable[currentvar][1]=2 (pruned)
            
            boolean result=false; // WHY?? What if a universal domain is empty? 
            // If a u. domain is empty then the problem is true (false in dual)
            // so we would already have backtracked
            int[] temparray;  // declare an array of integers
            
            // instead of copying, swap the pointers
            temparray = memotable[currentvar];
            memotable[currentvar] = new int[memotable[currentvar].length];	// create an array of integers
            
            for(int val=0; val<memotable[currentvar].length; val++)
            {
                memotable[currentvar][val]=2;
            }
            
            for(int val=0; val<memotable[currentvar].length;  val++)
            {
                // branch for val
                if(temparray[val]<2)
                {
                    memotable[currentvar][val]=0;

                    //System.out.println("In recursive case.");
                    //printmemotable(memotable);

                    result=table_constraint2(currentvar+1);
                    if(result)
                    {
                        temparray[val]=1;   // mark as checked
                    }
                    else
                    {
                        memotable[currentvar]=temparray;
                        return false;
                    }
                    memotable[currentvar][val]=2;   // undo the change
                }
            }
            
            // swap back
            memotable[currentvar]=temparray;
            return true;
        }
        else
        {
            // currentvar is existential
            return table_constraint2(currentvar+1);
        }
    }
    
    String print()
    {
        String st="Table constraint:\n";
        for(int i=0; i<tables.length; i++)
        {
            System.out.println(variables[i].name()+":");
            for(int j=0; j<tables[i].length; j++)
            {
                st+=tables[i][j]+", ";
            }
            st+="\n";
        }
        return st;
    }
}


