import java.util.*;
import java.io.*;

class qdimacs
{
    public static void main(String[] args) throws FileNotFoundException, IOException
    {
        // First argument is a filename
        if(args.length>1)
        {
            System.out.println("Too many args");
        }
        
        // solve each arg
        for(int i=0; i<args.length; i++)
        {
            qdimacs newinstance=new qdimacs(args[i]);
            System.out.println(args[i]+":"+newinstance.search());
        }
    }
    
    qcsp prob;
    
    qdimacs(String filename) throws FileNotFoundException, IOException
    {
        //variable[] variables;
        //constraint[] constraints;
        // Can't handle comments in the file, unless they're C/C++ style.
        
        prob=new qcsp();
        
        File inputFile = new File(filename);
        FileReader infile = new FileReader(inputFile);
        BufferedReader in = new BufferedReader(infile);
        StreamTokenizer st = new StreamTokenizer(in);
        
        st.eolIsSignificant(false);
        
        comptoken(st, "p");
        comptoken(st, "cnf");
        
        int numvars=getnumber(st);
        int numclauses=getnumber(st);
        
        System.out.println("p cnf "+numvars+" "+numclauses);
        
        hash_var [] variables=new hash_var[numvars];
        
        int currentvar=0;
        
        // some loop
        String quant=gettoken(st);
        
        while(quant.equals("e") || quant.equals("a"))
        {
            if (quant.equals("e"))
            {
                while(true)
                {
                    String name=gettoken(st);
                    if(!name.equals("0"))
                    {
                        System.out.print(name+",");
                        variables[currentvar]=new existential(2, prob, name);
                        prob.addvar(variables[currentvar]);
                        currentvar++;
                    }
                    else
                        break;
                }
            }
            else
            {
                while(true)
                {
                    String name=gettoken(st);
                    if(!name.equals("0"))
                    {
                        System.out.print(name+",");
                        variables[currentvar]=new universal(2, prob, name);
                        prob.addvar(variables[currentvar]);
                        currentvar++;
                    }
                    else
                        break;
                }
            }
            
            quant=gettoken(st);
        }
        System.out.println();
        
        for(int i=0; i<numvars; i++)
        {
            System.out.print(variables[i]+" ");
        }
        System.out.println();
        
        assert currentvar==numvars;
        
        // all being well, quant now contains the first literal of the first clause
        
        int literal=Integer.parseInt(quant);
        
        int [][] clauses= new int[numclauses][];
        int [] tempclause=new int[10000];
        
        for(int i=0; i<numclauses; i++)
        {
            int literals=0;
            while(literal!=0)
            {
                //System.out.print(literal+" ");
                tempclause[literals]=literal;
                literals++;
                literal=getnumber(st);
            }
            int [] clause= new int[literals];
            //System.out.println();
            System.arraycopy(tempclause, 0, clause, 0, literals);
            clauses[i]=clause;
            if( i<numclauses-1)
                literal=getnumber(st);
        }
        
        for(int i=0; i<clauses.length; i++)
        {
            for(int j=0; j<clauses[i].length; j++)
            {
                System.out.print(clauses[i][j]+", ");
            }
            System.out.println();
        }
        
        // constraint-dependent part
        
        gac_schema [] constraints= new gac_schema[numclauses];
        
        for(int i=0; i<clauses.length; i++)
        {
            // assumes the clause is not tautologous and contains no repeats
            // Also assumes the clause is sorted in quantification order.
            // And that the names of variables -1 is their index in variables
            // In other words, run it through compactor.py first.
            
            int[] thisclause=clauses[i];
            
            /*int[][][][] tables=new int[thisclause.length][][][];
            
            for(int j=0; j<thisclause.length; j++)
                tables[j]=new int[2][][];
            
            // the name -1 is the index in variables
            int[][] goods=new int[pow(2, thisclause.length) - 1][];
            
            if(thisclause.length==1)
            {
                //special case: unit clause
                if(thisclause[0]<0)
                {
                    //the only good is negative
                    int [][] goods1={{0}};
                    goods=goods1;
                }
                else
                {
                    //the only good is positive
                    int [][] goods1={{1}};
                    goods=goods1;
                }
            }
            else
            {
                int counter=0;
                int[] prevgood=new int[thisclause.length];
                
                for(int j=0; j<thisclause.length; j++)
                {
                    System.out.print(thisclause[j]+" ");
                    prevgood[j]=0;
                }
                System.out.println();
                                
                for(int j=1; j<pow(2,thisclause.length); j++)
                {
                    boolean ok=false;  // is it OK to include prevgood
                    
                    for(int k=0; k<thisclause.length; k++)
                    {
                        // if it matches one literal
                        if((prevgood[k]==0 && thisclause[k]<0) || (prevgood[k]==1 && thisclause[k]>0))
                        {
                            ok=true;
                            break;
                        }
                    }
                    
                    if(ok)
                    {
                        goods[counter]=prevgood;
                        counter++;
                        System.out.println("Adding good:");
                        for(int l=0; l<thisclause.length; l++)
                            System.out.print(prevgood[l]);
                        System.out.println();
                    }
                    
                    int[] good=new int[thisclause.length];
                    System.arraycopy(prevgood, 0, good, 0, thisclause.length);
                    
                    // add one in binary to good
                    
                    good[thisclause.length-1]++;
                    
                    for(int k=thisclause.length-1; k>=0; k--)
                    {
                        if(good[k]==2)
                        {
                            good[k-1]++;
                            good[k]=0;
                        }
                    }
                    
                    prevgood=good;
                }
                
                boolean ok=false;  // is it OK to include prevgood
                for(int k=0; k<thisclause.length; k++)
                {
                    if((prevgood[k]==0 && thisclause[k]<0) || (prevgood[k]==1 && thisclause[k]>0))
                    {
                        ok=true;
                        break;
                    }
                }
                
                if(ok)
                {
                    goods[counter]=prevgood;
                    counter++;
                    System.out.println("Adding good:");
                    for(int l=0; l<thisclause.length; l++)
                        System.out.print(prevgood[l]);
                    System.out.println();
                }
                
                assert counter==pow(2, thisclause.length)-1;
            } */
            
            if(thisclause.length>1)
            {
                // construct variable list and nogood
                mid_domain [] cvars=new mid_domain[thisclause.length];
                int [] nogood=new int[thisclause.length];

                for(int j=0; j<thisclause.length; j++)
                {
                    cvars[j]=variables[Math.abs(thisclause[j])-1];
                    System.out.print(cvars[j]+" ");

                    nogood[j]= (thisclause[j]>0)?0:1;
                }
                System.out.println();

                predicate_wrapper p1=new clause_predicate(nogood);

                constraints[i]=new gac_schema_predicate(cvars, prob, p1);
            }
            else
            {
                // unit clause
                System.out.println("Unit clause: "+thisclause[0]);
                variables[Math.abs(thisclause[0])-1].exclude((thisclause[0]>0)?0:1, null);
            }
        }
        
        prob.printdomains();
        
        boolean result=prob.establish();
        if(!result)
            System.out.println("Problem false.");
        
        prob.printdomains();
    }
    
    private boolean search()
    {
        prob.backtrack.add_backtrack_level();
        prob.printdomains();
        
        return prob.search();
    }
    
    private int pow(int a, int b)
    {
        return (int) Math.pow(a, b);
        // a^b
        /*assert a>0 && b>0;
        int total=1;
        for(int i=0; i<b; i++)
        {
            total*=a;
        }
        return total;*/
    }
    
    
    private void comptoken(StreamTokenizer st, String tok) throws IOException
    {
        if(gettoken(st).compareToIgnoreCase(tok)!=0)
        {
            System.out.println(tok+" not found.");
            throw new IOException("comptoken");
        }
    }
    
    private void getopenbracket(StreamTokenizer st) throws IOException
    {
        st.nextToken();
        if(st.ttype!=40)
        {
            System.out.println("Error in getopenbracket");
            throw new IOException("missing open bracket");
        }
    }
    
    private void getclosebracket(StreamTokenizer st) throws IOException
    {
        st.nextToken();
        if(st.ttype!=41)
        {
            System.out.println("Error in getclosebracket");
            throw new IOException("missing closing bracket");
        }
    }
    
    private String gettoken(StreamTokenizer st) throws IOException
    {
        st.nextToken();
        
        if(st.ttype == st.TT_NUMBER)
        {
            return Integer.toString( (int) st.nval);
        }
        else if(st.ttype == st.TT_WORD)
        {
            return st.sval;
        }
        else
        {
            System.out.println("Error in gettoken");
            System.out.println(st.sval);
            System.out.println(st.nval);
            System.out.println(st.ttype);
            System.out.println(st.TT_EOL);
            throw new IOException("gettoken");
        }
    }
    
    private int getnumber(StreamTokenizer st) throws IOException
    {
        st.nextToken();
        if(st.ttype!=st.TT_NUMBER)
        {
            System.out.println("Error in getnumber");
            throw new IOException("getnumber");
        }
        return (int)st.nval;
    }
    
    class clause_predicate extends predicate_wrapper
    {
        int [] nogood;
        
        clause_predicate(int [] nogoodin)
        {
            nogood=nogoodin;
        }
        
        boolean predicate(tuple tau)
        {
            assert nogood.length==tau.vals.length;
            
            for(int i=0; i<nogood.length; i++)
            {
                if(nogood[i]!=tau.vals[i])
                    return true;
            }
            
            return false;
        }
    }
}


