//import java.util.*;
package queso.testing;

import gnu.trove.*;
import java.io.*;

import queso.core.*;
import queso.constraints.*;

public class bandb_test
{
    public static void main(String[] args)
    {
        mid_domain[] variables = new mid_domain[4];
        constraint[] constraints = new constraint[1];
        
        qcsp prob = new qcsp();
        
        variables[0]=new existential(6, prob, "a");
        variables[1]=new universal(2, prob, "b");
        variables[2]=new existential(3, prob, "c");
        variables[3]=new existential(6, prob, "opt");
        
        
        testbandb_pred temp= new testbandb_pred();
        mid_domain [] gsvars= {variables[0], variables[1], variables[2]};
        
        gac_schema_predicate c1= new gac_schema_predicate(gsvars, prob, temp);
        
        equals_pred temp2= new equals_pred();
        mid_domain[] gsvars2={variables[0], variables[3]};
        
        gac_schema_predicate c2= new gac_schema_predicate(gsvars2, prob, temp2);
        
        prob.establish();
        
        System.out.println(prob.bandb(variables[3], false, false, false));
        
        try
        {
        File output = new File("bandb_test.dot");
        
        FileWriter out = new FileWriter(output);
        
        out.write(prob.printtree());
        
        out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing bandb_test.dot");
        }
    }
}

class testbandb_pred extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        return tau.vals[0]+tau.vals[1]+tau.vals[2] >= 6;
    }
}

class equals_pred extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        return tau.vals[0]==tau.vals[1];
    }
}
