//import java.util.*;
package queso.testing;

import gnu.trove.*;
import java.io.*;

import queso.core.*;
import queso.constraints.*;

public class bandb_test2
{
    public static void main(String[] args)
    {
        mid_domain[] variables = new mid_domain[6];
        
        qcsp prob = new qcsp();
        
        variables[0]=new existential(3, prob, "a");
        variables[1]=new universal(3, prob, "b");
        variables[2]=new existential(3, prob, "c");
        variables[3]=new universal(3, prob, "d");
        variables[4]=new existential(3, prob, "e");
        
        variables[5]=new existential(20, prob, "opt");
        
        testbandb_pred2 temp= new testbandb_pred2();
        mid_domain [] gsvars= {variables[0], variables[1], variables[2], variables[3], variables[4], variables[5]};
        
        gac_schema_predicate c1= new gac_schema_predicate(gsvars, prob, temp);
        
        equals_pred temp2= new equals_pred();
        mid_domain[] gsvars2={variables[3], variables[4]};
        
        gac_schema_predicate c2= new gac_schema_predicate(gsvars2, prob, temp2);
        
        prob.establish();
        
        System.out.println(prob.bandb(variables[5], false, false, false));
        
        try
        {
        File output = new File("bandb_test2.dot");
        
        FileWriter out = new FileWriter(output);
        
        out.write(prob.printtree());
        
        out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing bandb_test2.dot");
        }
    }
}

class testbandb_pred2 extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        return (tau.vals[1]+tau.vals[2]+tau.vals[3]+tau.vals[4]-tau.vals[0]+2) == tau.vals[5];
    }
}
