/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import savilerow.CmdFlags;
import savilerow.SatNull;
import savilerow.TabulationUtils;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Equals;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.LessEqual;
import savilerow.expression.MakeTable;
import savilerow.expression.Mapping;
import savilerow.expression.Maximising;
import savilerow.expression.Minimising;
import savilerow.expression.NegativeTable;
import savilerow.expression.NumberConstant;
import savilerow.expression.Table;
import savilerow.expression.TableShort;
import savilerow.expression.Tag;
import savilerow.expression.ToVariable;
import savilerow.expression.Top;
import savilerow.model.Model;
import savilerow.model.ModelContainer;
import savilerow.model.SymbolTable;
import savilerow.model.categoryentry;
import savilerow.solver.MinionSolver;
import savilerow.treetransformer.TransformCollectSATDirect;
import savilerow.treetransformer.TransformFixSTRef;
import savilerow.treetransformer.TransformNormalise;
import savilerow.treetransformer.TransformProductToMult;
import savilerow.treetransformer.TransformRemoveMappers;
import savilerow.treetransformer.TransformSATEncoding;
import savilerow.treetransformer.TransformSafeElementOne;
import savilerow.treetransformer.TransformSumEq;
import savilerow.treetransformer.TransformSumToShift;
import savilerow.treetransformer.TransformToFlatGecode;
import savilerow.treetransformer.TreeTransformer;

public class Tabulation {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    private Model m;
    private TabulationUtils tu;
    private long nodelimit;
    ASTNode optVar;
    ASTNode optCt = null;
    HashMap<ASTNode, ArrayList<ASTNode>> idToCons = new HashMap();

    public Tabulation(Model model) {
        this.m = model;
        this.tu = new TabulationUtils(this.m);
        this.nodelimit = CmdFlags.tabulate_nolimit ? Long.MAX_VALUE : 100000L;
    }

    public void process(boolean bl) {
        this.processMakeTable(this.m.constraints);
        if (!bl) {
            this.collectIdentifiers(this.m.constraints);
            if (CmdFlags.make_short_tab == 3 || CmdFlags.make_short_tab == 4) {
                CmdFlags.warning("-tabulate flag is deprecated and will be removed in a future release. Use -tabid or -tabid-light.");
                HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap = this.buildScopesList(this.m.constraints);
                this.identicalScopes(this.m.constraints, hashMap);
                this.applyHeuristicsBool(this.m.constraints);
            }
            if (CmdFlags.tabid) {
                double d = System.currentTimeMillis();
                int n = CmdFlags.make_short_tab;
                CmdFlags.make_short_tab = 1;
                HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap = this.buildScopesList(this.m.constraints);
                this.identicalScopes(this.m.constraints, hashMap);
                this.applyHeuristicsBool2(this.m.constraints, hashMap);
                this.applyHeuristicsNumerical2(this.m.constraints, hashMap);
                CmdFlags.make_short_tab = n;
                CmdFlags.tabtime = ((double)System.currentTimeMillis() - d) / 1000.0;
            }
            if (this.m.objective != null) {
                this.tightenObjectiveVar();
            }
        }
    }

    private void processMakeTable(ASTNode aSTNode) {
        block5: {
            block6: {
                block4: {
                    if (!(aSTNode instanceof MakeTable)) break block4;
                    if (CmdFlags.make_short_tab == 0) {
                        ASTNode aSTNode2 = aSTNode.getParent();
                        int n = aSTNode.getChildNo();
                        aSTNode.getChild(0).setParent(null);
                        aSTNode2.setChild(n, aSTNode.getChild(0));
                        this.processMakeTable(aSTNode2.getChild(n));
                    } else {
                        ASTNode aSTNode3 = this.tabulate(aSTNode.getChild(0), Long.MAX_VALUE, CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4, "MakeTableFunction");
                        aSTNode.getParent().setChild(aSTNode.getChildNo(), aSTNode3);
                    }
                    break block5;
                }
                if (!(aSTNode instanceof Table)) break block6;
                int n = aSTNode.getChild(0).numChildren() - 1;
                ASTNode aSTNode4 = aSTNode.getChildConst(1);
                if (aSTNode4.numChildren() <= 1) break block5;
                if (aSTNode4.getChild(1).getTupleLength() != n) {
                    CmdFlags.errorExit("Table scope size does not match length of tuples.\n" + String.valueOf(aSTNode));
                }
                if (aSTNode4.isRegularMatrix()) break block5;
                CmdFlags.errorExit("Table constraint contains irregular matrix (i.e. length of tuples differs).\n" + String.valueOf(aSTNode));
                break block5;
            }
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.processMakeTable(aSTNode.getChild(i));
            }
        }
    }

    private void identicalScopes(ASTNode aSTNode, HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap) {
        for (Map.Entry<ArrayList<ASTNode>, ArrayList<ASTNode>> entry : hashMap.entrySet()) {
            And and;
            ASTNode aSTNode2;
            ArrayList<ASTNode> arrayList = entry.getValue();
            if (arrayList.size() <= 1 || (aSTNode2 = this.tabulate(and = new And(arrayList), this.nodelimit, CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4, "IdenticalScopes", true)) == null) continue;
            this.replaceConstraintSet(arrayList, aSTNode2);
            arrayList.clear();
            arrayList.add(aSTNode2);
        }
    }

    private HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> buildScopesList(ASTNode aSTNode) {
        HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap = new HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>>();
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                if (aSTNode3 instanceof Table || aSTNode3 instanceof TableShort || aSTNode3 instanceof NegativeTable || aSTNode3 instanceof Tag) continue;
                assert (aSTNode3.isRelation());
                ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode3);
                ASTNode.sortByAlpha(arrayList);
                if (!hashMap.containsKey(arrayList)) {
                    hashMap.put(arrayList, new ArrayList());
                }
                hashMap.get(arrayList).add(aSTNode3);
            }
        }
        return hashMap;
    }

    private void replaceConstraintSet(ArrayList<ASTNode> arrayList, ASTNode aSTNode) {
        ASTNode aSTNode2 = arrayList.get(0);
        aSTNode2.getParent().setChild(aSTNode2.getChildNo(), aSTNode);
        for (int i = 1; i < arrayList.size(); ++i) {
            aSTNode2 = arrayList.get(i);
            aSTNode2.getParent().setChild(aSTNode2.getChildNo(), new BooleanConstant(true));
        }
    }

    private void applyHeuristicsBool(ASTNode aSTNode) {
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3;
                String string;
                ASTNode aSTNode4 = aSTNode2.getChild(i);
                if (aSTNode4 instanceof And || !aSTNode4.isRelation() || aSTNode4 instanceof Table || aSTNode4 instanceof TableShort || aSTNode4 instanceof NegativeTable || aSTNode4 instanceof BooleanConstant) continue;
                String string2 = string = CmdFlags.tab_diag_2 ? this.heurAll(aSTNode4) : this.heuristic(aSTNode4);
                if (string == null || (aSTNode3 = this.tabulate(aSTNode4, this.nodelimit, CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4, string, true)) == null) continue;
                aSTNode2.setChild(i, aSTNode3);
            }
        }
    }

    private void applyHeuristicsBool2(ASTNode aSTNode, HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap) {
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            ArrayDeque<ASTNode> arrayDeque = new ArrayDeque<ASTNode>(aSTNode2.getChildren());
            while (!arrayDeque.isEmpty()) {
                Object object;
                ASTNode aSTNode3 = arrayDeque.poll();
                if (!(!aSTNode3.isRelation() || aSTNode3.getDimension() != 0 || aSTNode3 instanceof Table || aSTNode3 instanceof TableShort || aSTNode3 instanceof NegativeTable || aSTNode3 instanceof BooleanConstant || aSTNode3.getParent().inTopAnd())) {
                    And and;
                    object = TabulationUtils.getVariablesOrdered(aSTNode3);
                    ASTNode.sortByAlpha(object);
                    if (hashMap.containsKey(object) && (hashMap.get(object).size() > 1 || !this.contains(hashMap.get(object).get(0), aSTNode3)) && this.applyHeuristicsBool2Attempt(aSTNode3, and = new And(hashMap.get(object)), "IdenticalScopesNested")) continue;
                }
                if (!(!aSTNode3.isRelation() || aSTNode3.getDimension() != 0 || aSTNode3 instanceof Table || aSTNode3 instanceof TableShort || aSTNode3 instanceof NegativeTable || aSTNode3 instanceof BooleanConstant)) {
                    Object object2 = object = CmdFlags.tab_diag_2 ? this.heurAll(aSTNode3) : this.heuristic(aSTNode3);
                    if (object != null && this.applyHeuristicsBool2Attempt(aSTNode3, null, (String)(aSTNode3.getParent().inTopAnd() ? object : (String)object + "(Nested)"))) continue;
                }
                arrayDeque.addAll(aSTNode3.getChildren());
            }
        }
    }

    private boolean checkSizeNestedTable(ASTNode aSTNode) {
        if (!(CmdFlags.getMiniontrans() || CmdFlags.getGecodetrans() || CmdFlags.getSattrans() || aSTNode.getParent().inTopAnd())) {
            ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode);
            double d = 1.0;
            for (int i = 0; i < arrayList.size(); ++i) {
                d *= (double)Intpair.numValues(arrayList.get(i).getIntervalSetExp());
            }
            if (d > (double)this.nodelimit) {
                return false;
            }
        }
        return true;
    }

    private boolean applyHeuristicsBool2Attempt(ASTNode aSTNode, ASTNode aSTNode2, String string) {
        ASTNode aSTNode3;
        if (!this.checkSizeNestedTable(aSTNode)) {
            return false;
        }
        ASTNode aSTNode4 = aSTNode.copy();
        if (aSTNode2 != null) {
            aSTNode4 = new And(aSTNode2.copy(), aSTNode4);
        }
        if ((aSTNode3 = this.tabulate(aSTNode4, this.nodelimit, false, string, aSTNode.getParent().inTopAnd())) != null) {
            aSTNode.getParent().setChild(aSTNode.getChildNo(), aSTNode3);
            return true;
        }
        return false;
    }

    private void applyHeuristicsNumerical2(ASTNode aSTNode, HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        HashMap<ASTNode, Identifier> hashMap2 = new HashMap<ASTNode, Identifier>();
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                ArrayDeque<ASTNode> arrayDeque = new ArrayDeque<ASTNode>(aSTNode3.getChildren());
                while (!arrayDeque.isEmpty()) {
                    ASTNode aSTNode4 = arrayDeque.poll();
                    ASTNode aSTNode5 = aSTNode4.getParent();
                    if (!(!aSTNode4.isNumerical() || aSTNode4 instanceof Identifier || aSTNode4 instanceof NumberConstant || aSTNode4 instanceof Mapping || aSTNode4.getDimension() != 0 || !aSTNode4.toFlatten(false) || aSTNode5 instanceof ToVariable || aSTNode5 instanceof Equals)) {
                        String string;
                        ASTNode aSTNode6;
                        String string2;
                        ASTNode aSTNode7;
                        ASTNode aSTNode8;
                        if (hashMap2.containsKey(aSTNode4)) {
                            aSTNode4.getParent().setChild(aSTNode4.getChildNo(), (ASTNode)hashMap2.get(aSTNode4));
                            continue;
                        }
                        ArrayList<Intpair> arrayList2 = aSTNode4.getIntervalSetExp();
                        ASTNode aSTNode9 = Intpair.makeDomain(arrayList2, aSTNode4.isRelation());
                        aSTNode9 = this.m.filt.constructDomain(aSTNode4, aSTNode9);
                        Identifier identifier = this.m.global_symbols.newAuxiliaryVariable(aSTNode9);
                        Equals equals = new Equals(aSTNode4.copy(), identifier);
                        ArrayList<ASTNode> arrayList3 = TabulationUtils.getVariablesOrdered(aSTNode4);
                        ASTNode.sortByAlpha(arrayList3);
                        if (hashMap.containsKey(arrayList3) && (hashMap.get(arrayList3).size() > 1 || !this.contains(hashMap.get(arrayList3).get(0), aSTNode4)) && (aSTNode8 = this.tabulate(new And((ASTNode)equals, aSTNode7 = new And(hashMap.get(arrayList3))), this.nodelimit, false, "IdenticalScopes(Integer)", false)) != null) {
                            arrayList.add(aSTNode8);
                            aSTNode4.getParent().setChild(aSTNode4.getChildNo(), identifier);
                            hashMap2.put(aSTNode4, identifier);
                            continue;
                        }
                        aSTNode7 = aSTNode4.getParent();
                        aSTNode7.setChild(aSTNode4.getChildNo(), identifier);
                        boolean bl = aSTNode3.strongProp();
                        aSTNode4.setParent(null);
                        aSTNode7.setChild(aSTNode4.getChildNo(), aSTNode4);
                        boolean bl2 = bl && !((ASTNode)equals).strongProp();
                        String string3 = string2 = CmdFlags.tab_diag_2 ? this.heurAll(equals) : this.heuristic(equals);
                        if ((bl2 || string2 != null) && (aSTNode6 = this.tabulate(equals, this.nodelimit, false, string = bl2 ? (String)(string2 == null ? "" : string2 + ",") + "WeakPropagation1(Integer)" : string2 + "(Integer)", false)) != null) {
                            arrayList.add(aSTNode6);
                            aSTNode4.getParent().setChild(aSTNode4.getChildNo(), identifier);
                            hashMap2.put(aSTNode4, identifier);
                            continue;
                        }
                        this.m.global_symbols.deleteSymbol(((ASTNode)identifier).toString());
                        assert (((ASTNode)identifier).toString().equals("aux" + String.valueOf(this.m.global_symbols.auxvarcounter - 1)));
                        --this.m.global_symbols.auxvarcounter;
                    }
                    arrayDeque.addAll(aSTNode4.getChildren());
                }
            }
            if (arrayList.size() > 0) {
                aSTNode.getChild(0).setParent(null);
                aSTNode.setChild(0, new And(aSTNode.getChild(0), new And(arrayList)));
            }
        }
    }

    void findOptCt(ASTNode aSTNode) {
        if (aSTNode.equals(this.optVar)) {
            ASTNode aSTNode2 = aSTNode.getParent();
            while (!aSTNode2.isRelation()) {
                aSTNode2 = aSTNode2.getParent();
            }
            this.optCt = aSTNode2;
            return;
        }
        for (int i = 0; i < aSTNode.numChildren() && this.optCt == null; ++i) {
            this.findOptCt(aSTNode.getChild(i));
        }
    }

    void collectIdentifiers(ASTNode aSTNode) {
        if (aSTNode instanceof Identifier) {
            ASTNode aSTNode2 = aSTNode.getParent();
            while (!aSTNode2.isRelation() || aSTNode2.getDimension() != 0) {
                aSTNode2 = aSTNode2.getParent();
            }
            if (!this.idToCons.containsKey(aSTNode)) {
                this.idToCons.put(aSTNode, new ArrayList());
            }
            this.idToCons.get(aSTNode).add(aSTNode2);
        } else {
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.collectIdentifiers(aSTNode.getChild(i));
            }
        }
    }

    void tightenObjectiveVar() {
        long l;
        if (this.m.objective instanceof Minimising && this.optCt instanceof LessEqual && this.optCt.getChild(1).equals(this.optVar)) {
            long l2 = this.optCt.getChild((int)0).getBounds().upper;
            if (l2 < this.optVar.getBounds().upper) {
                ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
                arrayList.add(new Intpair(Long.MIN_VALUE, l2));
                this.m.global_symbols.setDomain(this.optVar.toString(), Intpair.makeDomain(Intpair.intersection(this.optVar.getIntervalSetExp(), arrayList), this.optVar.isRelation()));
            }
        } else if (this.m.objective instanceof Maximising && this.optCt instanceof LessEqual && this.optCt.getChild(0).equals(this.optVar) && (l = this.optCt.getChild((int)1).getBounds().lower) > this.optVar.getBounds().lower) {
            ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
            arrayList.add(new Intpair(l, Long.MAX_VALUE));
            this.m.global_symbols.setDomain(this.optVar.toString(), Intpair.makeDomain(Intpair.intersection(this.optVar.getIntervalSetExp(), arrayList), this.optVar.isRelation()));
        }
    }

    private String heuristic(ASTNode aSTNode) {
        ASTNode aSTNode2;
        ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode);
        ArrayList<ASTNode> arrayList2 = TabulationUtils.getVariablesDup(aSTNode);
        if (arrayList.size() < arrayList2.size()) {
            return "DuplicateVariables";
        }
        if (aSTNode.treesize() > 5 * arrayList.size()) {
            return "LargeAST";
        }
        if (!aSTNode.strongProp() && (aSTNode2 = this.m.constraints.getChild(0)) instanceof And) {
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                if (!aSTNode3.strongProp()) continue;
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (!aSTNode3.contains(arrayList.get(j))) continue;
                    return "WeakPropagation";
                }
            }
        }
        return null;
    }

    private String heurAll(ASTNode aSTNode) {
        assert (CmdFlags.tab_diag_2);
        ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode);
        ArrayList<ASTNode> arrayList2 = TabulationUtils.getVariablesDup(aSTNode);
        Object object = "";
        if (arrayList.size() < arrayList2.size()) {
            object = (String)object + "DuplicateVariables,";
        }
        if (aSTNode.treesize() > 5 * arrayList.size()) {
            object = (String)object + "LargeAST,";
        }
        if (!aSTNode.strongProp()) {
            boolean bl = false;
            ASTNode aSTNode2 = this.m.constraints.getChild(0);
            if (aSTNode2 instanceof And) {
                for (int i = 0; i < aSTNode2.numChildren() && !bl; ++i) {
                    ASTNode aSTNode3 = aSTNode2.getChild(i);
                    if (!aSTNode3.strongProp()) continue;
                    for (int j = 0; j < arrayList.size() && !bl; ++j) {
                        if (!aSTNode3.contains(arrayList.get(j))) continue;
                        object = (String)object + "WeakPropagation";
                        bl = true;
                    }
                }
            }
        }
        return ((String)object).equals("") ? null : object;
    }

    public boolean contains(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == aSTNode2) {
            return true;
        }
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            if (!this.contains(aSTNode.getChild(i), aSTNode2)) continue;
            return true;
        }
        return false;
    }

    public ASTNode tabulate(ASTNode aSTNode, long l, boolean bl, String string) {
        return this.tabulate(aSTNode, l, bl, string, true);
    }

    public ASTNode tabulate(ASTNode aSTNode, long l, boolean bl, String string, boolean bl2) {
        ASTNode aSTNode2;
        long l2;
        ASTNode aSTNode3 = this.tu.normalise(aSTNode);
        ASTNode aSTNode4 = aSTNode3.copy();
        if (CmdFlags.tabulate_diagnostics) {
            CmdFlags.println(ANSI_RED + string + "\u001b[0m   Attempting tabulation: " + String.valueOf(aSTNode3));
        }
        TabulationUtils.RetPair retPair = this.tu.tryCacheNormalised(aSTNode, bl);
        if (retPair.nodereplace != null) {
            if (CmdFlags.tabulate_diagnostics) {
                CmdFlags.println("\u001b[32mTabulated\u001b[0m by retrieving from cache.");
            }
            return retPair.nodereplace.current_node;
        }
        if (this.tu.tryFailCache(retPair.expstring)) {
            if (CmdFlags.tabulate_diagnostics) {
                CmdFlags.println(ANSI_RED + string + "\u001b[0m   Not tabulated, found in fail cache.");
            }
            return null;
        }
        ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode3);
        int n = arrayList.size();
        if (CmdFlags.tabid_light && n > 2 && (CmdFlags.getChuffedtrans() || CmdFlags.getOrtoolstrans() || CmdFlags.getSattrans())) {
            if (CmdFlags.tabulate_diagnostics) {
                CmdFlags.println(ANSI_RED + string + "\u001b[0m   Not tabulated, arity>2 and -tabid-light version with CDCL solver.");
            }
            return null;
        }
        if (n > 20) {
            if (CmdFlags.tabulate_diagnostics) {
                CmdFlags.println(ANSI_RED + string + "\u001b[0m   Not tabulated, arity>20.");
            }
            return null;
        }
        long l3 = 1000000000L;
        long l4 = 1000000000L;
        if (CmdFlags.tab_satsizelimit) {
            double d = 2.0;
            long l5 = 1000000000L;
            l2 = 0L;
            for (int i = 0; i < arrayList.size(); ++i) {
                l2 += Intpair.numValues(arrayList.get(i).getIntervalSetExp());
            }
            if (bl2) {
                if (n > 2) {
                    if (!CmdFlags.sat_table_mdd) {
                        l5 = (long)Math.ceil((double)(l2 + l * (long)n + 1L) / d) + 1L;
                    }
                } else if (n == 2) {
                    l5 = (long)Math.ceil((double)l2 / d) + 1L;
                }
            } else if (n > 1) {
                l5 = (long)Math.ceil((double)(l * (long)(n + 2) + 1L) / d) + 1L;
            } else {
                assert (n == 1);
                l5 = (long)Math.ceil((double)l2 / d) + 1L;
            }
            if (n > 1 || !bl2) {
                Intpair intpair = this.estimateSATEncodingSize(aSTNode3, l5, bl2);
                l4 = (long)Math.ceil((double)intpair.upper * d);
                if (intpair.upper < l5) {
                    if (bl2) {
                        if (n > 2) {
                            if (!CmdFlags.sat_table_mdd) {
                                double d2 = Math.ceil(d * ((double)intpair.upper - 1.0 - (double)l2) / (double)n);
                                l3 = d2 > 1.0E9 ? 1000000000L : (long)d2;
                            }
                        } else if (n == 2 && (double)l2 > (double)intpair.upper * d) {
                            return null;
                        }
                    } else if (n > 1) {
                        if (!CmdFlags.sat_table_mdd) {
                            double d3 = Math.ceil(d * ((double)intpair.upper - 1.0) / ((double)n + 2.0));
                            l3 = d3 > 1.0E9 ? 1000000000L : (long)d3;
                        }
                    } else if ((double)l2 > (double)intpair.upper * d) {
                        return null;
                    }
                }
            }
        }
        if (l3 < 0L) {
            l3 = 0L;
        }
        boolean bl3 = true;
        ASTNode aSTNode5 = null;
        boolean bl4 = false;
        l2 = -1L;
        if (!bl) {
            if (CmdFlags.tab_minion) {
                aSTNode2 = this.tabulateMinion(aSTNode3, l, l3);
            } else {
                aSTNode2 = aSTNode5 != null ? this.tu.makeTableLongDominance(aSTNode3, l, l3, aSTNode5, bl4) : this.tu.makeTableLong(aSTNode3, l, l3);
                l2 = this.tu.nodecount;
            }
        } else {
            aSTNode2 = l == Long.MAX_VALUE ? this.tu.makeTableShort(aSTNode3, l, l, l) : this.tu.makeTableShort(aSTNode3, 10000L, 100000L, 100000L);
        }
        if (CmdFlags.tab_satsizelimit && bl2 && n > 2 && CmdFlags.sat_table_mdd && aSTNode2 != null) {
            Intpair intpair = this.estimateSATEncodingSize(aSTNode2, l4 + 1L, bl2);
            if (intpair.upper > l4) {
                System.out.println("Failed SAT size limit check.");
                aSTNode2 = null;
            }
        }
        if (aSTNode2 == null) {
            this.tu.saveToFailCache(retPair.expstring);
        } else {
            if (bl3) {
                this.tu.saveToCacheNormalised(retPair.expstring, aSTNode4, aSTNode2);
            }
            if (CmdFlags.tabulate_diagnostics) {
                CmdFlags.println("\u001b[32mTabulated\u001b[0m in nodes:" + l2);
            }
            if (bl2) {
                if (aSTNode2 instanceof Table) {
                    ((Table)aSTNode2).propagate();
                } else {
                    ((TableShort)aSTNode2).propagate();
                }
            }
        }
        return aSTNode2;
    }

    public Intpair estimateSATEncodingSize(ASTNode aSTNode, long l, boolean bl) {
        CmdFlags.SolEnum solEnum = CmdFlags.soltype;
        CmdFlags.soltype = CmdFlags.SolEnum.SAT;
        ASTNode aSTNode2 = aSTNode.copy();
        ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode2);
        ModelContainer modelContainer = this.createModelForExpression(aSTNode2, arrayList, bl);
        Model model = modelContainer.m;
        HashSet<String> hashSet = new HashSet<String>();
        for (ASTNode aSTNode3 : arrayList) {
            hashSet.add(aSTNode3.toString());
        }
        boolean bl2 = CmdFlags.getOutputReady();
        boolean bl3 = CmdFlags.getAfterAggregate();
        long l2 = CmdFlags.getCNFLimit();
        CmdFlags.setCNFLimit(0L);
        boolean bl4 = CmdFlags.getUseDeleteVars();
        CmdFlags.setUseDeleteVars(false);
        TransformSumToShift transformSumToShift = new TransformSumToShift(model);
        model.transform(transformSumToShift);
        TransformProductToMult transformProductToMult = new TransformProductToMult(model);
        model.transform(transformProductToMult);
        TransformNormalise transformNormalise = new TransformNormalise(model);
        model.transform(transformNormalise);
        modelContainer.instanceFlattening(false);
        modelContainer.decomposeSatEncodingFlat();
        TransformToFlatGecode transformToFlatGecode = new TransformToFlatGecode(model);
        model.transform(transformToFlatGecode);
        model.simplify();
        TransformCollectSATDirect transformCollectSATDirect = new TransformCollectSATDirect(model);
        transformCollectSATDirect.transform(model.constraints);
        model.satModel = new SatNull(model.global_symbols);
        categoryentry categoryentry2 = model.global_symbols.getCategoryFirst();
        while (categoryentry2 != null) {
            if (!hashSet.contains(categoryentry2.name)) {
                categoryentry2.already_written = true;
            }
            categoryentry2 = categoryentry2.next;
        }
        try {
            model.satModel.generateVariableEncoding(transformCollectSATDirect.getVarsInConstraints(), false);
        }
        catch (IOException iOException) {
            CmdFlags.errorExit(String.valueOf(iOException));
        }
        long l3 = model.satModel.getNumVars();
        long l4 = model.satModel.getNumClauses();
        CmdFlags.setCNFLimit(l + l4);
        categoryentry2 = model.global_symbols.getCategoryFirst();
        while (categoryentry2 != null) {
            if (!hashSet.contains(categoryentry2.name)) {
                categoryentry2.already_written = false;
            }
            categoryentry2 = categoryentry2.next;
        }
        boolean bl5 = false;
        try {
            model.satModel.generateVariableEncoding(transformCollectSATDirect.getVarsInConstraints(), false);
        }
        catch (IOException iOException) {
            bl5 = true;
        }
        if (!bl5) {
            TransformSATEncoding transformSATEncoding = new TransformSATEncoding(model);
            model.constraints = transformSATEncoding.transform(model.constraints);
            model.toSAT();
        }
        l3 = model.satModel.getNumVars() - l3;
        l4 = model.satModel.getNumClauses() - l4;
        CmdFlags.setOutputReady(bl2);
        CmdFlags.setAfterAggregate(bl3);
        CmdFlags.setUseDeleteVars(bl4);
        CmdFlags.setCNFLimit(l2);
        CmdFlags.soltype = solEnum;
        return new Intpair(l3, l4);
    }

    public ModelContainer createModelForExpression(ASTNode aSTNode, ArrayList<ASTNode> arrayList, boolean bl) {
        int n;
        Model model = new Model();
        SymbolTable symbolTable = new SymbolTable();
        model.setup(new Top(new BooleanConstant(true)), symbolTable, null, null, this.m.heuristic, null, null);
        ArrayList<ASTNode> arrayList2 = this.tu.getDomains(arrayList);
        ArrayList<ASTNode> arrayList3 = TabulationUtils.getConstMatrixRefs(aSTNode);
        TransformFixSTRef transformFixSTRef = new TransformFixSTRef(model);
        transformFixSTRef.transform(aSTNode);
        for (n = 0; n < arrayList.size(); ++n) {
            symbolTable.newVariable(arrayList.get(n).toString(), arrayList2.get(n), 3);
        }
        model.branchingon = new CompoundMatrix(arrayList);
        transformFixSTRef.transform(model.branchingon);
        for (n = 0; n < arrayList3.size(); ++n) {
            model.cmstore.newConstantMatrix(arrayList3.get(n).toString(), this.m.cmstore.getConstantMatrix(arrayList3.get(n).toString()).copy());
        }
        if (aSTNode.isRelation() && bl) {
            model.constraints.setChild(0, aSTNode);
        } else {
            ASTNode aSTNode2 = model.global_symbols.newAuxHelper(aSTNode);
            ToVariable toVariable = new ToVariable(aSTNode, aSTNode2);
            model.constraints.setChild(0, toVariable);
        }
        return new ModelContainer(model, new ArrayList<ASTNode>());
    }

    public ASTNode tabulateMinion(ASTNode aSTNode, long l, long l2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ASTNode aSTNode2 = aSTNode.copy();
        ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode2);
        ModelContainer modelContainer = this.createModelForExpression(aSTNode2, arrayList, true);
        Model model = modelContainer.m;
        if (CmdFlags.getSattrans()) {
            object4 = new TransformRemoveMappers();
            model.transform((TreeTransformer)object4);
        }
        object4 = new HashSet();
        for (ASTNode aSTNode3 : arrayList) {
            ((HashSet)object4).add(aSTNode3.toString());
        }
        boolean bl = CmdFlags.getOutputReady();
        boolean bl2 = CmdFlags.getAfterAggregate();
        ArrayList<String> arrayList2 = CmdFlags.solverflags;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("-findallsols");
        if (l2 < Long.MAX_VALUE) {
            arrayList3.add("-sollimit");
            arrayList3.add(String.valueOf(l2 > 0L ? l2 : l2 + 1L));
        }
        if (l < Long.MAX_VALUE) {
            arrayList3.add("-nodelimit");
            arrayList3.add(String.valueOf(l));
        }
        arrayList3.add("-X-tabulation");
        CmdFlags.solverflags = arrayList3;
        String string = CmdFlags.getPreprocess();
        CmdFlags.preprocess = "GAC";
        boolean bl3 = CmdFlags.getUseDeleteVars();
        CmdFlags.setUseDeleteVars(false);
        boolean bl4 = CmdFlags.getRemoveRedundantVars();
        CmdFlags.setRemoveRedundantVars(false);
        boolean bl5 = CmdFlags.getAuxNonFunctional();
        CmdFlags.setAuxNonFunctional(false);
        TransformSafeElementOne transformSafeElementOne = new TransformSafeElementOne(model);
        model.transform(transformSafeElementOne);
        TransformNormalise transformNormalise = new TransformNormalise(model);
        model.transform(transformNormalise);
        modelContainer.instanceFlattening(true);
        TransformSumEq transformSumEq = new TransformSumEq(true);
        model.transform(transformSumEq);
        model.simplify();
        new File(CmdFlags.getMinionSolsTempFile()).delete();
        try {
            object3 = new BufferedWriter(new FileWriter(CmdFlags.minionfile));
            model.toMinion((BufferedWriter)object3, false);
            ((BufferedWriter)object3).close();
        }
        catch (IOException iOException) {
            System.out.println("Could not open file for Minion output.");
            CmdFlags.exit();
        }
        object3 = new MinionSolver();
        ArrayList<String> arrayList4 = null;
        try {
            arrayList4 = ((MinionSolver)object3).runMinion(CmdFlags.getMinion(), CmdFlags.minionfile, model, false, -1);
        }
        catch (Exception exception) {
            System.out.println("Could not run Minion for tabulation.");
            CmdFlags.exit();
        }
        String string2 = arrayList4.get(arrayList4.size() - 1).trim();
        ArrayList<ASTNode> arrayList5 = null;
        if (string2.equals("STOP-PC")) {
            System.out.println("Stopped by progress-check in Minion");
        } else if (string2.equals("STOP-NC")) {
            System.out.println("Stopped by node limit in Minion");
        } else if (string2.equals("STOP-SC")) {
            System.out.println("Stopped by solution limit in Minion (1)");
        } else if (CmdFlags.tab_stop_btfree && string2.equals("STOP-BTFREE")) {
            System.out.println("Stopped by a backtrack-free search in Minion");
        } else {
            object2 = null;
            try {
                object2 = new BufferedReader(new FileReader(CmdFlags.getMinionSolsTempFile()));
            }
            catch (IOException iOException) {
                System.out.println("Could not open Minion solution file.");
                CmdFlags.exit();
            }
            arrayList5 = new ArrayList<ASTNode>();
            try {
                object = ((BufferedReader)object2).readLine();
                while (object != null) {
                    String[] stringArray = ((String)object).split("\\s");
                    ArrayList<ASTNode> arrayList6 = new ArrayList<ASTNode>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        arrayList6.add(NumberConstant.make(Long.valueOf(stringArray[i])));
                    }
                    assert (arrayList6.size() == arrayList.size());
                    arrayList5.add(CompoundMatrix.make(arrayList6));
                    object = ((BufferedReader)object2).readLine();
                }
                if ((long)arrayList5.size() > l2) {
                    arrayList5 = null;
                    System.out.println("Stopped by solution limit in Minion (2)");
                }
            }
            catch (IOException iOException) {
                return null;
            }
            try {
                object = new File(CmdFlags.getMinionSolsTempFile());
                ((File)object).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CmdFlags.setOutputReady(bl);
        CmdFlags.setAfterAggregate(bl2);
        CmdFlags.solverflags = arrayList2;
        CmdFlags.preprocess = string;
        CmdFlags.setUseDeleteVars(bl3);
        CmdFlags.setRemoveRedundantVars(bl4);
        CmdFlags.setAuxNonFunctional(bl5);
        new File(CmdFlags.getMinionSolsTempFile()).delete();
        if (arrayList5 != null) {
            object2 = CompoundMatrix.make(arrayList5);
            object2 = this.m.cmstore.newConstantMatrixDedup((ASTNode)object2);
            object = new Table(this.m, CompoundMatrix.make(TabulationUtils.getVariablesOrdered(aSTNode)), (ASTNode)object2);
            return object;
        }
        return null;
    }
}

