/*
 * Decompiled with CFR 0.152.
 */
package savilerow.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import savilerow.ACCSE;
import savilerow.ACCSEActiveSum;
import savilerow.ACCSEActiveSum2;
import savilerow.AMODetect;
import savilerow.CSE;
import savilerow.CSEActive;
import savilerow.CSETopLevel;
import savilerow.CmdFlags;
import savilerow.ElementGAC;
import savilerow.FactorEncoding;
import savilerow.ICSEProduct;
import savilerow.ICSESum;
import savilerow.MIP;
import savilerow.Pair;
import savilerow.RemoveRedundantVars;
import savilerow.SumEnc;
import savilerow.SymmetryBreaker;
import savilerow.Tabulation;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Find;
import savilerow.expression.Given;
import savilerow.expression.Identifier;
import savilerow.expression.Intersect;
import savilerow.expression.Intpair;
import savilerow.expression.Less;
import savilerow.expression.LessEqual;
import savilerow.expression.Letting;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixDomain;
import savilerow.expression.MaxSATObjective;
import savilerow.expression.Minimising;
import savilerow.expression.MultiplyMapper;
import savilerow.expression.NumberConstant;
import savilerow.expression.SNS;
import savilerow.expression.SNSIncumbentMapping;
import savilerow.expression.SafeMatrixDeref;
import savilerow.expression.Solution;
import savilerow.expression.Times;
import savilerow.expression.ToVariable;
import savilerow.expression.WeightedSum;
import savilerow.expression.Where;
import savilerow.model.BitVector;
import savilerow.model.ConstantMatrixStore;
import savilerow.model.DominanceModelContainer;
import savilerow.model.FilteredDomainStore;
import savilerow.model.InteractiveSMT;
import savilerow.model.InteractiveSat;
import savilerow.model.Model;
import savilerow.solver.AllMinisatSATSolver;
import savilerow.solver.BoolectorSolver;
import savilerow.solver.CadicalSATSolver;
import savilerow.solver.FznSolver;
import savilerow.solver.GlucoseSATSolver;
import savilerow.solver.LingelingSATSolver;
import savilerow.solver.MinionSolver;
import savilerow.solver.MinisatSATSolver;
import savilerow.solver.MznSolver;
import savilerow.solver.SATSolver;
import savilerow.solver.Solver;
import savilerow.solver.Stats;
import savilerow.solver.WMaxCDCLSolver;
import savilerow.solver.YicesSolver;
import savilerow.solver.Z3Solver;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformAbsReify;
import savilerow.treetransformer.TransformAlldiffExcept;
import savilerow.treetransformer.TransformAlldiffGCCSum;
import savilerow.treetransformer.TransformAlldiffToSums;
import savilerow.treetransformer.TransformBreakupSum2;
import savilerow.treetransformer.TransformBreakupSum2SMT;
import savilerow.treetransformer.TransformCollectAlldiff;
import savilerow.treetransformer.TransformCollectBool;
import savilerow.treetransformer.TransformCollectGCC;
import savilerow.treetransformer.TransformCollectPBDirect;
import savilerow.treetransformer.TransformCollectSATDirect;
import savilerow.treetransformer.TransformCollectSMT;
import savilerow.treetransformer.TransformCountToSum;
import savilerow.treetransformer.TransformDecomposeAlldiff;
import savilerow.treetransformer.TransformDecomposeCircuit;
import savilerow.treetransformer.TransformDecomposeCumulative;
import savilerow.treetransformer.TransformDecomposeDiffN;
import savilerow.treetransformer.TransformDecomposeDisjunctive;
import savilerow.treetransformer.TransformDecomposeInverse;
import savilerow.treetransformer.TransformDecomposeLex2;
import savilerow.treetransformer.TransformDecomposeMinMax;
import savilerow.treetransformer.TransformDecomposeNegativeTable;
import savilerow.treetransformer.TransformDecomposeReifLex2;
import savilerow.treetransformer.TransformDivToTable;
import savilerow.treetransformer.TransformEOPB;
import savilerow.treetransformer.TransformElementForSAT2;
import savilerow.treetransformer.TransformElementForSAT3;
import savilerow.treetransformer.TransformEncodeSumSpecial;
import savilerow.treetransformer.TransformEqual;
import savilerow.treetransformer.TransformEqualConst;
import savilerow.treetransformer.TransformExistsVar;
import savilerow.treetransformer.TransformExpandShortTable;
import savilerow.treetransformer.TransformExtractBoolsInSums;
import savilerow.treetransformer.TransformFixSTRef;
import savilerow.treetransformer.TransformForBoundVars;
import savilerow.treetransformer.TransformGCAssignClique;
import savilerow.treetransformer.TransformGCCSum;
import savilerow.treetransformer.TransformGCCToSums;
import savilerow.treetransformer.TransformLexAlldiff;
import savilerow.treetransformer.TransformMakeSafe;
import savilerow.treetransformer.TransformMappingToTable;
import savilerow.treetransformer.TransformMatrixDeref;
import savilerow.treetransformer.TransformMatrixDerefDecomp;
import savilerow.treetransformer.TransformMatrixIndexedMatrix;
import savilerow.treetransformer.TransformMatrixToAtoms;
import savilerow.treetransformer.TransformModToTable;
import savilerow.treetransformer.TransformNormalise;
import savilerow.treetransformer.TransformOccurrence;
import savilerow.treetransformer.TransformOccurrenceToSum;
import savilerow.treetransformer.TransformPowToTable;
import savilerow.treetransformer.TransformProductToMult;
import savilerow.treetransformer.TransformQuantifiedExpression;
import savilerow.treetransformer.TransformReifyAlldiff;
import savilerow.treetransformer.TransformReifyMin;
import savilerow.treetransformer.TransformRemoveSafeTypes;
import savilerow.treetransformer.TransformSATEncoding;
import savilerow.treetransformer.TransformSafeElementOne;
import savilerow.treetransformer.TransformShiftToIDL;
import savilerow.treetransformer.TransformShortTableSquash;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TransformSizeBV;
import savilerow.treetransformer.TransformSumEq;
import savilerow.treetransformer.TransformSumEqToSum;
import savilerow.treetransformer.TransformSumForSAT;
import savilerow.treetransformer.TransformSumToAMOPB;
import savilerow.treetransformer.TransformSumToShift;
import savilerow.treetransformer.TransformTableReify;
import savilerow.treetransformer.TransformTableToElement;
import savilerow.treetransformer.TransformTableToShortTable;
import savilerow.treetransformer.TransformTimes;
import savilerow.treetransformer.TransformToFlat;
import savilerow.treetransformer.TransformToFlatGecode;
import savilerow.treetransformer.TransformToFlatPol;
import savilerow.treetransformer.TransformToFlatSMT;
import savilerow.treetransformer.TransformTrimElement;
import savilerow.treetransformer.TransformXor;
import savilerow.treetransformer.TreeTransformer;
import savilerow.treetransformer.TreeTransformerBottomUp;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;
import savilerow.treetransformer.TreeTransformerTopdown;

public class ModelContainer {
    public Model m;
    public ArrayList<ASTNode> parameters;

    public ModelContainer(Model model, ArrayList<ASTNode> arrayList) {
        this.m = model;
        this.parameters = arrayList;
    }

    public void process() {
        this.processPreamble();
        this.instancePreFlattening1();
        if (CmdFlags.getUsePropagate()) {
            this.squashDomains();
        }
        this.instancePreFlattening2(false);
        this.instanceFlattening(false);
        this.postFlattening(false);
    }

    public void dryrun() {
        this.processPreamble();
        this.instancePreFlattening1();
        if (CmdFlags.getUsePropagate()) {
            this.squashDomains();
        }
        this.instancePreFlattening2(false);
        this.instanceFlattening(false);
    }

    public void processPreamble() {
        TreeTransformer treeTransformer;
        Object object;
        Object object2;
        Object object3;
        CmdFlags.setOutputReady(false);
        CmdFlags.setAfterAggregate(false);
        ArrayDeque<ASTNode> arrayDeque = this.m.global_symbols.lettings_givens;
        for (int i = 0; i < this.parameters.size(); ++i) {
            object3 = this.parameters.get(i);
            if (!((ASTNode)object3).typecheck(this.m.global_symbols)) {
                CmdFlags.errorExit("Failed type checking in parameter file:" + String.valueOf(object3));
            }
            object2 = new TransformMakeSafe(this.m);
            object3 = ((TreeTransformerBottomUp)object2).transform((ASTNode)object3);
            object = ((TreeTransformerBottomUp)object2).getContextCts();
            if (object != null) {
                arrayDeque.addLast(new Where((ASTNode)object));
            }
            treeTransformer = new TransformSimplify();
            object3 = ((TreeTransformerBottomUpNoWrapper)treeTransformer).transform((ASTNode)object3);
            TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
            object3 = transformQuantifiedExpression.transform((ASTNode)object3);
            object3 = ((TreeTransformerBottomUpNoWrapper)treeTransformer).transform((ASTNode)object3);
            object3 = this.fixIndexDomainsLetting((ASTNode)object3);
            this.parameters.set(i, (ASTNode)object3);
            ReplaceASTNode replaceASTNode = new ReplaceASTNode(((ASTNode)object3).getChild(0), ((ASTNode)object3).getChild(1));
            for (int j = i + 1; j < this.parameters.size(); ++j) {
                this.parameters.set(j, replaceASTNode.transform(this.parameters.get(j)));
            }
        }
        while (arrayDeque.size() != 0) {
            ASTNode aSTNode = arrayDeque.removeFirst();
            if (!aSTNode.typecheck(this.m.global_symbols)) {
                CmdFlags.errorExit("Failed type checking:" + String.valueOf(aSTNode));
            }
            object3 = new TransformMakeSafe(this.m);
            aSTNode = ((TreeTransformerBottomUp)object3).transform(aSTNode);
            object2 = ((TreeTransformerBottomUp)object3).getContextCts();
            if (object2 != null) {
                arrayDeque.addLast(new Where((ASTNode)object2));
            }
            object = new TransformSimplify();
            aSTNode = ((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode);
            treeTransformer = new TransformQuantifiedExpression(this.m);
            aSTNode = ((TreeTransformerTopdown)treeTransformer).transform(aSTNode);
            if ((aSTNode = ((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode)) instanceof Letting) {
                aSTNode = this.fixIndexDomainsLetting(aSTNode);
                this.processLetting(aSTNode);
                continue;
            }
            if (aSTNode instanceof Find) {
                this.processFind(aSTNode);
                continue;
            }
            if (aSTNode instanceof Where) {
                this.processWhere(aSTNode);
                continue;
            }
            assert (aSTNode instanceof Given);
            this.processGiven(aSTNode);
        }
        if (this.parameters.size() > 0) {
            CmdFlags.warning("Number of givens in model file does not match number of lettings in parameter file.");
        }
        this.parameters = null;
        if (!this.m.typecheck()) {
            CmdFlags.errorExit("Failed type checking after substituting in lettings.");
        }
        if (CmdFlags.getVerbose()) {
            CmdFlags.println("Model before undef handling:");
            CmdFlags.println(this.m);
        }
        this.removeMatrixIndexedMatrices();
        if (!this.m.constraints.typecheck2(this.m.global_symbols)) {
            CmdFlags.errorExit("Failed type checking.");
        }
        TransformMakeSafe transformMakeSafe = new TransformMakeSafe(this.m);
        this.m.transform(transformMakeSafe);
        this.m.simplify();
    }

    public void instancePreFlattening1() {
        Object object;
        Object object2;
        if (!CmdFlags.getMinionSNStrans() && this.m.sns != null) {
            object2 = ((SNS)this.m.sns).deactivateEarly();
            this.m.constraints.getChild(0).setParent(null);
            this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), (ASTNode)object2));
            this.m.simplify();
        }
        object2 = new TransformExistsVar(this.m);
        this.m.transform((TreeTransformer)object2);
        TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
        this.m.transform(transformQuantifiedExpression);
        this.destroyMatrices();
        if (this.m.sns != null) {
            object = ((SNSIncumbentMapping)this.m.sns.getChild(0)).makeIncumbentDisable();
            this.m.constraints.getChild(0).setParent(null);
            this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), (ASTNode)object));
            this.m.simplify();
        }
        if (CmdFlags.getGraphColSymBreak()) {
            object = new TransformGCAssignClique(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getUseVarSymBreaking()) {
            this.writeModelAsJSON(this.m);
        }
        if (CmdFlags.amo_detect) {
            AMODetect.init();
        }
    }

    public void instancePreFlattening2(boolean bl) {
        TreeTransformer treeTransformer;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        TreeTransformer treeTransformer2;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper2;
        Object object;
        TreeTransformer treeTransformer3;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper3;
        TreeTransformer treeTransformer4;
        Object object2;
        TreeTransformer treeTransformer5;
        if (bl || CmdFlags.soltype != CmdFlags.SolEnum.MIP && (!CmdFlags.sat_matrixderef_decomp || !CmdFlags.getSattrans())) {
            treeTransformer5 = new TransformMatrixDeref(this.m, bl);
            this.m.transform(treeTransformer5);
        }
        if (this.m.objective != null) {
            this.processObjective(bl);
        }
        if (CmdFlags.amo_detect) {
            treeTransformer5 = new TransformExtractBoolsInSums(this.m);
            this.m.transform(treeTransformer5);
        }
        treeTransformer5 = new TransformTrimElement(this.m);
        this.m.transform(treeTransformer5);
        TransformNormalise transformNormalise = new TransformNormalise(this.m);
        this.m.transform(transformNormalise);
        if ((!CmdFlags.getMinionSNStrans() || bl) && this.m.sns != null) {
            object2 = ((SNS)this.m.sns).deactivate();
            this.m.constraints.getChild(0).setParent(null);
            this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), (ASTNode)object2));
            this.m.simplify();
            this.m.sns = null;
        }
        if (CmdFlags.getRemoveRedundantVars()) {
            object2 = new RemoveRedundantVars();
            ((RemoveRedundantVars)object2).transform(this.m);
        }
        object2 = new TransformEOPB(this.m, bl);
        this.m.transform((TreeTransformer)object2);
        if (CmdFlags.getUseAggregate()) {
            treeTransformer4 = new TransformCollectAlldiff(this.m);
            this.m.transform(treeTransformer4);
            treeTransformerBottomUpNoWrapper3 = new TransformCollectGCC(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper3);
        }
        CmdFlags.setAfterAggregate(true);
        if (CmdFlags.getUseDeleteVars() && CmdFlags.getUseAggregate()) {
            this.m.simplify();
        }
        treeTransformer4 = new TransformAlldiffExcept(this.m);
        this.m.transform(treeTransformer4);
        treeTransformerBottomUpNoWrapper3 = new TransformOccurrence();
        this.m.transform(treeTransformerBottomUpNoWrapper3);
        if (CmdFlags.getUseBoundVars() && (CmdFlags.getMiniontrans() || bl)) {
            treeTransformer3 = new TransformForBoundVars(this.m);
            this.m.transform(treeTransformer3);
        }
        treeTransformer3 = new TransformGCCSum(this.m);
        this.m.transform(treeTransformer3);
        if (CmdFlags.getSattrans() && !bl && (CmdFlags.make_short_tab == 3 || CmdFlags.make_short_tab == 4 || CmdFlags.tabid)) {
            object = new TransformSumToShift(this.m);
            this.m.transform((TreeTransformer)object);
            treeTransformerBottomUpNoWrapper2 = new TransformProductToMult(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper2);
        }
        this.m.transform(transformNormalise);
        object = new Tabulation(this.m);
        ((Tabulation)object).process(bl);
        treeTransformerBottomUpNoWrapper2 = new TransformLexAlldiff(this.m);
        this.m.transform(treeTransformerBottomUpNoWrapper2);
        TransformDecomposeCircuit transformDecomposeCircuit = new TransformDecomposeCircuit(this.m, bl);
        this.m.transform(transformDecomposeCircuit);
        TransformDecomposeInverse transformDecomposeInverse = new TransformDecomposeInverse(this.m, bl);
        this.m.transform(transformDecomposeInverse);
        TransformDecomposeCumulative transformDecomposeCumulative = new TransformDecomposeCumulative(bl);
        this.m.transform(transformDecomposeCumulative);
        TransformDecomposeDisjunctive transformDecomposeDisjunctive = new TransformDecomposeDisjunctive(bl);
        this.m.transform(transformDecomposeDisjunctive);
        TransformDecomposeDiffN transformDecomposeDiffN = new TransformDecomposeDiffN(bl);
        this.m.transform(transformDecomposeDiffN);
        if (!CmdFlags.getSattrans() || bl) {
            treeTransformer2 = new TransformSafeElementOne(this.m);
            this.m.transform(treeTransformer2);
        }
        if (CmdFlags.getFlatzinctrans() && !bl) {
            treeTransformer2 = new TransformReifyAlldiff(this.m);
            this.m.transform(treeTransformer2);
            treeTransformerBottomUpNoWrapper = new TransformDecomposeNegativeTable(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
            treeTransformer = new TransformDecomposeReifLex2(this.m);
            this.m.transform(treeTransformer);
        }
        if ((CmdFlags.getChuffedtrans() || CmdFlags.getOrtoolstrans()) && !bl) {
            treeTransformer2 = new TransformOccurrenceToSum();
            this.m.transform(treeTransformer2);
            treeTransformerBottomUpNoWrapper = new TransformGCCToSums();
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        if (CmdFlags.getOrtoolstrans() && !bl) {
            treeTransformer2 = new TransformDecomposeLex2(this.m);
            this.m.transform(treeTransformer2);
        }
        if (!(!CmdFlags.getFlatzinctrans() || CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans() || CmdFlags.getOrtoolstrans() || CmdFlags.getChocotrans())) {
            treeTransformer2 = new TransformOccurrenceToSum();
            this.m.transform(treeTransformer2);
            treeTransformerBottomUpNoWrapper = new TransformGCCToSums();
            this.m.transform(treeTransformerBottomUpNoWrapper);
            treeTransformer = new TransformDecomposeAlldiff(this.m);
            this.m.transform(treeTransformer);
            TransformDecomposeLex2 transformDecomposeLex2 = new TransformDecomposeLex2(this.m);
            this.m.transform(transformDecomposeLex2);
        }
        if (CmdFlags.getSattrans() && !bl) {
            treeTransformer2 = new TransformSumToShift(this.m);
            this.m.transform(treeTransformer2);
            treeTransformerBottomUpNoWrapper = new TransformProductToMult(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        treeTransformer2 = new TransformNormalise(this.m);
        this.m.transform(treeTransformer2);
    }

    public void processObjective(boolean bl) {
        ASTNode aSTNode = this.m.objective.getChild(0);
        if (!CmdFlags.getMiniontrans() && !bl && aSTNode.getDimension() > 0) {
            ASTNode aSTNode2 = aSTNode.getChild(1);
            for (int i = 2; i < aSTNode.numChildren(); ++i) {
                Intpair intpair = aSTNode.getChild(i).getBounds();
                NumberConstant numberConstant = NumberConstant.make(intpair.upper - intpair.lower + 1L);
                aSTNode2 = new WeightedSum((ASTNode)new Times(aSTNode2, numberConstant), aSTNode.getChild(i));
            }
            aSTNode = aSTNode2;
            this.m.objective.setChild(0, aSTNode);
        }
        if (aSTNode.getDimension() > 0) {
            assert (aSTNode instanceof CompoundMatrix);
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode.getChild(i);
                this.processObjective1(bl, aSTNode3);
            }
        } else {
            this.processObjective1(bl, aSTNode);
        }
    }

    public void processObjective1(boolean bl, ASTNode aSTNode) {
        if (!aSTNode.isConstant() && !(aSTNode instanceof Identifier)) {
            ASTNode aSTNode2;
            boolean bl2 = true;
            if (aSTNode instanceof MatrixDeref || aSTNode instanceof SafeMatrixDeref) {
                bl2 = false;
                for (int i = 1; i < aSTNode.numChildren(); ++i) {
                    if (aSTNode.getChild(i).isConstant()) continue;
                    bl2 = true;
                }
            }
            if (bl2 && !bl && (CmdFlags.getMaxsattrans() || CmdFlags.getPBtrans()) && this.m.objective.getChild(0) instanceof WeightedSum) {
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
                aSTNode2 = this.m.objective.getChild(0);
                for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                    arrayList.add(new MultiplyMapper(aSTNode2.getChild(i), NumberConstant.make(((WeightedSum)aSTNode2).getWeight(i))));
                }
                aSTNode.getParent().setChild(aSTNode.getChildNo(), new MaxSATObjective(arrayList));
                bl2 = false;
            }
            if (bl2) {
                ASTNode aSTNode3 = this.m.global_symbols.newAuxHelper(aSTNode);
                aSTNode2 = CmdFlags.getAuxNonFunctional() && this.m.objective.getChild(0) instanceof WeightedSum && CmdFlags.getSattrans() ? (this.m.objective instanceof Minimising ? new LessEqual(aSTNode, aSTNode3) : new LessEqual(aSTNode3, aSTNode)) : new ToVariable(aSTNode, aSTNode3);
                this.m.global_symbols.auxVarRepresentsConstraint(aSTNode3.toString(), aSTNode.toString());
                aSTNode.getParent().setChild(aSTNode.getChildNo(), aSTNode3);
                this.m.constraints.getChild(0).setParent(null);
                this.m.constraints.setChild(0, new And(aSTNode2, this.m.constraints.getChild(0)));
            }
        }
    }

    public void squashDomains() {
        Object object;
        ASTNode aSTNode;
        Object object2;
        String string;
        ASTNode aSTNode2;
        Model model = this.m.copy();
        Model model2 = null;
        if (CmdFlags.getVerbose()) {
            model2 = this.m.copy();
        }
        boolean bl = CmdFlags.getOutputReady();
        boolean bl2 = CmdFlags.getAfterAggregate();
        this.instancePreFlattening2(true);
        this.instanceFlattening(true);
        ArrayList<ASTNode> arrayList = this.postFlattening(true);
        FilteredDomainStore filteredDomainStore = this.m.filt;
        ASTNode aSTNode3 = this.m.incumbentSolution;
        this.m = model;
        this.m.filt = filteredDomainStore;
        this.m.incumbentSolution = aSTNode3;
        CmdFlags.setOutputReady(bl);
        CmdFlags.setAfterAggregate(bl2);
        for (int i = 0; i < arrayList.size(); ++i) {
            aSTNode2 = arrayList.get(i).getChild(0);
            ASTNode aSTNode4 = arrayList.get(i).getChild(1);
            assert (aSTNode2 instanceof Identifier);
            assert (aSTNode4.isFiniteSet());
            string = aSTNode2.toString();
            if (this.m.global_symbols.getCategory(string) == 3) {
                object2 = this.m.global_symbols.getDomain(string);
                aSTNode = new Intersect((ASTNode)object2, aSTNode4);
                if (((ASTNode)object2).isBooleanSet()) {
                    object = new TransformSimplify();
                    aSTNode = Intpair.makeDomain(((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode).getIntervalSet(), true);
                }
                this.m.global_symbols.setDomain(string, aSTNode);
                continue;
            }
            this.m.filt.auxVarFilteredDomain(string, aSTNode4);
        }
        if (this.m.sns != null && CmdFlags.getMinionSNStrans()) {
            ASTNode aSTNode5 = this.m.sns.getChild(0).getChild(0);
            aSTNode2 = this.m.sns.getChild(0).getChild(1);
            assert (aSTNode5 instanceof CompoundMatrix);
            assert (aSTNode2 instanceof CompoundMatrix);
            for (int i = 1; i < aSTNode5.numChildren(); ++i) {
                string = aSTNode5.getChild(i).toString();
                object2 = aSTNode2.getChild(i).toString();
                aSTNode = this.m.global_symbols.getDomain(string);
                object = new Intersect(aSTNode, this.m.global_symbols.getDomain((String)object2));
                if (this.m.global_symbols.getDomain((String)object2).isBooleanSet()) {
                    TransformSimplify transformSimplify = new TransformSimplify();
                    object = Intpair.makeDomain(transformSimplify.transform((ASTNode)object).getIntervalSet(), true);
                }
                this.m.global_symbols.setDomain((String)object2, (ASTNode)object);
            }
        }
        this.m.simplify();
        if (CmdFlags.getVerbose() && !this.m.equals(model2)) {
            System.out.println("Domain filtering changed model:\n" + this.m.toString());
        }
    }

    public void instanceFlattening(boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        TreeTransformer treeTransformer;
        if ((CmdFlags.getFlatzinctrans() || CmdFlags.getMinizinctrans()) && !bl) {
            treeTransformer = new TransformRemoveSafeTypes(this.m);
            this.m.transform(treeTransformer);
        }
        if (CmdFlags.getVerbose()) {
            System.out.println("Rules: Normalisation and CSE");
        }
        treeTransformer = new TransformAlldiffGCCSum(this.m);
        if (CmdFlags.getUseACCSE() || CmdFlags.getUseACCSEAlt()) {
            this.m.transform(treeTransformer);
        }
        TransformNormalise transformNormalise = new TransformNormalise(this.m);
        if (CmdFlags.getUseACCSE()) {
            this.m.transform(transformNormalise);
            object4 = new ACCSE();
            ((ACCSE)object4).flattenCSEs(this.m, "*");
            CmdFlags.stats.put("AC-CSE-Times_number", ((ACCSE)object4).numcse);
            CmdFlags.stats.put("AC-CSE-Times_eliminated_expressions", ((ACCSE)object4).countcse);
            CmdFlags.stats.put("AC-CSE-Times_total_size", ((ACCSE)object4).totallength);
            this.m.simplify();
            ((ACCSE)object4).flattenCSEs(this.m, "xor");
            CmdFlags.stats.put("AC-CSE-Xor_number", ((ACCSE)object4).numcse);
            CmdFlags.stats.put("AC-CSE-Xor_eliminated_expressions", ((ACCSE)object4).countcse);
            CmdFlags.stats.put("AC-CSE-Xor_total_size", ((ACCSE)object4).totallength);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSEAlt()) {
            this.m.transform(transformNormalise);
            object4 = new ICSEProduct();
            ((ICSEProduct)object4).flattenCSEs(this.m);
            this.m.simplify();
        }
        CmdFlags.setOutputReady(true);
        object4 = new TransformTimes(this.m);
        this.m.transform((TreeTransformer)object4);
        TransformXor transformXor = new TransformXor(this.m);
        this.m.transform(transformXor);
        if (CmdFlags.getUseCSE()) {
            this.m.transform(transformNormalise);
            object3 = new CSETopLevel();
            ((CSETopLevel)object3).flattenCSEs(this.m);
            CmdFlags.stats.put("CSETopLevel_number", ((CSETopLevel)object3).numcse);
            CmdFlags.stats.put("CSETopLevel_eliminated_expressions", ((CSETopLevel)object3).countcse);
            CmdFlags.stats.put("CSETopLevel_total_size", ((CSETopLevel)object3).totallength);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSE() || this instanceof DominanceModelContainer && CmdFlags.compressDominance) {
            object3 = new ACCSE();
            this.m.transform(transformNormalise);
            ((ACCSE)object3).flattenCSEs(this.m, "\\/");
            CmdFlags.stats.put("AC-CSE-Or_number", ((ACCSE)object3).numcse);
            CmdFlags.stats.put("AC-CSE-Or_eliminated_expressions", ((ACCSE)object3).countcse);
            CmdFlags.stats.put("AC-CSE-Or_total_size", ((ACCSE)object3).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            ((ACCSE)object3).flattenCSEs(this.m, "/\\");
            CmdFlags.stats.put("AC-CSE-And_number", ((ACCSE)object3).numcse);
            CmdFlags.stats.put("AC-CSE-And_eliminated_expressions", ((ACCSE)object3).countcse);
            CmdFlags.stats.put("AC-CSE-And_total_size", ((ACCSE)object3).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            if (CmdFlags.getUseActiveACCSE()) {
                object2 = new ACCSEActiveSum();
                ((ACCSEActiveSum)object2).flattenCSEs(this.m);
                CmdFlags.stats.put("Active-AC-CSE-Sum_number", ((ACCSEActiveSum)object2).numcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_eliminated_expressions", ((ACCSEActiveSum)object2).countcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_total_size", ((ACCSEActiveSum)object2).totallength);
                CmdFlags.stats.put("Active-AC-CSE-Found", ((ACCSEActiveSum)object2).active_ac_cs_found ? 1 : 0);
            } else if (CmdFlags.getUseActiveACCSE2()) {
                object2 = new ACCSEActiveSum2();
                ((ACCSEActiveSum2)object2).flattenCSEs(this.m);
                CmdFlags.stats.put("Active-AC-CSE-Sum_number", ((ACCSEActiveSum2)object2).numcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_eliminated_expressions", ((ACCSEActiveSum2)object2).countcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_total_size", ((ACCSEActiveSum2)object2).totallength);
                CmdFlags.stats.put("Active-AC-CSE-Found", ((ACCSEActiveSum2)object2).active_ac_cs_found ? 1 : 0);
            } else {
                ((ACCSE)object3).flattenCSEs(this.m, "+");
                CmdFlags.stats.put("AC-CSE-Sum_number", ((ACCSE)object3).numcse);
                CmdFlags.stats.put("AC-CSE-Sum_eliminated_expressions", ((ACCSE)object3).countcse);
                CmdFlags.stats.put("AC-CSE-Sum_total_size", ((ACCSE)object3).totallength);
            }
        }
        if (CmdFlags.getUseACCSEAlt()) {
            object3 = new ACCSE();
            this.m.transform(transformNormalise);
            ((ACCSE)object3).flattenCSEs(this.m, "\\/");
            CmdFlags.stats.put("AC-CSE-Or_number", ((ACCSE)object3).numcse);
            CmdFlags.stats.put("AC-CSE-Or_eliminated_expressions", ((ACCSE)object3).countcse);
            CmdFlags.stats.put("AC-CSE-Or_total_size", ((ACCSE)object3).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            ((ACCSE)object3).flattenCSEs(this.m, "/\\");
            CmdFlags.stats.put("AC-CSE-And_number", ((ACCSE)object3).numcse);
            CmdFlags.stats.put("AC-CSE-And_eliminated_expressions", ((ACCSE)object3).countcse);
            CmdFlags.stats.put("AC-CSE-And_total_size", ((ACCSE)object3).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            object2 = new ICSESum();
            ((ICSESum)object2).flattenCSEs(this.m);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSE() || CmdFlags.getUseACCSEAlt()) {
            ((TransformAlldiffGCCSum)treeTransformer).removeImpliedConstraints();
        }
        if (CmdFlags.getSattrans() && !bl) {
            this.decomposeSatEncoding();
        }
        if (CmdFlags.soltype == CmdFlags.SolEnum.MIP && !bl) {
            this.decomposeMIPEncoding();
        }
        if (CmdFlags.getUseCSE() || CmdFlags.getUseActiveCSE()) {
            this.m.transform(transformNormalise);
            if (CmdFlags.getUseActiveCSE()) {
                object3 = new CSEActive();
                ((CSEActive)object3).flattenCSEs(this.m);
                this.m.simplify();
                CmdFlags.stats.put("CSE_active_number", ((CSEActive)object3).numcse);
                CmdFlags.stats.put("CSE_active_eliminated_expressions", ((CSEActive)object3).countcse);
                CmdFlags.stats.put("CSE_active_total_size", ((CSEActive)object3).totallength);
            } else {
                object3 = new CSE();
                ((CSE)object3).flattenCSEs(this.m);
                this.m.simplify();
                CmdFlags.stats.put("CSE_number", ((CSE)object3).numcse);
                CmdFlags.stats.put("CSE_eliminated_expressions", ((CSE)object3).countcse);
                CmdFlags.stats.put("CSE_total_size", ((CSE)object3).totallength);
            }
        }
        if (CmdFlags.getVerbose()) {
            System.out.println("Model may have changed by CSE. Model after rule application:\n" + this.m.toString());
        }
        object3 = new TransformEqual(this.m, bl);
        this.m.transform((TreeTransformer)object3);
        object2 = new TransformEqualConst(bl);
        this.m.transform((TreeTransformer)object2);
        if (CmdFlags.getFlatzinctrans() && !CmdFlags.getGecodetrans()) {
            object = new TransformCountToSum();
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.table_squash == 1 || CmdFlags.table_squash == 3) {
            object = new TransformShortTableSquash(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.table_squash == 2 || CmdFlags.table_squash == 3) {
            object = new TransformTableToShortTable(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getSattrans() && !CmdFlags.getSMTtrans() && !bl && CmdFlags.use_polarity) {
            object = new TransformToFlatPol(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getSMTtrans() && !bl) {
            object = new TransformToFlatSMT(this.m, bl);
            this.m.transform((TreeTransformer)object);
        } else {
            object = new TransformToFlat(this.m, bl);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.element_gac) {
            object = new ElementGAC();
            ((ElementGAC)object).transform(this.m);
        }
        if (CmdFlags.factor_encoding) {
            object = new FactorEncoding();
            ((FactorEncoding)object).factorEncoding(this.m);
            this.m.simplify();
        }
        if (CmdFlags.getFlatzinctrans() && !bl) {
            object = new TransformToFlatGecode(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getExpandShortTab() || (CmdFlags.getFlatzinctrans() || CmdFlags.getMinizinctrans()) && !bl) {
            object = new TransformExpandShortTable(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getChuffedtrans() && !bl) {
            object = new TransformModToTable(this.m);
            this.m.transform((TreeTransformer)object);
            TransformDivToTable transformDivToTable = new TransformDivToTable(this.m);
            this.m.transform(transformDivToTable);
        }
        if ((CmdFlags.getFlatzinctrans() || CmdFlags.getMinizinctrans()) && !bl) {
            object = new TransformPowToTable(this.m);
            this.m.transform((TreeTransformer)object);
        }
        object = new TransformMappingToTable(this.m);
        this.m.transform((TreeTransformer)object);
    }

    public ArrayList<ASTNode> postFlattening(boolean bl) {
        block25: {
            Object object;
            Object object2;
            if (CmdFlags.getFlatzinctrans() && !bl) {
                this.fznFlattening();
                return null;
            }
            if (CmdFlags.getMinizinctrans() && !bl) {
                this.minizincOutput();
                return null;
            }
            if (CmdFlags.soltype == CmdFlags.SolEnum.MIP && !bl) {
                this.mipOutput();
                return null;
            }
            if (CmdFlags.getSattrans() && !CmdFlags.getSMTtrans() && !CmdFlags.getPBtrans() && !bl) {
                return this.satPrepOutput();
            }
            if (CmdFlags.getSMTtrans() && !bl) {
                return this.smtPrepOutput();
            }
            if (CmdFlags.getPBtrans() && !bl) {
                return this.pbPrepOutput();
            }
            TransformSumEq transformSumEq = new TransformSumEq(bl);
            this.m.transform(transformSumEq);
            this.m.simplify();
            if (CmdFlags.getOptWarmStart() && this.m.objective != null && bl) {
                object2 = new MinionSolver();
                try {
                    object = ((MinionSolver)object2).optWarmStart(this.m);
                    if (object != null) {
                        this.m.incumbentSolution = object;
                        long l = ((Solution)object).optval;
                        ASTNode aSTNode = this.m.objective.getChild(0);
                        Less less = this.m.objective instanceof Minimising ? new Less(aSTNode, NumberConstant.make(l)) : new Less((ASTNode)NumberConstant.make(l), aSTNode);
                        System.out.println("Adding warm start constraint: " + String.valueOf(less));
                        this.m.constraints.getChild(0).setParent(null);
                        this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), less));
                        this.m.simplify();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (CmdFlags.minionfile != null);
            object2 = CmdFlags.minionfile;
            if (!(this instanceof DominanceModelContainer)) {
                try {
                    object = new FileOutputStream((String)object2);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
                    this.m.toMinion(bufferedWriter, bl);
                    bufferedWriter.flush();
                    ((FileOutputStream)object).getFD().sync();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    CmdFlags.errorExit("Could not open file for Minion output.");
                }
                CmdFlags.println("Created output file " + (bl ? "for domain filtering " : "") + (String)object2);
            }
            if (bl) {
                object = new MinionSolver();
                try {
                    return ((MinionSolver)object).reduceDomains(CmdFlags.getMinion(), (String)object2, this.m);
                }
                catch (IOException iOException) {
                    CmdFlags.errorExit("Could not run Minion: " + String.valueOf(iOException));
                    break block25;
                }
                catch (InterruptedException interruptedException) {
                    CmdFlags.errorExit("Could not run Minion: " + String.valueOf(interruptedException));
                    break block25;
                }
            }
            if (CmdFlags.getRunSolver()) {
                object = new MinionSolver();
                try {
                    if (!(this instanceof DominanceModelContainer)) {
                        if (CmdFlags.dominanceRelation) {
                            DominanceModelContainer dominanceModelContainer = new DominanceModelContainer(this.m, this.parameters, (Solver)object);
                            dominanceModelContainer.process();
                        } else {
                            ((MinionSolver)object).findSolutions(CmdFlags.getMinion(), (String)object2, this.m);
                        }
                    }
                }
                catch (IOException iOException) {
                    CmdFlags.errorExit("Could not run Minion: " + String.valueOf(iOException));
                }
                catch (InterruptedException interruptedException) {
                    CmdFlags.errorExit("Could not run Minion: " + String.valueOf(interruptedException));
                }
            }
        }
        return null;
    }

    public ArrayList<ASTNode> satPrepOutput() {
        this.decomposeSatEncodingFlat();
        TransformToFlatGecode transformToFlatGecode = new TransformToFlatGecode(this.m);
        this.m.transform(transformToFlatGecode);
        this.m.simplify();
        if (CmdFlags.test_solutions) {
            CmdFlags.checkSolModel = this.m.copy();
        }
        TransformCollectSATDirect transformCollectSATDirect = new TransformCollectSATDirect(this.m);
        transformCollectSATDirect.transform(this.m.constraints);
        if (this.m.objective != null) {
            transformCollectSATDirect.transform(this.m.objective);
        }
        CmdFlags.printlnIfVerbose("About to do m.setupSAT");
        boolean bl = this.m.setupSAT(transformCollectSATDirect.getVarsInConstraints());
        if (!bl) {
            this.createInfoFiles("SAT");
        }
        CmdFlags.printlnIfVerbose("Done m.setupSAT");
        TransformSATEncoding transformSATEncoding = new TransformSATEncoding(this.m);
        this.m.constraints = transformSATEncoding.transform(this.m.constraints);
        if (this.m.objective != null) {
            this.m.objective = transformSATEncoding.transform(this.m.objective);
        }
        if (!(this instanceof DominanceModelContainer)) {
            if (CmdFlags.dominanceRelation) {
                if (!CmdFlags.getRunSolver()) {
                    CmdFlags.errorExit("Solution Dominance mode only works on run-solver mode");
                }
                SATSolver sATSolver = this.createSolver();
                DominanceModelContainer dominanceModelContainer = new DominanceModelContainer(this.m, this.parameters, sATSolver);
                dominanceModelContainer.process();
            } else {
                this.satOutput();
            }
        }
        return null;
    }

    public ArrayList<ASTNode> smtPrepOutput() {
        TreeTransformer treeTransformer;
        this.decomposeSatEncodingFlat();
        if (CmdFlags.getUseFlat() || CmdFlags.getUseIDL() || CmdFlags.getUseUF()) {
            treeTransformer = new TransformToFlatGecode(this.m);
            this.m.transform(treeTransformer);
            this.m.simplify();
        }
        if (CmdFlags.test_solutions) {
            CmdFlags.checkSolModel = this.m.copy();
        }
        this.smtTransformations();
        this.smtConfig();
        treeTransformer = new TransformSATEncoding(this.m);
        this.m.constraints = ((TreeTransformerBottomUpNoWrapper)treeTransformer).transform(this.m.constraints);
        if (this.m.objective != null) {
            this.m.objective = ((TreeTransformerBottomUpNoWrapper)treeTransformer).transform(this.m.objective);
        }
        if (!(this instanceof DominanceModelContainer)) {
            if (CmdFlags.dominanceRelation) {
                if (!CmdFlags.getRunSolver()) {
                    CmdFlags.errorExit("Solution Dominance mode only works on run-solver mode");
                }
                SATSolver sATSolver = this.createSolver();
                DominanceModelContainer dominanceModelContainer = new DominanceModelContainer(this.m, this.parameters, sATSolver);
                dominanceModelContainer.process();
            } else {
                this.smtOutput();
            }
        }
        return null;
    }

    public void smtTransformations() {
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        if (CmdFlags.getUseIDL()) {
            treeTransformerBottomUpNoWrapper = new TransformShiftToIDL(this.m);
            treeTransformerBottomUpNoWrapper.transform(this.m.constraints);
        }
        treeTransformerBottomUpNoWrapper = new TransformCollectSMT(this.m);
        treeTransformerBottomUpNoWrapper.transform(this.m.constraints);
        if (CmdFlags.getUseBV()) {
            TransformSizeBV transformSizeBV = new TransformSizeBV(this.m);
            CmdFlags.setBvTraversal(true);
            transformSizeBV.transform(this.m.constraints);
            CmdFlags.setBvTraversal(false);
            BitVector.determineBits();
        }
    }

    public void smtConfig() {
        TransformCollectSATDirect transformCollectSATDirect = new TransformCollectSATDirect(this.m);
        transformCollectSATDirect.transform(this.m.constraints);
        CmdFlags.printlnIfVerbose("About to do m.setupSMT");
        boolean bl = this.m.setupSMT(transformCollectSATDirect.getVarsInConstraints());
        if (!bl) {
            this.createInfoFiles("SMT");
        }
        CmdFlags.printlnIfVerbose("Done m.setupSMT");
    }

    public ArrayList<ASTNode> pbPrepOutput() {
        this.decomposeSatEncodingFlat();
        TransformToFlatGecode transformToFlatGecode = new TransformToFlatGecode(this.m);
        this.m.transform(transformToFlatGecode);
        this.m.simplify();
        if (CmdFlags.test_solutions) {
            CmdFlags.checkSolModel = this.m.copy();
        }
        TransformCollectPBDirect transformCollectPBDirect = new TransformCollectPBDirect(this.m);
        transformCollectPBDirect.transform(this.m.constraints);
        if (this.m.objective != null) {
            transformCollectPBDirect.transform(this.m.objective);
        }
        CmdFlags.printlnIfVerbose("About to do m.setupPB");
        boolean bl = this.m.setupPB(transformCollectPBDirect.getVarsInConstraints());
        if (!bl) {
            this.createInfoFiles("PB");
        }
        CmdFlags.printlnIfVerbose("Done m.setupPB");
        TransformSATEncoding transformSATEncoding = new TransformSATEncoding(this.m);
        this.m.constraints = transformSATEncoding.transform(this.m.constraints);
        if (this.m.objective != null) {
            this.m.objective = transformSATEncoding.transform(this.m.objective);
        }
        this.pbOutput();
        return null;
    }

    private void destroyMatrices() {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
            for (Map.Entry<String, ASTNode> entry : hashMap.entrySet()) {
                if (!(entry.getValue() instanceof MatrixDomain) || this.m.global_symbols.getCategory(entry.getKey()) != 3) continue;
                TransformMatrixToAtoms transformMatrixToAtoms = new TransformMatrixToAtoms(entry.getKey(), this.m);
                this.m.transform(transformMatrixToAtoms);
                bl = true;
                continue block0;
            }
        }
    }

    private void removeMatrixIndexedMatrices() {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
            for (Map.Entry<String, ASTNode> entry : hashMap.entrySet()) {
                if (!(entry.getValue() instanceof MatrixDomain) || this.m.global_symbols.getCategory(entry.getKey()) != 3) continue;
                boolean bl2 = false;
                for (int i = 3; i < entry.getValue().numChildren(); ++i) {
                    if (!(entry.getValue().getChild(i) instanceof MatrixDomain)) continue;
                    bl2 = true;
                }
                if (!bl2) continue;
                TransformMatrixIndexedMatrix transformMatrixIndexedMatrix = new TransformMatrixIndexedMatrix(entry.getKey(), this.m);
                this.m.transform(transformMatrixIndexedMatrix);
                bl = true;
                continue block0;
            }
        }
    }

    private void fznFlattening() {
        Object object;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        TransformSumEqToSum transformSumEqToSum = new TransformSumEqToSum();
        this.m.transform(transformSumEqToSum);
        TransformReifyMin transformReifyMin = new TransformReifyMin(this.m);
        this.m.transform(transformReifyMin);
        TransformAbsReify transformAbsReify = new TransformAbsReify(this.m);
        this.m.transform(transformAbsReify);
        if (CmdFlags.getFlatzinctrans() && !CmdFlags.getGecodetrans()) {
            treeTransformerBottomUpNoWrapper = new TransformTableReify(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        if (!(!CmdFlags.getFlatzinctrans() || CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans() || CmdFlags.getOrtoolstrans() || CmdFlags.getChocotrans())) {
            treeTransformerBottomUpNoWrapper = new TransformTableToElement(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        this.m.simplify();
        treeTransformerBottomUpNoWrapper = new TransformCollectBool(this.m);
        this.m.constraints = treeTransformerBottomUpNoWrapper.transform(this.m.constraints);
        if (this.m.objective != null) {
            this.m.objective = treeTransformerBottomUpNoWrapper.transform(this.m.objective);
        }
        try {
            object = new FileOutputStream(CmdFlags.fznfile);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
            this.m.toFlatzinc(bufferedWriter);
            bufferedWriter.flush();
            ((FileOutputStream)object).getFD().sync();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Could not open file for flatzinc output.");
        }
        CmdFlags.println("Created output file " + CmdFlags.fznfile);
        if (CmdFlags.getRunSolver()) {
            object = new FznSolver();
            try {
                ((FznSolver)object).findSolutions(CmdFlags.getFznSolver(), CmdFlags.fznfile, this.m);
            }
            catch (IOException iOException) {
                CmdFlags.errorExit("Could not run flatzinc solver: " + String.valueOf(iOException));
            }
            catch (InterruptedException interruptedException) {
                CmdFlags.errorExit("Could not run flatzinc solver: " + String.valueOf(interruptedException));
            }
        }
    }

    private void minizincOutput() {
        Object object;
        TransformCollectBool transformCollectBool = new TransformCollectBool(this.m);
        this.m.transform(transformCollectBool);
        StringBuilder stringBuilder = new StringBuilder();
        this.m.toMinizinc(stringBuilder);
        try {
            object = new BufferedWriter(new FileWriter(CmdFlags.minizincfile));
            ((Writer)object).append(stringBuilder);
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Could not open file for minizinc output.");
        }
        CmdFlags.println("Created output file " + CmdFlags.minizincfile);
        if (CmdFlags.getRunSolver()) {
            object = new MznSolver();
            try {
                ((MznSolver)object).findSolutions("minizinc", CmdFlags.minizincfile, this.m);
            }
            catch (IOException iOException) {
                CmdFlags.errorExit("Could not run minizinc solver: " + String.valueOf(iOException));
            }
            catch (InterruptedException interruptedException) {
                CmdFlags.errorExit("Could not run minizinc solver: " + String.valueOf(interruptedException));
            }
        }
    }

    private void mipOutput() {
        this.decomposeMIPEncodingFlat();
        MIP mIP = new MIP(this.m);
        mIP.process();
        this.m.simplify();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(CmdFlags.mipfile);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            this.m.toMIP(bufferedWriter);
            bufferedWriter.flush();
            fileOutputStream.getFD().sync();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Could not open file for MIP output.");
        }
        CmdFlags.println("Created output file " + CmdFlags.mipfile);
    }

    private void decomposeSatEncoding() {
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        if (CmdFlags.getSMTtrans()) {
            if (CmdFlags.SMTDecompAlldiff()) {
                if (CmdFlags.SMTPairwiseAlldiff()) {
                    treeTransformerBottomUpNoWrapper = new TransformDecomposeAlldiff(this.m);
                    this.m.transform(treeTransformerBottomUpNoWrapper);
                } else {
                    treeTransformerBottomUpNoWrapper = new TransformAlldiffToSums(this.m);
                    this.m.transform(treeTransformerBottomUpNoWrapper);
                }
            }
        } else {
            treeTransformerBottomUpNoWrapper = new TransformAlldiffToSums(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        treeTransformerBottomUpNoWrapper = new TransformGCCToSums();
        this.m.transform(treeTransformerBottomUpNoWrapper);
        TransformCountToSum transformCountToSum = new TransformCountToSum();
        this.m.transform(transformCountToSum);
        TransformOccurrenceToSum transformOccurrenceToSum = new TransformOccurrenceToSum();
        this.m.transform(transformOccurrenceToSum);
        TransformDecomposeLex2 transformDecomposeLex2 = new TransformDecomposeLex2(this.m);
        this.m.transform(transformDecomposeLex2);
    }

    public void decomposeSatEncodingFlat() {
        TreeTransformerBottomUp treeTransformerBottomUp;
        TreeTransformer treeTransformer;
        TreeTransformerBottomUp treeTransformerBottomUp2;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        TransformDecomposeMinMax transformDecomposeMinMax = new TransformDecomposeMinMax(this.m);
        this.m.transform(transformDecomposeMinMax);
        if (CmdFlags.sat_matrixderef_decomp) {
            treeTransformerBottomUpNoWrapper = new TransformMatrixDerefDecomp(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        } else if (CmdFlags.sat_element_gac) {
            treeTransformerBottomUpNoWrapper = new TransformElementForSAT3(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        } else {
            treeTransformerBottomUpNoWrapper = new TransformElementForSAT2(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        treeTransformerBottomUpNoWrapper = new TransformSumForSAT();
        this.m.transform(treeTransformerBottomUpNoWrapper);
        if (CmdFlags.getSatPBEnc() != SumEnc.TREE || CmdFlags.getSatSumEnc() != SumEnc.TREE) {
            treeTransformerBottomUp2 = new TransformSumToAMOPB(this.m);
            this.m.transform(treeTransformerBottomUp2);
        }
        treeTransformerBottomUp2 = new TransformEncodeSumSpecial(this.m);
        this.m.simplify();
        if (!CmdFlags.getSMTtrans() && !CmdFlags.getPBtrans() || CmdFlags.getUseIDL() || CmdFlags.getUseUF()) {
            if (CmdFlags.getSMTtrans()) {
                treeTransformer = new TransformBreakupSum2SMT(this.m);
                this.m.transform(treeTransformer);
            } else {
                treeTransformer = new TransformBreakupSum2(this.m);
                this.m.transform(treeTransformer);
            }
        }
        treeTransformer = new TransformSumEq(false);
        this.m.transform(treeTransformer);
        this.m.transform(treeTransformerBottomUpNoWrapper);
        if (CmdFlags.getSattrans() && !CmdFlags.getSMTtrans() && CmdFlags.use_polarity) {
            treeTransformerBottomUp = new TransformToFlatPol(this.m);
            this.m.transform(treeTransformerBottomUp);
        }
        if (!CmdFlags.getSMTtrans() || CmdFlags.getUseFlat() || CmdFlags.getUseIDL() || CmdFlags.getUseUF()) {
            if (CmdFlags.getSMTtrans()) {
                treeTransformerBottomUp = new TransformToFlatSMT(this.m, false);
                this.m.transform(treeTransformerBottomUp);
            } else {
                treeTransformerBottomUp = new TransformToFlat(this.m, false);
                this.m.transform(treeTransformerBottomUp);
            }
        }
    }

    private void satOutput() {
        boolean bl;
        if (CmdFlags.getMaxsattrans() && CmdFlags.maxsat_lower_bound) {
            System.out.println("MaxSAT lower bound of objective: " + this.m.objective.getChild((int)0).getBounds().lower);
        }
        if (!(bl = this.m.toSAT())) {
            this.createInfoFiles("SAT");
        }
        if (!CmdFlags.getRunSolver()) {
            if (CmdFlags.interactiveSolver) {
                CmdFlags.errorExit("Interactive Solvers only works on run-solver mode");
            }
        } else if (!CmdFlags.dominanceRelation) {
            File file;
            if (!CmdFlags.interactiveSolver) {
                CmdFlags.println("Created output SAT file " + CmdFlags.satfile);
            }
            SATSolver sATSolver = this.createSolver();
            try {
                sATSolver.findSolutions(CmdFlags.getSatSolver(), CmdFlags.satfile, this.m);
            }
            catch (Exception exception) {
                CmdFlags.errorExit("Could not run SAT solver: " + String.valueOf(exception));
            }
            if (!CmdFlags.getKeepDimacsFile() && (file = new File(CmdFlags.satfile)).exists()) {
                file.delete();
            }
        }
    }

    protected void smtOutput() {
        boolean bl = this.m.toSMT();
        if (!bl) {
            this.createInfoFiles("SMT");
        }
        if (!CmdFlags.interactiveSolver) {
            CmdFlags.println("Created output SMT file " + CmdFlags.smtfile);
        }
        if (!CmdFlags.dominanceRelation && CmdFlags.getRunSolver()) {
            File file;
            SATSolver sATSolver = this.createSolver();
            try {
                sATSolver.findSolutions(CmdFlags.getSMTSolverPath(), CmdFlags.smtfile, this.m);
            }
            catch (Exception exception) {
                CmdFlags.errorExit("Could not run SMT solver: " + String.valueOf(exception));
            }
            if (!CmdFlags.getKeepDimacsFile() && (file = new File(CmdFlags.smtfile)).exists()) {
                file.delete();
            }
        }
    }

    private void decomposeMIPEncoding() {
        TransformAlldiffToSums transformAlldiffToSums = new TransformAlldiffToSums(this.m);
        this.m.transform(transformAlldiffToSums);
        TransformGCCToSums transformGCCToSums = new TransformGCCToSums();
        this.m.transform(transformGCCToSums);
        TransformCountToSum transformCountToSum = new TransformCountToSum();
        this.m.transform(transformCountToSum);
        TransformOccurrenceToSum transformOccurrenceToSum = new TransformOccurrenceToSum();
        this.m.transform(transformOccurrenceToSum);
        TransformDecomposeLex2 transformDecomposeLex2 = new TransformDecomposeLex2(this.m);
        this.m.transform(transformDecomposeLex2);
    }

    private void decomposeMIPEncodingFlat() {
        TransformMatrixDerefDecomp transformMatrixDerefDecomp = new TransformMatrixDerefDecomp(this.m);
        this.m.transform(transformMatrixDerefDecomp);
    }

    private SATSolver createSolver() {
        SATSolver sATSolver;
        if (CmdFlags.interactiveSolver) {
            if (!CmdFlags.getRunSolver()) {
                CmdFlags.errorExit("Interactive Solvers only works on run-solver mode");
            }
            sATSolver = CmdFlags.getSMTtrans() ? ((InteractiveSMT)this.m.satModel).getInteractiveSolver() : ((InteractiveSat)this.m.satModel).getInteractiveSolver();
        } else if (CmdFlags.getMaxsattrans()) {
            sATSolver = new WMaxCDCLSolver(this.m);
        } else if (CmdFlags.getSMTtrans()) {
            if (CmdFlags.usingZ3()) {
                sATSolver = new Z3Solver(this.m);
            } else if (CmdFlags.usingBoolector()) {
                sATSolver = new BoolectorSolver(this.m);
            } else {
                assert (CmdFlags.usingYices2());
                sATSolver = new YicesSolver(this.m);
            }
        } else if (CmdFlags.getSatFamily().equals("minisat")) {
            sATSolver = new MinisatSATSolver(this.m);
        } else if (CmdFlags.getSatFamily().equals("glucose")) {
            sATSolver = new GlucoseSATSolver(this.m);
        } else if (CmdFlags.getSatFamily().equals("cadical") || CmdFlags.getSatFamily().equals("kissat")) {
            sATSolver = new CadicalSATSolver(this.m);
        } else if (CmdFlags.getSatFamily().equals("nbc_minisat_all") || CmdFlags.getSatFamily().equals("bc_minisat_all")) {
            sATSolver = new AllMinisatSATSolver(this.m);
        } else {
            assert (CmdFlags.getSatFamily().equals("lingeling"));
            sATSolver = new LingelingSATSolver(this.m);
        }
        return sATSolver;
    }

    private void pbOutput() {
        boolean bl = this.m.toPB();
        if (!bl) {
            this.createInfoFiles("PB");
        }
        CmdFlags.println("Created output PB file " + CmdFlags.pbfile);
        if (CmdFlags.getRunSolver()) {
            File file;
            assert (false);
            SATSolver sATSolver = this.createSolver();
            try {
                sATSolver.findSolutions(CmdFlags.getSatSolver(), CmdFlags.satfile, this.m);
            }
            catch (Exception exception) {
                CmdFlags.errorExit("Could not run SAT solver: " + String.valueOf(exception));
            }
            if (!CmdFlags.getKeepDimacsFile() && (file = new File(CmdFlags.pbfile)).exists()) {
                file.delete();
            }
        }
    }

    private void createInfoFiles(String string) {
        Stats stats = new Stats();
        stats.putValue("SavileRowTotalTime", String.valueOf(((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0));
        stats.putValue("SavileRowClauseOut", "1");
        stats.makeInfoFiles();
        CmdFlags.errorExit("Failed when writing " + string + " encoding to file.");
    }

    private void processGiven(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getChild(0);
        String string = ((Identifier)aSTNode2).getName();
        ASTNode aSTNode3 = aSTNode.getChild(1);
        if (this.m.global_symbols.hasVariable(string)) {
            CmdFlags.errorExit("Symbol " + string + " declared more than once.");
        }
        this.m.global_symbols.newVariable(string, aSTNode3, 1);
        int n = 0;
        ASTNode aSTNode4 = null;
        for (ASTNode aSTNode5 : this.parameters) {
            if (!((Identifier)((Letting)aSTNode5).getChildren().get(0)).getName().equals(string)) continue;
            aSTNode4 = aSTNode5;
            ++n;
        }
        if (n != 1) {
            CmdFlags.errorExit("Parameter ('given') variable " + string + " is defined " + n + " times in parameter file.");
        }
        this.processLetting(aSTNode4);
        this.parameters.remove(aSTNode4);
    }

    private void processLetting(ASTNode aSTNode) {
        Serializable serializable;
        ASTNode aSTNode2;
        assert (aSTNode instanceof Letting);
        ASTNode aSTNode3 = aSTNode.getChild(0);
        String string = aSTNode3.toString();
        if (this.m.global_symbols.hasVariable(string) && this.m.global_symbols.getCategory(string) != 1) {
            CmdFlags.errorExit("Symbol " + string + " declared more than once.");
        }
        if ((aSTNode2 = aSTNode.getChild(1)).getCategory() > 2) {
            CmdFlags.errorExit("In statement: " + String.valueOf(aSTNode), "Right-hand side contains an identifier that is not a constant or parameter.");
        }
        if (this.m.global_symbols.getDomain(string) != null) {
            serializable = this.m.global_symbols.getDomain(string);
            if (((ASTNode)serializable).isSet()) {
                if (aSTNode2.getDimension() > 0 || ((ASTNode)serializable).isBooleanSet() != aSTNode2.isRelation()) {
                    CmdFlags.errorExit("For parameter " + string + ", type of value in parameter file does not match type in given statement.");
                }
            } else {
                assert (serializable instanceof MatrixDomain);
                if (aSTNode2.getDimension() == 0) {
                    CmdFlags.errorExit("For parameter " + string + ", type of value in parameter file does not match type in given statement.");
                }
            }
        }
        if (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix) {
            this.m.cmstore.newConstantMatrix(string, aSTNode2);
            serializable = this.m.cmstore.makeLettingsConstantMatrix(string);
            Iterator iterator = ((ArrayList)serializable).iterator();
            while (iterator.hasNext()) {
                ASTNode aSTNode4 = (ASTNode)iterator.next();
                this.processLetting(aSTNode4);
            }
            this.m.cmstore.correctIndicesConstantMatrix(string, true);
        } else {
            this.m.substitute(aSTNode.getChild(0), aSTNode2.copy());
        }
    }

    private void processFind(ASTNode aSTNode) {
        assert (aSTNode instanceof Find);
        ASTNode aSTNode2 = aSTNode.getChild(0);
        String string = ((Identifier)aSTNode2).getName();
        if (this.m.global_symbols.hasVariable(string)) {
            CmdFlags.errorExit("Symbol " + string + " declared more than once.");
        }
        if (aSTNode.getChild(1).getCategory() > 2) {
            CmdFlags.errorExit("In statement : " + String.valueOf(aSTNode), "Right-hand side contains an identifier that is not a constant or parameter.");
        }
        this.m.global_symbols.newVariable(string, aSTNode.getChild(1), 3);
    }

    private void processWhere(ASTNode aSTNode) {
        if ((aSTNode = aSTNode.getChild(0)).getCategory() > 2) {
            CmdFlags.errorExit("In statement: where " + String.valueOf(aSTNode), "Contains an identifier that is not a constant or parameter.");
        }
        if (!aSTNode.equals(new BooleanConstant(true))) {
            CmdFlags.errorExit("In statement: where " + String.valueOf(aSTNode), "Does not evaluate to true.");
        }
    }

    private ASTNode fixIndexDomainsLetting(ASTNode aSTNode) {
        ASTNode aSTNode2;
        if (aSTNode.numChildren() == 3 && ((aSTNode2 = aSTNode.getChild(1)) instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix)) {
            Pair<ASTNode, Boolean> pair = ConstantMatrixStore.fixIndicesConstantMatrix(aSTNode.getChild(2), aSTNode2.copy());
            if (pair.getSecond().booleanValue()) {
                CmdFlags.warning("The index domains in the matrix literal do not match");
                CmdFlags.warning("the given matrix domain in the following letting statement:");
                CmdFlags.warning(String.valueOf(aSTNode));
            }
            return new Letting(aSTNode.getChild(0), pair.getFirst());
        }
        return aSTNode;
    }

    public ModelContainer copy() {
        Model model = this.m.copy();
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        TransformFixSTRef transformFixSTRef = new TransformFixSTRef(model);
        for (int i = 0; i < this.parameters.size(); ++i) {
            arrayList.add(transformFixSTRef.transform(this.parameters.get(i)));
        }
        return new ModelContainer(model, arrayList);
    }

    public void writeModelAsJSON(Model model) {
        SymmetryBreaker symmetryBreaker = new SymmetryBreaker();
        symmetryBreaker.detectAndBreakSymmetries(model);
        model.simplify();
    }
}

