/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.Intpair;
import savilerow.model.SymbolTable;

public class IfThenElse
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public IfThenElse(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3);
    }

    public IfThenElse(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
        assert (aSTNodeArray.length == 3);
    }

    @Override
    public ASTNode copy() {
        return new IfThenElse(this.getChildrenArray());
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(1).isNumerical() || this.getChild(2).isNumerical();
    }

    @Override
    public boolean isRelation() {
        return this.getChild(1).isRelation() && this.getChild(2).isRelation();
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant()) {
            long l = this.getChild(0).getValue();
            if (l == 0L) {
                this.getChild(2).setParent(null);
                return this.getChild(2);
            }
            this.getChild(1).setParent(null);
            return this.getChild(1);
        }
        return null;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() > 0) {
                CmdFlags.println("ERROR: Unexpected matrix in 'if': " + String.valueOf(this));
                return false;
            }
            if (this.getChild(i).getCategory() <= 2) continue;
            CmdFlags.println("ERROR: 'if' cannot contain decision variables: " + String.valueOf(this));
            return false;
        }
        if (!this.getChild(0).isRelation()) {
            CmdFlags.println("ERROR: First argument of function 'if' must be boolean: " + String.valueOf(this));
            return false;
        }
        if (!this.getChild(1).isRelation() && !this.getChild(1).isNumerical()) {
            CmdFlags.println("ERROR: Second argument of function 'if' must be integer or boolean: " + String.valueOf(this));
            return false;
        }
        if (!this.getChild(2).isRelation() && !this.getChild(2).isNumerical()) {
            CmdFlags.println("ERROR: Third argument of function 'if' must be integer or boolean: " + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(1).getBounds();
        Intpair intpair2 = this.getChild(2).getBounds();
        if (intpair2.lower < intpair.lower) {
            intpair.lower = intpair2.lower;
        }
        if (intpair2.upper > intpair.upper) {
            intpair.upper = intpair2.upper;
        }
        return intpair;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(1).getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = this.getChild(2).getIntervalSetExp();
        return Intpair.union(arrayList, arrayList2);
    }

    @Override
    public String toString() {
        return this.generic_to_string("if");
    }
}

