/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.CommAssocFactory;
import savilerow.expression.MultiplyMapper;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.ToVariable;
import savilerow.expression.WeightedSum;
import savilerow.model.Model;

public class ACCSEActiveSum2 {
    private LinkedHashMap<PairASTNode, ArrayList<Pair<Long, ASTNode>>> exp;
    private HashMap<ASTNode, Long> expression_counts;
    public int numcse;
    public int countcse;
    public int totallength;
    public boolean active_ac_cs_found;

    public void flattenCSEs(Model model) {
        this.numcse = 0;
        this.countcse = 0;
        this.totallength = 0;
        this.active_ac_cs_found = false;
        this.exp = new LinkedHashMap();
        this.expression_counts = new HashMap();
        assert (CmdFlags.accse_heuristic == 1);
        this.populate_expression_counts(model.constraints);
        this.populate_exp(model.constraints);
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        while (!this.exp.isEmpty()) {
            PairASTNode pairASTNode = this.heuristic();
            if (this.exp.isEmpty()) break;
            ArrayList<Pair<Long, ASTNode>> arrayList2 = this.exp.get(pairASTNode);
            this.exp.remove(pairASTNode);
            if (arrayList2.size() < 2) continue;
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            arrayList3.add(pairASTNode.e1.getChild(0));
            arrayList3.add(pairASTNode.e2.getChild(0));
            ArrayList<Long> arrayList4 = new ArrayList<Long>();
            arrayList4.add(pairASTNode.e1.getChild(1).getValue());
            arrayList4.add(pairASTNode.e2.getChild(1).getValue());
            this.growCommonSet(arrayList3, arrayList4, arrayList2);
            ASTNode aSTNode = CommAssocFactory.makeCommAssoc("+", arrayList3, arrayList4);
            ASTNode aSTNode2 = model.global_symbols.newAuxHelper(aSTNode);
            ToVariable toVariable = new ToVariable(aSTNode, aSTNode2);
            System.out.println("AC-CS: " + String.valueOf(aSTNode));
            for (Pair<Long, ASTNode> pair : arrayList2) {
                int n = pair.getSecond().getChildNo();
                ArrayList<ASTNode> arrayList5 = pair.getSecond().getChildren();
                ArrayList<Long> arrayList6 = ((WeightedSum)pair.getSecond()).getWeights();
                long l = pair.getFirst();
                if (l != 1L) {
                    this.active_ac_cs_found = true;
                }
                for (int i = 0; i < arrayList3.size(); ++i) {
                    int n2 = arrayList5.indexOf(arrayList3.get(i));
                    arrayList5.set(n2, arrayList5.get(arrayList5.size() - 1));
                    arrayList5.remove(arrayList5.size() - 1);
                    arrayList6.set(n2, arrayList6.get(arrayList6.size() - 1));
                    arrayList6.remove(arrayList6.size() - 1);
                }
                arrayList5.add(aSTNode2.copy());
                arrayList6.add(l);
                ASTNode aSTNode3 = CommAssocFactory.makeCommAssoc("+", arrayList5, arrayList6);
                this.populate_exp(aSTNode3);
                System.out.println("  Replacing " + String.valueOf(pair) + "   with   " + String.valueOf(aSTNode3));
                pair.getSecond().getParent().setChild(n, aSTNode3);
            }
            if (this.numcse > 1) {
                // empty if block
            }
            this.populate_exp(toVariable);
            model.global_symbols.auxVarRepresentsConstraint(aSTNode2.toString(), "CSE-ACCSE-SUM-Active2: " + arrayList2.size() + " occurrences of: " + aSTNode.toString());
            arrayList.add(toVariable);
            ++this.numcse;
            this.countcse += arrayList2.size();
            this.totallength += arrayList3.size() * arrayList2.size();
        }
        model.constraints.getChild(0).setParent(null);
        arrayList.add(model.constraints.getChild(0));
        model.constraints.setChild(0, new And(arrayList));
    }

    private void growCommonSet(ArrayList<ASTNode> arrayList, ArrayList<Long> arrayList2, ArrayList<Pair<Long, ASTNode>> arrayList3) {
    }

    private void populate_exp(ASTNode aSTNode) {
        int n;
        if (aSTNode instanceof WeightedSum) {
            for (n = 0; n < aSTNode.numChildren(); ++n) {
                ASTNode aSTNode2 = aSTNode.getChild(n);
                if (this.expression_counts.containsKey(aSTNode2) && this.expression_counts.get(aSTNode2) <= 1L) continue;
                for (int i = n + 1; i < aSTNode.numChildren(); ++i) {
                    ASTNode aSTNode3;
                    ASTNode aSTNode4 = aSTNode.getChild(i);
                    if (this.expression_counts.containsKey(aSTNode4) && this.expression_counts.get(aSTNode4) <= 1L) continue;
                    long l = ((WeightedSum)aSTNode).getWeight(n);
                    long l2 = ((WeightedSum)aSTNode).getWeight(i);
                    BigInteger bigInteger = BigInteger.valueOf(l).gcd(BigInteger.valueOf(l2));
                    long l3 = bigInteger.longValue();
                    if (aSTNode2.hashCode() > aSTNode4.hashCode()) {
                        aSTNode3 = aSTNode4;
                        aSTNode4 = aSTNode2;
                        aSTNode2 = aSTNode3;
                        long l4 = l2;
                        l2 = l;
                        l = l4;
                    }
                    if (l / l3 < 0L) {
                        l3 = -l3;
                    }
                    aSTNode3 = new MultiplyMapper(aSTNode2, NumberConstant.make(l / l3));
                    MultiplyMapper multiplyMapper = new MultiplyMapper(aSTNode4, NumberConstant.make(l2 / l3));
                    PairASTNode pairASTNode = new PairASTNode(aSTNode3, multiplyMapper);
                    System.out.println("Adding mapping: " + String.valueOf(pairASTNode) + " ---->  " + String.valueOf(aSTNode));
                    if (this.exp.containsKey(pairASTNode)) {
                        this.exp.get(pairASTNode).add(new Pair<Long, ASTNode>(l3, aSTNode));
                        continue;
                    }
                    ArrayList<Pair<Long, ASTNode>> arrayList = new ArrayList<Pair<Long, ASTNode>>();
                    arrayList.add(new Pair<Long, ASTNode>(l3, aSTNode));
                    this.exp.put(pairASTNode, arrayList);
                }
            }
        }
        for (n = 0; n < aSTNode.numChildren(); ++n) {
            this.populate_exp(aSTNode.getChild(n));
        }
    }

    public void filterlist(ArrayList<Pair<Long, ASTNode>> arrayList) {
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (!arrayList.get(i).getSecond().isDetached()) continue;
            arrayList.set(i, arrayList.get(arrayList.size() - 1));
            arrayList.remove(arrayList.size() - 1);
        }
    }

    private PairASTNode heuristic() {
        Object object;
        Iterator<Map.Entry<PairASTNode, ArrayList<Pair<Long, ASTNode>>>> iterator = this.exp.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            PairASTNode pairASTNode = object.getKey();
            ArrayList<Pair<Long, ASTNode>> object2 = object.getValue();
            this.filterlist(object2);
            if (object2.size() >= 2) continue;
            iterator.remove();
        }
        object = null;
        int n = -1;
        for (Map.Entry<PairASTNode, ArrayList<Pair<Long, ASTNode>>> entry : this.exp.entrySet()) {
            PairASTNode pairASTNode = entry.getKey();
            ArrayList<Pair<Long, ASTNode>> arrayList = entry.getValue();
            if (arrayList.size() <= n) continue;
            object = pairASTNode;
            n = arrayList.size();
        }
        return object;
    }

    private void populate_expression_counts(ASTNode aSTNode) {
        int n;
        if (aSTNode instanceof WeightedSum) {
            for (n = 0; n < aSTNode.numChildren(); ++n) {
                ASTNode aSTNode2 = aSTNode.getChild(n);
                if (this.expression_counts.containsKey(aSTNode2)) {
                    this.expression_counts.put(aSTNode2, this.expression_counts.get(aSTNode2) + 1L);
                    continue;
                }
                this.expression_counts.put(aSTNode2, 1L);
            }
        }
        for (n = 0; n < aSTNode.numChildren(); ++n) {
            this.populate_expression_counts(aSTNode.getChild(n));
        }
    }
}

