/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import savilerow.CmdFlags;
import savilerow.Constants;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.UnaryMinus;
import savilerow.model.SMT;
import savilerow.model.Sat;

public class Divide
extends BinOp {
    public static final long serialVersionUID = 1L;

    public Divide(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Divide(this.getChild(0), this.getChild(1));
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            long l = this.getChild(0).getValue();
            long l2 = this.getChild(1).getValue();
            if (l2 == 0L) {
                return null;
            }
            if (l % l2 != 0L && l2 < 0L) {
                CmdFlags.warning("Result of integer division is not an integer: " + String.valueOf(this) + ". Using floor(a/b) semantics.");
            }
            return NumberConstant.make(Divide.div(l, l2));
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 1L) {
            return this.getChild(0);
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == -1L) {
            return new UnaryMinus(this.getChild(0));
        }
        if (this.getChild(0).isConstant() && this.getChild(0).getValue() == 0L) {
            return NumberConstant.make(0L);
        }
        return null;
    }

    public static long div(long l, long l2) {
        try {
            BigInteger[] bigIntegerArray = BigInteger.valueOf(l).divideAndRemainder(BigInteger.valueOf(l2));
            if (bigIntegerArray[1].compareTo(BigInteger.valueOf(0L)) != 0 && (l < 0L && l2 > 0L || l > 0L && l2 < 0L)) {
                bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(-1L));
            }
            return Intpair.BigIntegerToLong(bigIntegerArray[0]);
        }
        catch (ArithmeticException arithmeticException) {
            CmdFlags.println("WARNING: Division by zero. This is a bug, please report it.");
            return 0L;
        }
    }

    public static long divceil(long l, long l2) {
        try {
            BigInteger[] bigIntegerArray = BigInteger.valueOf(l).divideAndRemainder(BigInteger.valueOf(l2));
            if (bigIntegerArray[1].compareTo(BigInteger.valueOf(0L)) != 0 && (l > 0L && l2 > 0L || l < 0L && l2 < 0L)) {
                bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(1L));
            }
            return Intpair.BigIntegerToLong(bigIntegerArray[0]);
        }
        catch (ArithmeticException arithmeticException) {
            CmdFlags.println("WARNING: Division by zero. This is a bug, please report it.");
            return 0L;
        }
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        ArrayList<Long> arrayList = new ArrayList<Long>(8);
        if (intpair2.lower != 0L) {
            arrayList.add(Divide.div(intpair.lower, intpair2.lower));
            arrayList.add(Divide.div(intpair.upper, intpair2.lower));
        }
        if (intpair2.upper != 0L) {
            arrayList.add(Divide.div(intpair.lower, intpair2.upper));
            arrayList.add(Divide.div(intpair.upper, intpair2.upper));
        }
        if (intpair2.lower <= -1L && intpair2.upper >= -1L) {
            arrayList.add(Divide.div(intpair.lower, -1L));
            arrayList.add(Divide.div(intpair.upper, -1L));
        }
        if (intpair2.lower <= 1L && intpair2.upper >= 1L) {
            arrayList.add(Divide.div(intpair.lower, 1L));
            arrayList.add(Divide.div(intpair.upper, 1L));
        }
        intpair.lower = (Long)Collections.min(arrayList);
        intpair.upper = (Long)Collections.max(arrayList);
        return intpair;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = this.getChild(1).getIntervalSetExp();
        if (Intpair.numValues(arrayList) * Intpair.numValues(arrayList2) > (long)Constants.intervallim) {
            return super.getIntervalSetExp();
        }
        ArrayList<Intpair> arrayList3 = new ArrayList<Intpair>();
        for (int i = 0; i < arrayList.size(); ++i) {
            for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                for (int k = 0; k < arrayList2.size(); ++k) {
                    for (long i2 = arrayList2.get((int)k).lower; i2 <= arrayList2.get((int)k).upper; ++i2) {
                        long l = Divide.div(j, i2);
                        arrayList3.add(new Intpair(l, l));
                    }
                }
            }
        }
        Intpair.normalise(arrayList3);
        return arrayList3;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("div(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public String toString() {
        return "(" + String.valueOf(this.getChild(0)) + "/" + String.valueOf(this.getChild(1)) + ")";
    }

    @Override
    public void toFlatzincWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("constraint int_div(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        aSTNode.toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (!bl);
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(" div ");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.ternaryEncoding(this, aSTNode);
    }

    @Override
    public boolean test(long l, long l2, long l3) {
        return Divide.div(l, l2) == l3;
    }

    @Override
    public long func(long l, long l2) {
        return Divide.div(l, l2);
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseBV() || CmdFlags.getUseNIA();
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        if (CmdFlags.getUseBV()) {
            return "(bvsdiv " + this.getChild(0).smtEncodeBV(sMT) + " " + this.getChild(1).smtEncodeBV(sMT) + ")";
        }
        return null;
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        if (CmdFlags.getUseNIA()) {
            return "(div " + this.getChild(0).smtEncodeInt(sMT) + " " + this.getChild(1).smtEncodeInt(sMT) + ")";
        }
        return null;
    }
}

