/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Intpair;
import savilerow.expression.MatrixDeref;
import savilerow.expression.NumberConstant;
import savilerow.model.SymbolTable;

public class ElementId
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public ElementId(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new ElementId(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            System.out.println("ERROR: Dimension mismatch in elementId: " + String.valueOf(this));
            return false;
        }
        if (!this.getChild(0).isNumerical() && !this.getChild(0).isRelation()) {
            System.out.println("ERROR: Numerical or boolean matrix required in elementId: " + String.valueOf(this));
            return false;
        }
        if (!this.getChild(1).isNumerical() && !this.getChild(1).isRelation()) {
            System.out.println("ERROR: Numerical index required in elementId: " + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if (aSTNode.isMatrixLiteral()) {
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
            ArrayList<Intpair> arrayList2 = aSTNode.getIndexDomains().get(0).getIntervalSet();
            ArrayList<Intpair> arrayList3 = this.getChild(1).getIntervalSetExp();
            if (arrayList3 != null && arrayList2 != null) {
                if (arrayList3.size() == 0) {
                    return null;
                }
                ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>();
                for (int i = 0; i < arrayList3.size(); ++i) {
                    for (long j = arrayList3.get((int)i).lower; j <= arrayList3.get((int)i).upper; ++j) {
                        if (Intpair.contains(arrayList2, j)) {
                            long l = Intpair.location(arrayList2, j);
                            arrayList4.add(arrayList.get((int)l));
                            continue;
                        }
                        arrayList4.add(NumberConstant.make(j));
                    }
                }
                return new MatrixDeref(CompoundMatrix.make(Intpair.makeDomain(arrayList3, false), arrayList4, false), this.getChild(1));
            }
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        return intpair.union(intpair2);
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        return Intpair.union(this.getChild(0).getIntervalSetExp(), this.getChild(1).getIntervalSetExp());
    }

    @Override
    public String toString() {
        return "elementId(" + String.valueOf(this.getChild(0)) + "," + String.valueOf(this.getChild(1)) + ")";
    }
}

