/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.model.SymbolTable;

public class Inverse
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Inverse(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Inverse(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() != 1 || this.getChild(1).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in inverse constraint: " + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.generic_to_string("inverse");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        long l = this.getChild((int)0).getChild((int)0).getBounds().lower;
        long l2 = this.getChild((int)1).getChild((int)0).getBounds().lower;
        if (CmdFlags.getOrtoolstrans()) {
            bufferedWriter.append("constraint ortools_inverse(");
            this.getChild(0).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(",");
            this.getChild(1).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(",");
            bufferedWriter.append(String.valueOf(l));
            bufferedWriter.append(",");
            bufferedWriter.append(String.valueOf(l2));
            bufferedWriter.append(");");
        } else {
            if (CmdFlags.getChocotrans()) {
                bufferedWriter.append("constraint fzn_inverse(");
            } else {
                bufferedWriter.append("constraint inverse_offsets(");
            }
            this.getChild(0).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(",");
            bufferedWriter.append(String.valueOf(l2));
            bufferedWriter.append(",");
            this.getChild(1).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(",");
            bufferedWriter.append(String.valueOf(l));
            bufferedWriter.append(");");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("inverse(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }
}

