/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Table;
import savilerow.model.Model;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class NegativeTable
extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    protected transient Model m;

    public NegativeTable(Model model, ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
        this.m = model;
    }

    @Override
    public boolean hasModel() {
        return true;
    }

    @Override
    public Model getModel() {
        return this.m;
    }

    @Override
    public void setModel(Model model) {
        this.m = model;
    }

    @Override
    public ASTNode copy() {
        return new NegativeTable(this.m, this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (!this.getChild(1).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: First argument of negativetable should be 1-dimensional matrix: " + String.valueOf(this));
            return false;
        }
        if (this.getChild(1).getDimension() != 2) {
            CmdFlags.println("ERROR: Second argument of negativetable should be 2-dimensional matrix: " + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if ((aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) && this.getChild(1).getCategory() == 0) {
            ASTNode aSTNode2 = this.getChildConst(1);
            if (aSTNode2 == this.getChild(1) && (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix)) {
                if (aSTNode2 instanceof EmptyMatrix) {
                    return new BooleanConstant(true);
                }
                ASTNode aSTNode3 = this.m.cmstore.newConstantMatrixDedup(aSTNode2);
                this.getChild(0).setParent(null);
                return new NegativeTable(this.m, this.getChild(0), aSTNode3);
            }
            if (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix) {
                if (aSTNode2 instanceof EmptyMatrix) {
                    return new BooleanConstant(true);
                }
                if (aSTNode instanceof EmptyMatrix) {
                    return new BooleanConstant(false);
                }
                ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n;
                    if (!arrayList.get(i).isConstant()) continue;
                    long l = arrayList.get(i).getValue();
                    arrayList.remove(i);
                    ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                    for (n = 1; n < aSTNode2.numChildren(); ++n) {
                        ASTNode aSTNode4 = aSTNode2.getChildConst(n);
                        if (!(aSTNode4 instanceof CompoundMatrix)) {
                            return null;
                        }
                        if (aSTNode4.getChild(i + 1).getValue() != l) continue;
                        ArrayList<ASTNode> arrayList3 = aSTNode2.getChildConst(n).getChildren(1);
                        arrayList3.remove(i);
                        arrayList2.add(CompoundMatrix.make(arrayList3));
                    }
                    if (aSTNode == this.getChild(0)) {
                        for (n = 0; n < arrayList.size(); ++n) {
                            arrayList.get(n).setParent(null);
                        }
                    }
                    return new NegativeTable(this.m, CompoundMatrix.make(arrayList), CompoundMatrix.make(arrayList2));
                }
            }
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new Table(this.m, this.getChild(0), this.getChild(1));
    }

    @Override
    public String toString() {
        return this.generic_to_string("!table");
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("negativetable(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
            ArrayList<ASTNode> arrayList = this.getChild(1).getChildren();
            bufferedWriter.append("{");
            for (int i = 1; i < arrayList.size(); ++i) {
                ArrayList<ASTNode> arrayList2 = arrayList.get(i).getChildren();
                bufferedWriter.append("<");
                for (int j = 1; j < arrayList2.size(); ++j) {
                    arrayList2.get(j).toMinion(bufferedWriter, false);
                    if (j >= arrayList2.size() - 1) continue;
                    bufferedWriter.append(", ");
                }
                bufferedWriter.append(">");
                if (i >= arrayList.size() - 1) continue;
                bufferedWriter.append(", ");
            }
            bufferedWriter.append("}");
        } else {
            this.getChild(1).toMinion(bufferedWriter, false);
        }
        bufferedWriter.append(")");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("constraint table_int_reif(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",[");
        ASTNode aSTNode = this.getChildConst(1);
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            for (int j = 1; j < aSTNode.getChild(i).numChildren(); ++j) {
                aSTNode.getChild(i).getChild(j).toFlatzinc(bufferedWriter, false);
                bufferedWriter.append(",");
            }
        }
        bufferedWriter.append("], false);");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(not table(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
            stringBuilder.append("[");
            for (int i = 1; i < this.getChild(1).numChildren(); ++i) {
                ASTNode aSTNode = this.getChild(1).getChild(i);
                stringBuilder.append("| ");
                for (int j = 1; j < aSTNode.numChildren(); ++j) {
                    aSTNode.getChild(j).toMinizinc(stringBuilder, false);
                    if (j >= aSTNode.numChildren() - 1) continue;
                    stringBuilder.append(",");
                }
            }
            stringBuilder.append("|]");
        } else {
            this.getChild(1).toMinizinc(stringBuilder, false);
        }
        stringBuilder.append("))");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        ASTNode aSTNode = this.getChild(0);
        ASTNode aSTNode2 = this.getChildConst(1);
        for (int i = 1; i < aSTNode2.numChildren(); ++i) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int j = 1; j < aSTNode2.getChild(i).numChildren(); ++j) {
                long l = aSTNode.getChild(j).directEncode(sat, aSTNode2.getChild(i).getChild(j).getValue());
                arrayList.add(-l);
            }
            sat.addClause(arrayList);
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        ASTNode aSTNode = this.getChild(0);
        ASTNode aSTNode2 = this.getChildConst(1);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 1; i < aSTNode2.numChildren(); ++i) {
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (int j = 1; j < aSTNode2.getChild(i).numChildren(); ++j) {
                long l2 = aSTNode.getChild(j).directEncode(sat, aSTNode2.getChild(i).getChild(j).getValue());
                arrayList2.add(-l2);
            }
            Long l3 = sat.createAuxSATVariable();
            arrayList.add(l3);
            sat.addClauseReified(arrayList2, -l3.longValue());
        }
        sat.addClauseReified(arrayList, -l);
    }
}

