/*
 * Decompiled with CFR 0.152.
 */
package savilerow.model;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.BooleanDomain;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.EmptyRange;
import savilerow.expression.Identifier;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intersect;
import savilerow.expression.Intpair;
import savilerow.expression.Letting;
import savilerow.expression.MatrixDomain;
import savilerow.expression.NumberConstant;
import savilerow.expression.Range;
import savilerow.expression.SimpleDomain;
import savilerow.model.Model;
import savilerow.treetransformer.TransformSimplify;

public class ConstantMatrixStore {
    private HashMap<String, ASTNode> cm;
    private HashSet<String> already_written;
    private HashMap<ASTNode, HashSet<String>> cm_names;
    public Model m;

    public ConstantMatrixStore(Model model) {
        this.m = model;
        this.cm = new HashMap();
        this.cm_names = new HashMap();
        this.already_written = new HashSet();
    }

    private void removeEntry(String string) {
        assert (this.cm.containsKey(string));
        ASTNode aSTNode = this.cm.get(string);
        boolean bl = this.cm_names.get(aSTNode).remove(string);
        assert (bl);
        if (this.cm_names.get(aSTNode).isEmpty()) {
            this.cm_names.remove(aSTNode);
        }
        this.cm.remove(string);
    }

    private void addEntry(String string, ASTNode aSTNode) {
        assert (!this.cm.containsKey(string));
        if (this.cm_names.containsKey(aSTNode)) {
            ASTNode aSTNode2 = this.cm.get(this.cm_names.get(aSTNode).iterator().next());
            this.cm_names.get(aSTNode2).add(string);
            this.cm.put(string, aSTNode2);
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string);
            this.cm_names.put(aSTNode, hashSet);
            this.cm.put(string, aSTNode);
        }
    }

    public ASTNode getConstantMatrix(String string) {
        assert (this.cm.containsKey(string));
        return this.cm.get(string);
    }

    public void setConstantMatrix(String string, ASTNode aSTNode) {
        this.removeEntry(string);
        this.addEntry(string, aSTNode);
    }

    public boolean hasConstantMatrix(String string) {
        return this.cm.containsKey(string);
    }

    public void removeConstantMatrix(String string) {
        this.removeEntry(string);
    }

    public void newConstantMatrix(String string, ASTNode aSTNode) {
        this.m.global_symbols.registerConstantMatrix(string);
        this.addEntry(string, aSTNode);
        if (this.m.global_symbols.getDomain(string) == null) {
            Intpair intpair = this.getConstantMatrixBounds(aSTNode);
            SimpleDomain simpleDomain = intpair == null ? (aSTNode.isRelation() ? new BooleanDomain(new Range((ASTNode)NumberConstant.make(0L), NumberConstant.make(0L))) : new IntegerDomain(new Range((ASTNode)NumberConstant.make(0L), NumberConstant.make(0L)))) : (aSTNode.isRelation() ? new BooleanDomain(new Range((ASTNode)NumberConstant.make(intpair.lower), NumberConstant.make(intpair.upper))) : new IntegerDomain(new Range((ASTNode)NumberConstant.make(intpair.lower), NumberConstant.make(intpair.upper))));
            ArrayList<ASTNode> arrayList = aSTNode.getIndexDomainsIrregular();
            MatrixDomain matrixDomain = new MatrixDomain((ASTNode)simpleDomain, arrayList);
            this.m.global_symbols.setDomain(string, matrixDomain);
        } else {
            this.tightenConstantMatrixDomain(string, this.m.global_symbols.getDomain(string));
        }
    }

    public ASTNode newConstantMatrixDedup(ASTNode aSTNode) {
        if (this.containsRefs(aSTNode)) {
            aSTNode = aSTNode.copy();
            this.copyInRefs(aSTNode);
        }
        if (this.cm_names.containsKey(aSTNode)) {
            String string = this.cm_names.get(aSTNode).iterator().next();
            return new Identifier(this.m, string);
        }
        String string = this.m.global_symbols.newAuxId();
        this.newConstantMatrix(string, aSTNode);
        return new Identifier(this.m, string);
    }

    private boolean containsRefs(ASTNode aSTNode) {
        if (aSTNode instanceof Identifier) {
            return true;
        }
        if (aSTNode instanceof CompoundMatrix) {
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                if (!this.containsRefs(aSTNode.getChild(i))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void copyInRefs(ASTNode aSTNode) {
        assert (aSTNode instanceof CompoundMatrix);
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            this.copyInRefsInner(aSTNode.getChild(i));
        }
    }

    private void copyInRefsInner(ASTNode aSTNode) {
        if (aSTNode instanceof Identifier) {
            ASTNode aSTNode2 = this.getConstantMatrix(aSTNode.toString());
            aSTNode.getParent().setChild(aSTNode.getChildNo(), aSTNode2);
            aSTNode = aSTNode2;
        }
        if (aSTNode instanceof CompoundMatrix) {
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                this.copyInRefsInner(aSTNode.getChild(i));
            }
        }
    }

    private void tightenConstantMatrixDomain(String string, ASTNode aSTNode) {
        Serializable serializable;
        Intpair intpair = this.getConstantMatrixBounds(this.cm.get(string));
        if (intpair != null) {
            serializable = aSTNode.getChild(0);
            if (!((ASTNode)serializable).isBooleanSet()) {
                serializable = new Intersect((ASTNode)serializable, new IntegerDomain(new Range((ASTNode)NumberConstant.make(intpair.lower), NumberConstant.make(intpair.upper))));
                TransformSimplify transformSimplify = new TransformSimplify();
                serializable = transformSimplify.transform((ASTNode)serializable);
            }
            aSTNode.setChild(0, (ASTNode)serializable);
        }
        serializable = this.cm.get(string).getIndexDomainsIrregular();
        for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
            if (aSTNode.numChildren() <= i + 3 || aSTNode.getChild(i + 3).isFiniteSet() || !((ASTNode)((ArrayList)serializable).get(i)).isFiniteSet()) continue;
            aSTNode.setChild(i + 3, (ASTNode)((ArrayList)serializable).get(i));
        }
    }

    ArrayList<Long> getConstantMatrixSize(ASTNode aSTNode) {
        ArrayList<ASTNode> arrayList = aSTNode.getIndexDomains();
        ArrayList<Long> arrayList2 = new ArrayList<Long>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<Intpair> arrayList3 = arrayList.get(i).getIntervalSet();
            long l = 0L;
            for (int j = 0; j < arrayList3.size(); ++j) {
                l = l + arrayList3.get((int)j).upper - arrayList3.get((int)j).lower + 1L;
            }
            arrayList2.add(l);
        }
        return arrayList2;
    }

    public static ArrayList<Long> getConstantMatrixContents(ASTNode aSTNode) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) {
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                arrayList.addAll(ConstantMatrixStore.getConstantMatrixContents(aSTNode.getChild(i)));
            }
        } else if (aSTNode.isTuple()) {
            for (int i = 1; i <= aSTNode.getTupleLength(); ++i) {
                arrayList.add(aSTNode.getValueIdx(i));
            }
        } else {
            assert (aSTNode.isConstant());
            arrayList.add(aSTNode.getValue());
        }
        return arrayList;
    }

    Intpair getConstantMatrixBounds(ASTNode aSTNode) {
        if (aSTNode instanceof CompoundMatrix) {
            Intpair intpair = null;
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                Intpair intpair2 = this.getConstantMatrixBounds(aSTNode.getChild(i));
                if (intpair2 == null) continue;
                if (intpair == null) {
                    intpair = intpair2;
                    continue;
                }
                intpair.lower = intpair.lower < intpair2.lower ? intpair.lower : intpair2.lower;
                intpair.upper = intpair.upper > intpair2.upper ? intpair.upper : intpair2.upper;
            }
            return intpair;
        }
        if (aSTNode.isTuple()) {
            return aSTNode.getBounds();
        }
        if (aSTNode instanceof EmptyMatrix) {
            return null;
        }
        assert (aSTNode.isConstant());
        Intpair intpair = new Intpair(aSTNode.getValue(), aSTNode.getValue());
        return intpair;
    }

    public ArrayList<ASTNode> makeLettingsConstantMatrix(String string) {
        ASTNode aSTNode = this.cm.get(string);
        ASTNode aSTNode2 = this.m.global_symbols.getDomain(string);
        ArrayList<ASTNode> arrayList = aSTNode.getIndexDomains();
        ASTNode aSTNode3 = aSTNode2.getChild(0);
        ArrayList<ASTNode> arrayList2 = aSTNode2.getChildren(3);
        ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList2.size() && i < arrayList.size(); ++i) {
            ASTNode aSTNode4;
            long l;
            ASTNode aSTNode5;
            if (!(arrayList2.get(i) instanceof IntegerDomain) || arrayList2.get(i).numChildren() != 1 || !((aSTNode5 = arrayList2.get(i).getChild(0)) instanceof Range)) continue;
            if (aSTNode5.getChild(0) instanceof Identifier) {
                l = Intpair.numValues(arrayList.get(i).getIntervalSet());
                aSTNode4 = new Letting(aSTNode5.getChild(0), BinOp.makeBinOp("-", aSTNode5.getChild(1), NumberConstant.make(l - 1L)));
                aSTNode4 = new TransformSimplify().transform(aSTNode4);
                arrayList3.add(aSTNode4);
            }
            if (!(aSTNode5.getChild(1) instanceof Identifier)) continue;
            l = Intpair.numValues(arrayList.get(i).getIntervalSet());
            aSTNode4 = new Letting(aSTNode5.getChild(1), BinOp.makeBinOp("+", aSTNode5.getChild(0), NumberConstant.make(l - 1L)));
            aSTNode4 = new TransformSimplify().transform(aSTNode4);
            arrayList3.add(aSTNode4);
        }
        return arrayList3;
    }

    public void correctIndicesConstantMatrix(String string, boolean bl) {
        ASTNode aSTNode = this.cm.get(string).copy();
        ASTNode aSTNode2 = this.m.global_symbols.getDomain(string);
        this.removeEntry(string);
        Pair<ASTNode, Boolean> pair = ConstantMatrixStore.fixIndicesConstantMatrix(aSTNode2, aSTNode);
        if (pair.getSecond().booleanValue() && bl) {
            CmdFlags.println("WARNING: Index domains do not match for the matrix " + string);
            CmdFlags.println("WARNING: This could be a mismatch between the matrix given in the parameter file");
            CmdFlags.println("WARNING: and its matrix domain in the given statement in the model file.");
        }
        this.addEntry(string, pair.getFirst());
    }

    public static Pair<ASTNode, Boolean> fixIndicesConstantMatrix(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode2 instanceof EmptyMatrix) {
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(3);
            boolean bl = false;
            ArrayList<ASTNode> arrayList2 = aSTNode2.getChild(0).getChildren(3);
            ASTNode aSTNode3 = aSTNode2.getChild(0).getChild(0);
            if (arrayList2.size() != arrayList.size()) {
                while (arrayList2.size() < arrayList.size()) {
                    arrayList2.add(new IntegerDomain(new EmptyRange()));
                }
                while (arrayList2.size() > arrayList.size()) {
                    arrayList2.remove(arrayList2.size() - 1);
                }
                bl = true;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!arrayList.get(i).isFiniteSet() || arrayList.get(i).equals(arrayList2.get(i))) continue;
                arrayList2.set(i, arrayList.get(i));
                bl = true;
            }
            if (bl) {
                return new Pair<ASTNode, Boolean>(new EmptyMatrix(new MatrixDomain(aSTNode3, arrayList2)), true);
            }
            return new Pair<ASTNode, Boolean>(aSTNode2, false);
        }
        if (aSTNode2 instanceof CompoundMatrix) {
            ArrayList<ASTNode> arrayList;
            boolean bl = false;
            ASTNode aSTNode4 = aSTNode2.getChild(0);
            ASTNode aSTNode5 = aSTNode.getChild(3);
            if (aSTNode5.isFiniteSet() && !aSTNode4.getIntervalSet().equals(aSTNode5.getIntervalSet())) {
                aSTNode2.setChild(0, aSTNode5);
                bl = true;
            }
            if ((arrayList = aSTNode.getChildren(4)).size() == 0) {
                return new Pair<ASTNode, Boolean>(aSTNode2, bl);
            }
            for (int i = 1; i < aSTNode2.numChildren(); ++i) {
                MatrixDomain matrixDomain = new MatrixDomain(aSTNode.getChild(0), arrayList);
                Pair<ASTNode, Boolean> pair = ConstantMatrixStore.fixIndicesConstantMatrix(matrixDomain, aSTNode2.getChild(i));
                aSTNode2.setChild(i, pair.getFirst());
                bl = bl || pair.getSecond() != false;
            }
            return new Pair<ASTNode, Boolean>(aSTNode2, bl);
        }
        return new Pair<ASTNode, Boolean>(aSTNode2, false);
    }

    public boolean typecheck() {
        for (String string : this.cm.keySet()) {
            ASTNode aSTNode = this.m.global_symbols.getDomain(string);
            ASTNode aSTNode2 = aSTNode.getChild(0);
            boolean bl = aSTNode2.isBooleanSet();
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(3);
            if (this.cm.get(string).getDimension() != arrayList.size()) {
                CmdFlags.println("ERROR: Number of dimensions differs for constant matrix: " + string);
                return false;
            }
            TransformSimplify transformSimplify = new TransformSimplify();
            ArrayList<Intpair> arrayList2 = transformSimplify.transform(aSTNode2).getIntervalSet();
            if (this.checkConstantMatrixDomain(string, this.cm.get(string), arrayList, arrayList2, bl, 0)) continue;
            return false;
        }
        return true;
    }

    private boolean checkConstantMatrixDomain(String string, ASTNode aSTNode, ArrayList<ASTNode> arrayList, ArrayList<Intpair> arrayList2, boolean bl, int n) {
        ASTNode aSTNode2 = arrayList.get(n);
        TransformSimplify transformSimplify = new TransformSimplify();
        if (aSTNode2.isFiniteSet()) {
            long l = Intpair.numValues(transformSimplify.transform(aSTNode2).getIntervalSet());
            if ((long)(aSTNode.numChildren() - 1) != l) {
                CmdFlags.println("ERROR: At index " + (n + 1) + " of constant matrix " + string + ", actual size does not match the matrix dimensions.");
                return false;
            }
        }
        if (n == arrayList.size() - 1) {
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode.getChild(i);
                if (!Intpair.contains(arrayList2, aSTNode3.getValue())) {
                    CmdFlags.println("ERROR: Item " + String.valueOf(aSTNode3) + " is not contained in domain of constant matrix " + string + ".");
                    return false;
                }
                if (!bl || aSTNode3.isRelation()) continue;
                CmdFlags.println("ERROR: Item " + String.valueOf(aSTNode3) + " is not boolean in constant matrix " + string + ".");
                return false;
            }
        } else {
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                ASTNode aSTNode4 = aSTNode.getChild(i);
                if (this.checkConstantMatrixDomain(string, aSTNode4, arrayList, arrayList2, bl, n + 1)) continue;
                return false;
            }
        }
        return true;
    }

    public ConstantMatrixStore copy(Model model) {
        ConstantMatrixStore constantMatrixStore = new ConstantMatrixStore(model);
        for (String string : this.cm.keySet()) {
            ASTNode aSTNode = this.cm.get(string).copy();
            constantMatrixStore.addEntry(string, aSTNode);
        }
        return constantMatrixStore;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConstantMatrixStore)) {
            return false;
        }
        ConstantMatrixStore constantMatrixStore = (ConstantMatrixStore)object;
        return constantMatrixStore.cm.equals(this.cm);
    }

    public int hashCode() {
        return this.cm.hashCode();
    }

    public void toMinion(BufferedWriter bufferedWriter) throws IOException {
        for (String string : this.cm.keySet()) {
            int n;
            int n2;
            ASTNode aSTNode;
            int n3;
            if (this.already_written.contains(string)) continue;
            ArrayList<Long> arrayList = this.getConstantMatrixSize(this.cm.get(string));
            ArrayList<ASTNode> arrayList2 = this.cm.get(string).getIndexDomainsIrregular();
            boolean bl = true;
            boolean[] blArray = new boolean[arrayList2.size()];
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                ArrayList<Intpair> arrayList3 = arrayList2.get(n3).getIntervalSet();
                blArray[n3] = arrayList3.size() != 1 || arrayList3.get((int)0).lower != Long.MIN_VALUE || arrayList3.get((int)0).upper != Long.MAX_VALUE;
                bl = bl && blArray[n3];
            }
            if (arrayList.size() == 2 && bl) {
                bufferedWriter.append("**TUPLELIST**\n");
                bufferedWriter.append(string + " ");
                ASTNode aSTNode2 = this.cm.get(string);
                bufferedWriter.append(String.valueOf(arrayList.get(0)) + " " + String.valueOf(arrayList.get(1)) + "\n");
                for (int i = 1; i < aSTNode2.numChildren(); ++i) {
                    aSTNode = aSTNode2.getChild(i);
                    if (aSTNode.isTuple()) {
                        for (n2 = 1; n2 <= aSTNode.getTupleLength(); ++n2) {
                            bufferedWriter.append(String.valueOf(aSTNode.getValueIdx(n2)));
                            bufferedWriter.append(" ");
                        }
                    } else {
                        assert (aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix);
                        for (n2 = 1; n2 < aSTNode.numChildren(); ++n2) {
                            ASTNode aSTNode3 = aSTNode.getChild(n2);
                            aSTNode3.toMinion(bufferedWriter, false);
                            bufferedWriter.append(" ");
                        }
                    }
                    bufferedWriter.append("\n");
                }
            }
            if (arrayList.size() == 3 && arrayList.get(2) == 2L && blArray[2]) {
                bufferedWriter.append("**SHORTTUPLELIST**\n");
                bufferedWriter.append(string);
                bufferedWriter.append(" ");
                ASTNode aSTNode4 = this.cm.get(string);
                bufferedWriter.append(String.valueOf(aSTNode4.numChildren() - 1));
                bufferedWriter.append("\n");
                for (int i = 1; i < aSTNode4.numChildren(); ++i) {
                    bufferedWriter.append("[");
                    aSTNode = aSTNode4.getChild(i);
                    for (n2 = 1; n2 < aSTNode4.getChild(i).numChildren(); ++n2) {
                        long l = aSTNode.getChild(n2).getChild(1).getValue();
                        long l2 = aSTNode.getChild(n2).getChild(2).getValue();
                        bufferedWriter.append("(");
                        bufferedWriter.append(String.valueOf(l - 1L));
                        bufferedWriter.append(",");
                        bufferedWriter.append(String.valueOf(l2));
                        bufferedWriter.append("),");
                    }
                    bufferedWriter.append("]\n");
                }
            }
            n3 = 0;
            for (n = 0; n < arrayList.size(); ++n) {
                if (arrayList.get(n) != 0L) continue;
                n3 = 1;
            }
            if (n3 == 0 && bl) {
                bufferedWriter.append("**VARIABLES**\n");
                bufferedWriter.append("ALIAS " + string + "[");
                for (n = 0; n < arrayList.size(); ++n) {
                    bufferedWriter.append(String.valueOf(arrayList.get(n)));
                    if (n >= arrayList.size() - 1) continue;
                    bufferedWriter.append(",");
                }
                bufferedWriter.append("]=");
                this.cm.get(string).toMinion(bufferedWriter, false);
                bufferedWriter.append("\n");
            }
            this.already_written.add(string);
        }
    }

    public void toFlatzinc(BufferedWriter bufferedWriter) throws IOException {
        for (String string : this.cm.keySet()) {
            ASTNode aSTNode = this.cm.get(string);
            ArrayList<Long> arrayList = this.getConstantMatrixSize(aSTNode);
            ArrayList<Long> arrayList2 = ConstantMatrixStore.getConstantMatrixContents(aSTNode);
            if (arrayList.size() != 1) continue;
            bufferedWriter.append("array [1.." + String.valueOf(arrayList.get(0)) + "] of int: " + string + " = " + arrayList2.toString() + ";\n");
        }
    }

    public void toMinizinc(StringBuilder stringBuilder) {
        for (String string : this.cm.keySet()) {
            ASTNode aSTNode = this.cm.get(string);
            if (!aSTNode.isRegularMatrix()) continue;
            ArrayList<Long> arrayList = this.getConstantMatrixSize(aSTNode);
            ArrayList<Long> arrayList2 = ConstantMatrixStore.getConstantMatrixContents(aSTNode);
            if (arrayList.size() == 1) {
                stringBuilder.append("array [1.." + String.valueOf(arrayList.get(0)) + "] of int: " + string + " = " + arrayList2.toString() + ";\n");
                continue;
            }
            if (arrayList.size() != 2) continue;
            stringBuilder.append("array [1.." + String.valueOf(arrayList.get(0)) + ", 1.." + String.valueOf(arrayList.get(1)) + "] of int: " + string + " = ");
            ConstantMatrixStore.printMzn2darray(stringBuilder, aSTNode);
            stringBuilder.append(";\n");
        }
    }

    public static void printMzn2darray(StringBuilder stringBuilder, ASTNode aSTNode) {
        assert (aSTNode.getDimension() == 2);
        stringBuilder.append("[");
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            ASTNode aSTNode2 = aSTNode.getChild(i);
            stringBuilder.append("| ");
            for (int j = 1; j <= aSTNode2.getTupleLength(); ++j) {
                stringBuilder.append(aSTNode2.getValueIdx(j));
                if (j >= aSTNode2.getTupleLength()) continue;
                stringBuilder.append(",");
            }
        }
        stringBuilder.append("|]");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.cm.keySet()) {
            stringBuilder.append("letting " + string + " = " + String.valueOf(this.cm.get(string)) + "\n");
        }
        return stringBuilder.toString();
    }
}

