/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.model.Model;
import savilerow.solver.ReadProcessOutput;
import savilerow.solver.RunCommand;
import savilerow.solver.SATSolver;
import savilerow.solver.Stats;
import savilerow.solver.WMaxCDCLStats;

public class WMaxCDCLSolver
extends SATSolver {
    public WMaxCDCLSolver(Model model) {
        super(model);
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        try {
            boolean bl;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            ArrayList<String> arrayList2 = new ArrayList<String>(CmdFlags.getSolverExtraFlags());
            assert (stats == null);
            arrayList.addAll(arrayList2);
            arrayList.add(string2);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            ReadProcessOutput readProcessOutput = new ReadProcessOutput(arrayList4);
            double d = System.currentTimeMillis();
            int n = RunCommand.runCommand(false, arrayList, arrayList3, readProcessOutput);
            CmdFlags.println("MaxSAT solver exited with error code:" + n + " and error message:");
            CmdFlags.println(arrayList3);
            d = ((double)System.currentTimeMillis() - d) / 1000.0;
            WMaxCDCLStats wMaxCDCLStats = new WMaxCDCLStats(arrayList4);
            wMaxCDCLStats.putValue("SolverTotalTime", String.valueOf(d));
            boolean bl2 = bl = wMaxCDCLStats.hasValue("SolverSatisfiable") && wMaxCDCLStats.getValue("SolverSatisfiable") == "1";
            if (bl) {
                ArrayList<Object> arrayList5 = new ArrayList<Object>();
                for (String string3 : arrayList4) {
                    CmdFlags.printlnIfVerbose(string3);
                    if (!string3.startsWith("v")) continue;
                    String[] stringArray = string3.trim().split(" ");
                    for (int i = 0; i < stringArray[1].length(); ++i) {
                        String string4 = stringArray[1].substring(i, i + 1);
                        if (string4.equals("0")) {
                            arrayList5.add("-" + String.valueOf(i + 1));
                            continue;
                        }
                        if (string4.equals("1")) {
                            arrayList5.add(String.valueOf(i + 1));
                            continue;
                        }
                        throw new Exception("Could not interpret binary value " + string4);
                    }
                }
                return new Pair<ArrayList<String>, Stats>(arrayList5, wMaxCDCLStats);
            }
            return new Pair<Object, WMaxCDCLStats>(null, wMaxCDCLStats);
        }
        catch (Exception exception) {
            System.out.println("Exception." + String.valueOf(exception));
            CmdFlags.rmTempFiles();
            return new Pair<Object, Object>(null, null);
        }
    }
}

