/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import java.util.ArrayList;
import java.util.HashSet;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.AllDifferent;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Equals;
import savilerow.expression.GlobalCard;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.LessEqual;
import savilerow.expression.NumberConstant;
import savilerow.expression.Tag;
import savilerow.expression.Top;
import savilerow.expression.WeightedSum;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.TransformNormalise;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;

public class TransformAlldiffGCCSum
extends TreeTransformerBottomUpNoWrapper {
    private HashSet<ASTNode> impliedCons = new HashSet();
    ArrayList<Integer> augpath;
    ArrayList<Integer> lb;
    ArrayList<Integer> ub;
    ArrayList<Integer> occs;
    ArrayList<Integer> varvalmatch;
    ArrayList<ArrayList<Integer>> valadjlist;
    int valmin;
    int valmax;
    int numvars;
    ArrayList<Integer> prev;
    ArrayList<Integer> distance;
    boolean bfflag;

    public TransformAlldiffGCCSum(Model model) {
        super(model);
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        if (aSTNode instanceof AllDifferent && aSTNode.getParent().inTopAnd() && aSTNode.getChild(0) instanceof CompoundMatrix && !(aSTNode.getParent() instanceof Tag)) {
            ASTNodeC aSTNodeC;
            this.setupFF();
            Intpair intpair = this.fordFulkerson(aSTNode);
            if (intpair == null) {
                return new NodeReplacement(new BooleanConstant(false));
            }
            TransformNormalise transformNormalise = new TransformNormalise(this.m);
            TransformSimplify transformSimplify = new TransformSimplify();
            ArrayList<ASTNode> arrayList = aSTNode.getChild(0).getChildren(1);
            if (intpair.lower == intpair.upper) {
                aSTNodeC = new Equals((ASTNode)NumberConstant.make(intpair.lower), new WeightedSum(arrayList));
                this.impliedCons.add(transformNormalise.transform(transformSimplify.transform(((ASTNode)aSTNodeC).copy())));
            } else {
                LessEqual lessEqual = new LessEqual((ASTNode)NumberConstant.make(intpair.lower), new WeightedSum(arrayList));
                LessEqual lessEqual2 = new LessEqual((ASTNode)new WeightedSum(arrayList), NumberConstant.make(intpair.upper));
                this.impliedCons.add(transformNormalise.transform(transformSimplify.transform(((ASTNode)lessEqual).copy())));
                this.impliedCons.add(transformNormalise.transform(transformSimplify.transform(((ASTNode)lessEqual2).copy())));
                aSTNodeC = new And((ASTNode)lessEqual, lessEqual2);
            }
            return new NodeReplacement(new And((ASTNode)new Tag(aSTNode), aSTNodeC));
        }
        if (aSTNode instanceof GlobalCard && aSTNode.getParent().inTopAnd() && !(aSTNode.getParent() instanceof Tag) && aSTNode.getChild(0) instanceof CompoundMatrix && aSTNode.getChild(1) instanceof CompoundMatrix && aSTNode.getChild(2) instanceof CompoundMatrix) {
            ArrayList<ASTNode> arrayList = aSTNode.getChild(0).getChildren(1);
            if (aSTNode.getChild(1).getCategory() == 0) {
                ASTNodeC aSTNodeC;
                this.setupFF();
                Intpair intpair = this.fordFulkerson(aSTNode);
                TransformNormalise transformNormalise = new TransformNormalise(this.m);
                TransformSimplify transformSimplify = new TransformSimplify();
                if (intpair == null) {
                    return new NodeReplacement(new BooleanConstant(false));
                }
                if (intpair.lower == intpair.upper) {
                    aSTNodeC = new Equals((ASTNode)NumberConstant.make(intpair.lower), new WeightedSum(arrayList));
                    this.impliedCons.add(transformNormalise.transform(transformSimplify.transform(((ASTNode)aSTNodeC).copy())));
                } else {
                    LessEqual lessEqual = new LessEqual((ASTNode)NumberConstant.make(intpair.lower), new WeightedSum(arrayList));
                    LessEqual lessEqual3 = new LessEqual((ASTNode)new WeightedSum(arrayList), NumberConstant.make(intpair.upper));
                    this.impliedCons.add(transformNormalise.transform(transformSimplify.transform(((ASTNode)lessEqual).copy())));
                    this.impliedCons.add(transformNormalise.transform(transformSimplify.transform(((ASTNode)lessEqual3).copy())));
                    aSTNodeC = new And((ASTNode)lessEqual, lessEqual3);
                }
                return new NodeReplacement(new And((ASTNode)new Tag(aSTNode), aSTNodeC));
            }
        }
        return null;
    }

    public void removeImpliedConstraints() {
        assert (this.m.constraints instanceof Top);
        if (this.m.constraints.getChild(0) instanceof And) {
            this.removeImpliedConstraints2(this.m.constraints.getChild(0));
        }
    }

    private void removeImpliedConstraints2(ASTNode aSTNode) {
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            if (aSTNode.getChild(i) instanceof And) {
                this.removeImpliedConstraints2(aSTNode.getChild(i));
            }
            if (!this.impliedCons.contains(aSTNode.getChild(i))) continue;
            aSTNode.setChild(i, new BooleanConstant(true));
        }
    }

    void setupFF() {
        this.augpath = new ArrayList();
        this.lb = new ArrayList();
        this.ub = new ArrayList();
        this.occs = new ArrayList();
        this.valadjlist = new ArrayList();
        this.varvalmatch = new ArrayList();
        this.prev = new ArrayList();
        this.distance = new ArrayList();
    }

    Intpair fordFulkerson(ASTNode aSTNode) {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        int n4;
        this.augpath.clear();
        this.lb.clear();
        this.ub.clear();
        this.valadjlist.clear();
        this.varvalmatch.clear();
        this.valmin = Integer.MAX_VALUE;
        this.valmax = Integer.MIN_VALUE;
        ArrayList<ASTNode> arrayList = aSTNode.getChild(0).getChildren(1);
        this.numvars = arrayList.size();
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            object2 = arrayList.get(n4).getBounds();
            if (((Intpair)object2).lower < (long)this.valmin) {
                this.valmin = (int)((Intpair)object2).lower;
            }
            if (((Intpair)object2).upper <= (long)this.valmax) continue;
            this.valmax = (int)((Intpair)object2).upper;
        }
        for (n4 = this.valmin; n4 <= this.valmax; ++n4) {
            this.valadjlist.add(new ArrayList());
        }
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            if (arrayList.get(n4) instanceof Identifier) {
                object2 = ((Identifier)arrayList.get(n4)).getDomain();
                object = ((ASTNode)object2).getIntervalSet();
                for (n3 = 0; n3 < ((ArrayList)object).size(); ++n3) {
                    Intpair intpair = ((ArrayList)object).get(n3);
                    int n5 = (int)intpair.lower;
                    while ((long)n5 <= intpair.upper) {
                        this.valadjlist.get(n5 - this.valmin).add(n4);
                        ++n5;
                    }
                }
                continue;
            }
            object2 = arrayList.get(n4).getBounds();
            int n6 = (int)((Intpair)object2).lower;
            while ((long)n6 <= ((Intpair)object2).upper) {
                this.valadjlist.get(n6 - this.valmin).add(n4);
                ++n6;
            }
        }
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            this.varvalmatch.add(this.valmin - 1);
        }
        if (aSTNode instanceof AllDifferent) {
            for (n4 = this.valmin; n4 <= this.valmax; ++n4) {
                this.lb.add(0);
                this.ub.add(1);
                this.occs.add(0);
            }
        } else {
            assert (aSTNode instanceof GlobalCard);
            for (n4 = this.valmin; n4 <= this.valmax; ++n4) {
                this.lb.add(0);
                this.ub.add(this.numvars);
                this.occs.add(0);
                for (int i = 1; i < aSTNode.getChild(1).numChildren(); ++i) {
                    if ((long)n4 != aSTNode.getChild(1).getChild(i).getValue()) continue;
                    object = aSTNode.getChild(2).getChild(i).getBounds();
                    this.lb.set(this.lb.size() - 1, (int)((Intpair)object).lower);
                    this.ub.set(this.ub.size() - 1, (int)((Intpair)object).upper);
                }
            }
        }
        n4 = 0;
        for (n2 = this.valmin; n2 <= this.valmax; ++n2) {
            while (this.lb.get(n2 - this.valmin) > this.occs.get(n2 - this.valmin)) {
                int n7;
                this.distance.clear();
                this.prev.clear();
                for (n7 = 0; n7 < 2 + this.numvars + (this.valmax - this.valmin + 1); ++n7) {
                    this.distance.add(Integer.MAX_VALUE);
                    this.prev.add(Integer.MIN_VALUE);
                }
                this.distance.set(n2 - this.valmin + this.numvars + 2, 0);
                this.bellmanFord(n2 - this.valmin + this.numvars + 2, true);
                n7 = this.extractPath(n2 - this.valmin + this.numvars + 2, 1) ? 1 : 0;
                if (n7 != 0) {
                    this.augmentBF();
                    ++n4;
                    continue;
                }
                return null;
            }
        }
        while (n4 < this.numvars) {
            this.distance.clear();
            this.prev.clear();
            for (n2 = 0; n2 < 2 + this.numvars + (this.valmax - this.valmin + 1); ++n2) {
                this.distance.add(Integer.MAX_VALUE);
                this.prev.add(Integer.MIN_VALUE);
            }
            this.distance.set(0, 0);
            this.bellmanFord(0, true);
            n2 = this.extractPath(0, 1) ? 1 : 0;
            if (n2 != 0) {
                this.augmentBF();
                ++n4;
                continue;
            }
            return null;
        }
        Intpair intpair = new Intpair(0L, 0L);
        for (n = 0; n < this.varvalmatch.size(); ++n) {
            intpair.lower += (long)this.varvalmatch.get(n).intValue();
        }
        for (n = 0; n < this.numvars; ++n) {
            this.varvalmatch.set(n, this.valmin - 1);
        }
        for (n = this.valmin; n <= this.valmax; ++n) {
            this.occs.set(n - this.valmin, 0);
        }
        n4 = 0;
        for (n = this.valmin; n <= this.valmax; ++n) {
            while (this.lb.get(n - this.valmin) > this.occs.get(n - this.valmin)) {
                this.distance.clear();
                this.prev.clear();
                for (n3 = 0; n3 < 2 + this.numvars + (this.valmax - this.valmin + 1); ++n3) {
                    this.distance.add(Integer.MAX_VALUE);
                    this.prev.add(Integer.MIN_VALUE);
                }
                this.distance.set(n - this.valmin + this.numvars + 2, 0);
                this.bellmanFord(n - this.valmin + this.numvars + 2, false);
                n3 = this.extractPath(n - this.valmin + this.numvars + 2, 1) ? 1 : 0;
                if (n3 != 0) {
                    this.augmentBF();
                    ++n4;
                    continue;
                }
                return null;
            }
        }
        while (n4 < this.numvars) {
            this.distance.clear();
            this.prev.clear();
            for (n = 0; n < 2 + this.numvars + (this.valmax - this.valmin + 1); ++n) {
                this.distance.add(Integer.MAX_VALUE);
                this.prev.add(Integer.MIN_VALUE);
            }
            this.distance.set(0, 0);
            this.bellmanFord(0, false);
            n = this.extractPath(0, 1) ? 1 : 0;
            if (n != 0) {
                this.augmentBF();
                ++n4;
                continue;
            }
            return null;
        }
        for (n = 0; n < this.varvalmatch.size(); ++n) {
            intpair.upper += (long)this.varvalmatch.get(n).intValue();
        }
        return intpair;
    }

    void checkUpdateEdge(int n, int n2, int n3) {
        if (this.distance.get(n) < Integer.MAX_VALUE && this.distance.get(n) + n3 < this.distance.get(n2)) {
            this.distance.set(n2, this.distance.get(n) + n3);
            this.prev.set(n2, n);
            this.bfflag = true;
        }
    }

    void bellmanFord(int n, boolean bl) {
        int n2 = 2 + this.numvars + (this.valmax - this.valmin + 1);
        for (int i = 1; i < n2; ++i) {
            int n3;
            int n4;
            this.bfflag = false;
            for (n4 = this.valmin; n4 <= this.valmax; ++n4) {
                if (this.occs.get(n4 - this.valmin) >= this.ub.get(n4 - this.valmin)) continue;
                this.checkUpdateEdge(0, this.numvars + 2 + n4 - this.valmin, 0);
            }
            for (n4 = this.valmin; n4 <= this.valmax; ++n4) {
                if (this.occs.get(n4 - this.valmin) <= this.lb.get(n4 - this.valmin)) continue;
                this.checkUpdateEdge(this.numvars + 2 + n4 - this.valmin, 0, 0);
            }
            for (n4 = this.valmin; n4 <= this.valmax; ++n4) {
                ArrayList<Integer> arrayList = this.valadjlist.get(n4 - this.valmin);
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    int n5 = arrayList.get(n3);
                    if (this.varvalmatch.get(n5) == n4) continue;
                    int n6 = bl ? n4 - this.valmin : this.valmax - n4;
                    this.checkUpdateEdge(n4 - this.valmin + this.numvars + 2, n5 + 2, n6);
                }
            }
            for (n4 = 0; n4 < this.numvars; ++n4) {
                if (this.varvalmatch.get(n4) != this.valmin - 1) {
                    int n7 = this.varvalmatch.get(n4);
                    n3 = bl ? -(n7 - this.valmin) : -(this.valmax - n7);
                    this.checkUpdateEdge(n4 + 2, n7 - this.valmin + this.numvars + 2, n3);
                    continue;
                }
                this.checkUpdateEdge(n4 + 2, 1, 0);
            }
            for (n4 = 0; n4 < this.numvars; ++n4) {
                if (this.varvalmatch.get(n4) == this.valmin - 1) continue;
                this.checkUpdateEdge(1, n4 + 2, 0);
            }
            if (!this.bfflag) break;
        }
    }

    String printVertex(int n) {
        if (n == 0) {
            return "s";
        }
        if (n == 1) {
            return "t";
        }
        if (n > 1 && n < 2 + this.numvars) {
            return "x" + (n - 2);
        }
        if (n >= 2 + this.numvars && n < 2 + this.numvars + this.valmax - this.valmin + 1) {
            return String.valueOf(n - 2 - this.numvars + this.valmin);
        }
        return "Node out of range:" + n;
    }

    boolean extractPath(int n, int n2) {
        this.augpath.clear();
        int n3 = n2;
        while (n3 != n) {
            this.augpath.add(n3);
            if ((n3 = this.prev.get(n3).intValue()) != Integer.MIN_VALUE) continue;
            return false;
        }
        this.augpath.add(n);
        return true;
    }

    void augmentBF() {
        for (int i = this.augpath.size() - 1; i > 0; --i) {
            int n = this.augpath.get(i) - 2;
            int n2 = this.augpath.get(i - 1) - 2;
            if (n < this.numvars || n >= this.numvars + (this.valmax - this.valmin + 1) || n2 < 0 || n2 >= this.numvars) continue;
            if (this.varvalmatch.get(n2) != this.valmin - 1) {
                int n3 = this.varvalmatch.get(n2);
                this.occs.set(n3 - this.valmin, this.occs.get(n3 - this.valmin) - 1);
            }
            this.varvalmatch.set(n2, n - this.numvars + this.valmin);
            this.occs.set(n - this.numvars, this.occs.get(n - this.numvars) + 1);
        }
    }
}

