/*
 * Decompiled with CFR 0.152.
 */
package savilerow.eprimeparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.eprimeparser.EPrimeSyntaxException;
import savilerow.eprimeparser.EPrimeTokenizer;
import savilerow.eprimeparser.ShuntingYard;
import savilerow.expression.AMOPB;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.Absolute;
import savilerow.expression.AllDifferent;
import savilerow.expression.AllDifferentExcept;
import savilerow.expression.And;
import savilerow.expression.AndVector;
import savilerow.expression.AtLeast;
import savilerow.expression.AtMost;
import savilerow.expression.BinOpPlaceholder;
import savilerow.expression.BooleanConstant;
import savilerow.expression.BooleanDomainFull;
import savilerow.expression.Brackets;
import savilerow.expression.Cat;
import savilerow.expression.CatchUndef;
import savilerow.expression.Circuit;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.ComprehensionForall;
import savilerow.expression.ComprehensionMatrix;
import savilerow.expression.ConcatenateMatrix;
import savilerow.expression.Container;
import savilerow.expression.Count;
import savilerow.expression.Cumulative;
import savilerow.expression.DiffN;
import savilerow.expression.Disjunctive;
import savilerow.expression.DominanceRelation;
import savilerow.expression.EOPB;
import savilerow.expression.ElementId;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.EmptyRange;
import savilerow.expression.ExistsExpression;
import savilerow.expression.Factorial;
import savilerow.expression.FailWhenFalse;
import savilerow.expression.Find;
import savilerow.expression.Flatten;
import savilerow.expression.ForallExpression;
import savilerow.expression.FrameUpdate;
import savilerow.expression.FromSolution;
import savilerow.expression.Given;
import savilerow.expression.GlobalCard;
import savilerow.expression.Identifier;
import savilerow.expression.IfThenElse;
import savilerow.expression.IncomparabilityFunction;
import savilerow.expression.IndexOf;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Inverse;
import savilerow.expression.IsRegularMatrix;
import savilerow.expression.Length;
import savilerow.expression.Letting;
import savilerow.expression.ListFunction;
import savilerow.expression.MakeTable;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixDomain;
import savilerow.expression.MatrixSlice;
import savilerow.expression.Max;
import savilerow.expression.MaxVector;
import savilerow.expression.Maximising;
import savilerow.expression.Min;
import savilerow.expression.MinVector;
import savilerow.expression.Minimising;
import savilerow.expression.Negate;
import savilerow.expression.NoValue;
import savilerow.expression.NumberConstant;
import savilerow.expression.OrVector;
import savilerow.expression.Popcount;
import savilerow.expression.Power;
import savilerow.expression.Print;
import savilerow.expression.QuantifiedSum;
import savilerow.expression.Range;
import savilerow.expression.SNS;
import savilerow.expression.SNSGroup;
import savilerow.expression.SNSIncumbentMapping;
import savilerow.expression.SNSNeighbourhood;
import savilerow.expression.SumVector;
import savilerow.expression.Table;
import savilerow.expression.TableShort;
import savilerow.expression.TimesVector;
import savilerow.expression.ToInt;
import savilerow.expression.ToSet;
import savilerow.expression.Top;
import savilerow.expression.UnaryMinus;
import savilerow.expression.Union;
import savilerow.expression.Where;
import savilerow.expression.XorVector;
import savilerow.model.Model;
import savilerow.model.SymbolTable;

public final class EPrimeReader {
    private EPrimeTokenizer tokens;
    private static final boolean VB_MTDS = false;
    static String[] ops = new String[]{"+", "-", "/", "*", "**", "%", "\\/", "/\\", "=>", "->", "<=>", "<->", "=", "!=", "<=", "<", ">=", ">", "<lex", "<=lex", ">lex", ">=lex", "union", "intersect", "subset", "subsetEq", "supset", "supsetEq", "in", "xor"};
    static String[] keywds = new String[]{"forall", "forAll", "exists", "sum", "such", "that", "letting", "given", "where", "find", "language", "int", "bool", "union", "intersect", "in", "false", "true"};
    private Model m;
    private ASTNode branchingon;
    private ASTNode preservevariables;
    private String heuristic;
    private ArrayList<ASTNode> neighbourhoods;
    private ArrayList<ASTNode> groups;
    private ASTNode incumbentmapping;
    private HashSet<String> binops;
    private HashSet<String> keywords;
    private HashMap<String, FunctionDescription> funcs;

    public EPrimeReader(String string, boolean bl) {
        this.tokens = new EPrimeTokenizer(string, bl);
        this.binops = new HashSet<String>(Arrays.asList(ops));
        this.m = new Model();
        this.keywords = new HashSet<String>(Arrays.asList(keywds));
        this.populateGenericFunctions();
        this.neighbourhoods = new ArrayList();
        this.groups = new ArrayList();
    }

    private void populateGenericFunctions() {
        this.funcs = new HashMap();
        this.funcs.put("toSet", new FunctionDescription("ToSet", 1));
        this.funcs.put("popcount", new FunctionDescription("Popcount", 1));
        this.funcs.put("toInt", new FunctionDescription("ToInt", 1));
        this.funcs.put("count", new FunctionDescription("Count", 2));
        this.funcs.put("makeTable", new FunctionDescription("MakeTable", 1));
        this.funcs.put("indexOf", new FunctionDescription("IndexOf", 1));
        this.funcs.put("length", new FunctionDescription("Length", 1));
        this.funcs.put("if", new FunctionDescription("IfThenElse", 3));
        this.funcs.put("alldifferent", new FunctionDescription("AllDifferent", 1));
        this.funcs.put("allDiff", new FunctionDescription("AllDifferent", 1));
        this.funcs.put("gcc", new FunctionDescription("GlobalCard", 3));
        this.funcs.put("cumulative", new FunctionDescription("Cumulative", 4));
        this.funcs.put("disjunctive", new FunctionDescription("Disjunctive", 2));
        this.funcs.put("diffn", new FunctionDescription("DiffN", 4));
        this.funcs.put("circuit", new FunctionDescription("Circuit", 1));
        this.funcs.put("inverse", new FunctionDescription("Inverse", 2));
        this.funcs.put("atmost", new FunctionDescription("AtMost", 3));
        this.funcs.put("atleast", new FunctionDescription("AtLeast", 3));
        this.funcs.put("alldifferent_except", new FunctionDescription("AllDifferentExcept", 2));
        this.funcs.put("factorial", new FunctionDescription("Factorial", 1));
        this.funcs.put("product", new FunctionDescription("TimesVector", 1));
        this.funcs.put("and", new FunctionDescription("AndVector", 1));
        this.funcs.put("or", new FunctionDescription("OrVector", 1));
        this.funcs.put("xor", new FunctionDescription("XorVector", 1));
        this.funcs.put("print", new FunctionDescription("Print", 1));
        this.funcs.put("catchUndef", new FunctionDescription("CatchUndef", 2));
        this.funcs.put("frameUpdate", new FunctionDescription("FrameUpdate", 4));
        this.funcs.put("isRegular", new FunctionDescription("IsRegularMatrix", 1));
        this.funcs.put("dominance_relation", new FunctionDescription("DominanceRelation", 1));
        this.funcs.put("incomparability_function", new FunctionDescription("IncomparabilityFunction", 2));
        this.funcs.put("fromSolution", new FunctionDescription("FromSolution", 1));
        this.funcs.put("elementId", new FunctionDescription("ElementId", 2));
        this.funcs.put("amopb", new FunctionDescription("AMOPB", 3));
        this.funcs.put("eopb", new FunctionDescription("EOPB", 3));
    }

    public Model readModel() {
        ASTNode aSTNode = null;
        ASTNode aSTNode2 = null;
        this.m.global_symbols = new SymbolTable();
        try {
            this.tokens.mark("model1");
            this.readHeader();
            this.tokens.commit("Read header line successfully.");
            this.readDeclarations();
            try {
                this.tokens.mark("model2");
                aSTNode2 = this.readObjective();
                this.tokens.eraseMark("model2");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("model2");
            }
            aSTNode = this.readConstraints();
            this.tokens.eraseMark("model1");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("model1");
            CmdFlags.errorExit("Failed to read header line. Expected the following:  language ESSENCE' 1.0");
        }
        SNS sNS = null;
        if (this.incumbentmapping != null) {
            sNS = new SNS(this.incumbentmapping, new Container(this.neighbourhoods), new NoValue(), new Container(this.groups));
        }
        this.m.setup(aSTNode, this.m.global_symbols, aSTNode2, this.branchingon, this.heuristic, sNS, this.preservevariables);
        return this.m;
    }

    public ArrayList<ASTNode> readParameterFile(Model model) {
        this.m = model;
        this.branchingon = null;
        this.heuristic = null;
        try {
            this.tokens.mark("paramhead");
            this.readHeader();
            this.tokens.eraseMark("paramhead");
            this.tokens.commit("Successfully parsed language line.");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("paramhead");
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        try {
            while (true) {
                this.tokens.mark("param");
                try {
                    this.tokens.mark("rpf");
                    ASTNode aSTNode = this.readLetting();
                    arrayList.add(aSTNode);
                    this.tokens.eraseMark("rpf");
                    this.tokens.commit("Successfully parsed letting statement.");
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException) {
                    this.tokens.reset("rpf");
                    try {
                        this.tokens.mark("rpf2");
                        this.readHeuristic();
                        this.tokens.eraseMark("rpf2");
                        this.tokens.commit("Successfully parsed heuristic.");
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                        this.tokens.reset("rpf2");
                        this.readBranchingOn();
                        this.tokens.commit("Successfully parsed branching on statement.");
                    }
                }
                this.tokens.eraseMark("param");
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("param");
            try {
                this.tokens.nextToken();
                if (this.tokens.tokenType == 4) {
                    if (this.heuristic != null) {
                        if (this.m.heuristic != null) {
                            CmdFlags.println("WARNING: Parameter file overrides 'heuristic' statement in model file.");
                        }
                        this.m.heuristic = this.heuristic;
                    }
                    if (this.branchingon != null) {
                        if (this.m.branchingon != null) {
                            CmdFlags.println("WARNING: Parameter file overrides 'branching on' statement in model file.");
                        }
                        this.m.branchingon = this.branchingon;
                    }
                    return arrayList;
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                // empty catch block
            }
            this.tokens.raiseError();
            return null;
        }
    }

    private void readHeader() throws EPrimeSyntaxException {
        this.readTerminalString("language");
        try {
            this.tokens.mark("ess");
            this.readTerminalStringPrime("ESSENCE'");
            this.tokens.eraseMark("ess");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("ess");
            this.readTerminalString("Essence");
        }
        this.readPositiveInt();
        this.readTerminalString(".");
        this.readPositiveInt();
    }

    private void readDeclarations() throws EPrimeSyntaxException {
        try {
            while (true) {
                this.readDeclaration();
                this.tokens.commit("Successfully parsed declaration.");
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            return;
        }
    }

    private void readDeclaration() throws EPrimeSyntaxException {
        try {
            this.tokens.mark();
            this.readGiven();
            this.tokens.eraseMark();
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset();
            try {
                this.tokens.mark();
                this.readWhere();
                this.tokens.eraseMark();
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset();
                try {
                    this.tokens.mark();
                    ASTNode aSTNode = this.readLetting();
                    this.tokens.eraseMark();
                    this.m.global_symbols.lettings_givens.add(aSTNode);
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                    this.tokens.reset();
                    try {
                        this.tokens.mark();
                        this.readFind();
                        this.tokens.eraseMark();
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException4) {
                        this.tokens.reset();
                        try {
                            this.tokens.mark();
                            this.readBranchingOn();
                            this.tokens.eraseMark();
                        }
                        catch (EPrimeSyntaxException ePrimeSyntaxException5) {
                            this.tokens.reset();
                            try {
                                this.tokens.mark();
                                this.readHeuristic();
                                this.tokens.eraseMark();
                            }
                            catch (EPrimeSyntaxException ePrimeSyntaxException6) {
                                this.tokens.reset();
                                try {
                                    this.tokens.mark("sns");
                                    this.readSNS();
                                    this.tokens.eraseMark("sns");
                                }
                                catch (EPrimeSyntaxException ePrimeSyntaxException7) {
                                    this.tokens.reset("sns");
                                    try {
                                        this.tokens.mark("presvars");
                                        this.readPreserveVariables();
                                        this.tokens.eraseMark("presvars");
                                    }
                                    catch (EPrimeSyntaxException ePrimeSyntaxException8) {
                                        this.tokens.reset("presvars");
                                        throw new EPrimeSyntaxException("Expecting: Given, Where, Letting, Find, Branching on, Heuristic or preserveVariables statement. Found: " + this.tokens.toString());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void readGiven() throws EPrimeSyntaxException {
        this.readTerminalString("given");
        this.tokens.commit("Parsed 'given' keyword.");
        ASTNode aSTNode = this.readIdList();
        try {
            this.tokens.mark("given");
            this.readTerminalString(":");
            this.tokens.commit("Parsed 'given ... :'.");
            ASTNode aSTNode2 = this.readExpression();
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.m.global_symbols.lettings_givens.add(new Given(aSTNode.getChild(i), aSTNode2));
            }
            this.tokens.eraseMark("given");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("given");
            this.readTerminalString("new");
            this.readTerminalString("domain");
            this.readTerminalString("int");
            this.tokens.commit("Successfully parsed 'given ... new domain int'.");
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.m.global_symbols.lettings_givens.add(new Given(aSTNode.getChild(i), new IntegerDomain(new Range(null, null))));
            }
        }
    }

    private void readWhere() throws EPrimeSyntaxException {
        this.readTerminalString("where");
        this.tokens.commit("Successfully parsed 'where' keyword.");
        ASTNode aSTNode = this.readExpression();
        this.m.global_symbols.lettings_givens.add(new Where(new FailWhenFalse(aSTNode, "Where statement is false: where " + String.valueOf(aSTNode))));
    }

    private ASTNode readLetting() throws EPrimeSyntaxException {
        this.readTerminalString("letting");
        this.tokens.commit("Parsed 'letting' keyword.");
        ASTNode aSTNode = this.readIdentifier();
        this.tokens.commit("Parsed 'letting' keyword and identifier.");
        try {
            this.tokens.mark("rl");
            this.readTerminalString("be");
            this.readTerminalString("domain");
            this.tokens.commit("Successfully parsed 'letting ... be domain'.");
            ASTNode aSTNode2 = this.readExpression();
            this.tokens.eraseMark("rl");
            return new Letting(aSTNode, aSTNode2);
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            ASTNode aSTNode3;
            this.tokens.reset("rl");
            try {
                this.tokens.mark("rldom");
                this.readTerminalString(":");
                this.tokens.commit("Successfully parsed 'letting ... :'.");
                aSTNode3 = this.readExpression();
                this.tokens.eraseMark("rldom");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("rldom");
                aSTNode3 = null;
            }
            try {
                this.tokens.mark("rlp");
                this.readTerminalString("be");
                this.tokens.eraseMark("rlp");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                this.tokens.reset("rlp");
                this.readTerminalString("=");
            }
            this.tokens.commit("Successfully parsed 'letting ... be'.");
            ASTNode aSTNode4 = null;
            try {
                this.tokens.mark("quick");
                aSTNode4 = this.readQuickConstantMatrixNotDeref();
                this.tokens.eraseMark("quick");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException4) {
                this.tokens.reset("quick");
            }
            if (aSTNode4 == null) {
                aSTNode4 = this.readExpression();
            }
            this.tokens.commit("Letting statement read successfully");
            if (aSTNode3 == null) {
                return new Letting(aSTNode, aSTNode4);
            }
            return new Letting(aSTNode, aSTNode4, aSTNode3);
        }
    }

    private void readFind() throws EPrimeSyntaxException {
        this.readTerminalString("find");
        this.tokens.commit("Parsed 'find' keyword.");
        ASTNode aSTNode = this.readIdList();
        this.tokens.commit("Parsed 'find' keyword and list of identifiers.");
        this.readTerminalString(":");
        this.tokens.commit("Parsed 'find ... :'.");
        ASTNode aSTNode2 = this.readExpression();
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            this.m.global_symbols.lettings_givens.add(new Find(aSTNode.getChild(i), aSTNode2.copy()));
        }
    }

    private void readBranchingOn() throws EPrimeSyntaxException {
        this.readTerminalString("branching");
        this.readTerminalString("on");
        this.tokens.commit("Parsed 'branching on'.");
        if (this.branchingon != null) {
            throw new EPrimeSyntaxException("Expected at most one 'branching on' statement. Found a second 'branching on' statement.");
        }
        this.branchingon = this.readMagicList();
    }

    private void readPreserveVariables() throws EPrimeSyntaxException {
        this.readTerminalString("preserveVariables");
        this.tokens.commit("Parsed 'preserveVariables'.");
        if (this.preservevariables != null) {
            throw new EPrimeSyntaxException("Expected at most one 'preserveVariables' statement. Found a second 'preserveVariables' statement.");
        }
        this.preservevariables = this.readMagicList();
    }

    private ASTNode readMagicList() throws EPrimeSyntaxException {
        this.readTerminalString("[");
        this.tokens.commit("Parsed '['.");
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        while (true) {
            try {
                this.tokens.mark("bo");
                arrayList.add(this.readExpression());
                this.tokens.eraseMark("bo");
                this.tokens.commit("Parsed entry in list.");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("bo");
                break;
            }
            try {
                this.tokens.mark("comma");
                this.readTerminalString(",");
                this.tokens.eraseMark("comma");
                this.tokens.commit("Parsed ',' in list.");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("comma");
                break;
            }
        }
        this.readTerminalString("]");
        for (int i = 0; i < arrayList.size(); ++i) {
            if (((ASTNode)arrayList.get(i)).getDimension() == 0) {
                ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                arrayList2.add(arrayList.get(i));
                arrayList.set(i, new CompoundMatrix(arrayList2));
            }
            arrayList.set(i, new Flatten(arrayList.get(i)));
        }
        return new Cat(arrayList);
    }

    private void readHeuristic() throws EPrimeSyntaxException {
        this.readTerminalString("heuristic");
        this.tokens.commit("Successfully parsed 'heuristic' keyword.");
        String string = this.readTerminalString();
        String string2 = null;
        if (string.equals("static")) {
            string2 = "STATIC";
        } else if (string.equals("sdf")) {
            string2 = "SDF";
        } else if (string.equals("conflict")) {
            string2 = "CONFLICT";
        } else if (string.equals("srf")) {
            string2 = "SRF";
        } else if (string.equals("ldf")) {
            string2 = "LDF";
        } else if (string.equals("wdeg")) {
            string2 = "WDEG";
        } else if (string.equals("domoverwdeg")) {
            string2 = "DOMOVERWDEG";
        }
        if (string2 == null) {
            throw new EPrimeSyntaxException("Expected static, sdf, conflict srf, ldf, wdeg or domoverwdeg, found:" + string);
        }
        if (this.heuristic != null) {
            throw new EPrimeSyntaxException("Expected at most one 'heuristic' statement. Found A second 'heuristic' statement.");
        }
        this.heuristic = string2;
    }

    private void readSNS() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("sns2");
            this.readTerminalString("SNSNeighbourhood");
            this.tokens.commit("Successfully parsed 'SNSNeighbourhood' keyword.");
            ASTNode[] aSTNodeArray = new ASTNode[5];
            aSTNodeArray[0] = this.readIdentifier();
            this.readTerminalString(":");
            this.readTerminalString("(");
            aSTNodeArray[1] = this.readExpression();
            this.readTerminalString(",");
            aSTNodeArray[2] = this.readExpression();
            this.readTerminalString(",");
            aSTNodeArray[3] = this.readIdentifier();
            this.readTerminalString(",");
            aSTNodeArray[4] = this.readMagicList();
            this.readTerminalString(")");
            this.tokens.eraseMark("sns2");
            this.neighbourhoods.add(new SNSNeighbourhood(aSTNodeArray));
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("sns2");
            try {
                this.tokens.mark("sns3");
                this.readTerminalString("SNSIncumbentMapping");
                this.tokens.commit("Successfully parsed 'SNSIncumbentMapping' keyword.");
                this.readTerminalString("(");
                ASTNode aSTNode = this.readMagicList();
                this.readTerminalString(",");
                ASTNode aSTNode2 = this.readMagicList();
                this.readTerminalString(")");
                this.tokens.eraseMark("sns3");
                this.incumbentmapping = new SNSIncumbentMapping(this.m, aSTNode, aSTNode2);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("sns3");
                this.readTerminalString("SNSGroup");
                this.tokens.commit("Successfully parsed 'SNSGroup' keyword.");
                ASTNode aSTNode = this.readIdentifier();
                this.readTerminalString(":");
                ASTNode aSTNode3 = this.readMagicList();
                this.groups.add(new SNSGroup(aSTNode, aSTNode3));
            }
        }
    }

    private ASTNode readSimpleDomainAtom() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("rsd");
            this.readTerminalString("bool");
            this.tokens.eraseMark("rsd");
            return new BooleanDomainFull();
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("rsd");
            try {
                this.tokens.mark("rsd2");
                this.readTerminalString("int");
                try {
                    ASTNode aSTNode;
                    this.tokens.mark("rsd3");
                    this.readTerminalString("(");
                    try {
                        this.tokens.mark("rsd5");
                        aSTNode = this.readUnboundedSetOfRanges();
                        this.tokens.eraseMark("rsd5");
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                        this.tokens.reset("rsd5");
                        aSTNode = new IntegerDomain(new EmptyRange());
                    }
                    this.readTerminalString(")");
                    this.tokens.eraseMark("rsd3");
                    this.tokens.eraseMark("rsd2");
                    return aSTNode;
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                    this.tokens.reset("rsd3");
                    this.tokens.eraseMark("rsd2");
                    return new IntegerDomain(new Range(null, null));
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException4) {
                this.tokens.reset("rsd2");
                ASTNode aSTNode = this.readIdentifier();
                return aSTNode;
            }
        }
    }

    private ASTNode readMatrixDomain() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        this.readTerminalString("matrix");
        this.tokens.commit("Successfully parsed 'matrix' keyword.");
        try {
            this.tokens.mark("indexedby");
            this.readTerminalString("indexed");
            this.readTerminalString("by");
            this.tokens.eraseMark("indexedby");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("indexedby");
        }
        this.tokens.commit("Successfully parsed 'matrix indexed by'.");
        this.readTerminalString("[");
        arrayList.add(this.readExpression());
        this.tokens.commit("Parsed 'matrix indexed by [...'.");
        try {
            while (true) {
                this.tokens.mark("rmdom");
                this.readTerminalString(",");
                this.tokens.commit("Parsed 'matrix indexed by [... ,'.");
                ASTNode aSTNode = this.readExpression();
                this.tokens.commit("Parsed 'matrix indexed by [...'.");
                this.tokens.eraseMark("rmdom");
                arrayList.add(aSTNode);
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("rmdom");
            this.readTerminalString("]");
            this.readTerminalString("of");
            this.tokens.commit("Successfully parsed 'matrix indexed by ... of'.");
            ASTNode aSTNode = this.readExpression();
            return new MatrixDomain(aSTNode, arrayList);
        }
    }

    private ASTNode readObjective() throws EPrimeSyntaxException {
        ASTNode aSTNode = null;
        try {
            this.tokens.mark();
            aSTNode = this.readMaximising();
            this.tokens.eraseMark();
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset();
            try {
                this.tokens.mark();
                aSTNode = this.readMinimising();
                this.tokens.eraseMark();
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset();
                throw new EPrimeSyntaxException("Expected objective, found: " + this.tokens.token);
            }
        }
        return aSTNode;
    }

    private ASTNode readMinimising() throws EPrimeSyntaxException {
        this.readTerminalString("minimising");
        this.tokens.commit("Successfully parsed 'minimising' keyword.");
        ASTNode aSTNode = this.readExpression();
        return new Minimising(aSTNode);
    }

    private ASTNode readMaximising() throws EPrimeSyntaxException {
        this.readTerminalString("maximising");
        this.tokens.commit("Successfully parsed 'maximising' keyword.");
        ASTNode aSTNode = this.readExpression();
        return new Maximising(aSTNode);
    }

    private ASTNode readConstraints() throws EPrimeSyntaxException {
        this.readTerminalString("such");
        this.readTerminalString("that");
        this.tokens.commit("Successfully parsed 'such that'.");
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        try {
            this.tokens.mark("con1");
            arrayList.add(this.readExpression());
            this.tokens.eraseMark("con1");
            try {
                while (true) {
                    this.tokens.mark("con2");
                    this.readTerminalString(",");
                    this.tokens.commit("Parsed comma.");
                    arrayList.add(this.readExpression());
                    this.tokens.eraseMark("con2");
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("con2");
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("con1");
        }
        this.tokens.nextToken();
        if (this.tokens.tokenType == 4) {
            return new Top(new And(arrayList));
        }
        throw new EPrimeSyntaxException("Expected constraint, found: " + this.tokens.toString());
    }

    private ASTNode readExpression() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(this.readPartExpression());
        this.tokens.commit("Successfully read part expression:" + String.valueOf(arrayList.get(0)));
        try {
            while (true) {
                this.tokens.mark("inreadexpression");
                ASTNode aSTNode = this.readBinOp();
                this.tokens.commit("Successfully read binop:" + String.valueOf(aSTNode));
                ASTNode aSTNode2 = this.readPartExpression();
                this.tokens.commit("Successfully read part expression:" + String.valueOf(aSTNode2));
                this.tokens.eraseMark("inreadexpression");
                arrayList.add(aSTNode);
                arrayList.add(aSTNode2);
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("inreadexpression");
            ShuntingYard shuntingYard = new ShuntingYard();
            ASTNode aSTNode = shuntingYard.convertToTree(arrayList);
            return aSTNode;
        }
    }

    private ASTNode readPartExpression() throws EPrimeSyntaxException {
        ASTNode aSTNode;
        try {
            this.tokens.mark("matdom");
            aSTNode = this.readMatrixDomain();
            this.tokens.eraseMark("matdom");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("matdom");
            try {
                this.tokens.mark("rpe");
                aSTNode = this.readBracketedExpression();
                this.tokens.eraseMark("rpe");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("rpe");
                try {
                    this.tokens.mark("rpe2");
                    aSTNode = this.readUnaryExpression();
                    this.tokens.eraseMark("rpe2");
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                    this.tokens.reset("rpe2");
                    try {
                        this.tokens.mark("rpe3");
                        aSTNode = this.readConstant();
                        this.tokens.eraseMark("rpe3");
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException4) {
                        this.tokens.reset("rpe3");
                        try {
                            this.tokens.mark("rpe4");
                            aSTNode = this.readGlobalConstraint();
                            this.tokens.eraseMark("rpe4");
                        }
                        catch (EPrimeSyntaxException ePrimeSyntaxException5) {
                            this.tokens.reset("rpe4");
                            try {
                                this.tokens.mark("rpe5");
                                aSTNode = this.readQuantifiedExpression();
                                this.tokens.eraseMark("rpe5");
                            }
                            catch (EPrimeSyntaxException ePrimeSyntaxException6) {
                                this.tokens.reset("rpe5");
                                try {
                                    this.tokens.mark("rpe6");
                                    aSTNode = this.readArrayExpression();
                                    this.tokens.eraseMark("rpe6");
                                }
                                catch (EPrimeSyntaxException ePrimeSyntaxException7) {
                                    this.tokens.reset("rpe6");
                                    try {
                                        this.tokens.mark("rpe7");
                                        aSTNode = this.readSetComprehensionOrLiteral();
                                        this.tokens.eraseMark("rpe7");
                                    }
                                    catch (EPrimeSyntaxException ePrimeSyntaxException8) {
                                        this.tokens.reset("rpe7");
                                        aSTNode = this.readSimpleDomainAtom();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        try {
            this.tokens.mark("slice");
            aSTNode = this.readSliceOrDeref(aSTNode);
            this.tokens.eraseMark("slice");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("slice");
        }
        return aSTNode;
    }

    private ASTNode readBracketedExpression() throws EPrimeSyntaxException {
        this.readTerminalString("(");
        ASTNode aSTNode = this.readExpression();
        this.readTerminalString(")");
        aSTNode = new Brackets(aSTNode);
        try {
            this.tokens.mark("slice");
            aSTNode = this.readSliceOrDeref(aSTNode);
            this.tokens.eraseMark("slice");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("slice");
        }
        return aSTNode;
    }

    private ASTNode readUnaryExpression() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("not");
            this.readTerminalString("!");
            this.tokens.commit("Read '!' (negation)");
            ASTNode aSTNode = this.readPartExpression();
            this.tokens.eraseMark("not");
            return new Negate(aSTNode);
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("not");
            try {
                this.tokens.mark("unaryminus");
                this.readTerminalString("-");
                this.tokens.commit("Read '-' (unary minus)");
                ASTNode aSTNode = this.readPartExpression();
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
                try {
                    while (true) {
                        this.tokens.mark("trypow");
                        this.readTerminalString("**");
                        this.tokens.commit("Read '**' (power)");
                        arrayList.add(this.readPartExpression());
                        this.tokens.eraseMark("trypow");
                    }
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                    this.tokens.reset("trypow");
                    this.tokens.eraseMark("unaryminus");
                    if (arrayList.size() > 0) {
                        ASTNode aSTNode2 = (ASTNode)arrayList.get(arrayList.size() - 1);
                        arrayList.remove(arrayList.size() - 1);
                        while (arrayList.size() > 0) {
                            aSTNode2 = new Power((ASTNode)arrayList.get(arrayList.size() - 1), aSTNode2);
                            arrayList.remove(arrayList.size() - 1);
                        }
                        aSTNode2 = new Power(aSTNode, aSTNode2);
                        return new UnaryMinus(aSTNode2);
                    }
                    return new UnaryMinus(aSTNode);
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                this.tokens.reset("unaryminus");
                this.readTerminalString("|");
                this.tokens.commit("Read '|' (absolute value)");
                ASTNode aSTNode = this.readExpression();
                this.readTerminalString("|");
                return new Absolute(aSTNode);
            }
        }
    }

    private ASTNode readGlobalConstraint() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("readtab");
            ASTNode aSTNode = this.readTableConstraint();
            this.tokens.eraseMark("readtab");
            return aSTNode;
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("readtab");
            try {
                this.tokens.mark("func");
                ASTNode aSTNode = this.readFunction();
                this.tokens.eraseMark("func");
                return aSTNode;
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("func");
                ASTNode aSTNode = this.readFunctionGeneric();
                return aSTNode;
            }
        }
    }

    private ASTNode readFunction() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("min");
            this.readTerminalString("min");
            this.tokens.commit("Parsed keyword 'min'");
            this.tokens.eraseMark("min");
            this.readTerminalString("(");
            ASTNode aSTNode = this.readExpression();
            boolean bl = this.tryReadTerminalString(",");
            if (bl) {
                ASTNode aSTNode2 = this.readExpression();
                this.readTerminalString(")");
                return new Min(aSTNode, aSTNode2);
            }
            this.readTerminalString(")");
            return new MinVector(aSTNode);
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("min");
            try {
                this.tokens.mark("max");
                this.readTerminalString("max");
                this.tokens.commit("Parsed keyword 'max'");
                this.tokens.eraseMark("max");
                this.readTerminalString("(");
                ASTNode aSTNode = this.readExpression();
                boolean bl = this.tryReadTerminalString(",");
                if (bl) {
                    ASTNode aSTNode3 = this.readExpression();
                    this.readTerminalString(")");
                    return new Max(aSTNode, aSTNode3);
                }
                this.readTerminalString(")");
                return new MaxVector(aSTNode);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("max");
                this.readTerminalString("sum");
                this.readTerminalString("(");
                this.tokens.commit("Parsed keyword 'sum'");
                ASTNode aSTNode = this.readArrayExpression();
                this.readTerminalString(")");
                return new SumVector(aSTNode);
            }
        }
    }

    private ASTNode readFunctionGeneric() throws EPrimeSyntaxException {
        this.tokens.mark("readfuncg");
        try {
            String string = this.readTerminalString();
            if (!this.funcs.containsKey(string)) {
                throw new EPrimeSyntaxException("Expected generic Function, found something unknown.");
            }
            FunctionDescription functionDescription = this.funcs.get(string);
            this.readTerminalString("(");
            this.tokens.commit("Parsed function name " + string + " and open bracket.");
            ASTNode aSTNode = this.readExpression();
            ASTNode aSTNode2 = null;
            ASTNode aSTNode3 = null;
            ASTNode aSTNode4 = null;
            if (functionDescription.numArgs > 1) {
                this.readTerminalString(",");
                aSTNode2 = this.readExpression();
                if (functionDescription.numArgs > 2) {
                    this.readTerminalString(",");
                    aSTNode3 = this.readExpression();
                }
                if (functionDescription.numArgs > 3) {
                    this.readTerminalString(",");
                    aSTNode4 = this.readExpression();
                }
            }
            this.readTerminalString(")");
            ASTNode aSTNode5 = functionDescription.construct(aSTNode, aSTNode2, aSTNode3, aSTNode4);
            this.tokens.eraseMark("readfuncg");
            return aSTNode5;
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("readfuncg");
            throw ePrimeSyntaxException;
        }
    }

    private ASTNode readTableConstraint() throws EPrimeSyntaxException {
        try {
            ASTNode aSTNode;
            this.tokens.mark("tab");
            this.readTerminalString("table");
            this.tokens.commit("Parsed keyword 'table'");
            this.readTerminalString("(");
            ASTNode aSTNode2 = this.readArrayExpression();
            this.readTerminalString(",");
            this.tokens.commit("Parsed 'table(...,', expecting matrix of satisfying tuples.");
            try {
                this.tokens.mark("tableinner");
                this.readTerminalString("[");
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
                while (true) {
                    try {
                        this.tokens.mark();
                        arrayList.add(this.readTuple());
                        this.tokens.eraseMark();
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException) {
                        this.tokens.reset();
                        break;
                    }
                    try {
                        this.tokens.mark();
                        this.readTerminalString(",");
                        this.tokens.eraseMark();
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException) {
                        this.tokens.reset();
                        break;
                    }
                }
                this.readTerminalString("]");
                this.tokens.eraseMark("tableinner");
                aSTNode = CompoundMatrix.make(arrayList);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("tableinner");
                aSTNode = this.readArrayExpression();
            }
            this.readTerminalString(")");
            this.tokens.eraseMark("tab");
            return new Table(this.m, aSTNode2, aSTNode);
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("tab");
            this.readTerminalString("tableshort");
            this.tokens.commit("Parsed keyword 'tableshort'");
            this.readTerminalString("(");
            ASTNode aSTNode = this.readArrayExpression();
            this.readTerminalString(",");
            ASTNode aSTNode3 = this.readArrayExpression();
            this.readTerminalString(")");
            return new TableShort(this.m, aSTNode, aSTNode3);
        }
    }

    private ASTNode readQuantifiedExpression() throws EPrimeSyntaxException {
        int n;
        try {
            this.tokens.mark();
            try {
                this.tokens.mark("forall");
                this.readTerminalString("forall");
                this.tokens.eraseMark("forall");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("forall");
                this.readTerminalString("forAll");
            }
            this.tokens.eraseMark();
            n = 1;
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset();
            try {
                this.tokens.mark();
                this.readTerminalString("exists");
                this.tokens.eraseMark();
                n = 2;
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset();
                this.readTerminalString("sum");
                n = 3;
            }
        }
        ASTNode aSTNode = this.readIdList();
        this.readTerminalString(":");
        ASTNode aSTNode2 = this.readExpression();
        this.readTerminalString(".");
        ASTNode aSTNode3 = this.readExpression();
        for (int i = aSTNode.numChildren() - 1; i >= 0; --i) {
            if (n == 1) {
                aSTNode3 = new ForallExpression(aSTNode.getChild(i), aSTNode2, aSTNode3);
                continue;
            }
            if (n == 2) {
                aSTNode3 = new ExistsExpression(aSTNode.getChild(i), aSTNode2, aSTNode3);
                continue;
            }
            assert (n == 3);
            aSTNode3 = new QuantifiedSum(aSTNode.getChild(i), aSTNode2, aSTNode3);
        }
        return aSTNode3;
    }

    private ASTNode readSliceOrDeref(ASTNode aSTNode) throws EPrimeSyntaxException {
        Object object;
        this.readTerminalString("[");
        this.tokens.commit("Parsed '[' (start of matrix deref or slice)");
        ArrayList<ASTNode> arrayList = this.readSliceRangeList();
        this.readTerminalString("]");
        boolean bl = false;
        for (ASTNode aSTNode2 : arrayList) {
            if (!aSTNode2.isSet()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.tokens.commit("Parsed ']' (end of matrix slice)");
            object = new MatrixSlice(this.m, aSTNode, arrayList);
        } else {
            this.tokens.commit("Parsed ']' (end of matrix deref)");
            object = new MatrixDeref(aSTNode, arrayList);
        }
        if (bl) {
            try {
                this.tokens.mark("readslicerecurse");
                object = this.readSliceOrDeref((ASTNode)object);
                this.tokens.eraseMark("readslicerecurse");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("readslicerecurse");
            }
        }
        return object;
    }

    private ASTNode readArrayExpression() throws EPrimeSyntaxException {
        ASTNode aSTNode;
        try {
            this.tokens.mark("arrayfunc");
            aSTNode = this.readArrayFunction();
            this.tokens.eraseMark("arrayfunc");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("arrayfunc");
            try {
                this.tokens.mark("arrayvarious");
                aSTNode = this.readArrayExpressionInner();
                this.tokens.eraseMark("arrayvarious");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("arrayvarious");
                this.readTerminalString("(");
                aSTNode = this.readArrayExpression();
                this.readTerminalString(")");
            }
        }
        try {
            this.tokens.mark("slice");
            aSTNode = this.readSliceOrDeref(aSTNode);
            this.tokens.eraseMark("slice");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("slice");
        }
        return aSTNode;
    }

    private ASTNode readArrayFunction() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("flat");
            this.readTerminalString("flatten");
            this.readTerminalString("(");
            this.tokens.commit("Read flatten(");
            try {
                this.tokens.mark("flat2");
                ASTNode aSTNode = this.readArrayExpression();
                this.readTerminalString(")");
                this.tokens.eraseMark("flat2");
                this.tokens.eraseMark("flat");
                return new Flatten(aSTNode);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                long l;
                this.tokens.reset("flat2");
                if (l < 1L) {
                    throw new EPrimeSyntaxException("Expected integer >=1 in flatten, found: " + String.valueOf(l));
                }
                this.readTerminalString(",");
                ASTNode aSTNode = this.readArrayExpression();
                this.readTerminalString(")");
                this.tokens.eraseMark("flat");
                for (l = this.readPositiveInt(); l > 0L; --l) {
                    aSTNode = new ConcatenateMatrix(aSTNode);
                }
                return aSTNode;
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("flat");
            try {
                this.tokens.mark("cat");
                this.readTerminalString("cat");
                this.readTerminalString("(");
                this.tokens.commit("Read cat(");
                ArrayList<ASTNode> arrayList = this.readCommaSeparatedList();
                this.readTerminalString(")");
                this.tokens.eraseMark("cat");
                return new Cat(arrayList);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("cat");
                try {
                    this.tokens.mark("list");
                    this.readTerminalString("list");
                    this.readTerminalString("(");
                    this.tokens.commit("Read list(");
                    ArrayList<ASTNode> arrayList = this.readCommaSeparatedList();
                    this.readTerminalString(")");
                    this.tokens.eraseMark("list");
                    return new ListFunction(arrayList);
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                    this.tokens.reset("list");
                    return this.readFunctionGeneric();
                }
            }
        }
    }

    private ArrayList<ASTNode> readCommaSeparatedList() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        try {
            this.tokens.mark("readexp");
            ASTNode aSTNode = this.readPartExpression();
            arrayList.add(aSTNode);
            this.tokens.eraseMark("readexp");
            this.tokens.commit("Read expression in comma-separated list of arguments.");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("readexp");
            return arrayList;
        }
        try {
            this.tokens.mark("rrl");
            this.readTerminalString(",");
            this.tokens.commit("Read ',' in comma-separated list of arguments.");
            arrayList.addAll(this.readCommaSeparatedList());
            this.tokens.eraseMark("rrl");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("rrl");
        }
        return arrayList;
    }

    private ASTNode readArrayExpressionInner() throws EPrimeSyntaxException {
        ASTNode aSTNode;
        try {
            this.tokens.mark("comparray");
            aSTNode = this.readCompoundOrComprehensionArrayExpression();
            this.tokens.eraseMark("comparray");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("comparray");
            aSTNode = this.readIdentifier();
        }
        return aSTNode;
    }

    private ArrayList<ASTNode> readSliceRangeList() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        try {
            this.tokens.mark("readdotdot");
            this.readTerminalString("..");
            arrayList.add(new IntegerDomain(new Range(null, null)));
            this.tokens.eraseMark("readdotdot");
            this.tokens.commit("Read '..' in matrix slice or deref.");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("readdotdot");
            arrayList.add(this.readExpression());
        }
        try {
            this.tokens.mark("rrl");
            this.readTerminalString(",");
            this.tokens.commit("Read ',' in matrix slice or deref.");
            arrayList.addAll(this.readSliceRangeList());
            this.tokens.eraseMark("rrl");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("rrl");
        }
        return arrayList;
    }

    private ASTNode readCompoundOrComprehensionArrayExpression() throws EPrimeSyntaxException {
        this.readTerminalString("[");
        this.tokens.commit("Parsed '[' (start of matrix literal or matrix comprehension)");
        try {
            this.tokens.mark("emptymatrix");
            this.readTerminalString("]");
            this.tokens.commit("Parsed '[ ]' (empty matrix)");
            try {
                this.tokens.mark("empty2");
                this.readTerminalString(":");
                this.tokens.commit("Parsed '[ ] :' (empty matrix with type annotation)");
                this.readTerminalString("`");
                this.tokens.commit("Parsed '[ ] : `' (empty matrix with type annotation)");
                ASTNode aSTNode = this.readMatrixDomain();
                this.readTerminalString("`");
                this.tokens.eraseMark("empty2");
                this.tokens.eraseMark("emptymatrix");
                return new EmptyMatrix(aSTNode);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("empty2");
                this.tokens.eraseMark("emptymatrix");
                return CompoundMatrix.make(new ArrayList<ASTNode>());
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            boolean bl;
            this.tokens.reset("emptymatrix");
            boolean bl2 = false;
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            while (true) {
                try {
                    this.tokens.mark();
                    ASTNode aSTNode = this.readExpression();
                    this.tokens.eraseMark();
                    arrayList.add(aSTNode);
                    if (arrayList.size() == 1) {
                        this.tokens.commit("Parsed first element in matrix literal or comprehension.");
                    } else {
                        this.tokens.commit("Parsed element in matrix literal.");
                    }
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                    this.tokens.reset();
                    break;
                }
                boolean bl3 = bl2 = !this.tryReadTerminalString(",");
                if (bl2) break;
                this.tokens.commit("Parsed ',' in matrix literal or comprehension.");
            }
            if (bl2 && arrayList.size() == 1 && (bl = this.tryReadTerminalString("|"))) {
                this.tokens.commit("Parsed '|' (in comprehension)");
                return this.readComprehensionInner(arrayList.get(0));
            }
            ASTNode aSTNode = null;
            try {
                this.tokens.mark("optdom");
                this.readTerminalString(";");
                aSTNode = this.readExpression();
                this.tokens.eraseMark("optdom");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                this.tokens.reset("optdom");
            }
            this.readTerminalString("]");
            if (aSTNode == null) {
                return CompoundMatrix.make(arrayList);
            }
            return CompoundMatrix.make(aSTNode, arrayList, false);
        }
    }

    private ASTNode readComprehensionInner(ASTNode aSTNode) throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        boolean bl = true;
        try {
            while (true) {
                this.tokens.mark("cquant");
                if (!bl) {
                    this.readTerminalString(",");
                }
                ASTNode aSTNode2 = this.readIdList();
                this.readTerminalString(":");
                ASTNode aSTNode3 = this.readExpression();
                this.tokens.eraseMark("cquant");
                for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                    arrayList.add(new ComprehensionForall(aSTNode2.getChild(i), aSTNode3));
                }
                bl = false;
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("cquant");
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            try {
                while (true) {
                    this.tokens.mark("ccond");
                    if (!bl) {
                        this.readTerminalString(",");
                    }
                    ASTNode aSTNode4 = this.readExpression();
                    this.tokens.eraseMark("ccond");
                    arrayList2.add(aSTNode4);
                    bl = false;
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("ccond");
                ASTNode aSTNode5 = null;
                try {
                    this.tokens.mark("optdom");
                    this.readTerminalString(";");
                    aSTNode5 = this.readExpression();
                    this.tokens.eraseMark("optdom");
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                    this.tokens.reset("optdom");
                }
                this.readTerminalString("]");
                if (aSTNode5 == null) {
                    return new ComprehensionMatrix(aSTNode, arrayList, (ASTNode)new And(arrayList2));
                }
                return new ComprehensionMatrix(aSTNode, arrayList, (ASTNode)new And(arrayList2), aSTNode5);
            }
        }
    }

    private ASTNode readQuickConstantMatrixNotDeref() throws EPrimeSyntaxException {
        ASTNode aSTNode = this.readQuickConstantMatrix();
        this.tokens.mark("brac");
        boolean bl = false;
        try {
            this.readTerminalString("[");
            bl = true;
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            // empty catch block
        }
        this.tokens.reset("brac");
        if (bl) {
            throw new EPrimeSyntaxException("Expected simple matrix, found matrix deref");
        }
        return aSTNode;
    }

    private ASTNode readQuickConstantMatrix() throws EPrimeSyntaxException {
        this.readTerminalString("[");
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        while (true) {
            try {
                this.tokens.mark();
                long l = this.readPositiveInt();
                this.tokens.eraseMark();
                arrayList.add(NumberConstant.make(l));
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset();
                try {
                    this.tokens.mark("nested");
                    ASTNode aSTNode = this.readQuickConstantMatrix();
                    this.tokens.eraseMark("nested");
                    arrayList.add(aSTNode);
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                    this.tokens.reset("nested");
                    break;
                }
            }
            try {
                this.tokens.mark();
                this.readTerminalString(",");
                this.tokens.eraseMark();
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset();
                break;
            }
        }
        this.readTerminalString("]");
        return CompoundMatrix.make(arrayList);
    }

    private ArrayList<ASTNode> readRangeList() throws EPrimeSyntaxException {
        ASTNode aSTNode = this.readOpenRange();
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        try {
            this.tokens.mark("rrl");
            this.readTerminalString(",");
            arrayList.addAll(this.readRangeList());
            this.tokens.eraseMark("rrl");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("rrl");
        }
        return arrayList;
    }

    private ASTNode readOpenRange() throws EPrimeSyntaxException {
        boolean bl = this.tryReadTerminalString("..");
        if (bl) {
            try {
                this.tokens.mark("oprange");
                ASTNode aSTNode = this.readExpression();
                this.tokens.eraseMark("oprange");
                return new Range(null, aSTNode);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("oprange");
                return new Range(null, null);
            }
        }
        ASTNode aSTNode = this.readExpression();
        boolean bl2 = this.tryReadTerminalString("..");
        if (bl2) {
            try {
                this.tokens.mark("oprange2");
                ASTNode aSTNode2 = this.readExpression();
                this.tokens.eraseMark("oprange2");
                return new Range(aSTNode, aSTNode2);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("oprange2");
                return new Range(aSTNode, null);
            }
        }
        return aSTNode;
    }

    private ASTNode readBinOp() throws EPrimeSyntaxException {
        this.tokens.nextToken();
        if (this.tokens.tokenType != 0 && this.tokens.tokenType != 2) {
            throw new EPrimeSyntaxException("Expected binary operator, found: " + this.tokens.token);
        }
        if (!this.binops.contains(this.tokens.token)) {
            throw new EPrimeSyntaxException("Expected binary operator, found: " + this.tokens.token);
        }
        return new BinOpPlaceholder(this.tokens.token);
    }

    private ASTNode readIdList() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(this.readIdentifier());
        try {
            while (true) {
                this.tokens.mark("readidlist");
                this.readTerminalString(",");
                arrayList.add(this.readIdentifier());
                this.tokens.eraseMark("readidlist");
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("readidlist");
            return new Container(arrayList);
        }
    }

    private ASTNode readTuple() throws EPrimeSyntaxException {
        this.readTerminalString("<");
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        while (true) {
            try {
                this.tokens.mark();
                arrayList.add(this.readConstant());
                this.tokens.eraseMark();
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset();
                break;
            }
            try {
                this.tokens.mark();
                this.readTerminalString(",");
                this.tokens.eraseMark();
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset();
                break;
            }
        }
        this.readTerminalString(">");
        return CompoundMatrix.make(arrayList);
    }

    private ASTNode readIdentifier() throws EPrimeSyntaxException {
        this.tokens.nextToken();
        if (this.tokens.tokenType != 0 || this.keywords.contains(this.tokens.wordToken)) {
            throw new EPrimeSyntaxException("Expected a variable identifier. Found: " + this.tokens.toString());
        }
        return new Identifier(this.m, this.tokens.wordToken);
    }

    private ASTNode makeUnionOfRanges(ArrayList<ASTNode> arrayList, int n, int n2) {
        if (n2 - n < 5) {
            ASTNodeC aSTNodeC = new IntegerDomain(arrayList.get(n));
            for (int i = n + 1; i < n2; ++i) {
                aSTNodeC = new Union((ASTNode)aSTNodeC, new IntegerDomain(arrayList.get(i)));
            }
            return aSTNodeC;
        }
        return new Union(this.makeUnionOfRanges(arrayList, n, n + (n2 - n) / 2), this.makeUnionOfRanges(arrayList, n + (n2 - n) / 2, n2));
    }

    private ASTNode readUnboundedSetOfRanges() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = this.readRangeList();
        return this.makeUnionOfRanges(arrayList, 0, arrayList.size());
    }

    private ASTNode readSetComprehensionOrLiteral() throws EPrimeSyntaxException {
        boolean bl;
        this.readTerminalString("{");
        this.tokens.commit("Parsed '{' (start of set literal or set comprehension)");
        if (this.tryReadTerminalString("}")) {
            return new IntegerDomain(new EmptyRange());
        }
        boolean bl2 = false;
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        while (true) {
            try {
                this.tokens.mark();
                ASTNode aSTNode = this.readExpression();
                this.tokens.eraseMark();
                if (this.tryReadTerminalString("..")) {
                    this.tokens.commit("Read up to ..");
                    this.tokens.mark();
                    ASTNode aSTNode2 = this.readExpression();
                    this.tokens.eraseMark();
                    aSTNode = new Range(aSTNode, aSTNode2);
                }
                arrayList.add(aSTNode);
                if (arrayList.size() == 1) {
                    this.tokens.commit("Parsed first element in set literal or comprehension.");
                } else {
                    this.tokens.commit("Parsed element in set literal.");
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset();
                break;
            }
            boolean bl3 = bl2 = !this.tryReadTerminalString(",");
            if (bl2) break;
            this.tokens.commit("Parsed ',' in set literal.");
        }
        if (bl2 && arrayList.size() == 1 && (bl = this.tryReadTerminalString("|"))) {
            if (arrayList.get(0) instanceof Range) {
                throw new EPrimeSyntaxException("Expected a single expression in set comprehension, found an interval.");
            }
            this.tokens.commit("Parsed '|' (in set comprehension)");
            return this.readSetComprehensionInner(arrayList.get(0));
        }
        this.readTerminalString("}");
        return this.makeUnionOfRanges(arrayList, 0, arrayList.size());
    }

    private ASTNode readSetComprehensionInner(ASTNode aSTNode) throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        boolean bl = true;
        try {
            while (true) {
                this.tokens.mark("cquant");
                if (!bl) {
                    this.readTerminalString(",");
                }
                ASTNode aSTNode2 = this.readIdList();
                this.readTerminalString(":");
                ASTNode aSTNode3 = this.readExpression();
                this.tokens.eraseMark("cquant");
                for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                    arrayList.add(new ComprehensionForall(aSTNode2.getChild(i), aSTNode3));
                }
                bl = false;
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("cquant");
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            try {
                while (true) {
                    this.tokens.mark("ccond");
                    if (!bl) {
                        this.readTerminalString(",");
                    }
                    ASTNode aSTNode4 = this.readExpression();
                    this.tokens.eraseMark("ccond");
                    arrayList2.add(aSTNode4);
                    bl = false;
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("ccond");
                this.readTerminalString("}");
                return new ToSet(new ComprehensionMatrix(aSTNode, arrayList, (ASTNode)new And(arrayList2)));
            }
        }
    }

    private ASTNode readConstant() throws EPrimeSyntaxException {
        try {
            this.tokens.mark();
            long l = this.readPositiveInt();
            this.tokens.eraseMark();
            return NumberConstant.make(l);
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset();
            try {
                this.tokens.mark();
                this.readTerminalString("true");
                this.tokens.eraseMark();
                return new BooleanConstant(true);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset();
                this.readTerminalString("false");
                return new BooleanConstant(false);
            }
        }
    }

    private long readPositiveInt() throws EPrimeSyntaxException {
        this.tokens.nextToken();
        if (this.tokens.tokenType == 3) {
            return this.tokens.intToken;
        }
        throw new EPrimeSyntaxException("Expected positive integer.");
    }

    private boolean tryReadTerminalString(String string) {
        try {
            this.tokens.mark("trts");
            this.readTerminalString(string);
            this.tokens.eraseMark("trts");
            return true;
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("trts");
            return false;
        }
    }

    private void readTerminalString(String string) throws EPrimeSyntaxException {
        this.tokens.nextToken();
        if (this.tokens.tokenType != 0 && this.tokens.tokenType != 2) {
            throw new EPrimeSyntaxException("Expected " + string + ", found " + this.tokens.toString());
        }
        if (this.tokens.tokenType == 0 && !this.tokens.wordToken.equals(string)) {
            throw new EPrimeSyntaxException("Expected " + string + ", found " + this.tokens.toString());
        }
        if (this.tokens.tokenType == 2 && !this.tokens.otherToken.equals(string)) {
            throw new EPrimeSyntaxException("Expected " + string + ", found " + this.tokens.toString());
        }
    }

    private void readTerminalStringPrime(String string) throws EPrimeSyntaxException {
        this.tokens.nextToken();
        if (this.tokens.tokenType != 1) {
            throw new EPrimeSyntaxException("Expected: " + string + " found: " + this.tokens.toString());
        }
        if (this.tokens.tokenType == 1 && !this.tokens.wordToken.equals(string)) {
            throw new EPrimeSyntaxException("Expected: " + string + " found: " + this.tokens.toString());
        }
    }

    private String readTerminalString() throws EPrimeSyntaxException {
        this.tokens.nextToken();
        if (this.tokens.tokenType == 0) {
            return this.tokens.wordToken;
        }
        if (this.tokens.tokenType == 2) {
            return this.tokens.otherToken;
        }
        throw new EPrimeSyntaxException("Unexpected:" + this.tokens.toString());
    }

    public class FunctionDescription {
        public String className;
        public int numArgs;

        FunctionDescription(String string, int n) {
            this.className = string;
            this.numArgs = n;
        }

        public ASTNode construct(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, ASTNode aSTNode4) {
            if (this.className.equals("ToSet")) {
                return new ToSet(aSTNode);
            }
            if (this.className.equals("Popcount")) {
                return new Popcount(aSTNode);
            }
            if (this.className.equals("ToInt")) {
                return new ToInt(aSTNode);
            }
            if (this.className.equals("MakeTable")) {
                return new MakeTable(aSTNode);
            }
            if (this.className.equals("IndexOf")) {
                return new IndexOf(aSTNode);
            }
            if (this.className.equals("Length")) {
                return new Length(aSTNode);
            }
            if (this.className.equals("IfThenElse")) {
                return new IfThenElse(aSTNode, aSTNode2, aSTNode3);
            }
            if (this.className.equals("AllDifferent")) {
                return new AllDifferent(aSTNode);
            }
            if (this.className.equals("Factorial")) {
                return new Factorial(aSTNode);
            }
            if (this.className.equals("TimesVector")) {
                return new TimesVector(aSTNode);
            }
            if (this.className.equals("AndVector")) {
                return new AndVector(aSTNode);
            }
            if (this.className.equals("OrVector")) {
                return new OrVector(aSTNode);
            }
            if (this.className.equals("XorVector")) {
                return new XorVector(aSTNode);
            }
            if (this.className.equals("Print")) {
                return new Print(aSTNode);
            }
            if (this.className.equals("IsRegularMatrix")) {
                return new IsRegularMatrix(aSTNode);
            }
            if (this.className.equals("FromSolution")) {
                return new FromSolution(aSTNode);
            }
            if (this.className.equals("DominanceRelation")) {
                return new DominanceRelation(aSTNode);
            }
            if (this.className.equals("Circuit")) {
                return new Circuit(aSTNode);
            }
            if (this.className.equals("Count")) {
                return new Count(aSTNode, aSTNode2);
            }
            if (this.className.equals("AllDifferentExcept")) {
                return new AllDifferentExcept(aSTNode, aSTNode2);
            }
            if (this.className.equals("CatchUndef")) {
                return new CatchUndef(aSTNode, aSTNode2);
            }
            if (this.className.equals("IncomparabilityFunction")) {
                return new IncomparabilityFunction(aSTNode, aSTNode2);
            }
            if (this.className.equals("ElementId")) {
                return new ElementId(aSTNode, aSTNode2);
            }
            if (this.className.equals("Disjunctive")) {
                return new Disjunctive(aSTNode, aSTNode2);
            }
            if (this.className.equals("Inverse")) {
                return new Inverse(aSTNode, aSTNode2);
            }
            if (this.className.equals("AMOPB")) {
                return new AMOPB(aSTNode, aSTNode2, aSTNode3, true);
            }
            if (this.className.equals("EOPB")) {
                return new EOPB(aSTNode, aSTNode2, aSTNode3, true);
            }
            if (this.className.equals("GlobalCard")) {
                return new GlobalCard(aSTNode, aSTNode2, aSTNode3);
            }
            if (this.className.equals("AtMost")) {
                return new AtMost(aSTNode, aSTNode2, aSTNode3);
            }
            if (this.className.equals("AtLeast")) {
                return new AtLeast(aSTNode, aSTNode2, aSTNode3);
            }
            if (this.className.equals("FrameUpdate")) {
                return new FrameUpdate(aSTNode, aSTNode2, aSTNode3, aSTNode4);
            }
            if (this.className.equals("Cumulative")) {
                return new Cumulative(aSTNode, aSTNode2, aSTNode3, aSTNode4);
            }
            if (this.className.equals("DiffN")) {
                return new DiffN(aSTNode, aSTNode2, aSTNode3, aSTNode4);
            }
            CmdFlags.errorExit("Internal error constructing: " + this.className);
            return null;
        }
    }
}

