/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Intpair;
import savilerow.model.SymbolTable;

public class Circuit
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Circuit(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new Circuit(this.getChild(0));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in circuit constraint: " + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if ((aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) && this.getChild(0).getCategory() == 0) {
            long l;
            if (aSTNode instanceof EmptyMatrix) {
                return new BooleanConstant(true);
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            ArrayList<Intpair> arrayList2 = aSTNode.getChild(0).getIntervalSet();
            long l2 = l = arrayList2.get((int)0).lower;
            arrayList.add(l2);
            while (!arrayList.contains(l2 = aSTNode.getChild((int)(l2 - l + 1L)).getValue())) {
                arrayList.add(l2);
            }
            return new BooleanConstant(arrayList.size() == aSTNode.numChildren() - 1);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.generic_to_string("circuit");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (CmdFlags.getOrtoolstrans() || CmdFlags.getChuffedtrans()) {
            if (CmdFlags.getOrtoolstrans()) {
                bufferedWriter.append("constraint ortools_circuit(");
            } else {
                bufferedWriter.append("constraint chuffed_circuit(");
            }
            this.getChild(0).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(",");
            bufferedWriter.append(String.valueOf(this.getChild((int)0).getChild((int)0).getBounds().lower));
            bufferedWriter.append(");");
        } else {
            if (CmdFlags.getGecodetrans()) {
                bufferedWriter.append("constraint gecode_circuit(");
            } else {
                bufferedWriter.append("constraint fzn_circuit(");
            }
            bufferedWriter.append(String.valueOf(this.getChild((int)0).getChild((int)0).getBounds().lower));
            bufferedWriter.append(",");
            this.getChild(0).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(");");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("circuit(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }
}

