/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.Flatten;
import savilerow.expression.FrameUpdateFlat;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.model.SymbolTable;

public class FrameUpdate
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public FrameUpdate(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, ASTNode aSTNode4) {
        super(aSTNode, aSTNode2, aSTNode3, aSTNode4);
    }

    @Override
    public ASTNode copy() {
        return new FrameUpdate(this.getChild(0), this.getChild(1), this.getChild(2), this.getChild(3));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < 4; ++i) {
            if (this.getChild(i).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() < 1) {
            CmdFlags.println("ERROR: Expected matrix with at least one dimension as source matrix in frameUpdate constraint: " + String.valueOf(this));
            return false;
        }
        if (this.getChild(1).getDimension() < 1) {
            CmdFlags.println("ERROR: Expected matrix with at least one dimension as target matrix in frameUpdate constraint: " + String.valueOf(this));
            return false;
        }
        if (this.getChild(2).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix for sourceIndices in frameUpdate constraint: " + String.valueOf(this));
            return false;
        }
        if (this.getChild(3).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix for targetIndices in frameUpdate constraint: " + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        for (int i = 0; i < 4; ++i) {
            if (this.getChild(i).isMatrixLiteral()) continue;
            return null;
        }
        ArrayList<ASTNode> arrayList = this.getChild(0).getIndexDomains();
        ArrayList<ASTNode> arrayList2 = this.getChild(1).getIndexDomains();
        ArrayList<Intpair> arrayList3 = arrayList.get(0).getIntervalSet();
        long l = Intpair.numValues(arrayList3);
        assert (arrayList3.equals(arrayList2.get(0).getIntervalSet())) : "Mismatch between indexing of source and target in frameUpdate constraint.";
        if (arrayList3.size() != 1 || arrayList3.get((int)0).lower != 1L || arrayList3.get((int)0).upper != l) assert (false) : "Source and target matrices must be indexed by int(1..n) in frameUpdate constraint.";
        long l2 = 1L;
        for (int i = 1; i < arrayList.size(); ++i) {
            long l3 = Intpair.numValues(arrayList.get(i).getIntervalSet());
            l2 *= l3;
        }
        long l4 = 1L;
        for (int i = 1; i < arrayList2.size(); ++i) {
            long l5 = Intpair.numValues(arrayList2.get(i).getIntervalSet());
            l4 *= l5;
        }
        assert (l2 == l4) : "Mismatch between block sizes of source and target in frameUpdate constraint.";
        return new FrameUpdateFlat(new Flatten(this.getChild(0)), new Flatten(this.getChild(1)), this.getChild(2), this.getChild(3), NumberConstant.make(l2));
    }

    @Override
    public String toString() {
        return "frameUpdate(" + String.valueOf(this.getChild(0)) + "," + String.valueOf(this.getChild(1)) + "," + String.valueOf(this.getChild(2)) + "," + String.valueOf(this.getChild(3)) + ")";
    }
}

