/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.Intpair;
import savilerow.expression.Maximising;
import savilerow.expression.Minimising;
import savilerow.expression.NumberConstant;
import savilerow.model.PB;
import savilerow.model.Sat;

public class MaxSATObjective
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public MaxSATObjective(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    public MaxSATObjective(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
    }

    @Override
    public ASTNode copy() {
        return new MaxSATObjective(this.getChildrenArray());
    }

    @Override
    public Intpair getBounds() {
        BigInteger bigInteger = BigInteger.valueOf(0L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        for (int i = 0; i < this.numChildren(); ++i) {
            Intpair intpair = this.getChild(i).getBounds();
            bigInteger = bigInteger.add(BigInteger.valueOf(intpair.lower));
            bigInteger2 = bigInteger2.add(BigInteger.valueOf(intpair.upper));
        }
        return new Intpair(Intpair.BigIntegerToLong(bigInteger), Intpair.BigIntegerToLong(bigInteger2));
    }

    @Override
    public ASTNode simplify() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        int n = -1;
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).isConstant()) continue;
            if (n == -1) {
                n = i;
                continue;
            }
            arrayList.set(n, NumberConstant.make(arrayList.get(n).getValue() + arrayList.get(i).getValue()));
            arrayList.set(i, arrayList.get(arrayList.size() - 1));
            arrayList.remove(arrayList.size() - 1);
            --i;
            bl = true;
        }
        if (bl) {
            if (arrayList.size() == 1 && arrayList.get(0).isConstant()) {
                return arrayList.get(0);
            }
            return new MaxSATObjective(arrayList);
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        if (this.getParent() instanceof Maximising) {
            for (int i = 0; i < this.numChildren(); ++i) {
                ArrayList<Intpair> arrayList = this.getChild(i).getIntervalSetExp();
                long l = arrayList.size() > 0 ? arrayList.get((int)0).lower : 0L;
                for (int j = 0; j < arrayList.size(); ++j) {
                    for (long k = arrayList.get((int)j).lower; k <= arrayList.get((int)j).upper; ++k) {
                        if (k <= l) continue;
                        sat.addSoftClause(this.getChild(i).directEncode(sat, k), k - l);
                    }
                }
            }
        } else {
            assert (this.getParent() instanceof Minimising);
            for (int i = 0; i < this.numChildren(); ++i) {
                ArrayList<Intpair> arrayList = this.getChild(i).getIntervalSetExp();
                long l = arrayList.size() > 0 ? arrayList.get((int)(arrayList.size() - 1)).upper : 0L;
                for (int j = 0; j < arrayList.size(); ++j) {
                    for (long k = arrayList.get((int)j).lower; k <= arrayList.get((int)j).upper; ++k) {
                        if (k >= l) continue;
                        sat.addSoftClause(this.getChild(i).directEncode(sat, k), l - k);
                    }
                }
            }
        }
    }

    @Override
    public int polarity(int n) {
        return this.polarity();
    }

    @Override
    public void toPB(PB pB) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        for (int i = 0; i < this.numChildren(); ++i) {
            System.out.println(this.getChild(i));
            System.out.println(this.getChild(i).getIntervalSetExp());
            pB.encodeIntegerTerm(this.getChild(i), 1L, arrayList, arrayList2, 0L);
        }
        pB.addExpression(arrayList, arrayList2, 0L);
    }
}

