/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.MaxSATObjective;
import savilerow.model.PB;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Minimising
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Minimising(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        assert (this.numChildren() == 1);
        return new Minimising(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() > 1) {
            CmdFlags.println("ERROR: Expected numerical expression or one-dimensional literal matrix in minimising, found a matrix: " + String.valueOf(this));
            return false;
        }
        if (this.getChild(0).getDimension() == 1 && !(this.getChild(0) instanceof CompoundMatrix)) {
            CmdFlags.println("ERROR: Expected numerical expression or one-dimensional literal matrix in minimising, found a matrix: " + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public int polarity(int n) {
        return -1;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("MINIMISING ");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append("\n");
    }

    @Override
    public String toString() {
        return "minimising " + String.valueOf(this.getChild(0)) + "\n";
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (!this.getChild(0).isConstant()) {
            bufferedWriter.append("minimize ");
            this.getChild(0).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(";\n");
        } else {
            bufferedWriter.append("satisfy;\n");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("minimize ");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(";\n");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        if (this.getChild(0) instanceof Identifier) {
            ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
            for (int i = 0; i < arrayList.size(); ++i) {
                Intpair intpair = arrayList.get(i);
                for (long j = intpair.lower; j <= intpair.upper; ++j) {
                    if (i >= arrayList.size() - 1 && j >= intpair.upper) continue;
                    sat.addSoftClause(this.getChild(0).orderEncode(sat, j));
                }
            }
        } else if (this.getChild(0) instanceof MaxSATObjective) {
            this.getChild(0).toSAT(sat);
        } else assert (this.getChild(0).isConstant());
    }

    @Override
    public void toMIP(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.append("Minimize\n");
        bufferedWriter.append("obj: ");
        this.getChild(0).toMIP(bufferedWriter);
        bufferedWriter.append("\n");
    }

    @Override
    public void toPB(PB pB) throws IOException {
        pB.write("min: ");
        if (this.getChild(0) instanceof MaxSATObjective) {
            this.getChild(0).toPB(pB);
        } else {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            pB.encodeIntegerTerm(this.getChild(0), 1L, arrayList, arrayList2, 0L);
            pB.addExpression(arrayList, arrayList2, 0L);
        }
        pB.write(";\n");
    }
}

