/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import savilerow.Constants;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.Divide;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.model.Sat;

public class SafeMod
extends BinOp {
    public static final long serialVersionUID = 1L;

    public SafeMod(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new SafeMod(this.getChild(0), this.getChild(1));
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            long l = this.getChild(0).getValue();
            long l2 = this.getChild(1).getValue();
            if (l2 == 0L) {
                return NumberConstant.make(0L);
            }
            return NumberConstant.make(this.mod(l, l2));
        }
        return null;
    }

    public long mod(long l, long l2) {
        return Intpair.BigIntegerToLong(BigInteger.valueOf(l).subtract(BigInteger.valueOf(Divide.div(l, l2)).multiply(BigInteger.valueOf(l2))));
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        --intpair2.upper;
        ++intpair2.lower;
        if (intpair2.upper < 0L) {
            intpair2.upper = 0L;
        }
        if (intpair2.lower > 0L) {
            intpair2.lower = 0L;
        }
        return intpair2;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = this.getChild(1).getIntervalSetExp();
        if (Intpair.numValues(arrayList) * Intpair.numValues(arrayList2) > (long)Constants.intervallim) {
            return super.getIntervalSetExp();
        }
        ArrayList<Intpair> arrayList3 = new ArrayList<Intpair>();
        for (int i = 0; i < arrayList.size(); ++i) {
            for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                for (int k = 0; k < arrayList2.size(); ++k) {
                    for (long i2 = arrayList2.get((int)k).lower; i2 <= arrayList2.get((int)k).upper; ++i2) {
                        if (i2 == 0L) continue;
                        long l = this.mod(j, i2);
                        arrayList3.add(new Intpair(l, l));
                    }
                }
            }
        }
        arrayList3.add(new Intpair(0L, 0L));
        Intpair.normalise(arrayList3);
        return arrayList3;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("modulo_undefzero(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(",");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public String toString() {
        return "(" + String.valueOf(this.getChild(0)) + "%" + String.valueOf(this.getChild(1)) + ")";
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(" mod ");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.ternaryEncoding(this, aSTNode);
    }

    @Override
    public boolean test(long l, long l2, long l3) {
        if (l2 == 0L) {
            return l3 == 0L;
        }
        return this.mod(l, l2) == l3;
    }

    @Override
    public long func(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        return this.mod(l, l2);
    }
}

