/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.Xor;
import savilerow.model.SymbolTable;

public class XorVector
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public XorVector(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new XorVector(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in xor function: " + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof Identifier && this.getChild(0).getCategory() == 0) {
            ASTNode aSTNode = ((Identifier)this.getChild(0)).getCM();
            boolean bl = false;
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                boolean bl2 = aSTNode.getChild(i).getValue() == 1L;
                bl = bl && !bl2 || !bl && bl2;
            }
            return new BooleanConstant(bl);
        }
        if (this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) {
            ASTNode[] aSTNodeArray = this.getChild(0).getChildrenArray(1);
            for (int i = 0; i < aSTNodeArray.length; ++i) {
                aSTNodeArray[i].setParent(null);
            }
            return new Xor(aSTNodeArray);
        }
        return null;
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public String toString() {
        return "xor(" + String.valueOf(this.getChild(0)) + ")";
    }
}

