/*
 * Decompiled with CFR 0.152.
 */
package savilerow.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanDomainFull;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intersect;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.Range;
import savilerow.model.SymbolTable;
import savilerow.treetransformer.TransformDeAux;
import savilerow.treetransformer.TransformFixSTRef;
import savilerow.treetransformer.TransformNormalise;
import savilerow.treetransformer.TransformSimplify;

public class FilteredDomainStore {
    private static final long serialVersionUID = 1L;
    private HashMap<String, ASTNode> aux_to_expression;
    private HashMap<ASTNode, ASTNode> aux_filtered_domain;
    SymbolTable st;
    private boolean firstPass;
    private boolean storeDomains;

    public FilteredDomainStore(SymbolTable symbolTable) {
        this.st = symbolTable;
        this.aux_to_expression = new HashMap();
        this.aux_filtered_domain = new HashMap();
        this.firstPass = true;
        this.storeDomains = false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilteredDomainStore)) {
            return false;
        }
        FilteredDomainStore filteredDomainStore = (FilteredDomainStore)object;
        if (!filteredDomainStore.aux_to_expression.equals(this.aux_to_expression)) {
            return false;
        }
        if (!filteredDomainStore.aux_filtered_domain.equals(this.aux_filtered_domain)) {
            return false;
        }
        return filteredDomainStore.firstPass == this.firstPass && filteredDomainStore.storeDomains == this.storeDomains;
    }

    public int hashCode() {
        return Objects.hash(this.aux_to_expression, this.aux_filtered_domain, this.firstPass, this.storeDomains);
    }

    public FilteredDomainStore copy(SymbolTable symbolTable) {
        FilteredDomainStore filteredDomainStore = new FilteredDomainStore(symbolTable);
        TransformFixSTRef transformFixSTRef = new TransformFixSTRef(symbolTable.m);
        for (String object : this.aux_to_expression.keySet()) {
            filteredDomainStore.aux_to_expression.put(object, transformFixSTRef.transform(this.aux_to_expression.get(object).copy()));
        }
        for (ASTNode aSTNode : this.aux_filtered_domain.keySet()) {
            filteredDomainStore.aux_filtered_domain.put(transformFixSTRef.transform(aSTNode.copy()), transformFixSTRef.transform(this.aux_filtered_domain.get(aSTNode).copy()));
        }
        filteredDomainStore.firstPass = this.firstPass;
        filteredDomainStore.storeDomains = this.storeDomains;
        return filteredDomainStore;
    }

    public void simplify() {
        if (CmdFlags.getUsePropagateExtend() && !this.firstPass) {
            TransformSimplify transformSimplify = new TransformSimplify();
            TransformNormalise transformNormalise = new TransformNormalise(this.st.m);
            HashMap<ASTNode, ASTNode> hashMap = new HashMap<ASTNode, ASTNode>(this.aux_filtered_domain.size(), 0.75f);
            for (Map.Entry<ASTNode, ASTNode> entry : this.aux_filtered_domain.entrySet()) {
                ASTNode aSTNode = entry.getKey();
                ASTNode aSTNode2 = entry.getValue();
                ASTNode aSTNode3 = transformSimplify.transform(aSTNode.copy());
                if (!aSTNode3.equals(aSTNode)) {
                    if (hashMap.containsKey(aSTNode3 = transformNormalise.transform(aSTNode3))) {
                        hashMap.put(aSTNode3, transformSimplify.transform(new Intersect((ASTNode)hashMap.get(aSTNode3), aSTNode2)));
                        continue;
                    }
                    hashMap.put(aSTNode3, aSTNode2);
                    continue;
                }
                if (hashMap.containsKey(aSTNode)) {
                    hashMap.put(aSTNode, transformSimplify.transform(new Intersect((ASTNode)hashMap.get(aSTNode), aSTNode2)));
                    continue;
                }
                hashMap.put(aSTNode, aSTNode2);
            }
            this.aux_filtered_domain = hashMap;
        }
    }

    public void auxVarRepresentsAST(String string, ASTNode aSTNode) {
        if (CmdFlags.getUsePropagateExtend()) {
            if (!this.firstPass && this.storeDomains) {
                this.aux_to_expression.clear();
                this.storeDomains = false;
            }
            TransformDeAux transformDeAux = new TransformDeAux(this.aux_to_expression);
            TransformSimplify transformSimplify = new TransformSimplify();
            TransformNormalise transformNormalise = new TransformNormalise(this.st.m);
            ASTNode aSTNode2 = aSTNode.copy();
            aSTNode2 = transformDeAux.transform(aSTNode2);
            aSTNode2 = transformSimplify.transform(aSTNode2);
            if (!(aSTNode2 = transformNormalise.transform(aSTNode2)).containsAux()) {
                this.aux_to_expression.put(string, aSTNode2);
            }
        }
    }

    public void auxVarFilteredDomain(String string, ASTNode aSTNode) {
        if (CmdFlags.getUsePropagateExtend()) {
            ASTNode aSTNode2 = this.aux_to_expression.get(string);
            if (aSTNode2 != null) {
                this.aux_filtered_domain.put(aSTNode2.copy(), aSTNode);
            }
            this.firstPass = false;
            this.storeDomains = true;
        }
    }

    public ASTNode constructDomain(ASTNode aSTNode, ASTNode aSTNode2) {
        if (!this.firstPass && this.storeDomains) {
            this.aux_to_expression.clear();
            this.storeDomains = false;
        }
        if (!this.firstPass && CmdFlags.getUsePropagateExtend()) {
            TransformDeAux transformDeAux = new TransformDeAux(this.aux_to_expression);
            TransformSimplify transformSimplify = new TransformSimplify();
            TransformNormalise transformNormalise = new TransformNormalise(this.st.m);
            ASTNode aSTNode3 = aSTNode.copy();
            aSTNode3 = transformDeAux.transform(aSTNode3);
            aSTNode3 = transformSimplify.transform(aSTNode3);
            ASTNode aSTNode4 = this.aux_filtered_domain.get(aSTNode3 = transformNormalise.transform(aSTNode3));
            if (aSTNode4 != null) {
                aSTNode4 = new Intersect(aSTNode4, aSTNode2);
                if (aSTNode2.isBooleanSet()) {
                    aSTNode4 = Intpair.makeDomain(transformSimplify.transform(aSTNode4).getIntervalSet(), true);
                }
                aSTNode4 = transformSimplify.transform(aSTNode4);
                return aSTNode4;
            }
        }
        return aSTNode2;
    }

    public ASTNode constructDomain(ASTNode aSTNode, long l, long l2) {
        if (l == 0L && l2 == 1L) {
            return this.constructDomain(aSTNode, new BooleanDomainFull());
        }
        return this.constructDomain(aSTNode, new IntegerDomain(new Range((ASTNode)NumberConstant.make(l), NumberConstant.make(l2))));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FilteredDomainStore:\n");
        stringBuilder.append("Mapping from aux to expression:\n");
        stringBuilder.append(this.aux_to_expression.toString());
        stringBuilder.append("\n");
        stringBuilder.append("From expression to filtered domain:\n");
        stringBuilder.append(this.aux_filtered_domain.toString());
        return stringBuilder.toString();
    }
}

